/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionInfo;
import Ice.Endpoint;
import Ice.EndpointInfo;
import Ice.Instrumentation.CollocatedObserver;
import Ice.Instrumentation.InvocationObserver;
import Ice.Instrumentation.RemoteObserver;
import Ice.ObjectAdapter;
import IceInternal.CollocatedObserverI;
import IceInternal.CommunicatorObserverI;
import IceInternal.RemoteObserverI;
import IceMX.CollocatedMetrics;
import IceMX.InvocationMetrics;
import IceMX.MetricsHelper;
import IceMX.Observer;
import IceMX.ObserverWithDelegate;
import IceMX.RemoteMetrics;

public class InvocationObserverI
extends ObserverWithDelegate<InvocationMetrics, InvocationObserver>
implements InvocationObserver {
    final Observer.MetricsUpdate<InvocationMetrics> _incrementRetry = new Observer.MetricsUpdate<InvocationMetrics>(){

        public void update(InvocationMetrics invocationMetrics) {
            ++invocationMetrics.retry;
        }
    };
    final Observer.MetricsUpdate<InvocationMetrics> _userException = new Observer.MetricsUpdate<InvocationMetrics>(){

        public void update(InvocationMetrics invocationMetrics) {
            ++invocationMetrics.userException;
        }
    };

    @Override
    public void userException() {
        this.forEach(this._userException);
        if (this._delegate != null) {
            ((InvocationObserver)this._delegate).userException();
        }
    }

    @Override
    public void retried() {
        this.forEach(this._incrementRetry);
        if (this._delegate != null) {
            ((InvocationObserver)this._delegate).retried();
        }
    }

    @Override
    public RemoteObserver getRemoteObserver(ConnectionInfo connectionInfo, Endpoint endpoint, int n, int n2) {
        RemoteObserver remoteObserver = null;
        if (this._delegate != null) {
            remoteObserver = ((InvocationObserver)this._delegate).getRemoteObserver(connectionInfo, endpoint, n, n2);
        }
        return (RemoteObserver)this.getObserver("Remote", new RemoteInvocationHelper(connectionInfo, endpoint, n, n2), RemoteMetrics.class, RemoteObserverI.class, remoteObserver);
    }

    @Override
    public CollocatedObserver getCollocatedObserver(ObjectAdapter objectAdapter, int n, int n2) {
        CollocatedObserver collocatedObserver = null;
        if (this._delegate != null) {
            collocatedObserver = ((InvocationObserver)this._delegate).getCollocatedObserver(objectAdapter, n, n2);
        }
        return (CollocatedObserver)this.getObserver("Collocated", new CollocatedInvocationHelper(objectAdapter, n, n2), CollocatedMetrics.class, CollocatedObserverI.class, collocatedObserver);
    }

    public static final class CollocatedInvocationHelper
    extends MetricsHelper<CollocatedMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        Class<CollocatedInvocationHelper> clazz = CollocatedInvocationHelper.class;
                        this.add("parent", clazz.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", clazz.getDeclaredMethod("getId", new Class[0]));
                        this.add("requestId", clazz.getDeclaredMethod("getRequestId", new Class[0]));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final int _requestId;
        private final int _size;
        private final String _id;

        CollocatedInvocationHelper(ObjectAdapter objectAdapter, int n, int n2) {
            super(_attributes);
            this._id = objectAdapter.getName();
            this._requestId = n;
            this._size = n2;
        }

        public void initMetrics(CollocatedMetrics collocatedMetrics) {
            collocatedMetrics.size += (long)this._size;
        }

        public String getId() {
            return this._id;
        }

        int getRequestId() {
            return this._requestId;
        }

        public String getParent() {
            return "Communicator";
        }
    }

    public static final class RemoteInvocationHelper
    extends MetricsHelper<RemoteMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        Class<RemoteInvocationHelper> clazz = RemoteInvocationHelper.class;
                        this.add("parent", clazz.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", clazz.getDeclaredMethod("getId", new Class[0]));
                        this.add("requestId", clazz.getDeclaredMethod("getRequestId", new Class[0]));
                        CommunicatorObserverI.addConnectionAttributes(this, RemoteInvocationHelper.class);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final ConnectionInfo _connectionInfo;
        private final Endpoint _endpoint;
        private final int _requestId;
        private final int _size;
        private String _id;
        private EndpointInfo _endpointInfo;

        RemoteInvocationHelper(ConnectionInfo connectionInfo, Endpoint endpoint, int n, int n2) {
            super(_attributes);
            this._connectionInfo = connectionInfo;
            this._endpoint = endpoint;
            this._requestId = n;
            this._size = n2;
        }

        public void initMetrics(RemoteMetrics remoteMetrics) {
            remoteMetrics.size += (long)this._size;
        }

        public String getId() {
            if (this._id == null) {
                this._id = this._endpoint.toString();
                if (this._connectionInfo.connectionId != null && !this._connectionInfo.connectionId.isEmpty()) {
                    this._id = this._id + " [" + this._connectionInfo.connectionId + "]";
                }
            }
            return this._id;
        }

        int getRequestId() {
            return this._requestId;
        }

        public String getParent() {
            if (this._connectionInfo.adapterName != null && !this._connectionInfo.adapterName.isEmpty()) {
                return this._connectionInfo.adapterName;
            }
            return "Communicator";
        }

        public ConnectionInfo getConnectionInfo() {
            return this._connectionInfo;
        }

        public Endpoint getEndpoint() {
            return this._endpoint;
        }

        public EndpointInfo getEndpointInfo() {
            if (this._endpointInfo == null) {
                this._endpointInfo = this._endpoint.getInfo();
            }
            return this._endpointInfo;
        }
    }
}

