/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.FileException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.ImplicitContextI;
import Ice.InitializationData;
import Ice.InitializationException;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.Instrumentation.ObserverUpdater;
import Ice.Instrumentation.ThreadObserver;
import Ice.Instrumentation.ThreadState;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.Logger;
import Ice.LoggerI;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.OperationInterruptedException;
import Ice.PluginManager;
import Ice.PluginManagerI;
import Ice.ProcessPrx;
import Ice.ProcessPrxHelper;
import Ice.Properties;
import Ice.PropertiesI;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.ServerNotFoundException;
import Ice.StringSeqHolder;
import Ice.SysLoggerI;
import Ice.ThreadNotification;
import IceInternal.ACMConfig;
import IceInternal.BufSizeWarnInfo;
import IceInternal.CommunicatorObserverI;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointFactory;
import IceInternal.EndpointFactoryManager;
import IceInternal.EndpointHostResolver;
import IceInternal.Ex;
import IceInternal.HTTPNetworkProxy;
import IceInternal.LocatorManager;
import IceInternal.LoggerAdminLogger;
import IceInternal.LoggerAdminLoggerI;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import IceInternal.ObjectAdapterFactory;
import IceInternal.ObjectFactoryManager;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.ProcessI;
import IceInternal.PropertiesAdminI;
import IceInternal.ProtocolInstance;
import IceInternal.ProxyFactory;
import IceInternal.QueueExecutorService;
import IceInternal.ReferenceFactory;
import IceInternal.RequestHandlerFactory;
import IceInternal.RetryQueue;
import IceInternal.RouterManager;
import IceInternal.SOCKSNetworkProxy;
import IceInternal.TcpEndpointFactory;
import IceInternal.ThreadPool;
import IceInternal.TraceLevels;
import IceInternal.UdpEndpointFactory;
import IceInternal.Util;
import IceInternal.WSEndpointFactory;
import IceUtilInternal.Assert;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Instance {
    private static final int StateActive = 0;
    private static final int StateDestroyInProgress = 1;
    private static final int StateDestroyed = 2;
    private int _state = 0;
    private final InitializationData _initData;
    private final TraceLevels _traceLevels;
    private final DefaultsAndOverrides _defaultsAndOverrides;
    private final int _messageSizeMax;
    private final int _batchAutoFlushSize;
    private final int _cacheMessageBuffers;
    private final ACMConfig _clientACM;
    private final ACMConfig _serverACM;
    private final ImplicitContextI _implicitContext;
    private RouterManager _routerManager;
    private LocatorManager _locatorManager;
    private ReferenceFactory _referenceFactory;
    private RequestHandlerFactory _requestHandlerFactory;
    private ProxyFactory _proxyFactory;
    private OutgoingConnectionFactory _outgoingConnectionFactory;
    private ObjectFactoryManager _servantFactoryManager;
    private ObjectAdapterFactory _objectAdapterFactory;
    private int _protocolSupport;
    private boolean _preferIPv6;
    private NetworkProxy _networkProxy;
    private ThreadPool _clientThreadPool;
    private ThreadPool _serverThreadPool;
    private EndpointHostResolver _endpointHostResolver;
    private RetryQueue _retryQueue;
    private Timer _timer;
    private EndpointFactoryManager _endpointFactoryManager;
    private PluginManager _pluginManager;
    private boolean _adminEnabled = false;
    private ObjectAdapter _adminAdapter;
    private Map<String, Object> _adminFacets = new HashMap<String, Object>();
    private Set<String> _adminFacetFilter = new HashSet<String>();
    private Identity _adminIdentity;
    private Map<Short, BufSizeWarnInfo> _setBufSizeWarn = new HashMap<Short, BufSizeWarnInfo>();
    private Map<String, String> _typeToClassMap = new HashMap<String, String>();
    private final String[] _packages;
    private final boolean _useApplicationClassLoader;
    private static boolean _oneOfDone = false;
    private QueueExecutorService _queueExecutorService;
    private QueueExecutor _queueExecutor;

    public InitializationData initializationData() {
        return this._initData;
    }

    public TraceLevels traceLevels() {
        assert (this._traceLevels != null);
        return this._traceLevels;
    }

    public DefaultsAndOverrides defaultsAndOverrides() {
        assert (this._defaultsAndOverrides != null);
        return this._defaultsAndOverrides;
    }

    public synchronized RouterManager routerManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._routerManager != null);
        return this._routerManager;
    }

    public synchronized LocatorManager locatorManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._locatorManager != null);
        return this._locatorManager;
    }

    public synchronized ReferenceFactory referenceFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._referenceFactory != null);
        return this._referenceFactory;
    }

    public synchronized RequestHandlerFactory requestHandlerFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._requestHandlerFactory != null);
        return this._requestHandlerFactory;
    }

    public synchronized ProxyFactory proxyFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._proxyFactory != null);
        return this._proxyFactory;
    }

    public synchronized OutgoingConnectionFactory outgoingConnectionFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._outgoingConnectionFactory != null);
        return this._outgoingConnectionFactory;
    }

    public synchronized ObjectFactoryManager servantFactoryManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._servantFactoryManager != null);
        return this._servantFactoryManager;
    }

    public synchronized ObjectAdapterFactory objectAdapterFactory() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._objectAdapterFactory != null);
        return this._objectAdapterFactory;
    }

    public int protocolSupport() {
        return this._protocolSupport;
    }

    public boolean preferIPv6() {
        return this._preferIPv6;
    }

    public NetworkProxy networkProxy() {
        return this._networkProxy;
    }

    public synchronized ThreadPool clientThreadPool() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._clientThreadPool != null);
        return this._clientThreadPool;
    }

    public synchronized ThreadPool serverThreadPool() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._serverThreadPool == null) {
            if (this._state == 1) {
                throw new CommunicatorDestroyedException();
            }
            int n = this._initData.properties.getPropertyAsInt("Ice.ServerIdleTime");
            this._serverThreadPool = new ThreadPool(this, "Ice.ThreadPool.Server", n);
        }
        return this._serverThreadPool;
    }

    public synchronized EndpointHostResolver endpointHostResolver() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._endpointHostResolver != null);
        return this._endpointHostResolver;
    }

    public synchronized RetryQueue retryQueue() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._retryQueue != null);
        return this._retryQueue;
    }

    public synchronized ScheduledExecutorService timer() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._timer != null);
        return this._timer;
    }

    public synchronized EndpointFactoryManager endpointFactoryManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._endpointFactoryManager != null);
        return this._endpointFactoryManager;
    }

    public synchronized PluginManager pluginManager() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        assert (this._pluginManager != null);
        return this._pluginManager;
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    public int batchAutoFlushSize() {
        return this._batchAutoFlushSize;
    }

    public int cacheMessageBuffers() {
        return this._cacheMessageBuffers;
    }

    public ACMConfig clientACM() {
        return this._clientACM;
    }

    public ACMConfig serverACM() {
        return this._serverACM;
    }

    public ImplicitContextI getImplicitContext() {
        return this._implicitContext;
    }

    public Identity stringToIdentity(String string) {
        return Ice.Util.stringToIdentity(string);
    }

    public String identityToString(Identity identity) {
        return Ice.Util.identityToString(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectPrx createAdmin(ObjectAdapter objectAdapter, Identity identity) {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        boolean bl = objectAdapter == null;
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            if (identity == null || identity.name == null || identity.name.isEmpty()) {
                throw new IllegalIdentityException(identity);
            }
            if (this._adminAdapter != null) {
                throw new InitializationException("Admin already created");
            }
            if (!this._adminEnabled) {
                throw new InitializationException("Admin is disabled");
            }
            if (bl) {
                if (!this._initData.properties.getProperty("Ice.Admin.Endpoints").isEmpty()) {
                    objectAdapter = this._objectAdapterFactory.createObjectAdapter("Ice.Admin", null);
                } else {
                    throw new InitializationException("Ice.Admin.Endpoints is not set");
                }
            }
            this._adminIdentity = identity;
            this._adminAdapter = objectAdapter;
            this.addAllAdminFacets();
        }
        if (bl) {
            try {
                objectAdapter.activate();
            }
            catch (LocalException localException) {
                objectAdapter.destroy();
                Instance instance2 = this;
                synchronized (instance2) {
                    this._adminAdapter = null;
                }
                throw localException;
            }
        }
        this.setServerProcessProxy(objectAdapter, identity);
        return objectAdapter.createProxy(identity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPrx getAdmin() {
        Identity identity;
        ObjectAdapter objectAdapter;
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        Instance instance = this;
        synchronized (instance) {
            if (this._state == 2) {
                throw new CommunicatorDestroyedException();
            }
            if (this._adminAdapter != null) {
                return this._adminAdapter.createProxy(this._adminIdentity);
            }
            if (this._adminEnabled) {
                if (this._initData.properties.getProperty("Ice.Admin.Endpoints").isEmpty()) {
                    return null;
                }
                objectAdapter = this._objectAdapterFactory.createObjectAdapter("Ice.Admin", null);
                identity = new Identity("admin", this._initData.properties.getProperty("Ice.Admin.InstanceName"));
                if (identity.category.isEmpty()) {
                    identity.category = UUID.randomUUID().toString();
                }
            } else {
                return null;
            }
            this._adminIdentity = identity;
            this._adminAdapter = objectAdapter;
            this.addAllAdminFacets();
        }
        try {
            objectAdapter.activate();
        }
        catch (LocalException localException) {
            objectAdapter.destroy();
            Instance instance2 = this;
            synchronized (instance2) {
                this._adminAdapter = null;
            }
            throw localException;
        }
        this.setServerProcessProxy(objectAdapter, identity);
        return objectAdapter.createProxy(identity);
    }

    public synchronized void addAdminFacet(Object object, String string) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._adminAdapter == null || !this._adminFacetFilter.isEmpty() && !this._adminFacetFilter.contains(string)) {
            if (this._adminFacets.get(string) != null) {
                throw new AlreadyRegisteredException("facet", string);
            }
            this._adminFacets.put(string, object);
        } else {
            this._adminAdapter.addFacet(object, this._adminIdentity, string);
        }
    }

    public synchronized Object removeAdminFacet(String string) {
        Object object;
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._adminAdapter == null || !this._adminFacetFilter.isEmpty() && !this._adminFacetFilter.contains(string)) {
            object = this._adminFacets.remove(string);
            if (object == null) {
                throw new NotRegisteredException("facet", string);
            }
        } else {
            object = this._adminAdapter.removeFacet(this._adminIdentity, string);
        }
        return object;
    }

    public synchronized Object findAdminFacet(String string) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        Object object = null;
        object = this._adminAdapter == null || !this._adminFacetFilter.isEmpty() && !this._adminFacetFilter.contains(string) ? this._adminFacets.get(string) : this._adminAdapter.findFacet(this._adminIdentity, string);
        return object;
    }

    public synchronized Map<String, Object> findAllAdminFacets() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        if (this._adminAdapter == null) {
            return new HashMap<String, Object>(this._adminFacets);
        }
        Map<String, Object> map = this._adminAdapter.findAllFacets(this._adminIdentity);
        if (!this._adminFacets.isEmpty()) {
            map.putAll(this._adminFacets);
        }
        return map;
    }

    public synchronized void setDefaultLocator(LocatorPrx locatorPrx) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        this._referenceFactory = this._referenceFactory.setDefaultLocator(locatorPrx);
    }

    public synchronized void setDefaultRouter(RouterPrx routerPrx) {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        this._referenceFactory = this._referenceFactory.setDefaultRouter(routerPrx);
    }

    public void setLogger(Logger logger) {
        this._initData.logger = logger;
    }

    public void setThreadHook(ThreadNotification threadNotification) {
        this._initData.threadHook = threadNotification;
    }

    public Class<?> findClass(String string) {
        return Util.findClass(string, this._initData.classLoader);
    }

    public ClassLoader getClassLoader() {
        return this._initData.classLoader;
    }

    public synchronized String getClassForType(String string) {
        return this._typeToClassMap.get(string);
    }

    public synchronized void addClassForType(String string, String string2) {
        if (this._typeToClassMap.containsKey(string)) {
            assert (this._typeToClassMap.get(string).equals(string2));
        } else {
            this._typeToClassMap.put(string, string2);
        }
    }

    public String[] getPackages() {
        return this._packages;
    }

    public boolean useApplicationClassLoader() {
        return this._useApplicationClassLoader;
    }

    public boolean queueRequests() {
        return this._queueExecutorService != null;
    }

    public synchronized QueueExecutorService getQueueExecutor() {
        if (this._state == 2) {
            throw new CommunicatorDestroyedException();
        }
        return this._queueExecutorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance(Communicator communicator, InitializationData initializationData) {
        this._initData = initializationData;
        try {
            if (this._initData.properties == null) {
                this._initData.properties = Ice.Util.createProperties();
            }
            java.lang.Object object = Instance.class;
            synchronized (Instance.class) {
                boolean bl;
                int n;
                java.lang.Object object2;
                if (!_oneOfDone) {
                    String string = this._initData.properties.getProperty("Ice.StdOut");
                    String string2 = this._initData.properties.getProperty("Ice.StdErr");
                    object2 = null;
                    if (string.length() > 0) {
                        System.out.close();
                        try {
                            object2 = new PrintStream(new FileOutputStream(string, true));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new FileException(0, string, fileNotFoundException);
                        }
                        System.setOut((PrintStream)object2);
                    }
                    if (string2.length() > 0) {
                        System.err.close();
                        if (string2.equals(string)) {
                            System.setErr(object2);
                        } else {
                            try {
                                System.setErr(new PrintStream(new FileOutputStream(string2, true)));
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                throw new FileException(0, string2, fileNotFoundException);
                            }
                        }
                    }
                    _oneOfDone = true;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (this._initData.logger == null) {
                    object = this._initData.properties.getProperty("Ice.LogFile");
                    if (this._initData.properties.getPropertyAsInt("Ice.UseSyslog") > 0 && !System.getProperty("os.name").startsWith("Windows")) {
                        if (((String)object).length() != 0) {
                            throw new InitializationException("Both syslog and file logger cannot be enabled.");
                        }
                        this._initData.logger = new SysLoggerI(this._initData.properties.getProperty("Ice.ProgramName"), this._initData.properties.getPropertyWithDefault("Ice.SyslogFacility", "LOG_USER"));
                    } else {
                        this._initData.logger = ((String)object).length() != 0 ? new LoggerI(this._initData.properties.getProperty("Ice.ProgramName"), (String)object) : Ice.Util.getProcessLogger();
                    }
                }
                this._packages = this.validatePackages();
                this._useApplicationClassLoader = this._initData.properties.getPropertyAsInt("Ice.UseApplicationClassLoader") > 0;
                this._traceLevels = new TraceLevels(this._initData.properties);
                this._defaultsAndOverrides = new DefaultsAndOverrides(this._initData.properties, this._initData.logger);
                this._clientACM = new ACMConfig(this._initData.properties, this._initData.logger, "Ice.ACM.Client", new ACMConfig(this._initData.properties, this._initData.logger, "Ice.ACM", new ACMConfig(false)));
                this._serverACM = new ACMConfig(this._initData.properties, this._initData.logger, "Ice.ACM.Server", new ACMConfig(this._initData.properties, this._initData.logger, "Ice.ACM", new ACMConfig(true)));
                int n2 = this._initData.properties.getPropertyAsIntWithDefault("Ice.MessageSizeMax", 1024);
                this._messageSizeMax = n2 < 1 || n2 > 0x1FFFFF ? Integer.MAX_VALUE : n2 * 1024;
                this._batchAutoFlushSize = this._initData.properties.getProperty("Ice.BatchAutoFlushSize").isEmpty() && !this._initData.properties.getProperty("Ice.BatchAutoFlush").isEmpty() ? (this._initData.properties.getPropertyAsInt("Ice.BatchAutoFlush") > 0 ? this._messageSizeMax : 0) : ((n = this._initData.properties.getPropertyAsIntWithDefault("Ice.BatchAutoFlushSize", 1024)) < 1 ? n : (n > 0x1FFFFF ? Integer.MAX_VALUE : n * 1024));
                this._implicitContext = ImplicitContextI.create(this._initData.properties.getProperty("Ice.ImplicitContext"));
                this._routerManager = new RouterManager();
                this._locatorManager = new LocatorManager(this._initData.properties);
                this._referenceFactory = new ReferenceFactory(this, communicator);
                this._requestHandlerFactory = new RequestHandlerFactory(this);
                this._proxyFactory = new ProxyFactory(this);
                boolean bl2 = Network.isIPv6Supported();
                n2 = this._initData.properties.getPropertyAsIntWithDefault("Ice.IPv4", 1) > 0 ? 1 : 0;
                boolean bl3 = bl = this._initData.properties.getPropertyAsIntWithDefault("Ice.IPv6", bl2 ? 1 : 0) > 0;
                if (n2 == 0 && !bl) {
                    throw new InitializationException("Both IPV4 and IPv6 support cannot be disabled.");
                }
                this._protocolSupport = n2 != 0 && bl ? 2 : (n2 != 0 ? 0 : 1);
                this._preferIPv6 = this._initData.properties.getPropertyAsInt("Ice.PreferIPv6Address") > 0;
                this._networkProxy = this.createNetworkProxy(this._initData.properties, this._protocolSupport);
                this._endpointFactoryManager = new EndpointFactoryManager(this);
                object2 = new ProtocolInstance(this, 1, "tcp", false);
                this._endpointFactoryManager.add(new TcpEndpointFactory((ProtocolInstance)object2));
                ProtocolInstance protocolInstance = new ProtocolInstance(this, 3, "udp", false);
                this._endpointFactoryManager.add(new UdpEndpointFactory(protocolInstance));
                this._pluginManager = new PluginManagerI(communicator, this);
                this._outgoingConnectionFactory = new OutgoingConnectionFactory(communicator, this);
                this._servantFactoryManager = new ObjectFactoryManager();
                this._objectAdapterFactory = new ObjectAdapterFactory(this, communicator);
                this._retryQueue = new RetryQueue(this);
                if (this._initData.properties.getPropertyAsInt("Ice.ThreadInterruptSafe") > 0 || Util.isAndroid()) {
                    this._queueExecutor = new QueueExecutor(this._initData.properties, Util.createThreadName(this._initData.properties, "Ice.BackgroundIO"));
                    this._queueExecutorService = new QueueExecutorService(this._queueExecutor);
                    this._cacheMessageBuffers = 0;
                } else {
                    this._cacheMessageBuffers = this._initData.properties.getPropertyAsIntWithDefault("Ice.CacheMessageBuffers", 2);
                }
            }
        }
        catch (LocalException localException) {
            this.destroy();
            throw localException;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._state == 2);
            Assert.FinalizerAssert(this._referenceFactory == null);
            Assert.FinalizerAssert(this._requestHandlerFactory == null);
            Assert.FinalizerAssert(this._proxyFactory == null);
            Assert.FinalizerAssert(this._outgoingConnectionFactory == null);
            Assert.FinalizerAssert(this._servantFactoryManager == null);
            Assert.FinalizerAssert(this._objectAdapterFactory == null);
            Assert.FinalizerAssert(this._clientThreadPool == null);
            Assert.FinalizerAssert(this._serverThreadPool == null);
            Assert.FinalizerAssert(this._endpointHostResolver == null);
            Assert.FinalizerAssert(this._timer == null);
            Assert.FinalizerAssert(this._routerManager == null);
            Assert.FinalizerAssert(this._locatorManager == null);
            Assert.FinalizerAssert(this._endpointFactoryManager == null);
            Assert.FinalizerAssert(this._pluginManager == null);
            Assert.FinalizerAssert(this._retryQueue == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    public void finishSetup(StringSeqHolder stringSeqHolder, Communicator communicator) {
        String string;
        java.lang.Object object;
        String[] stringArray;
        java.lang.Object object2;
        assert (this._serverThreadPool == null);
        PluginManagerI pluginManagerI = (PluginManagerI)this._pluginManager;
        pluginManagerI.loadPlugins(stringSeqHolder);
        EndpointFactory endpointFactory = this._endpointFactoryManager.get((short)1);
        if (endpointFactory != null) {
            object2 = new ProtocolInstance(this, 4, "ws", false);
            this._endpointFactoryManager.add(new WSEndpointFactory((ProtocolInstance)object2, endpointFactory.clone((ProtocolInstance)object2)));
        }
        if ((object2 = this._endpointFactoryManager.get((short)2)) != null) {
            stringArray = new ProtocolInstance(this, 5, "wss", true);
            this._endpointFactoryManager.add(new WSEndpointFactory((ProtocolInstance)stringArray, object2.clone((ProtocolInstance)stringArray)));
        }
        this._adminEnabled = this._initData.properties.getProperty("Ice.Admin.Enabled").isEmpty() ? !this._initData.properties.getProperty("Ice.Admin.Endpoints").isEmpty() : this._initData.properties.getPropertyAsInt("Ice.Admin.Enabled") > 0;
        stringArray = this._initData.properties.getPropertyAsList("Ice.Admin.Facets");
        if (stringArray.length > 0) {
            this._adminFacetFilter.addAll(Arrays.asList(stringArray));
        }
        if (this._adminEnabled) {
            java.lang.Object object3;
            object = "Process";
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(object)) {
                this._adminFacets.put((String)object, new ProcessI(communicator));
            }
            string = "Logger";
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(string)) {
                object3 = new LoggerAdminLoggerI(this._initData.properties, this._initData.logger);
                this.setLogger((Logger)object3);
                this._adminFacets.put(string, object3.getFacet());
            }
            object3 = "Properties";
            PropertiesAdminI propertiesAdminI = null;
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(object3)) {
                propertiesAdminI = new PropertiesAdminI(this._initData.properties, this._initData.logger);
                this._adminFacets.put((String)object3, propertiesAdminI);
            }
            String string2 = "Metrics";
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(string2)) {
                CommunicatorObserverI communicatorObserverI = new CommunicatorObserverI(this._initData);
                this._initData.observer = communicatorObserverI;
                this._adminFacets.put(string2, (Object)((java.lang.Object)communicatorObserverI.getFacet()));
                if (propertiesAdminI != null) {
                    propertiesAdminI.addUpdateCallback(communicatorObserverI.getFacet());
                }
            }
        }
        if (this._initData.observer != null) {
            this._initData.observer.setObserverUpdater(new ObserverUpdaterI());
        }
        try {
            this._timer = new Timer(this._initData.properties, Util.createThreadName(this._initData.properties, "Ice.Timer"));
        }
        catch (RuntimeException runtimeException) {
            string = "cannot create thread for timer:\n" + Ex.toString(runtimeException);
            this._initData.logger.error(string);
            throw runtimeException;
        }
        try {
            this._endpointHostResolver = new EndpointHostResolver(this);
        }
        catch (RuntimeException runtimeException) {
            string = "cannot create thread for endpoint host resolver:\n" + Ex.toString(runtimeException);
            this._initData.logger.error(string);
            throw runtimeException;
        }
        this._clientThreadPool = new ThreadPool(this, "Ice.ThreadPool.Client", 0);
        if (this._referenceFactory.getDefaultRouter() == null && (object = RouterPrxHelper.uncheckedCast(this._proxyFactory.propertyToProxy("Ice.Default.Router"))) != null) {
            this._referenceFactory = this._referenceFactory.setDefaultRouter((RouterPrx)object);
        }
        if (this._referenceFactory.getDefaultLocator() == null && (object = LocatorPrxHelper.uncheckedCast(this._proxyFactory.propertyToProxy("Ice.Default.Locator"))) != null) {
            this._referenceFactory = this._referenceFactory.setDefaultLocator((LocatorPrx)object);
        }
        if (this._initData.properties.getPropertyAsIntWithDefault("Ice.InitPlugins", 1) > 0) {
            pluginManagerI.initializePlugins();
        }
        if (this._initData.properties.getPropertyAsIntWithDefault("Ice.Admin.DelayCreation", 0) <= 0) {
            this.getAdmin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        java.lang.Object object = this;
        synchronized (object) {
            while (this._state == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationInterruptedException();
                }
            }
            if (this._state == 2) {
                return;
            }
            this._state = 1;
        }
        try {
            if (this._objectAdapterFactory != null) {
                this._objectAdapterFactory.shutdown();
            }
            if (this._outgoingConnectionFactory != null) {
                this._outgoingConnectionFactory.destroy();
            }
            if (this._objectAdapterFactory != null) {
                this._objectAdapterFactory.destroy();
            }
            if (this._outgoingConnectionFactory != null) {
                this._outgoingConnectionFactory.waitUntilFinished();
            }
            if (this._retryQueue != null) {
                this._retryQueue.destroy();
            }
            if (this._initData.observer != null) {
                this._initData.observer.setObserverUpdater(null);
            }
            if (this._initData.logger instanceof LoggerAdminLogger) {
                ((LoggerAdminLogger)this._initData.logger).destroy();
            }
            if (this._serverThreadPool != null) {
                this._serverThreadPool.destroy();
            }
            if (this._clientThreadPool != null) {
                this._clientThreadPool.destroy();
            }
            if (this._endpointHostResolver != null) {
                this._endpointHostResolver.destroy();
            }
            if (this._timer != null) {
                this._timer.shutdown();
            }
            try {
                if (this._clientThreadPool != null) {
                    this._clientThreadPool.joinWithAllThreads();
                }
                if (this._serverThreadPool != null) {
                    this._serverThreadPool.joinWithAllThreads();
                }
                if (this._endpointHostResolver != null) {
                    this._endpointHostResolver.joinWithThread();
                }
                if (this._queueExecutor != null) {
                    this._queueExecutor.destroy();
                }
                if (this._timer != null) {
                    while (!this._timer.isTerminated()) {
                        this._timer.awaitTermination(100000L, TimeUnit.SECONDS);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                throw new OperationInterruptedException();
            }
            if (this._servantFactoryManager != null) {
                this._servantFactoryManager.destroy();
            }
            if (this._routerManager != null) {
                this._routerManager.destroy();
            }
            if (this._locatorManager != null) {
                this._locatorManager.destroy();
            }
            if (this._endpointFactoryManager != null) {
                this._endpointFactoryManager.destroy();
            }
            if (this._initData.properties.getPropertyAsInt("Ice.Warn.UnusedProperties") > 0 && (object = ((PropertiesI)this._initData.properties).getUnusedProperties()).size() != 0) {
                StringBuilder stringBuilder = new StringBuilder("The following properties were set but never read:");
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    stringBuilder.append("\n    ");
                    stringBuilder.append(string);
                }
                this._initData.logger.warning(stringBuilder.toString());
            }
            if (this._pluginManager != null) {
                this._pluginManager.destroy();
            }
            object = this;
            synchronized (object) {
                this._objectAdapterFactory = null;
                this._outgoingConnectionFactory = null;
                this._retryQueue = null;
                this._serverThreadPool = null;
                this._clientThreadPool = null;
                this._endpointHostResolver = null;
                this._timer = null;
                this._servantFactoryManager = null;
                this._referenceFactory = null;
                this._requestHandlerFactory = null;
                this._proxyFactory = null;
                this._routerManager = null;
                this._locatorManager = null;
                this._endpointFactoryManager = null;
                this._pluginManager = null;
                this._adminAdapter = null;
                this._adminFacets.clear();
                this._queueExecutor = null;
                this._queueExecutorService = null;
                this._typeToClassMap.clear();
                this._state = 2;
                this.notifyAll();
            }
        }
        finally {
            object = this;
            synchronized (object) {
                if (this._state == 1) {
                    this._state = 0;
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufSizeWarnInfo getBufSizeWarn(short s) {
        Map<Short, BufSizeWarnInfo> map = this._setBufSizeWarn;
        synchronized (map) {
            BufSizeWarnInfo bufSizeWarnInfo;
            if (!this._setBufSizeWarn.containsKey(s)) {
                bufSizeWarnInfo = new BufSizeWarnInfo();
                bufSizeWarnInfo.sndWarn = false;
                bufSizeWarnInfo.sndSize = -1;
                bufSizeWarnInfo.rcvWarn = false;
                bufSizeWarnInfo.rcvSize = -1;
                this._setBufSizeWarn.put(s, bufSizeWarnInfo);
            } else {
                bufSizeWarnInfo = this._setBufSizeWarn.get(s);
            }
            return bufSizeWarnInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSndBufSizeWarn(short s, int n) {
        Map<Short, BufSizeWarnInfo> map = this._setBufSizeWarn;
        synchronized (map) {
            BufSizeWarnInfo bufSizeWarnInfo = this.getBufSizeWarn(s);
            bufSizeWarnInfo.sndWarn = true;
            bufSizeWarnInfo.sndSize = n;
            this._setBufSizeWarn.put(s, bufSizeWarnInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRcvBufSizeWarn(short s, int n) {
        Map<Short, BufSizeWarnInfo> map = this._setBufSizeWarn;
        synchronized (map) {
            BufSizeWarnInfo bufSizeWarnInfo = this.getBufSizeWarn(s);
            bufSizeWarnInfo.rcvWarn = true;
            bufSizeWarnInfo.rcvSize = n;
            this._setBufSizeWarn.put(s, bufSizeWarnInfo);
        }
    }

    private void updateConnectionObservers() {
        try {
            assert (this._outgoingConnectionFactory != null);
            this._outgoingConnectionFactory.updateConnectionObservers();
            assert (this._objectAdapterFactory != null);
            this._objectAdapterFactory.updateConnectionObservers();
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
            // empty catch block
        }
    }

    private void updateThreadObservers() {
        try {
            if (this._clientThreadPool != null) {
                this._clientThreadPool.updateObservers();
            }
            if (this._serverThreadPool != null) {
                this._serverThreadPool.updateObservers();
            }
            assert (this._objectAdapterFactory != null);
            this._objectAdapterFactory.updateThreadObservers();
            if (this._endpointHostResolver != null) {
                this._endpointHostResolver.updateObserver();
            }
            if (this._timer != null) {
                this._timer.updateObserver(this._initData.observer);
            }
            if (this._queueExecutor != null) {
                this._queueExecutor.updateObserver(this._initData.observer);
            }
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
            // empty catch block
        }
    }

    private String[] validatePackages() {
        Map<String, String> map = this._initData.properties.getPropertiesForPrefix("Ice.Package.");
        ArrayList<java.lang.Object> arrayList = new ArrayList<java.lang.Object>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string.length() == "Ice.Package.".length()) {
                this._initData.logger.warning("ignoring invalid property: " + string + "=" + string2);
            }
            String string3 = string.substring("Ice.Package.".length());
            String string4 = string2 + "." + string3 + "._Marker";
            Class<?> clazz = null;
            try {
                clazz = this.findClass(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz == null) {
                this._initData.logger.warning("unable to validate package: " + string + "=" + string2);
                continue;
            }
            arrayList.add(string2);
        }
        String string = this._initData.properties.getProperty("Ice.Default.Package");
        if (string.length() > 0) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private synchronized void addAllAdminFacets() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this._adminFacets.entrySet()) {
            if (this._adminFacetFilter.isEmpty() || this._adminFacetFilter.contains(entry.getKey())) {
                this._adminAdapter.addFacet(entry.getValue(), this._adminIdentity, entry.getKey());
                continue;
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        this._adminFacets = hashMap;
    }

    private void setServerProcessProxy(ObjectAdapter objectAdapter, Identity identity) {
        ObjectPrx objectPrx = objectAdapter.createProxy(identity);
        LocatorPrx locatorPrx = objectAdapter.getLocator();
        String string = this._initData.properties.getProperty("Ice.Admin.ServerId");
        if (locatorPrx != null && !string.isEmpty()) {
            ProcessPrx processPrx = ProcessPrxHelper.uncheckedCast(objectPrx.ice_facet("Process"));
            try {
                locatorPrx.getRegistry().setServerProcessProxy(string, processPrx);
            }
            catch (ServerNotFoundException serverNotFoundException) {
                if (this._traceLevels.location >= 1) {
                    StringBuilder stringBuilder = new StringBuilder(128);
                    stringBuilder.append("couldn't register server `");
                    stringBuilder.append(string);
                    stringBuilder.append("' with the locator registry:\n");
                    stringBuilder.append("the server is not known to the locator registry");
                    this._initData.logger.trace(this._traceLevels.locationCat, stringBuilder.toString());
                }
                throw new InitializationException("Locator knows nothing about server `" + string + "'");
            }
            catch (LocalException localException) {
                if (this._traceLevels.location >= 1) {
                    StringBuilder stringBuilder = new StringBuilder(128);
                    stringBuilder.append("couldn't register server `");
                    stringBuilder.append(string);
                    stringBuilder.append("' with the locator registry:\n");
                    stringBuilder.append(localException.toString());
                    this._initData.logger.trace(this._traceLevels.locationCat, stringBuilder.toString());
                }
                throw localException;
            }
            if (this._traceLevels.location >= 1) {
                StringBuilder stringBuilder = new StringBuilder(128);
                stringBuilder.append("registered server `");
                stringBuilder.append(string);
                stringBuilder.append("' with the locator registry");
                this._initData.logger.trace(this._traceLevels.locationCat, stringBuilder.toString());
            }
        }
    }

    private NetworkProxy createNetworkProxy(Properties properties, int n) {
        String string = properties.getProperty("Ice.SOCKSProxyHost");
        if (!string.isEmpty()) {
            if (n == 1) {
                throw new InitializationException("IPv6 only is not supported with SOCKS4 proxies");
            }
            int n2 = properties.getPropertyAsIntWithDefault("Ice.SOCKSProxyPort", 1080);
            return new SOCKSNetworkProxy(string, n2);
        }
        string = properties.getProperty("Ice.HTTPProxyHost");
        if (!string.isEmpty()) {
            return new HTTPNetworkProxy(string, properties.getPropertyAsIntWithDefault("Ice.HTTPProxyPort", 1080));
        }
        return null;
    }

    private class ObserverUpdaterI
    implements ObserverUpdater {
        private ObserverUpdaterI() {
        }

        @Override
        public void updateConnectionObservers() {
            Instance.this.updateConnectionObservers();
        }

        @Override
        public void updateThreadObservers() {
            Instance.this.updateThreadObservers();
        }
    }

    private static class QueueExecutor
    extends ThreadPoolExecutor {
        private final ThreadObserverHelper _observerHelper;

        QueueExecutor(Properties properties, String string) {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Util.createThreadFactory(properties, string));
            this._observerHelper = new ThreadObserverHelper(string);
        }

        public void updateObserver(CommunicatorObserver communicatorObserver) {
            this._observerHelper.updateObserver(communicatorObserver);
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            this._observerHelper.beforeExecute();
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            this._observerHelper.afterExecute();
        }

        public void destroy() throws InterruptedException {
            this.shutdown();
            while (!this.isTerminated()) {
                this.awaitTermination(100000L, TimeUnit.SECONDS);
            }
        }
    }

    private static class Timer
    extends ScheduledThreadPoolExecutor {
        private final ThreadObserverHelper _observerHelper;

        Timer(Properties properties, String string) {
            super(1, Util.createThreadFactory(properties, string));
            this.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this._observerHelper = new ThreadObserverHelper(string);
        }

        public void updateObserver(CommunicatorObserver communicatorObserver) {
            this._observerHelper.updateObserver(communicatorObserver);
        }

        @Override
        protected void beforeExecute(Thread thread, Runnable runnable) {
            this._observerHelper.beforeExecute();
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            this._observerHelper.afterExecute();
        }
    }

    private static class ThreadObserverHelper {
        private final String _threadName;
        private volatile ThreadObserver _observer;
        private ThreadObserver _threadObserver;

        ThreadObserverHelper(String string) {
            this._threadName = string;
        }

        public synchronized void updateObserver(CommunicatorObserver communicatorObserver) {
            assert (communicatorObserver != null);
            this._observer = communicatorObserver.getThreadObserver("Communicator", this._threadName, ThreadState.ThreadStateIdle, this._observer);
            if (this._observer != null) {
                this._observer.attach();
            }
        }

        protected void beforeExecute() {
            this._threadObserver = this._observer;
            if (this._threadObserver != null) {
                this._threadObserver.stateChanged(ThreadState.ThreadStateIdle, ThreadState.ThreadStateInUseForOther);
            }
        }

        protected void afterExecute() {
            if (this._threadObserver != null) {
                this._threadObserver.stateChanged(ThreadState.ThreadStateInUseForOther, ThreadState.ThreadStateIdle);
                this._threadObserver = null;
            }
        }
    }
}

