/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.BasicStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamWrapper
extends InputStream {
    private BasicStream _s;
    private int _markPos;

    public InputStreamWrapper(int n, BasicStream basicStream) {
        this._s = basicStream;
        this._markPos = 0;
    }

    @Override
    public int read() throws IOException {
        try {
            return this._s.getBuffer().b.get();
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this._s.getBuffer().b.get(byArray, n, n2);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        return n2;
    }

    @Override
    public int available() {
        return this._s.getBuffer().b.remaining();
    }

    @Override
    public void mark(int n) {
        this._markPos = this._s.pos();
    }

    @Override
    public void reset() throws IOException {
        this._s.pos(this._markPos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

