/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.LocalException;
import Ice.ObjectAdapterI;
import Ice.OperationInterruptedException;
import Ice.SocketException;
import Ice.SyscallException;
import IceInternal.Acceptor;
import IceInternal.CommunicatorFlushBatch;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.EventHandler;
import IceInternal.Ex;
import IceInternal.FactoryACMMonitor;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.ThreadPoolCurrent;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.nio.channels.SelectableChannel;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class IncomingConnectionFactory
extends EventHandler
implements ConnectionI.StartCallback {
    private static final int StateActive = 0;
    private static final int StateHolding = 1;
    private static final int StateClosed = 2;
    private static final int StateFinished = 3;
    private final Instance _instance;
    private final FactoryACMMonitor _monitor;
    private Acceptor _acceptor;
    private Transceiver _transceiver;
    private EndpointI _endpoint;
    private ObjectAdapterI _adapter;
    private final boolean _warn;
    private Set<ConnectionI> _connections = new HashSet<ConnectionI>();
    private int _state;

    public synchronized void activate() {
        this.setState(0);
    }

    public synchronized void hold() {
        this.setState(1);
    }

    public synchronized void destroy() {
        this.setState(2);
    }

    public synchronized void updateConnectionObservers() {
        for (ConnectionI connectionI : this._connections) {
            connectionI.updateObserver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilHolding() throws InterruptedException {
        LinkedList<ConnectionI> linkedList;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._state < 1) {
                this.wait();
            }
            linkedList = new LinkedList<ConnectionI>(this._connections);
        }
        for (ConnectionI connectionI : linkedList) {
            connectionI.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() throws InterruptedException {
        LinkedList<ConnectionI> linkedList = null;
        Object object = this;
        synchronized (object) {
            while (this._state != 3) {
                this.wait();
            }
            this._adapter = null;
            linkedList = new LinkedList<ConnectionI>(this._connections);
        }
        if (linkedList != null) {
            for (ConnectionI object2 : linkedList) {
                try {
                    object2.waitUntilFinished();
                }
                catch (InterruptedException interruptedException) {
                    for (ConnectionI connectionI : linkedList) {
                        connectionI.close(true);
                    }
                    throw interruptedException;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this._transceiver != null) {
                assert (this._connections.size() <= 1);
            } else {
                List<ConnectionI> list = this._monitor.swapReapedConnections();
                assert ((list == null ? 0 : list.size()) == this._connections.size());
                if (list != null) {
                    list.clear();
                }
            }
            this._connections.clear();
            this._monitor.destroy();
        }
    }

    public EndpointI endpoint() {
        return this._endpoint;
    }

    public synchronized LinkedList<ConnectionI> connections() {
        LinkedList<ConnectionI> linkedList = new LinkedList<ConnectionI>();
        for (ConnectionI connectionI : this._connections) {
            if (!connectionI.isActiveOrHolding()) continue;
            linkedList.add(connectionI);
        }
        return linkedList;
    }

    public void flushAsyncBatchRequests(CommunicatorFlushBatch communicatorFlushBatch) {
        for (ConnectionI connectionI : this.connections()) {
            try {
                communicatorFlushBatch.flushConnection(connectionI);
            }
            catch (LocalException localException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(ThreadPoolCurrent threadPoolCurrent) {
        ConnectionI connectionI = null;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            if (this._state >= 2) {
                return;
            }
            if (this._state == 1) {
                Thread.yield();
                return;
            }
            List<ConnectionI> list = this._monitor.swapReapedConnections();
            if (list != null) {
                for (ConnectionI object2 : list) {
                    this._connections.remove(object2);
                }
            }
            Object object = null;
            try {
                object = this._acceptor.accept();
                if (this._instance.traceLevels().network >= 2) {
                    StringBuffer socketException = new StringBuffer("trying to accept ");
                    socketException.append(this._endpoint.protocol());
                    socketException.append(" connection\n");
                    socketException.append(object.toString());
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, socketException.toString());
                }
            }
            catch (SocketException localException) {
                if (Network.noMoreFds(localException.getCause())) {
                    try {
                        String string = "fatal error: can't accept more connections:\n" + localException.getCause().getMessage();
                        string = string + '\n' + this._acceptor.toString();
                        this._instance.initializationData().logger.error(string);
                    }
                    finally {
                        Runtime.getRuntime().halt(1);
                    }
                }
                return;
            }
            catch (LocalException localException) {
                if (this._warn) {
                    this.warning(localException);
                }
                return;
            }
            assert (object != null);
            try {
                connectionI = new ConnectionI(this._adapter.getCommunicator(), this._instance, this._monitor, (Transceiver)object, null, this._endpoint, this._adapter);
            }
            catch (LocalException localException) {
                try {
                    object.close();
                }
                catch (LocalException localException2) {
                    // empty catch block
                }
                if (this._warn) {
                    this.warning(localException);
                }
                return;
            }
            this._connections.add(connectionI);
        }
        assert (connectionI != null);
        connectionI.start(this);
    }

    @Override
    public synchronized void finished(ThreadPoolCurrent threadPoolCurrent, boolean bl) {
        assert (this._state == 2);
        this.setState(3);
        if (bl) {
            this.closeAcceptor();
        }
    }

    @Override
    public synchronized String toString() {
        if (this._transceiver != null) {
            return this._transceiver.toString();
        }
        return this._acceptor.toString();
    }

    @Override
    public SelectableChannel fd() {
        assert (this._acceptor != null);
        return this._acceptor.fd();
    }

    @Override
    public synchronized void connectionStartCompleted(ConnectionI connectionI) {
        if (this._state == 0) {
            connectionI.activate();
        }
    }

    @Override
    public synchronized void connectionStartFailed(ConnectionI connectionI, LocalException localException) {
        if (this._state >= 2) {
            return;
        }
    }

    public IncomingConnectionFactory(Instance instance, EndpointI endpointI, ObjectAdapterI objectAdapterI) {
        this._instance = instance;
        this._endpoint = endpointI;
        this._adapter = objectAdapterI;
        this._warn = this._instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._state = 1;
        this._monitor = new FactoryACMMonitor(instance, objectAdapterI.getACM());
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        if (defaultsAndOverrides.overrideTimeout) {
            this._endpoint = this._endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
        }
        if (defaultsAndOverrides.overrideCompress) {
            this._endpoint = this._endpoint.compress(defaultsAndOverrides.overrideCompressValue);
        }
        try {
            this._transceiver = this._endpoint.transceiver();
            if (this._transceiver != null) {
                Object object;
                if (this._instance.traceLevels().network >= 2) {
                    object = new StringBuffer("attempting to bind to ");
                    ((StringBuffer)object).append(this._endpoint.protocol());
                    ((StringBuffer)object).append(" socket\n");
                    ((StringBuffer)object).append(this._transceiver.toString());
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, ((StringBuffer)object).toString());
                }
                this._endpoint = this._transceiver.bind();
                object = new ConnectionI(this._adapter.getCommunicator(), this._instance, null, this._transceiver, null, this._endpoint, this._adapter);
                ((ConnectionI)object).startAndWait();
                this._connections.add((ConnectionI)object);
            } else {
                this.createAcceptor();
            }
        }
        catch (Exception exception) {
            if (this._transceiver != null) {
                try {
                    this._transceiver.close();
                }
                catch (LocalException localException) {
                    // empty catch block
                }
            }
            this._state = 3;
            this._monitor.destroy();
            this._connections.clear();
            if (exception instanceof LocalException) {
                throw (LocalException)exception;
            }
            if (exception instanceof InterruptedException) {
                throw new OperationInterruptedException();
            }
            throw new SyscallException(exception);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._state == 3);
            Assert.FinalizerAssert(this._connections.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private void setState(int n) {
        if (this._state == n) {
            return;
        }
        switch (n) {
            case 0: {
                if (this._state != 1) {
                    return;
                }
                if (this._acceptor != null) {
                    if (this._instance.traceLevels().network >= 1) {
                        StringBuffer stringBuffer = new StringBuffer("accepting ");
                        stringBuffer.append(this._endpoint.protocol());
                        stringBuffer.append(" connections at ");
                        stringBuffer.append(this._acceptor.toString());
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
                    }
                    this._adapter.getThreadPool().register(this, 1);
                }
                for (ConnectionI connectionI : this._connections) {
                    connectionI.activate();
                }
                break;
            }
            case 1: {
                if (this._state != 0) {
                    return;
                }
                if (this._acceptor != null) {
                    if (this._instance.traceLevels().network >= 1) {
                        StringBuffer stringBuffer = new StringBuffer("holding ");
                        stringBuffer.append(this._endpoint.protocol());
                        stringBuffer.append(" connections at ");
                        stringBuffer.append(this._acceptor.toString());
                        this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
                    }
                    this._adapter.getThreadPool().unregister(this, 1);
                }
                for (ConnectionI connectionI : this._connections) {
                    connectionI.hold();
                }
                break;
            }
            case 2: {
                if (this._acceptor != null) {
                    if (this._adapter.getThreadPool().finish(this, true)) {
                        this.closeAcceptor();
                    }
                } else {
                    n = 3;
                }
                for (ConnectionI connectionI : this._connections) {
                    connectionI.destroy(0);
                }
                break;
            }
            case 3: {
                assert (this._state == 2);
                break;
            }
        }
        this._state = n;
        this.notifyAll();
    }

    private void createAcceptor() {
        block6: {
            try {
                StringBuffer stringBuffer;
                this._acceptor = this._endpoint.acceptor(this._adapter.getName());
                assert (this._acceptor != null);
                if (this._instance.traceLevels().network >= 2) {
                    stringBuffer = new StringBuffer("attempting to bind to ");
                    stringBuffer.append(this._endpoint.protocol());
                    stringBuffer.append(" socket ");
                    stringBuffer.append(this._acceptor.toString());
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
                }
                this._endpoint = this._acceptor.listen();
                if (this._instance.traceLevels().network >= 1) {
                    stringBuffer = new StringBuffer("listening for ");
                    stringBuffer.append(this._endpoint.protocol());
                    stringBuffer.append(" connections\n");
                    stringBuffer.append(this._acceptor.toDetailedString());
                    this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
                }
                this._adapter.getThreadPool().initialize(this);
                if (this._state == 0) {
                    this._adapter.getThreadPool().register(this, 1);
                }
            }
            catch (Exception exception) {
                if (this._acceptor == null) break block6;
                this._acceptor.close();
            }
        }
    }

    private void closeAcceptor() {
        if (this._instance.traceLevels().network >= 1) {
            StringBuffer stringBuffer = new StringBuffer("stopping to accept ");
            stringBuffer.append(this._endpoint.protocol());
            stringBuffer.append(" connections at ");
            stringBuffer.append(this._acceptor.toString());
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
        }
        this._acceptor.close();
    }

    private void warning(LocalException localException) {
        String string = "connection exception:\n" + Ex.toString(localException) + '\n' + this._acceptor.toString();
        this._instance.initializationData().logger.warning(string);
    }
}

