/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.ConnectionInfo;
import Ice.Current;
import Ice.DispatchInterceptorAsyncCallback;
import Ice.Exception;
import Ice.FacetNotExistException;
import Ice.FormatType;
import Ice.IPConnectionInfo;
import Ice.Identity;
import Ice.Instrumentation.DispatchObserver;
import Ice.LocalException;
import Ice.LocalObjectHolder;
import Ice.MarshalException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectNotExistException;
import Ice.OperationNotExistException;
import Ice.RequestFailedException;
import Ice.ServantLocator;
import Ice.SystemException;
import Ice.UnknownException;
import Ice.UnknownLocalException;
import Ice.UnknownUserException;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.Instance;
import IceInternal.Protocol;
import IceInternal.ResponseHandler;
import IceInternal.ServantError;
import IceUtilInternal.OutputBase;
import IceUtilInternal.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;

class IncomingBase {
    protected Instance _instance;
    protected Current _current;
    protected Object _servant;
    protected ServantLocator _locator;
    protected LocalObjectHolder _cookie;
    protected DispatchObserver _observer;
    protected boolean _response;
    protected byte _compress;
    protected BasicStream _os;
    protected ResponseHandler _responseHandler;
    protected LinkedList<DispatchInterceptorAsyncCallback> _interceptorAsyncCallbackList;

    protected IncomingBase(Instance instance, ResponseHandler responseHandler, ConnectionI connectionI, ObjectAdapter objectAdapter, boolean bl, byte by, int n) {
        this._instance = instance;
        this._responseHandler = responseHandler;
        this._response = bl;
        this._compress = by;
        if (this._response) {
            this._os = new BasicStream(instance, Protocol.currentProtocolEncoding);
        }
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = objectAdapter;
        this._current.con = connectionI;
        this._current.requestId = n;
        this._cookie = new LocalObjectHolder();
    }

    protected IncomingBase(IncomingBase incomingBase) {
        this._current = incomingBase._current;
        if (incomingBase._interceptorAsyncCallbackList != null) {
            this._interceptorAsyncCallbackList = new LinkedList<DispatchInterceptorAsyncCallback>(incomingBase._interceptorAsyncCallbackList);
        }
        this.adopt(incomingBase);
    }

    protected void adopt(IncomingBase incomingBase) {
        this._instance = incomingBase._instance;
        this._observer = incomingBase._observer;
        incomingBase._observer = null;
        this._servant = incomingBase._servant;
        incomingBase._servant = null;
        this._locator = incomingBase._locator;
        incomingBase._locator = null;
        this._cookie = incomingBase._cookie;
        incomingBase._cookie = null;
        this._response = incomingBase._response;
        incomingBase._response = false;
        this._compress = incomingBase._compress;
        incomingBase._compress = 0;
        this._os = incomingBase._os;
        incomingBase._os = null;
        this._responseHandler = incomingBase._responseHandler;
        incomingBase._responseHandler = null;
    }

    public BasicStream __startWriteParams(FormatType formatType) {
        if (!this._response) {
            throw new MarshalException("can't marshal out parameters for oneway dispatch");
        }
        assert (this._os.size() == 18);
        assert (this._current.encoding != null);
        this._os.writeByte((byte)0);
        this._os.startWriteEncaps(this._current.encoding, formatType);
        return this._os;
    }

    public void __endWriteParams(boolean bl) {
        if (!bl && this._observer != null) {
            this._observer.userException();
        }
        assert (this._response);
        int n = this._os.pos();
        this._os.pos(18);
        this._os.writeByte(bl ? (byte)0 : 1);
        this._os.pos(n);
        this._os.endWriteEncaps();
    }

    public void __writeEmptyParams() {
        if (this._response) {
            assert (this._os.size() == 18);
            assert (this._current.encoding != null);
            this._os.writeByte((byte)0);
            this._os.writeEmptyEncaps(this._current.encoding);
        }
    }

    public void __writeParamEncaps(byte[] byArray, boolean bl) {
        if (!bl && this._observer != null) {
            this._observer.userException();
        }
        if (this._response) {
            assert (this._os.size() == 18);
            assert (this._current.encoding != null);
            this._os.writeByte(bl ? (byte)0 : 1);
            if (byArray == null || byArray.length == 0) {
                this._os.writeEmptyEncaps(this._current.encoding);
            } else {
                this._os.writeEncaps(byArray);
            }
        }
    }

    public void __writeUserException(UserException userException, FormatType formatType) {
        BasicStream basicStream = this.__startWriteParams(formatType);
        basicStream.writeUserException(userException);
        this.__endWriteParams(false);
    }

    public void reset(Instance instance, ResponseHandler responseHandler, ConnectionI connectionI, ObjectAdapter objectAdapter, boolean bl, byte by, int n) {
        this._instance = instance;
        this._current = new Current();
        this._current.id = new Identity();
        this._current.adapter = objectAdapter;
        this._current.con = connectionI;
        this._current.requestId = n;
        if (this._cookie == null) {
            this._cookie = new LocalObjectHolder();
        }
        this._response = bl;
        this._compress = by;
        if (this._response && this._os == null) {
            this._os = new BasicStream(instance, Protocol.currentProtocolEncoding);
        }
        this._responseHandler = responseHandler;
        this._interceptorAsyncCallbackList = null;
    }

    public void reclaim() {
        this._servant = null;
        this._locator = null;
        if (this._cookie != null) {
            this._cookie.value = null;
        }
        this._observer = null;
        if (this._os != null) {
            this._os.reset();
        }
        this._interceptorAsyncCallbackList = null;
    }

    protected final void __warning(java.lang.Exception exception) {
        assert (this._instance != null);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        OutputBase outputBase = new OutputBase(printWriter);
        outputBase.setUseTab(false);
        outputBase.print("dispatch exception:");
        outputBase.print("\nidentity: " + this._instance.identityToString(this._current.id));
        outputBase.print("\nfacet: " + StringUtil.escapeString(this._current.facet, ""));
        outputBase.print("\noperation: " + this._current.operation);
        if (this._current.con != null) {
            try {
                ConnectionInfo connectionInfo = this._current.con.getInfo();
                if (connectionInfo instanceof IPConnectionInfo) {
                    IPConnectionInfo iPConnectionInfo = (IPConnectionInfo)connectionInfo;
                    outputBase.print("\nremote host: " + iPConnectionInfo.remoteAddress + " remote port: " + Integer.toString(iPConnectionInfo.remotePort));
                }
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
        outputBase.print("\n");
        exception.printStackTrace(printWriter);
        printWriter.flush();
        this._instance.initializationData().logger.warning(stringWriter.toString());
    }

    protected final boolean __servantLocatorFinished(boolean bl) {
        assert (this._locator != null && this._servant != null);
        try {
            this._locator.finished(this._current, this._servant, this._cookie.value);
            return true;
        }
        catch (UserException userException) {
            assert (this._responseHandler != null);
            if (this._observer != null) {
                this._observer.userException();
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)1);
                this._os.startWriteEncaps(this._current.encoding, FormatType.DefaultFormat);
                this._os.writeUserException(userException);
                this._os.endWriteEncaps();
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
            } else {
                this._responseHandler.sendNoResponse();
            }
            if (this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            this._responseHandler = null;
        }
        catch (java.lang.Exception exception) {
            this.__handleException(exception, bl);
        }
        catch (Error error) {
            this.__handleError(error, bl);
        }
        return false;
    }

    protected final void __handleException(java.lang.Exception exception, boolean bl) {
        assert (this._responseHandler != null);
        try {
            throw exception;
        }
        catch (RequestFailedException requestFailedException) {
            if (requestFailedException.id == null || requestFailedException.id.name == null || requestFailedException.id.name.isEmpty()) {
                requestFailedException.id = this._current.id;
            }
            if (requestFailedException.facet == null || requestFailedException.facet.isEmpty()) {
                requestFailedException.facet = this._current.facet;
            }
            if (requestFailedException.operation == null || requestFailedException.operation.length() == 0) {
                requestFailedException.operation = this._current.operation;
            }
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 1) {
                this.__warning(requestFailedException);
            }
            if (this._observer != null) {
                this._observer.failed(requestFailedException.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                if (requestFailedException instanceof ObjectNotExistException) {
                    this._os.writeByte((byte)2);
                } else if (requestFailedException instanceof FacetNotExistException) {
                    this._os.writeByte((byte)3);
                } else if (requestFailedException instanceof OperationNotExistException) {
                    this._os.writeByte((byte)4);
                } else assert (false);
                requestFailedException.id.__write(this._os);
                if (requestFailedException.facet == null || requestFailedException.facet.length() == 0) {
                    this._os.writeStringSeq(null);
                } else {
                    String[] stringArray = new String[]{requestFailedException.facet};
                    this._os.writeStringSeq(stringArray);
                }
                this._os.writeString(requestFailedException.operation);
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (UnknownLocalException unknownLocalException) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(unknownLocalException);
            }
            if (this._observer != null) {
                this._observer.failed(unknownLocalException.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                this._os.writeString(unknownLocalException.unknown);
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (UnknownUserException unknownUserException) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(unknownUserException);
            }
            if (this._observer != null) {
                this._observer.failed(unknownUserException.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)6);
                this._os.writeString(unknownUserException.unknown);
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (UnknownException unknownException) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(unknownException);
            }
            if (this._observer != null) {
                this._observer.failed(unknownException.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                this._os.writeString(unknownException.unknown);
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (Exception exception2) {
            if (exception2 instanceof SystemException && this._responseHandler.systemException(this._current.requestId, (SystemException)exception2, bl)) {
                return;
            }
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(exception2);
            }
            if (this._observer != null) {
                this._observer.failed(exception2.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)5);
                StringWriter stringWriter = new StringWriter();
                stringWriter.write(exception2.ice_name() + "\n");
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception2.printStackTrace(printWriter);
                printWriter.flush();
                this._os.writeString(stringWriter.toString());
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (UserException userException) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(userException);
            }
            if (this._observer != null) {
                this._observer.failed(userException.ice_name());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)6);
                StringWriter stringWriter = new StringWriter();
                stringWriter.write(userException.ice_name() + "\n");
                PrintWriter printWriter = new PrintWriter(stringWriter);
                userException.printStackTrace(printWriter);
                printWriter.flush();
                this._os.writeString(stringWriter.toString());
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
            } else {
                this._responseHandler.sendNoResponse();
            }
        }
        catch (java.lang.Exception exception3) {
            if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
                this.__warning(exception3);
            }
            if (this._observer != null) {
                this._observer.failed(exception3.getClass().getName());
            }
            if (this._response) {
                this._os.resize(18, false);
                this._os.writeByte((byte)7);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception3.printStackTrace(printWriter);
                printWriter.flush();
                this._os.writeString(stringWriter.toString());
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
            }
            this._responseHandler.sendNoResponse();
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
        this._responseHandler = null;
    }

    protected final void __handleError(Error error, boolean bl) {
        assert (this._responseHandler != null);
        UnknownException unknownException = new UnknownException(error);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        error.printStackTrace(printWriter);
        printWriter.flush();
        unknownException.unknown = stringWriter.toString();
        if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
            this.__warning(unknownException);
        }
        if (this._observer != null) {
            this._observer.failed(unknownException.ice_name());
        }
        if (this._response) {
            this._os.resize(18, false);
            this._os.writeByte((byte)7);
            this._os.writeString(unknownException.unknown);
            if (this._observer != null) {
                this._observer.reply(this._os.size() - 14 - 4);
            }
            this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, bl);
        } else {
            this._responseHandler.sendNoResponse();
        }
        if (this._observer != null) {
            this._observer.detach();
            this._observer = null;
        }
        this._responseHandler = null;
        throw new ServantError(error);
    }
}

