/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AMDCallback;
import Ice.DispatchInterceptorAsyncCallback;
import Ice.LocalException;
import Ice.ResponseSentException;
import IceInternal.Incoming;
import IceInternal.IncomingBase;

public class IncomingAsync
extends IncomingBase
implements AMDCallback {
    private final boolean _retriable;
    private boolean _active = false;

    public IncomingAsync(Incoming incoming) {
        super(incoming);
        this._retriable = incoming.isRetriable();
        if (this._retriable) {
            incoming.setActive(this);
            this._active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ice_exception(Exception exception) {
        if (this._retriable) {
            try {
                if (this._interceptorAsyncCallbackList != null) {
                    for (DispatchInterceptorAsyncCallback dispatchInterceptorAsyncCallback : this._interceptorAsyncCallbackList) {
                        if (dispatchInterceptorAsyncCallback.exception(exception)) continue;
                        return;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                return;
            }
            IncomingAsync incomingAsync = this;
            synchronized (incomingAsync) {
                if (!this._active) {
                    return;
                }
                this._active = false;
            }
        }
        if (this._responseHandler != null) {
            this.__exception(exception);
        } else if (this._instance.initializationData().properties.getPropertyAsIntWithDefault("Ice.Warn.Dispatch", 1) > 0) {
            this.__warning(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void __deactivate(Incoming incoming) {
        assert (this._retriable);
        IncomingAsync incomingAsync = this;
        synchronized (incomingAsync) {
            if (!this._active) {
                throw new ResponseSentException();
            }
            this._active = false;
        }
        incoming.adopt(this);
    }

    protected final void __response() {
        try {
            if (this._locator != null && !this.__servantLocatorFinished(true)) {
                return;
            }
            assert (this._responseHandler != null);
            if (this._response) {
                if (this._observer != null) {
                    this._observer.reply(this._os.size() - 14 - 4);
                }
                this._responseHandler.sendResponse(this._current.requestId, this._os, this._compress, true);
            } else {
                this._responseHandler.sendNoResponse();
            }
            if (this._observer != null) {
                this._observer.detach();
                this._observer = null;
            }
            this._responseHandler = null;
        }
        catch (LocalException localException) {
            this._responseHandler.invokeException(this._current.requestId, localException, 1, true);
        }
    }

    public final void __error(Error error) {
        if (this._responseHandler == null) {
            throw error;
        }
        try {
            if (this._locator != null && !this.__servantLocatorFinished(true)) {
                return;
            }
            this.__handleError(error, true);
        }
        catch (LocalException localException) {
            this._responseHandler.invokeException(this._current.requestId, localException, 1, true);
        }
    }

    protected final void __exception(Exception exception) {
        try {
            if (this._locator != null && !this.__servantLocatorFinished(true)) {
                return;
            }
            this.__handleException(exception, true);
        }
        catch (LocalException localException) {
            this._responseHandler.invokeException(this._current.requestId, localException, 1, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean __validateResponse(boolean bl) {
        if (this._retriable) {
            try {
                if (this._interceptorAsyncCallbackList != null) {
                    for (DispatchInterceptorAsyncCallback dispatchInterceptorAsyncCallback : this._interceptorAsyncCallbackList) {
                        if (dispatchInterceptorAsyncCallback.response(bl)) continue;
                        return false;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
            IncomingAsync incomingAsync = this;
            synchronized (incomingAsync) {
                if (!this._active) {
                    return false;
                }
                this._active = false;
            }
        }
        return true;
    }
}

