/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointInfo;
import Ice.EndpointParseException;
import Ice.EndpointSelectionType;
import Ice.IPEndpointInfo;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointI_connectors;
import IceInternal.HashUtil;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import IceInternal.ProtocolInstance;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public abstract class IPEndpointI
extends EndpointI {
    protected ProtocolInstance _instance;
    protected String _host;
    protected int _port;
    protected InetSocketAddress _sourceAddr;
    protected String _connectionId;
    private boolean _hashInitialized;
    private int _hashValue;

    protected IPEndpointI(ProtocolInstance protocolInstance, String string, int n, InetSocketAddress inetSocketAddress, String string2) {
        this._instance = protocolInstance;
        this._host = string;
        this._port = n;
        this._sourceAddr = inetSocketAddress;
        this._connectionId = string2;
        this._hashInitialized = false;
    }

    protected IPEndpointI(ProtocolInstance protocolInstance) {
        this._instance = protocolInstance;
        this._host = null;
        this._port = 0;
        this._sourceAddr = null;
        this._connectionId = "";
        this._hashInitialized = false;
    }

    protected IPEndpointI(ProtocolInstance protocolInstance, BasicStream basicStream) {
        this._instance = protocolInstance;
        this._host = basicStream.readString();
        this._port = basicStream.readInt();
        this._sourceAddr = null;
        this._connectionId = "";
        this._hashInitialized = false;
    }

    @Override
    public void streamWrite(BasicStream basicStream) {
        basicStream.startWriteEncaps();
        this.streamWriteImpl(basicStream);
        basicStream.endWriteEncaps();
    }

    @Override
    public EndpointInfo getInfo() {
        IPEndpointInfo iPEndpointInfo = new IPEndpointInfo(){

            @Override
            public short type() {
                return IPEndpointI.this.type();
            }

            @Override
            public boolean datagram() {
                return IPEndpointI.this.datagram();
            }

            @Override
            public boolean secure() {
                return IPEndpointI.this.secure();
            }
        };
        this.fillEndpointInfo(iPEndpointInfo);
        return iPEndpointInfo;
    }

    @Override
    public short type() {
        return this._instance.type();
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public boolean secure() {
        return this._instance.secure();
    }

    @Override
    public String connectionId() {
        return this._connectionId;
    }

    @Override
    public EndpointI connectionId(String string) {
        if (string.equals(this._connectionId)) {
            return this;
        }
        return this.createEndpoint(this._host, this._port, string);
    }

    @Override
    public void connectors_async(EndpointSelectionType endpointSelectionType, EndpointI_connectors endpointI_connectors) {
        this._instance.resolve(this._host, this._port, endpointSelectionType, this, endpointI_connectors);
    }

    @Override
    public List<EndpointI> expand() {
        ArrayList<EndpointI> arrayList = new ArrayList<EndpointI>();
        ArrayList<String> arrayList2 = Network.getHostsForEndpointExpand(this._host, this._instance.protocolSupport(), false);
        if (arrayList2 == null || arrayList2.isEmpty()) {
            arrayList.add(this);
        } else {
            for (String string : arrayList2) {
                arrayList.add(this.createEndpoint(string, this._port, this._connectionId));
            }
        }
        return arrayList;
    }

    @Override
    public boolean equivalent(EndpointI endpointI) {
        if (!(endpointI instanceof IPEndpointI)) {
            return false;
        }
        IPEndpointI iPEndpointI = (IPEndpointI)endpointI;
        return iPEndpointI.type() == this.type() && iPEndpointI._host.equals(this._host) && iPEndpointI._port == this._port && Network.compareAddress(iPEndpointI._sourceAddr, this._sourceAddr) == 0;
    }

    public List<Connector> connectors(List<InetSocketAddress> list, NetworkProxy networkProxy) {
        ArrayList<Connector> arrayList = new ArrayList<Connector>();
        for (InetSocketAddress inetSocketAddress : list) {
            arrayList.add(this.createConnector(inetSocketAddress, networkProxy));
        }
        return arrayList;
    }

    public synchronized int hashCode() {
        if (!this._hashInitialized) {
            this._hashValue = 5381;
            this._hashValue = HashUtil.hashAdd(this._hashValue, this.type());
            this._hashValue = this.hashInit(this._hashValue);
            this._hashInitialized = true;
        }
        return this._hashValue;
    }

    @Override
    public String options() {
        String string = "";
        if (this._host != null && this._host.length() > 0) {
            boolean bl;
            string = string + " -h ";
            boolean bl2 = bl = this._host.indexOf(58) != -1;
            if (bl) {
                string = string + "\"";
            }
            string = string + this._host;
            if (bl) {
                string = string + "\"";
            }
        }
        string = string + " -p " + this._port;
        if (this._sourceAddr != null) {
            string = string + " --sourceAddress " + this._sourceAddr.getAddress().getHostAddress();
        }
        return string;
    }

    @Override
    public int compareTo(EndpointI endpointI) {
        if (!(endpointI instanceof IPEndpointI)) {
            return this.type() < endpointI.type() ? -1 : 1;
        }
        IPEndpointI iPEndpointI = (IPEndpointI)endpointI;
        if (this == iPEndpointI) {
            return 0;
        }
        int n = this._host.compareTo(iPEndpointI._host);
        if (n != 0) {
            return n;
        }
        if (this._port < iPEndpointI._port) {
            return -1;
        }
        if (iPEndpointI._port < this._port) {
            return 1;
        }
        int n2 = Network.compareAddress(this._sourceAddr, iPEndpointI._sourceAddr);
        if (n2 != 0) {
            return n2;
        }
        return this._connectionId.compareTo(iPEndpointI._connectionId);
    }

    public String host() {
        return this._host;
    }

    public int port() {
        return this._port;
    }

    public void streamWriteImpl(BasicStream basicStream) {
        basicStream.writeString(this._host);
        basicStream.writeInt(this._port);
    }

    public int hashInit(int n) {
        n = HashUtil.hashAdd(n, this._host);
        n = HashUtil.hashAdd(n, this._port);
        if (this._sourceAddr != null) {
            n = HashUtil.hashAdd(n, this._sourceAddr.getAddress().getHostAddress());
        }
        n = HashUtil.hashAdd(n, this._connectionId);
        return n;
    }

    public void fillEndpointInfo(IPEndpointInfo iPEndpointInfo) {
        iPEndpointInfo.host = this._host;
        iPEndpointInfo.port = this._port;
        iPEndpointInfo.sourceAddress = this._sourceAddr == null ? "" : this._sourceAddr.getAddress().getHostAddress();
    }

    public void initWithOptions(ArrayList<String> arrayList, boolean bl) {
        super.initWithOptions(arrayList);
        if (this._host == null || this._host.length() == 0) {
            this._host = this._instance.defaultHost();
        } else if (this._host.equals("*")) {
            if (bl) {
                this._host = "";
            } else {
                throw new EndpointParseException("`-h *' not valid for proxy endpoint `" + this.toString() + "'");
            }
        }
        if (this._host == null) {
            this._host = "";
        }
        if (this._sourceAddr == null) {
            if (!bl) {
                this._sourceAddr = this._instance.defaultSourceAddress();
            }
        } else if (bl) {
            throw new EndpointParseException("`--sourceAddress' not valid for object adapter endpoint `" + this.toString() + "'");
        }
    }

    @Override
    protected boolean checkOption(String string, String string2, String string3) {
        if (string.equals("-h")) {
            if (string2 == null) {
                throw new EndpointParseException("no argument provided for -h option in endpoint " + string3);
            }
            this._host = string2;
        } else if (string.equals("-p")) {
            if (string2 == null) {
                throw new EndpointParseException("no argument provided for -p option in endpoint " + string3);
            }
            try {
                this._port = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new EndpointParseException("invalid port value `" + string2 + "' in endpoint " + string3);
            }
            if (this._port < 0 || this._port > 65535) {
                throw new EndpointParseException("port value `" + string2 + "' out of range in endpoint " + string3);
            }
        } else if (string.equals("--sourceAddress")) {
            if (string2 == null) {
                throw new EndpointParseException("no argument provided for --sourceAddress option in endpoint " + string3);
            }
            this._sourceAddr = Network.getNumericAddress(string2);
            if (this._sourceAddr == null) {
                throw new EndpointParseException("invalid IP address provided for --sourceAddress option in endpoint " + string3);
            }
        } else {
            return false;
        }
        return true;
    }

    protected abstract Connector createConnector(InetSocketAddress var1, NetworkProxy var2);

    protected abstract IPEndpointI createEndpoint(String var1, int var2, String var3);
}

