/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import IceInternal.WebSocketException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

final class HttpParser {
    private Type _type;
    private StringBuffer _method = new StringBuffer();
    private StringBuffer _uri = new StringBuffer();
    private Map<String, String> _headers = new HashMap<String, String>();
    private Map<String, String> _headerNames = new HashMap<String, String>();
    private String _headerName = "";
    private int _versionMajor = 0;
    private int _versionMinor = 0;
    private int _status = 0;
    private String _reason;
    private State _state;

    HttpParser() {
        this._type = Type.Unknown;
        this._state = State.Init;
    }

    int isCompleteMessage(ByteBuffer byteBuffer, int n, int n2) {
        byte by;
        int n3;
        for (n3 = n; n3 < n2 && ((by = byteBuffer.get(n3)) == 13 || by == 10); ++n3) {
        }
        by = 0;
        while (n3 < n2) {
            byte by2;
            if ((by2 = byteBuffer.get(n3++)) == 10) {
                if (by != 0) {
                    return n3;
                }
                by = 1;
                continue;
            }
            if (by2 == 13) continue;
            by = 0;
        }
        return -1;
    }

    boolean parse(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        if (this._state == State.Complete) {
            this._state = State.Init;
        }
        block36: while (n3 != n2 && this._state != State.Complete) {
            char c = (char)byteBuffer.get(n3);
            switch (this._state) {
                case Init: {
                    this._method.setLength(0);
                    this._uri.setLength(0);
                    this._versionMajor = -1;
                    this._versionMinor = -1;
                    this._status = -1;
                    this._reason = "";
                    this._headers.clear();
                    this._state = State.Type;
                    continue block36;
                }
                case Type: {
                    if (c == '\r' || c == '\n') break;
                    if (c == 'H') {
                        this._state = State.TypeCheck;
                        break;
                    }
                    this._state = State.Request;
                    continue block36;
                }
                case TypeCheck: {
                    if (c == 'T') {
                        this._state = State.Response;
                        break;
                    }
                    if (c == 'E') {
                        this._state = State.Request;
                        this._method.append('H');
                        this._method.append('E');
                        break;
                    }
                    throw new WebSocketException("malformed request or response");
                }
                case Request: {
                    this._type = Type.Request;
                    this._state = State.RequestMethod;
                    continue block36;
                }
                case RequestMethod: {
                    if (c == ' ' || c == '\r' || c == '\n') {
                        this._state = State.RequestMethodSP;
                        continue block36;
                    }
                    this._method.append(c);
                    break;
                }
                case RequestMethodSP: {
                    if (c == ' ') break;
                    if (c == '\r' || c == '\n') {
                        throw new WebSocketException("malformed request");
                    }
                    this._state = State.RequestURI;
                    continue block36;
                }
                case RequestURI: {
                    if (c == ' ' || c == '\r' || c == '\n') {
                        this._state = State.RequestURISP;
                        continue block36;
                    }
                    this._uri.append(c);
                    break;
                }
                case RequestURISP: {
                    if (c == ' ') break;
                    if (c == '\r' || c == '\n') {
                        throw new WebSocketException("malformed request");
                    }
                    this._state = State.Version;
                    continue block36;
                }
                case RequestLF: {
                    if (c != '\n') {
                        throw new WebSocketException("malformed request");
                    }
                    this._state = State.HeaderFieldStart;
                    break;
                }
                case HeaderFieldStart: {
                    if (c == '\r') {
                        this._state = State.HeaderFieldEndLF;
                        break;
                    }
                    if (c == '\n') {
                        this._state = State.Complete;
                        break;
                    }
                    if (c == ' ') {
                        this._state = State.HeaderFieldContStart;
                        break;
                    }
                    this._state = State.HeaderFieldNameStart;
                    continue block36;
                }
                case HeaderFieldContStart: {
                    if (c == ' ') break;
                    this._state = State.HeaderFieldCont;
                    n4 = n3;
                    continue block36;
                }
                case HeaderFieldCont: {
                    CharSequence charSequence;
                    if (c != '\r' && c != '\n') break;
                    if (n3 > n4) {
                        if (this._headerName.isEmpty()) {
                            throw new WebSocketException("malformed header");
                        }
                        charSequence = this._headers.get(this._headerName);
                        assert (charSequence != null);
                        StringBuffer stringBuffer = new StringBuffer((String)charSequence);
                        stringBuffer.append(' ');
                        for (int i = n4; i < n3; ++i) {
                            stringBuffer.append((char)byteBuffer.get(i));
                        }
                        this._headers.put(this._headerName, stringBuffer.toString());
                        this._state = c == '\r' ? State.HeaderFieldLF : State.HeaderFieldStart;
                        break;
                    }
                    this._state = c == '\r' ? State.HeaderFieldEndLF : State.Complete;
                    break;
                }
                case HeaderFieldNameStart: {
                    assert (c != ' ');
                    n4 = n3;
                    this._headerName = "";
                    this._state = State.HeaderFieldName;
                    continue block36;
                }
                case HeaderFieldName: {
                    if (c == ' ' || c == ':') {
                        this._state = State.HeaderFieldNameEnd;
                        continue block36;
                    }
                    if (c != '\r' && c != '\n') break;
                    throw new WebSocketException("malformed header");
                }
                case HeaderFieldNameEnd: {
                    CharSequence charSequence;
                    if (this._headerName.isEmpty()) {
                        charSequence = new StringBuffer();
                        for (int i = n4; i < n3; ++i) {
                            ((StringBuffer)charSequence).append((char)byteBuffer.get(i));
                        }
                        this._headerName = ((StringBuffer)charSequence).toString().toLowerCase();
                        if (!this._headers.containsKey(this._headerName)) {
                            this._headers.put(this._headerName, "");
                            this._headerNames.put(this._headerName, ((StringBuffer)charSequence).toString());
                        }
                    }
                    if (c == ' ') break;
                    if (c != ':' || n3 == n4) {
                        throw new WebSocketException("malformed header");
                    }
                    this._state = State.HeaderFieldValueStart;
                    break;
                }
                case HeaderFieldValueStart: {
                    if (c == ' ') break;
                    if (c == '\r') {
                        this._state = State.HeaderFieldLF;
                        break;
                    }
                    if (c == '\n') {
                        this._state = State.HeaderFieldStart;
                        break;
                    }
                    n4 = n3;
                    this._state = State.HeaderFieldValue;
                    continue block36;
                }
                case HeaderFieldValue: {
                    if (c != '\r' && c != '\n') break;
                    this._state = State.HeaderFieldValueEnd;
                    continue block36;
                }
                case HeaderFieldValueEnd: {
                    CharSequence charSequence;
                    assert (c == '\r' || c == '\n');
                    if (n3 > n4) {
                        charSequence = new StringBuffer();
                        for (int i = n4; i < n3; ++i) {
                            ((StringBuffer)charSequence).append((char)byteBuffer.get(i));
                        }
                        String string = this._headers.get(this._headerName);
                        if (string == null || string.length() == 0) {
                            this._headers.put(this._headerName, ((StringBuffer)charSequence).toString());
                        } else {
                            this._headers.put(this._headerName, string + ", " + ((StringBuffer)charSequence).toString());
                        }
                    }
                    if (c == '\r') {
                        this._state = State.HeaderFieldLF;
                        break;
                    }
                    this._state = State.HeaderFieldStart;
                    break;
                }
                case HeaderFieldLF: {
                    if (c != '\n') {
                        throw new WebSocketException("malformed header");
                    }
                    this._state = State.HeaderFieldStart;
                    break;
                }
                case HeaderFieldEndLF: {
                    if (c != '\n') {
                        throw new WebSocketException("malformed header");
                    }
                    this._state = State.Complete;
                    break;
                }
                case Version: {
                    if (c != 'H') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionH;
                    break;
                }
                case VersionH: {
                    if (c != 'T') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionHT;
                    break;
                }
                case VersionHT: {
                    if (c != 'T') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionHTT;
                    break;
                }
                case VersionHTT: {
                    if (c != 'P') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionHTTP;
                    break;
                }
                case VersionHTTP: {
                    if (c != '/') {
                        throw new WebSocketException("malformed version");
                    }
                    this._state = State.VersionMajor;
                    break;
                }
                case VersionMajor: {
                    if (c == '.') {
                        if (this._versionMajor == -1) {
                            throw new WebSocketException("malformed version");
                        }
                        this._state = State.VersionMinor;
                        break;
                    }
                    if (c < '0' || c > '9') {
                        throw new WebSocketException("malformed version");
                    }
                    if (this._versionMajor == -1) {
                        this._versionMajor = 0;
                    }
                    this._versionMajor *= 10;
                    this._versionMajor += c - 48;
                    break;
                }
                case VersionMinor: {
                    if (c == '\r') {
                        if (this._versionMinor == -1 || this._type != Type.Request) {
                            throw new WebSocketException("malformed version");
                        }
                        this._state = State.RequestLF;
                        break;
                    }
                    if (c == '\n') {
                        if (this._versionMinor == -1 || this._type != Type.Request) {
                            throw new WebSocketException("malformed version");
                        }
                        this._state = State.HeaderFieldStart;
                        break;
                    }
                    if (c == ' ') {
                        if (this._versionMinor == -1 || this._type != Type.Response) {
                            throw new WebSocketException("malformed version");
                        }
                        this._state = State.ResponseVersionSP;
                        break;
                    }
                    if (c < '0' || c > '9') {
                        throw new WebSocketException("malformed version");
                    }
                    if (this._versionMinor == -1) {
                        this._versionMinor = 0;
                    }
                    this._versionMinor *= 10;
                    this._versionMinor += c - 48;
                    break;
                }
                case Response: {
                    this._type = Type.Response;
                    this._state = State.VersionHT;
                    continue block36;
                }
                case ResponseVersionSP: {
                    if (c == ' ') break;
                    this._state = State.ResponseStatus;
                    continue block36;
                }
                case ResponseStatus: {
                    if (c == '\r') {
                        if (this._status == -1) {
                            throw new WebSocketException("malformed response status");
                        }
                        this._state = State.ResponseLF;
                        break;
                    }
                    if (c == '\n') {
                        if (this._status == -1) {
                            throw new WebSocketException("malformed response status");
                        }
                        this._state = State.HeaderFieldStart;
                        break;
                    }
                    if (c == ' ') {
                        if (this._status == -1) {
                            throw new WebSocketException("malformed response status");
                        }
                        this._state = State.ResponseReasonStart;
                        break;
                    }
                    if (c < '0' || c > '9') {
                        throw new WebSocketException("malformed response status");
                    }
                    if (this._status == -1) {
                        this._status = 0;
                    }
                    this._status *= 10;
                    this._status += c - 48;
                    break;
                }
                case ResponseReasonStart: {
                    if (c == ' ') break;
                    this._state = State.ResponseReason;
                    n4 = n3;
                    continue block36;
                }
                case ResponseReason: {
                    CharSequence charSequence;
                    if (c != '\r' && c != '\n') break;
                    if (n3 > n4) {
                        charSequence = new StringBuffer();
                        for (int i = n4; i < n3; ++i) {
                            ((StringBuffer)charSequence).append((char)byteBuffer.get(i));
                        }
                        this._reason = ((StringBuffer)charSequence).toString();
                    }
                    this._state = c == '\r' ? State.ResponseLF : State.HeaderFieldStart;
                    break;
                }
                case ResponseLF: {
                    if (c != '\n') {
                        throw new WebSocketException("malformed status line");
                    }
                    this._state = State.HeaderFieldStart;
                    break;
                }
                case Complete: {
                    assert (false);
                    break;
                }
            }
            ++n3;
        }
        return this._state == State.Complete;
    }

    String uri() {
        assert (this._type == Type.Request);
        return this._uri.toString();
    }

    int versionMajor() {
        return this._versionMajor;
    }

    int versionMinor() {
        return this._versionMinor;
    }

    int status() {
        return this._status;
    }

    String reason() {
        return this._reason;
    }

    String getHeader(String string, boolean bl) {
        String string2 = this._headers.get(string.toLowerCase());
        if (string2 != null) {
            return bl ? string2.trim().toLowerCase() : string2.trim();
        }
        return null;
    }

    Map<String, String> getHeaders() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this._headers.entrySet()) {
            hashMap.put(this._headerNames.get(entry.getKey()), entry.getValue().trim());
        }
        return hashMap;
    }

    private static enum State {
        Init,
        Type,
        TypeCheck,
        Request,
        RequestMethod,
        RequestMethodSP,
        RequestURI,
        RequestURISP,
        RequestLF,
        HeaderFieldStart,
        HeaderFieldContStart,
        HeaderFieldCont,
        HeaderFieldNameStart,
        HeaderFieldName,
        HeaderFieldNameEnd,
        HeaderFieldValueStart,
        HeaderFieldValue,
        HeaderFieldValueEnd,
        HeaderFieldLF,
        HeaderFieldEndLF,
        Version,
        VersionH,
        VersionHT,
        VersionHTT,
        VersionHTTP,
        VersionMajor,
        VersionMinor,
        Response,
        ResponseVersionSP,
        ResponseStatus,
        ResponseReasonStart,
        ResponseReason,
        ResponseLF,
        Complete;

    }

    private static enum Type {
        Unknown,
        Request,
        Response;

    }
}

