/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.EndpointSelectionType;
import IceInternal.Buffer;
import IceInternal.HttpParser;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;

public final class HTTPNetworkProxy
implements NetworkProxy {
    private String _host;
    private int _port;
    private InetSocketAddress _address;
    private int _protocolSupport;

    public HTTPNetworkProxy(String string, int n) {
        this._host = string;
        this._port = n;
        this._protocolSupport = 2;
    }

    private HTTPNetworkProxy(InetSocketAddress inetSocketAddress, int n) {
        this._address = inetSocketAddress;
        this._protocolSupport = n;
    }

    @Override
    public void beginWrite(InetSocketAddress inetSocketAddress, Buffer buffer) {
        String string = Network.addrToString(inetSocketAddress);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONNECT ");
        stringBuilder.append(string);
        stringBuilder.append(" HTTP/1.1\r\nHost: ");
        stringBuilder.append(string);
        stringBuilder.append("\r\n\r\n");
        byte[] byArray = stringBuilder.toString().getBytes(Charset.forName("US-ASCII"));
        buffer.resize(byArray.length, false);
        buffer.b.position(0);
        buffer.b.put(byArray);
        buffer.b.position(0);
        buffer.b.limit(buffer.size());
    }

    @Override
    public int endWrite(Buffer buffer) {
        return buffer.b.hasRemaining() ? 4 : 1;
    }

    @Override
    public void beginRead(Buffer buffer) {
        buffer.resize(7, true);
        buffer.b.position(0);
    }

    @Override
    public int endRead(Buffer buffer) {
        int n = new HttpParser().isCompleteMessage(buffer.b, 0, buffer.b.position());
        if (n < 0 && !buffer.b.hasRemaining()) {
            buffer.resize(buffer.size() + 1, true);
            return 1;
        }
        return 0;
    }

    @Override
    public void finish(Buffer buffer, Buffer buffer2) {
        HttpParser httpParser = new HttpParser();
        httpParser.parse(buffer.b, 0, buffer.b.position());
        if (httpParser.status() != 200) {
            throw new ConnectFailedException();
        }
    }

    @Override
    public NetworkProxy resolveHost(int n) {
        assert (this._host != null);
        return new HTTPNetworkProxy(Network.getAddresses(this._host, this._port, n, EndpointSelectionType.Random, false, true).get(0), n);
    }

    @Override
    public InetSocketAddress getAddress() {
        assert (this._address != null);
        return this._address;
    }

    @Override
    public String getName() {
        return "HTTP";
    }

    @Override
    public int getProtocolSupport() {
        return this._protocolSupport;
    }
}

