/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EncodingVersion;
import Ice.EndpointSelectionType;
import Ice.FixedProxyException;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.BatchRequestQueue;
import IceInternal.ConnectionRequestHandler;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.QueueRequestHandler;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RouterInfo;
import java.util.Map;

public class FixedReference
extends Reference {
    private ConnectionI _fixedConnection;
    private static EndpointI[] _emptyEndpoints = new EndpointI[0];

    public FixedReference(Instance instance, Communicator communicator, Identity identity, String string, int n, boolean bl, EncodingVersion encodingVersion, ConnectionI connectionI) {
        super(instance, communicator, identity, string, n, bl, Util.Protocol_1_0, encodingVersion, -1, null);
        this._fixedConnection = connectionI;
    }

    @Override
    public EndpointI[] getEndpoints() {
        return _emptyEndpoints;
    }

    @Override
    public String getAdapterId() {
        return "";
    }

    @Override
    public LocatorInfo getLocatorInfo() {
        return null;
    }

    @Override
    public RouterInfo getRouterInfo() {
        return null;
    }

    @Override
    public boolean getCollocationOptimized() {
        return false;
    }

    @Override
    public final boolean getCacheConnection() {
        return true;
    }

    @Override
    public boolean getPreferSecure() {
        return false;
    }

    @Override
    public final EndpointSelectionType getEndpointSelection() {
        return EndpointSelectionType.Random;
    }

    @Override
    public int getLocatorCacheTimeout() {
        return 0;
    }

    @Override
    public String getConnectionId() {
        return "";
    }

    @Override
    public Reference changeEndpoints(EndpointI[] endpointIArray) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeAdapterId(String string) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeLocator(LocatorPrx locatorPrx) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeRouter(RouterPrx routerPrx) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeCollocationOptimized(boolean bl) {
        throw new FixedProxyException();
    }

    @Override
    public final Reference changeCacheConnection(boolean bl) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changePreferSecure(boolean bl) {
        throw new FixedProxyException();
    }

    @Override
    public final Reference changeEndpointSelection(EndpointSelectionType endpointSelectionType) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeLocatorCacheTimeout(int n) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeTimeout(int n) {
        throw new FixedProxyException();
    }

    @Override
    public Reference changeConnectionId(String string) {
        throw new FixedProxyException();
    }

    @Override
    public boolean isIndirect() {
        return false;
    }

    @Override
    public boolean isWellKnown() {
        return false;
    }

    @Override
    public void streamWrite(BasicStream basicStream) throws MarshalException {
        throw new FixedProxyException();
    }

    @Override
    public String toString() throws MarshalException {
        throw new FixedProxyException();
    }

    @Override
    public Map<String, String> toProperty(String string) {
        throw new FixedProxyException();
    }

    @Override
    public RequestHandler getRequestHandler(ObjectPrxHelperBase objectPrxHelperBase) {
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                if (!this._fixedConnection.endpoint().datagram()) break;
                throw new NoEndpointException("");
            }
            case 3: 
            case 4: {
                if (this._fixedConnection.endpoint().datagram()) break;
                throw new NoEndpointException("");
            }
        }
        DefaultsAndOverrides defaultsAndOverrides = this.getInstance().defaultsAndOverrides();
        boolean bl = defaultsAndOverrides.overrideSecure ? defaultsAndOverrides.overrideSecureValue : this.getSecure();
        if (bl && !this._fixedConnection.endpoint().secure()) {
            throw new NoEndpointException("");
        }
        this._fixedConnection.throwException();
        boolean bl2 = defaultsAndOverrides.overrideCompress ? defaultsAndOverrides.overrideCompressValue : (this._overrideCompress ? this._compress : this._fixedConnection.endpoint().compress());
        RequestHandler requestHandler = new ConnectionRequestHandler(this, this._fixedConnection, bl2);
        if (this.getInstance().queueRequests()) {
            requestHandler = new QueueRequestHandler(this.getInstance(), requestHandler);
        }
        return objectPrxHelperBase.__setRequestHandler(requestHandler);
    }

    @Override
    public BatchRequestQueue getBatchRequestQueue() {
        return this._fixedConnection.getBatchRequestQueue();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FixedReference)) {
            return false;
        }
        FixedReference fixedReference = (FixedReference)object;
        if (!super.equals(fixedReference)) {
            return false;
        }
        return this._fixedConnection.equals(fixedReference._fixedConnection);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

