/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ACM;
import Ice.ACMClose;
import Ice.ACMHeartbeat;
import Ice.ConnectionI;
import Ice.IntOptional;
import Ice.Optional;
import IceInternal.ACMConfig;
import IceInternal.ACMMonitor;
import IceInternal.ConnectionACMMonitor;
import IceInternal.Instance;
import IceInternal.Time;
import IceUtilInternal.Assert;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class FactoryACMMonitor
implements ACMMonitor {
    private Instance _instance;
    private final ACMConfig _config;
    private Set<ConnectionI> _connections = new HashSet<ConnectionI>();
    private List<Change> _changes = new ArrayList<Change>();
    private List<ConnectionI> _reapedConnections = new ArrayList<ConnectionI>();
    private Future<?> _future;

    FactoryACMMonitor(Instance instance, ACMConfig aCMConfig) {
        this._instance = instance;
        this._config = aCMConfig;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._instance == null);
            Assert.FinalizerAssert(this._connections.isEmpty());
            Assert.FinalizerAssert(this._changes.isEmpty());
            Assert.FinalizerAssert(this._reapedConnections.isEmpty());
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    synchronized void destroy() {
        if (this._instance == null) {
            return;
        }
        this._instance = null;
        this._connections.clear();
        this._changes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(ConnectionI connectionI) {
        if (this._config.timeout == 0) {
            return;
        }
        FactoryACMMonitor factoryACMMonitor = this;
        synchronized (factoryACMMonitor) {
            if (this._connections.isEmpty()) {
                this._connections.add(connectionI);
                assert (this._future == null);
                this._future = this._instance.timer().scheduleAtFixedRate(new Runnable(){

                    @Override
                    public void run() {
                        FactoryACMMonitor.this.monitorConnections();
                    }
                }, this._config.timeout / 2, this._config.timeout / 2, TimeUnit.MILLISECONDS);
            } else {
                this._changes.add(new Change(connectionI, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(ConnectionI connectionI) {
        if (this._config.timeout == 0) {
            return;
        }
        FactoryACMMonitor factoryACMMonitor = this;
        synchronized (factoryACMMonitor) {
            assert (this._instance != null);
            this._changes.add(new Change(connectionI, true));
        }
    }

    @Override
    public synchronized void reap(ConnectionI connectionI) {
        this._reapedConnections.add(connectionI);
    }

    @Override
    public synchronized ACMMonitor acm(IntOptional intOptional, Optional<ACMClose> optional, Optional<ACMHeartbeat> optional2) {
        assert (this._instance != null);
        ACMConfig aCMConfig = this._config.clone();
        if (intOptional != null && intOptional.isSet()) {
            aCMConfig.timeout = intOptional.get() * 1000;
        }
        if (optional != null && optional.isSet()) {
            aCMConfig.close = optional.get();
        }
        if (optional2 != null && optional2.isSet()) {
            aCMConfig.heartbeat = optional2.get();
        }
        return new ConnectionACMMonitor(this, this._instance.timer(), aCMConfig);
    }

    @Override
    public ACM getACM() {
        ACM aCM = new ACM();
        aCM.timeout = this._config.timeout / 1000;
        aCM.close = this._config.close;
        aCM.heartbeat = this._config.heartbeat;
        return aCM;
    }

    synchronized List<ConnectionI> swapReapedConnections() {
        if (this._reapedConnections.isEmpty()) {
            return null;
        }
        List<ConnectionI> list = this._reapedConnections;
        this._reapedConnections = new ArrayList<ConnectionI>();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorConnections() {
        FactoryACMMonitor factoryACMMonitor = this;
        synchronized (factoryACMMonitor) {
            if (this._instance == null) {
                return;
            }
            for (Change object : this._changes) {
                if (object.remove) {
                    this._connections.remove(object.connection);
                    continue;
                }
                this._connections.add(object.connection);
            }
            this._changes.clear();
            if (this._connections.isEmpty()) {
                this._future.cancel(false);
                this._future = null;
                return;
            }
        }
        long l = Time.currentMonotonicTimeMillis();
        for (ConnectionI connectionI : this._connections) {
            try {
                connectionI.monitor(l, this._config);
            }
            catch (Exception exception) {
                this.handleException(exception);
            }
        }
    }

    synchronized void handleException(Exception exception) {
        if (this._instance == null) {
            return;
        }
        this._instance.initializationData().logger.error("exception in connection monitor:\n" + exception);
    }

    static class Change {
        final ConnectionI connection;
        final boolean remove;

        Change(ConnectionI connectionI, boolean bl) {
            this.connection = connectionI;
            this.remove = bl;
        }
    }
}

