/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.EndpointSelectionType;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.Instrumentation.Observer;
import Ice.Instrumentation.ThreadObserver;
import Ice.Instrumentation.ThreadState;
import Ice.LocalException;
import IceInternal.EndpointI_connectors;
import IceInternal.Ex;
import IceInternal.IPEndpointI;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.NetworkProxy;
import IceInternal.Util;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class EndpointHostResolver {
    private final Instance _instance;
    private final int _protocol;
    private final boolean _preferIPv6;
    private boolean _destroyed;
    private ThreadObserver _observer;
    private String _threadName;
    private ExecutorService _executor;

    EndpointHostResolver(Instance instance) {
        this._instance = instance;
        this._protocol = instance.protocolSupport();
        this._preferIPv6 = instance.preferIPv6();
        try {
            this._threadName = Util.createThreadName(this._instance.initializationData().properties, "Ice.HostResolver");
            this._executor = Executors.newFixedThreadPool(1, Util.createThreadFactory(this._instance.initializationData().properties, this._threadName));
            this.updateObserver();
        }
        catch (RuntimeException runtimeException) {
            String string = "cannot create thread for endpoint host resolver thread:\n" + Ex.toString(runtimeException);
            this._instance.initializationData().logger.error(string);
            throw runtimeException;
        }
    }

    synchronized void resolve(String string, int n, EndpointSelectionType endpointSelectionType, IPEndpointI iPEndpointI, final EndpointI_connectors endpointI_connectors) {
        Object object;
        assert (!this._destroyed);
        NetworkProxy networkProxy = this._instance.networkProxy();
        if (networkProxy == null && (object = Network.getAddresses(string, n, this._protocol, endpointSelectionType, this._preferIPv6, false)) != null) {
            endpointI_connectors.connectors(iPEndpointI.connectors((List<InetSocketAddress>)object, networkProxy));
            return;
        }
        object = this._observer;
        final Observer observer = this.getObserver(iPEndpointI);
        if (observer != null) {
            observer.attach();
        }
        this._executor.execute(new Runnable((ThreadObserver)object, iPEndpointI, string, n, endpointSelectionType){
            final /* synthetic */ ThreadObserver val$threadObserver;
            final /* synthetic */ IPEndpointI val$endpoint;
            final /* synthetic */ String val$host;
            final /* synthetic */ int val$port;
            final /* synthetic */ EndpointSelectionType val$selType;
            {
                this.val$threadObserver = threadObserver;
                this.val$endpoint = iPEndpointI;
                this.val$host = string;
                this.val$port = n;
                this.val$selType = endpointSelectionType;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EndpointHostResolver endpointHostResolver = EndpointHostResolver.this;
                synchronized (endpointHostResolver) {
                    if (EndpointHostResolver.this._destroyed) {
                        CommunicatorDestroyedException communicatorDestroyedException = new CommunicatorDestroyedException();
                        if (observer != null) {
                            observer.failed(communicatorDestroyedException.ice_name());
                            observer.detach();
                        }
                        endpointI_connectors.exception(communicatorDestroyedException);
                        return;
                    }
                }
                if (this.val$threadObserver != null) {
                    this.val$threadObserver.stateChanged(ThreadState.ThreadStateIdle, ThreadState.ThreadStateInUseForOther);
                }
                try {
                    int n = EndpointHostResolver.this._protocol;
                    NetworkProxy networkProxy = EndpointHostResolver.this._instance.networkProxy();
                    if (networkProxy != null && (networkProxy = networkProxy.resolveHost(EndpointHostResolver.this._protocol)) != null) {
                        n = networkProxy.getProtocolSupport();
                    }
                    endpointI_connectors.connectors(this.val$endpoint.connectors(Network.getAddresses(this.val$host, this.val$port, n, this.val$selType, EndpointHostResolver.this._preferIPv6, true), networkProxy));
                }
                catch (LocalException localException) {
                    if (observer != null) {
                        observer.failed(localException.ice_name());
                    }
                    endpointI_connectors.exception(localException);
                }
                finally {
                    if (this.val$threadObserver != null) {
                        this.val$threadObserver.stateChanged(ThreadState.ThreadStateInUseForOther, ThreadState.ThreadStateIdle);
                    }
                    if (observer != null) {
                        observer.detach();
                    }
                }
            }
        });
    }

    synchronized void destroy() {
        assert (!this._destroyed);
        this._destroyed = true;
        this._executor.shutdown();
    }

    void joinWithThread() throws InterruptedException {
        try {
            while (!this._executor.isTerminated()) {
                this._executor.awaitTermination(100000L, TimeUnit.SECONDS);
            }
        }
        finally {
            if (this._observer != null) {
                this._observer.detach();
            }
        }
    }

    synchronized void updateObserver() {
        CommunicatorObserver communicatorObserver = this._instance.initializationData().observer;
        if (communicatorObserver != null) {
            this._observer = communicatorObserver.getThreadObserver("Communicator", this._threadName, ThreadState.ThreadStateIdle, this._observer);
            if (this._observer != null) {
                this._observer.attach();
            }
        }
    }

    private Observer getObserver(IPEndpointI iPEndpointI) {
        CommunicatorObserver communicatorObserver = this._instance.initializationData().observer;
        if (communicatorObserver != null) {
            return communicatorObserver.getEndpointLookupObserver(iPEndpointI);
        }
        return null;
    }
}

