/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointParseException;
import IceInternal.BasicStream;
import IceInternal.Buffer;
import IceInternal.EndpointFactory;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.OpaqueEndpointI;
import IceInternal.Protocol;
import IceUtilInternal.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class EndpointFactoryManager {
    private Instance _instance;
    private List<EndpointFactory> _factories = new ArrayList<EndpointFactory>();

    EndpointFactoryManager(Instance instance) {
        this._instance = instance;
    }

    public synchronized void add(EndpointFactory endpointFactory) {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory endpointFactory2 = this._factories.get(i);
            if (endpointFactory2.type() == endpointFactory.type()) assert (false);
        }
        this._factories.add(endpointFactory);
    }

    public synchronized EndpointFactory get(short s) {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory endpointFactory = this._factories.get(i);
            if (endpointFactory.type() != s) continue;
            return endpointFactory;
        }
        return null;
    }

    public synchronized EndpointI create(String string, boolean bl) {
        Object object;
        String[] stringArray = StringUtil.splitString(string, " \t\r\n");
        if (stringArray == null) {
            EndpointParseException endpointParseException = new EndpointParseException();
            endpointParseException.str = "mismatched quote";
            throw endpointParseException;
        }
        if (stringArray.length == 0) {
            EndpointParseException endpointParseException = new EndpointParseException();
            endpointParseException.str = "value has no non-whitespace characters";
            throw endpointParseException;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        String string2 = arrayList.get(0);
        arrayList.remove(0);
        if (string2.equals("default")) {
            string2 = this._instance.defaultsAndOverrides().defaultProtocol;
        }
        EndpointFactory endpointFactory = null;
        for (int i = 0; i < this._factories.size(); ++i) {
            object = this._factories.get(i);
            if (!object.protocol().equals(string2)) continue;
            endpointFactory = object;
        }
        if (endpointFactory != null) {
            EndpointI endpointI = endpointFactory.create(arrayList, bl);
            if (!arrayList.isEmpty()) {
                object = new EndpointParseException();
                ((EndpointParseException)object).str = "unrecognized argument `" + arrayList.get(0) + "' in endpoint `" + string + "'";
                throw object;
            }
            return endpointI;
        }
        if (string2.equals("opaque")) {
            OpaqueEndpointI opaqueEndpointI = new OpaqueEndpointI(arrayList);
            if (!arrayList.isEmpty()) {
                object = new EndpointParseException();
                ((EndpointParseException)object).str = "unrecognized argument `" + arrayList.get(0) + "' in endpoint `" + string + "'";
                throw object;
            }
            endpointFactory = this.get(((EndpointI)opaqueEndpointI).type());
            if (endpointFactory != null) {
                object = new BasicStream(this._instance, Protocol.currentProtocolEncoding, false);
                ((BasicStream)object).writeShort(((EndpointI)opaqueEndpointI).type());
                ((EndpointI)opaqueEndpointI).streamWrite((BasicStream)object);
                Buffer buffer = ((BasicStream)object).getBuffer();
                buffer.b.position(0);
                buffer.b.limit(buffer.size());
                ((BasicStream)object).readShort();
                ((BasicStream)object).startReadEncaps();
                EndpointI endpointI = endpointFactory.read((BasicStream)object);
                ((BasicStream)object).endReadEncaps();
                return endpointI;
            }
            return opaqueEndpointI;
        }
        return null;
    }

    public synchronized EndpointI read(BasicStream basicStream) {
        short s = basicStream.readShort();
        EndpointFactory endpointFactory = this.get(s);
        EndpointI endpointI = null;
        basicStream.startReadEncaps();
        endpointI = endpointFactory != null ? endpointFactory.read(basicStream) : new OpaqueEndpointI(s, basicStream);
        basicStream.endReadEncaps();
        return endpointI;
    }

    void destroy() {
        for (int i = 0; i < this._factories.size(); ++i) {
            EndpointFactory endpointFactory = this._factories.get(i);
            endpointFactory.destroy();
        }
        this._factories.clear();
    }
}

