/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EncodingVersion;
import Ice.EndpointSelectionType;
import Ice.EndpointSelectionTypeParseException;
import Ice.FormatType;
import Ice.InitializationException;
import Ice.Logger;
import Ice.Properties;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.Network;
import IceInternal.Protocol;
import java.net.InetSocketAddress;

public final class DefaultsAndOverrides {
    public final String defaultHost;
    public final InetSocketAddress defaultSourceAddress;
    public final String defaultProtocol;
    public final boolean defaultCollocationOptimization;
    public final EndpointSelectionType defaultEndpointSelection;
    public final int defaultTimeout;
    public final int defaultLocatorCacheTimeout;
    public final int defaultInvocationTimeout;
    public final boolean defaultPreferSecure;
    public final EncodingVersion defaultEncoding;
    public final FormatType defaultFormat;
    public final boolean overrideTimeout;
    public final int overrideTimeoutValue;
    public final boolean overrideConnectTimeout;
    public final int overrideConnectTimeoutValue;
    public final boolean overrideCloseTimeout;
    public final int overrideCloseTimeoutValue;
    public final boolean overrideCompress;
    public final boolean overrideCompressValue;
    public final boolean overrideSecure;
    public final boolean overrideSecureValue;

    DefaultsAndOverrides(Properties properties, Logger logger) {
        StringBuffer stringBuffer;
        int n;
        this.defaultProtocol = properties.getPropertyWithDefault("Ice.Default.Protocol", "tcp");
        String string = properties.getProperty("Ice.Default.Host");
        this.defaultHost = !string.isEmpty() ? string : null;
        string = properties.getProperty("Ice.Default.SourceAddress");
        if (!string.isEmpty()) {
            this.defaultSourceAddress = Network.getNumericAddress(string);
            if (this.defaultSourceAddress == null) {
                throw new InitializationException("invalid IP address set for Ice.Default.SourceAddress: `" + string + "'");
            }
        } else {
            this.defaultSourceAddress = null;
        }
        if (!(string = properties.getProperty("Ice.Override.Timeout")).isEmpty()) {
            this.overrideTimeout = true;
            n = properties.getPropertyAsInt("Ice.Override.Timeout");
            if (n < 0 && n != -1) {
                this.overrideTimeoutValue = -1;
                stringBuffer = new StringBuffer("invalid value for Ice.Override.Timeout `");
                stringBuffer.append(properties.getProperty("Ice.Override.Timeout"));
                stringBuffer.append("': defaulting to -1");
                logger.warning(stringBuffer.toString());
            } else {
                this.overrideTimeoutValue = n;
            }
        } else {
            this.overrideTimeout = false;
            this.overrideTimeoutValue = -1;
        }
        string = properties.getProperty("Ice.Override.ConnectTimeout");
        if (!string.isEmpty()) {
            this.overrideConnectTimeout = true;
            n = properties.getPropertyAsInt("Ice.Override.ConnectTimeout");
            if (n < 0 && n != -1) {
                this.overrideConnectTimeoutValue = -1;
                stringBuffer = new StringBuffer("invalid value for Ice.Override.ConnectTimeout `");
                stringBuffer.append(properties.getProperty("Ice.Override.ConnectTimeout"));
                stringBuffer.append("': defaulting to -1");
                logger.warning(stringBuffer.toString());
            } else {
                this.overrideConnectTimeoutValue = n;
            }
        } else {
            this.overrideConnectTimeout = false;
            this.overrideConnectTimeoutValue = -1;
        }
        string = properties.getProperty("Ice.Override.CloseTimeout");
        if (!string.isEmpty()) {
            this.overrideCloseTimeout = true;
            n = properties.getPropertyAsInt("Ice.Override.CloseTimeout");
            if (n < 0 && n != -1) {
                this.overrideCloseTimeoutValue = -1;
                stringBuffer = new StringBuffer("invalid value for Ice.Override.CloseTimeout `");
                stringBuffer.append(properties.getProperty("Ice.Override.CloseTimeout"));
                stringBuffer.append("': defaulting to -1");
                logger.warning(stringBuffer.toString());
            } else {
                this.overrideCloseTimeoutValue = n;
            }
        } else {
            this.overrideCloseTimeout = false;
            this.overrideCloseTimeoutValue = -1;
        }
        string = properties.getProperty("Ice.Override.Compress");
        if (!string.isEmpty()) {
            boolean bl;
            this.overrideCompress = true;
            boolean bl2 = bl = properties.getPropertyAsInt("Ice.Override.Compress") > 0;
            if (bl && !BasicStream.compressible()) {
                System.err.println("warning: bzip2 support not available, Ice.Override.Compress ignored");
                bl = false;
            }
            this.overrideCompressValue = bl;
        } else {
            this.overrideCompress = false;
            this.overrideCompressValue = false;
        }
        string = properties.getProperty("Ice.Override.Secure");
        if (!string.isEmpty()) {
            this.overrideSecure = true;
            this.overrideSecureValue = properties.getPropertyAsInt("Ice.Override.Secure") > 0;
        } else {
            this.overrideSecure = false;
            this.overrideSecureValue = false;
        }
        this.defaultCollocationOptimization = properties.getPropertyAsIntWithDefault("Ice.Default.CollocationOptimized", 1) > 0;
        string = properties.getPropertyWithDefault("Ice.Default.EndpointSelection", "Random");
        if (string.equals("Random")) {
            this.defaultEndpointSelection = EndpointSelectionType.Random;
        } else if (string.equals("Ordered")) {
            this.defaultEndpointSelection = EndpointSelectionType.Ordered;
        } else {
            EndpointSelectionTypeParseException endpointSelectionTypeParseException = new EndpointSelectionTypeParseException();
            endpointSelectionTypeParseException.str = "illegal value `" + string + "'; expected `Random' or `Ordered'";
            throw endpointSelectionTypeParseException;
        }
        n = properties.getPropertyAsIntWithDefault("Ice.Default.Timeout", 60000);
        if (n < 1 && n != -1) {
            this.defaultTimeout = 60000;
            StringBuffer stringBuffer2 = new StringBuffer("invalid value for Ice.Default.Timeout `");
            stringBuffer2.append(properties.getProperty("Ice.Default.Timeout"));
            stringBuffer2.append("': defaulting to 60000");
            logger.warning(stringBuffer2.toString());
        } else {
            this.defaultTimeout = n;
        }
        n = properties.getPropertyAsIntWithDefault("Ice.Default.LocatorCacheTimeout", -1);
        if (n < -1) {
            this.defaultLocatorCacheTimeout = -1;
            StringBuffer stringBuffer3 = new StringBuffer("invalid value for Ice.Default.LocatorCacheTimeout `");
            stringBuffer3.append(properties.getProperty("Ice.Default.LocatorCacheTimeout"));
            stringBuffer3.append("': defaulting to -1");
            logger.warning(stringBuffer3.toString());
        } else {
            this.defaultLocatorCacheTimeout = n;
        }
        n = properties.getPropertyAsIntWithDefault("Ice.Default.InvocationTimeout", -1);
        if (n < 1 && n != -1 && n != -2) {
            this.defaultInvocationTimeout = -1;
            StringBuffer stringBuffer4 = new StringBuffer("invalid value for Ice.Default.InvocationTimeout `");
            stringBuffer4.append(properties.getProperty("Ice.Default.InvocationTimeout"));
            stringBuffer4.append("': defaulting to -1");
            logger.warning(stringBuffer4.toString());
        } else {
            this.defaultInvocationTimeout = n;
        }
        this.defaultPreferSecure = properties.getPropertyAsIntWithDefault("Ice.Default.PreferSecure", 0) > 0;
        string = properties.getPropertyWithDefault("Ice.Default.EncodingVersion", Util.encodingVersionToString(Protocol.currentEncoding));
        this.defaultEncoding = Util.stringToEncodingVersion(string);
        Protocol.checkSupportedEncoding(this.defaultEncoding);
        boolean bl = properties.getPropertyAsIntWithDefault("Ice.Default.SlicedFormat", 0) > 0;
        this.defaultFormat = bl ? FormatType.SlicedFormat : FormatType.CompactFormat;
    }
}

