/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ACM;
import Ice.ACMClose;
import Ice.ACMHeartbeat;
import Ice.ConnectionI;
import Ice.IntOptional;
import Ice.Optional;
import IceInternal.ACMConfig;
import IceInternal.ACMMonitor;
import IceInternal.FactoryACMMonitor;
import IceInternal.Time;
import IceUtilInternal.Assert;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class ConnectionACMMonitor
implements ACMMonitor {
    private final FactoryACMMonitor _parent;
    private final ScheduledExecutorService _timer;
    private Future<?> _future;
    private final ACMConfig _config;
    private ConnectionI _connection;

    ConnectionACMMonitor(FactoryACMMonitor factoryACMMonitor, ScheduledExecutorService scheduledExecutorService, ACMConfig aCMConfig) {
        this._parent = factoryACMMonitor;
        this._timer = scheduledExecutorService;
        this._config = aCMConfig;
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._connection == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized void add(ConnectionI connectionI) {
        assert (this._connection == null);
        this._connection = connectionI;
        if (this._config.timeout > 0) {
            this._future = this._timer.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ConnectionACMMonitor.this.monitorConnection();
                }
            }, this._config.timeout / 2, this._config.timeout / 2, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void remove(ConnectionI connectionI) {
        assert (this._connection == connectionI);
        this._connection = null;
        if (this._config.timeout > 0) {
            this._future.cancel(false);
            this._future = null;
        }
    }

    @Override
    public void reap(ConnectionI connectionI) {
        this._parent.reap(connectionI);
    }

    @Override
    public ACMMonitor acm(IntOptional intOptional, Optional<ACMClose> optional, Optional<ACMHeartbeat> optional2) {
        return this._parent.acm(intOptional, optional, optional2);
    }

    @Override
    public ACM getACM() {
        ACM aCM = new ACM();
        aCM.timeout = this._config.timeout / 1000;
        aCM.close = this._config.close;
        aCM.heartbeat = this._config.heartbeat;
        return aCM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorConnection() {
        ConnectionI connectionI;
        ConnectionACMMonitor connectionACMMonitor = this;
        synchronized (connectionACMMonitor) {
            if (this._connection == null) {
                return;
            }
            connectionI = this._connection;
        }
        try {
            connectionI.monitor(Time.currentMonotonicTimeMillis(), this._config);
        }
        catch (Exception exception) {
            this._parent.handleException(exception);
        }
    }
}

