/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.ConnectionI;
import Ice.LocalException;
import Ice.ObjectPrxHelperBase;
import IceInternal.ConnectionRequestHandler;
import IceInternal.OutgoingAsyncBase;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.QueueRequestHandler;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.RetryException;
import IceInternal.RouterInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;

public class ConnectRequestHandler
implements RequestHandler,
Reference.GetConnectionCallback,
RouterInfo.AddProxyCallback {
    private final Reference _reference;
    private boolean _response;
    private ObjectPrxHelperBase _proxy;
    private Set<ObjectPrxHelperBase> _proxies = new HashSet<ObjectPrxHelperBase>();
    private ConnectionI _connection;
    private boolean _compress;
    private LocalException _exception;
    private boolean _initialized;
    private boolean _flushing;
    private List<ProxyOutgoingAsyncBase> _requests = new LinkedList<ProxyOutgoingAsyncBase>();
    private RequestHandler _requestHandler;

    public synchronized RequestHandler connect(ObjectPrxHelperBase objectPrxHelperBase) {
        if (!this.initialized()) {
            this._proxies.add(objectPrxHelperBase);
        }
        return this._requestHandler;
    }

    @Override
    public RequestHandler update(RequestHandler requestHandler, RequestHandler requestHandler2) {
        return requestHandler == this ? requestHandler2 : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendAsyncRequest(ProxyOutgoingAsyncBase proxyOutgoingAsyncBase) throws RetryException {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (!this._initialized) {
                proxyOutgoingAsyncBase.cancelable(this);
            }
            if (!this.initialized()) {
                this._requests.add(proxyOutgoingAsyncBase);
                return 0;
            }
        }
        return proxyOutgoingAsyncBase.invokeRemote(this._connection, this._compress, this._response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncRequestCanceled(OutgoingAsyncBase outgoingAsyncBase, LocalException localException) {
        ConnectRequestHandler connectRequestHandler = this;
        synchronized (connectRequestHandler) {
            if (this._exception != null) {
                return;
            }
            if (!this.initialized()) {
                Iterator<ProxyOutgoingAsyncBase> iterator = this._requests.iterator();
                while (iterator.hasNext()) {
                    OutgoingAsyncBase outgoingAsyncBase2 = iterator.next();
                    if (outgoingAsyncBase2 != outgoingAsyncBase) continue;
                    iterator.remove();
                    if (outgoingAsyncBase.completed(localException)) {
                        outgoingAsyncBase.invokeCompletedAsync();
                    }
                    return;
                }
                assert (false);
            }
        }
        this._connection.asyncRequestCanceled(outgoingAsyncBase, localException);
    }

    @Override
    public Reference getReference() {
        return this._reference;
    }

    @Override
    public synchronized ConnectionI getConnection() {
        if (this._exception != null) {
            throw (LocalException)this._exception.fillInStackTrace();
        }
        return this._connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnection(ConnectionI connectionI, boolean bl) {
        Object object = this;
        synchronized (object) {
            assert (this._exception == null && this._connection == null);
            this._connection = connectionI;
            this._compress = bl;
        }
        object = this._reference.getRouterInfo();
        if (object != null && !((RouterInfo)object).addProxy(this._proxy, this)) {
            return;
        }
        this.flushRequests();
    }

    @Override
    public synchronized void setException(LocalException localException) {
        assert (!this._initialized && this._exception == null);
        this._exception = localException;
        this._proxies.clear();
        this._proxy = null;
        try {
            this._reference.getInstance().requestHandlerFactory().removeRequestHandler(this._reference, this);
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
            // empty catch block
        }
        for (OutgoingAsyncBase outgoingAsyncBase : this._requests) {
            if (!outgoingAsyncBase.completed(this._exception)) continue;
            outgoingAsyncBase.invokeCompletedAsync();
        }
        this._requests.clear();
        this.notifyAll();
    }

    @Override
    public void addedProxy() {
        this.flushRequests();
    }

    public ConnectRequestHandler(Reference reference, ObjectPrxHelperBase objectPrxHelperBase) {
        this._reference = reference;
        this._response = this._reference.getMode() == 0;
        this._proxy = objectPrxHelperBase;
        this._initialized = false;
        this._flushing = false;
        this._requestHandler = this._reference.getInstance().queueRequests() ? new QueueRequestHandler(this._reference.getInstance(), this) : this;
    }

    private boolean initialized() {
        if (this._initialized) {
            assert (this._connection != null);
            return true;
        }
        boolean bl = false;
        while (this._flushing && this._exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if (this._exception != null) {
            if (this._connection != null) {
                return true;
            }
            throw (LocalException)this._exception.fillInStackTrace();
        }
        return this._initialized;
    }

    private void flushRequests() {
        if (this._reference.getInstance().queueRequests()) {
            this._reference.getInstance().getQueueExecutor().executeNoThrow(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    ConnectRequestHandler.this.flushRequestsImpl();
                    return null;
                }
            });
        } else {
            this.flushRequestsImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushRequestsImpl() {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            assert (this._connection != null && !this._initialized);
            this._flushing = true;
        }
        object2 = null;
        for (ProxyOutgoingAsyncBase object3 : this._requests) {
            try {
                if ((object3.invokeRemote(this._connection, this._compress, this._response) & 2) <= 0) continue;
                object3.invokeSentAsync();
            }
            catch (RetryException localException) {
                object2 = localException.get();
                this._reference.getInstance().requestHandlerFactory().removeRequestHandler(this._reference, this);
                object3.retryException(localException.get());
            }
            catch (LocalException localException) {
                object2 = localException;
                if (!object3.completed(localException)) continue;
                object3.invokeCompletedAsync();
            }
        }
        this._requests.clear();
        if (this._reference.getCacheConnection() && object2 == null) {
            object = this._requestHandler;
            this._requestHandler = new ConnectionRequestHandler(this._reference, this._connection, this._compress);
            if (this._reference.getInstance().queueRequests()) {
                this._requestHandler = new QueueRequestHandler(this._reference.getInstance(), this._requestHandler);
            }
            for (ObjectPrxHelperBase retryException : this._proxies) {
                retryException.__updateRequestHandler((RequestHandler)object, this._requestHandler);
            }
        }
        object = this;
        synchronized (object) {
            assert (!this._initialized);
            this._exception = object2;
            this._initialized = this._exception == null;
            this._flushing = false;
            this._reference.getInstance().requestHandlerFactory().removeRequestHandler(this._reference, this);
            this._proxies.clear();
            this._proxy = null;
            this.notifyAll();
        }
    }
}

