/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Connection;
import Ice.ConnectionInfo;
import Ice.Current;
import Ice.Endpoint;
import Ice.EndpointInfo;
import Ice.IPConnectionInfo;
import Ice.IPEndpointInfo;
import Ice.InitializationData;
import Ice.Instrumentation.CommunicatorObserver;
import Ice.Instrumentation.ConnectionObserver;
import Ice.Instrumentation.ConnectionState;
import Ice.Instrumentation.DispatchObserver;
import Ice.Instrumentation.InvocationObserver;
import Ice.Instrumentation.Observer;
import Ice.Instrumentation.ObserverUpdater;
import Ice.Instrumentation.ThreadObserver;
import Ice.Instrumentation.ThreadState;
import Ice.ObjectPrx;
import Ice.UDPConnectionInfo;
import Ice.Util;
import IceInternal.ConnectionObserverI;
import IceInternal.DispatchObserverI;
import IceInternal.Ex;
import IceInternal.InvocationObserverI;
import IceInternal.MetricsAdminI;
import IceInternal.ThreadObserverI;
import IceMX.CollocatedMetrics;
import IceMX.ConnectionMetrics;
import IceMX.DispatchMetrics;
import IceMX.InvocationMetrics;
import IceMX.Metrics;
import IceMX.MetricsHelper;
import IceMX.ObserverFactoryWithDelegate;
import IceMX.ObserverWithDelegateI;
import IceMX.RemoteMetrics;
import IceMX.ThreadMetrics;
import java.util.Map;

public class CommunicatorObserverI
implements CommunicatorObserver {
    private final MetricsAdminI _metrics;
    private final CommunicatorObserver _delegate;
    private final ObserverFactoryWithDelegate<ConnectionMetrics, ConnectionObserverI, ConnectionObserver> _connections;
    private final ObserverFactoryWithDelegate<DispatchMetrics, DispatchObserverI, DispatchObserver> _dispatch;
    private final ObserverFactoryWithDelegate<InvocationMetrics, InvocationObserverI, InvocationObserver> _invocations;
    private final ObserverFactoryWithDelegate<ThreadMetrics, ThreadObserverI, ThreadObserver> _threads;
    private final ObserverFactoryWithDelegate<Metrics, ObserverWithDelegateI, Observer> _connects;
    private final ObserverFactoryWithDelegate<Metrics, ObserverWithDelegateI, Observer> _endpointLookups;

    static void addEndpointAttributes(MetricsHelper.AttributeResolver attributeResolver, Class<?> clazz) throws Exception {
        attributeResolver.add("endpoint", clazz.getDeclaredMethod("getEndpoint", new Class[0]));
        Class<EndpointInfo> clazz2 = EndpointInfo.class;
        attributeResolver.add("endpointType", clazz.getDeclaredMethod("getEndpointInfo", new Class[0]), clazz2.getDeclaredMethod("type", new Class[0]));
        attributeResolver.add("endpointIsDatagram", clazz.getDeclaredMethod("getEndpointInfo", new Class[0]), clazz2.getDeclaredMethod("datagram", new Class[0]));
        attributeResolver.add("endpointIsSecure", clazz.getDeclaredMethod("getEndpointInfo", new Class[0]), clazz2.getDeclaredMethod("secure", new Class[0]));
        attributeResolver.add("endpointTimeout", clazz.getDeclaredMethod("getEndpointInfo", new Class[0]), clazz2.getDeclaredField("timeout"));
        attributeResolver.add("endpointCompress", clazz.getDeclaredMethod("getEndpointInfo", new Class[0]), clazz2.getDeclaredField("compress"));
        clazz2 = IPEndpointInfo.class;
        attributeResolver.add("endpointHost", clazz.getDeclaredMethod("getEndpointInfo", new Class[0]), clazz2.getDeclaredField("host"));
        attributeResolver.add("endpointPort", clazz.getDeclaredMethod("getEndpointInfo", new Class[0]), clazz2.getDeclaredField("port"));
    }

    static void addConnectionAttributes(MetricsHelper.AttributeResolver attributeResolver, Class<?> clazz) throws Exception {
        Class<ConnectionInfo> clazz2 = ConnectionInfo.class;
        attributeResolver.add("incoming", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("incoming"));
        attributeResolver.add("adapterName", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("adapterName"));
        attributeResolver.add("connectionId", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("connectionId"));
        clazz2 = IPConnectionInfo.class;
        attributeResolver.add("localHost", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("localAddress"));
        attributeResolver.add("localPort", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("localPort"));
        attributeResolver.add("remoteHost", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("remoteAddress"));
        attributeResolver.add("remotePort", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("remotePort"));
        clazz2 = UDPConnectionInfo.class;
        attributeResolver.add("mcastHost", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("mcastAddress"));
        attributeResolver.add("mcastPort", clazz.getDeclaredMethod("getConnectionInfo", new Class[0]), clazz2.getDeclaredField("mcastPort"));
        CommunicatorObserverI.addEndpointAttributes(attributeResolver, clazz);
    }

    public CommunicatorObserverI(InitializationData initializationData) {
        block2: {
            this._metrics = new MetricsAdminI(initializationData.properties, initializationData.logger);
            this._delegate = initializationData.observer;
            this._connections = new ObserverFactoryWithDelegate(this._metrics, "Connection", ConnectionMetrics.class);
            this._dispatch = new ObserverFactoryWithDelegate(this._metrics, "Dispatch", DispatchMetrics.class);
            this._invocations = new ObserverFactoryWithDelegate(this._metrics, "Invocation", InvocationMetrics.class);
            this._threads = new ObserverFactoryWithDelegate(this._metrics, "Thread", ThreadMetrics.class);
            this._connects = new ObserverFactoryWithDelegate(this._metrics, "ConnectionEstablishment", Metrics.class);
            this._endpointLookups = new ObserverFactoryWithDelegate(this._metrics, "EndpointLookup", Metrics.class);
            try {
                this._invocations.registerSubMap("Remote", RemoteMetrics.class, InvocationMetrics.class.getDeclaredField("remotes"));
                this._invocations.registerSubMap("Collocated", CollocatedMetrics.class, InvocationMetrics.class.getDeclaredField("collocated"));
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    @Override
    public Observer getConnectionEstablishmentObserver(Endpoint endpoint, String string) {
        if (this._connects.isEnabled()) {
            try {
                Observer observer = null;
                if (this._delegate != null) {
                    observer = this._delegate.getConnectionEstablishmentObserver(endpoint, string);
                }
                return this._connects.getObserver((MetricsHelper)new EndpointHelper(endpoint, string), ObserverWithDelegateI.class, observer);
            }
            catch (Exception exception) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(exception));
            }
        }
        return null;
    }

    @Override
    public Observer getEndpointLookupObserver(Endpoint endpoint) {
        if (this._endpointLookups.isEnabled()) {
            try {
                Observer observer = null;
                if (this._delegate != null) {
                    observer = this._delegate.getEndpointLookupObserver(endpoint);
                }
                return this._endpointLookups.getObserver((MetricsHelper)new EndpointHelper(endpoint), ObserverWithDelegateI.class, observer);
            }
            catch (Exception exception) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(exception));
            }
        }
        return null;
    }

    @Override
    public ConnectionObserver getConnectionObserver(ConnectionInfo connectionInfo, Endpoint endpoint, ConnectionState connectionState, ConnectionObserver connectionObserver) {
        if (this._connections.isEnabled()) {
            try {
                ConnectionObserverI connectionObserverI;
                ConnectionObserver connectionObserver2 = null;
                ConnectionObserverI connectionObserverI2 = connectionObserverI = connectionObserver instanceof ConnectionObserverI ? (ConnectionObserverI)connectionObserver : null;
                if (this._delegate != null) {
                    connectionObserver2 = this._delegate.getConnectionObserver(connectionInfo, endpoint, connectionState, connectionObserverI != null ? (ConnectionObserver)connectionObserverI.getDelegate() : connectionObserver);
                }
                return (ConnectionObserver)this._connections.getObserver((MetricsHelper)new ConnectionHelper(connectionInfo, endpoint, connectionState), (Object)connectionObserverI, ConnectionObserverI.class, (Observer)connectionObserver2);
            }
            catch (Exception exception) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(exception));
            }
        }
        return null;
    }

    @Override
    public ThreadObserver getThreadObserver(String string, String string2, ThreadState threadState, ThreadObserver threadObserver) {
        if (this._threads.isEnabled()) {
            try {
                ThreadObserverI threadObserverI;
                ThreadObserver threadObserver2 = null;
                ThreadObserverI threadObserverI2 = threadObserverI = threadObserver instanceof ThreadObserverI ? (ThreadObserverI)threadObserver : null;
                if (this._delegate != null) {
                    threadObserver2 = this._delegate.getThreadObserver(string, string2, threadState, threadObserverI != null ? (ThreadObserver)threadObserverI.getDelegate() : threadObserver);
                }
                return (ThreadObserver)this._threads.getObserver((MetricsHelper)new ThreadHelper(string, string2, threadState), (Object)threadObserverI, ThreadObserverI.class, (Observer)threadObserver2);
            }
            catch (Exception exception) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(exception));
            }
        }
        return null;
    }

    @Override
    public InvocationObserver getInvocationObserver(ObjectPrx objectPrx, String string, Map<String, String> map) {
        if (this._invocations.isEnabled()) {
            try {
                InvocationObserver invocationObserver = null;
                if (this._delegate != null) {
                    invocationObserver = this._delegate.getInvocationObserver(objectPrx, string, map);
                }
                return (InvocationObserver)this._invocations.getObserver((MetricsHelper)new InvocationHelper(objectPrx, string, map), InvocationObserverI.class, (Observer)invocationObserver);
            }
            catch (Exception exception) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(exception));
            }
        }
        return null;
    }

    @Override
    public DispatchObserver getDispatchObserver(Current current, int n) {
        if (this._dispatch.isEnabled()) {
            try {
                DispatchObserver dispatchObserver = null;
                if (this._delegate != null) {
                    dispatchObserver = this._delegate.getDispatchObserver(current, n);
                }
                return (DispatchObserver)this._dispatch.getObserver((MetricsHelper)new DispatchHelper(current, n), DispatchObserverI.class, (Observer)dispatchObserver);
            }
            catch (Exception exception) {
                this._metrics.getLogger().error("unexpected exception trying to obtain observer:\n" + Ex.toString(exception));
            }
        }
        return null;
    }

    @Override
    public void setObserverUpdater(final ObserverUpdater observerUpdater) {
        if (observerUpdater == null) {
            this._connections.setUpdater(null);
            this._threads.setUpdater(null);
        } else {
            this._connections.setUpdater(new Runnable(){

                @Override
                public void run() {
                    observerUpdater.updateConnectionObservers();
                }
            });
            this._threads.setUpdater(new Runnable(){

                @Override
                public void run() {
                    observerUpdater.updateThreadObservers();
                }
            });
        }
        if (this._delegate != null) {
            this._delegate.setObserverUpdater(observerUpdater);
        }
    }

    public MetricsAdminI getFacet() {
        return this._metrics;
    }

    public static final class EndpointHelper
    extends MetricsHelper<Metrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        this.add("parent", EndpointHelper.class.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", EndpointHelper.class.getDeclaredMethod("getId", new Class[0]));
                        CommunicatorObserverI.addEndpointAttributes(this, EndpointHelper.class);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final Endpoint _endpoint;
        private String _id;
        private EndpointInfo _endpointInfo;

        EndpointHelper(Endpoint endpoint, String string) {
            super(_attributes);
            this._endpoint = endpoint;
            this._id = string;
        }

        EndpointHelper(Endpoint endpoint) {
            super(_attributes);
            this._endpoint = endpoint;
        }

        public EndpointInfo getEndpointInfo() {
            if (this._endpointInfo == null) {
                this._endpointInfo = this._endpoint.getInfo();
            }
            return this._endpointInfo;
        }

        public String getParent() {
            return "Communicator";
        }

        public String getId() {
            if (this._id == null) {
                this._id = this._endpoint.toString();
            }
            return this._id;
        }

        public String getEndpoint() {
            return this._endpoint.toString();
        }
    }

    public static final class ThreadHelper
    extends MetricsHelper<ThreadMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        this.add("parent", ThreadHelper.class.getDeclaredField("_parent"));
                        this.add("id", ThreadHelper.class.getDeclaredField("_id"));
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        public final String _parent;
        public final String _id;
        private final ThreadState _state;

        ThreadHelper(String string, String string2, ThreadState threadState) {
            super(_attributes);
            this._parent = string;
            this._id = string2;
            this._state = threadState;
        }

        public void initMetrics(ThreadMetrics threadMetrics) {
            switch (this._state) {
                case ThreadStateInUseForIO: {
                    ++threadMetrics.inUseForIO;
                    break;
                }
                case ThreadStateInUseForUser: {
                    ++threadMetrics.inUseForUser;
                    break;
                }
                case ThreadStateInUseForOther: {
                    ++threadMetrics.inUseForOther;
                    break;
                }
            }
        }
    }

    public static final class InvocationHelper
    extends MetricsHelper<InvocationMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        Class<InvocationHelper> clazz = InvocationHelper.class;
                        this.add("parent", clazz.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", clazz.getDeclaredMethod("getId", new Class[0]));
                        this.add("operation", clazz.getDeclaredMethod("getOperation", new Class[0]));
                        this.add("identity", clazz.getDeclaredMethod("getIdentity", new Class[0]));
                        Class<ObjectPrx> clazz2 = ObjectPrx.class;
                        this.add("facet", clazz.getDeclaredMethod("getProxy", new Class[0]), clazz2.getDeclaredMethod("ice_getFacet", new Class[0]));
                        this.add("encoding", clazz.getDeclaredMethod("getEncodingVersion", new Class[0]));
                        this.add("mode", clazz.getDeclaredMethod("getMode", new Class[0]));
                        this.add("proxy", clazz.getDeclaredMethod("getProxy", new Class[0]));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final ObjectPrx _proxy;
        private final String _operation;
        private final Map<String, String> _context;
        private String _id;
        private static final Endpoint[] emptyEndpoints = new Endpoint[0];

        InvocationHelper(ObjectPrx objectPrx, String string, Map<String, String> map) {
            super(_attributes);
            this._proxy = objectPrx;
            this._operation = string;
            this._context = map;
        }

        protected String defaultResolve(String string) {
            String string2;
            if (string.indexOf("context.", 0) == 0 && (string2 = this._context.get(string.substring(8))) != null) {
                return string2;
            }
            throw new IllegalArgumentException(string);
        }

        public String getMode() {
            if (this._proxy == null) {
                throw new IllegalArgumentException("mode");
            }
            if (this._proxy.ice_isTwoway()) {
                return "twoway";
            }
            if (this._proxy.ice_isOneway()) {
                return "oneway";
            }
            if (this._proxy.ice_isBatchOneway()) {
                return "batch-oneway";
            }
            if (this._proxy.ice_isDatagram()) {
                return "datagram";
            }
            if (this._proxy.ice_isBatchDatagram()) {
                return "batch-datagram";
            }
            throw new IllegalArgumentException("mode");
        }

        public String getId() {
            if (this._id == null) {
                if (this._proxy != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        stringBuilder.append(this._proxy.ice_endpoints(emptyEndpoints)).append(" [").append(this._operation).append(']');
                    }
                    catch (Exception exception) {
                        stringBuilder.append(this._proxy.ice_getCommunicator().identityToString(this._proxy.ice_getIdentity()));
                        stringBuilder.append(" [").append(this._operation).append(']');
                    }
                    this._id = stringBuilder.toString();
                } else {
                    this._id = this._operation;
                }
            }
            return this._id;
        }

        public String getParent() {
            return "Communicator";
        }

        public ObjectPrx getProxy() {
            return this._proxy;
        }

        public String getIdentity() {
            if (this._proxy != null) {
                return this._proxy.ice_getCommunicator().identityToString(this._proxy.ice_getIdentity());
            }
            return "";
        }

        public String getOperation() {
            return this._operation;
        }

        public String getEncodingVersion() {
            return Util.encodingVersionToString(this._proxy.ice_getEncodingVersion());
        }
    }

    public static final class DispatchHelper
    extends MetricsHelper<DispatchMetrics> {
        private static final MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        Class<DispatchHelper> clazz = DispatchHelper.class;
                        this.add("parent", clazz.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", clazz.getDeclaredMethod("getId", new Class[0]));
                        CommunicatorObserverI.addConnectionAttributes(this, clazz);
                        Class<Current> clazz2 = Current.class;
                        this.add("operation", clazz.getDeclaredMethod("getCurrent", new Class[0]), clazz2.getDeclaredField("operation"));
                        this.add("identity", clazz.getDeclaredMethod("getIdentity", new Class[0]));
                        this.add("facet", clazz.getDeclaredMethod("getCurrent", new Class[0]), clazz2.getDeclaredField("facet"));
                        this.add("requestId", clazz.getDeclaredMethod("getCurrent", new Class[0]), clazz2.getDeclaredField("requestId"));
                        this.add("mode", clazz.getDeclaredMethod("getMode", new Class[0]));
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final Current _current;
        private final int _size;
        private String _id;
        private EndpointInfo _endpointInfo;

        DispatchHelper(Current current, int n) {
            super(_attributes);
            this._current = current;
            this._size = n;
        }

        public void initMetrics(DispatchMetrics dispatchMetrics) {
            dispatchMetrics.size += (long)this._size;
        }

        protected String defaultResolve(String string) {
            String string2;
            if (string.indexOf("context.", 0) == 0 && (string2 = this._current.ctx.get(string.substring(8))) != null) {
                return string2;
            }
            throw new IllegalArgumentException(string);
        }

        public String getMode() {
            return this._current.requestId == 0 ? "oneway" : "twoway";
        }

        public String getId() {
            if (this._id == null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this._current.id.category != null && !this._current.id.category.isEmpty()) {
                    stringBuilder.append(this._current.id.category).append('/');
                }
                stringBuilder.append(this._current.id.name).append(" [").append(this._current.operation).append(']');
                this._id = stringBuilder.toString();
            }
            return this._id;
        }

        public int getRequestId() {
            return this._current.requestId;
        }

        public String getParent() {
            return this._current.adapter.getName();
        }

        public ConnectionInfo getConnectionInfo() {
            if (this._current.con != null) {
                return this._current.con.getInfo();
            }
            return null;
        }

        public Endpoint getEndpoint() {
            if (this._current.con != null) {
                return this._current.con.getEndpoint();
            }
            return null;
        }

        public Connection getConnection() {
            return this._current.con;
        }

        public EndpointInfo getEndpointInfo() {
            if (this._current.con != null && this._endpointInfo == null) {
                this._endpointInfo = this._current.con.getEndpoint().getInfo();
            }
            return this._endpointInfo;
        }

        public Current getCurrent() {
            return this._current;
        }

        public String getIdentity() {
            return this._current.adapter.getCommunicator().identityToString(this._current.id);
        }
    }

    public static class ConnectionHelper
    extends MetricsHelper<ConnectionMetrics> {
        private static MetricsHelper.AttributeResolver _attributes = new MetricsHelper.AttributeResolver(){
            {
                block2: {
                    try {
                        this.add("parent", ConnectionHelper.class.getDeclaredMethod("getParent", new Class[0]));
                        this.add("id", ConnectionHelper.class.getDeclaredMethod("getId", new Class[0]));
                        this.add("state", ConnectionHelper.class.getDeclaredMethod("getState", new Class[0]));
                        CommunicatorObserverI.addConnectionAttributes(this, ConnectionHelper.class);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError();
                    }
                }
            }
        };
        private final ConnectionInfo _connectionInfo;
        private final Endpoint _endpoint;
        private final ConnectionState _state;
        private String _id;
        private EndpointInfo _endpointInfo;

        ConnectionHelper(ConnectionInfo connectionInfo, Endpoint endpoint, ConnectionState connectionState) {
            super(_attributes);
            this._connectionInfo = connectionInfo;
            this._endpoint = endpoint;
            this._state = connectionState;
        }

        public String getId() {
            if (this._id == null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this._connectionInfo instanceof IPConnectionInfo) {
                    IPConnectionInfo iPConnectionInfo = (IPConnectionInfo)this._connectionInfo;
                    stringBuilder.append(iPConnectionInfo.localAddress).append(':').append(iPConnectionInfo.localPort);
                    stringBuilder.append(" -> ");
                    stringBuilder.append(iPConnectionInfo.remoteAddress).append(':').append(iPConnectionInfo.remotePort);
                } else {
                    stringBuilder.append("connection-").append(this._connectionInfo);
                }
                if (!this._connectionInfo.connectionId.isEmpty()) {
                    stringBuilder.append(" [").append(this._connectionInfo.connectionId).append("]");
                }
                this._id = stringBuilder.toString();
            }
            return this._id;
        }

        public String getState() {
            switch (this._state) {
                case ConnectionStateValidating: {
                    return "validating";
                }
                case ConnectionStateHolding: {
                    return "holding";
                }
                case ConnectionStateActive: {
                    return "active";
                }
                case ConnectionStateClosing: {
                    return "closing";
                }
                case ConnectionStateClosed: {
                    return "closed";
                }
            }
            assert (false);
            return "";
        }

        public String getParent() {
            if (this._connectionInfo.adapterName != null && !this._connectionInfo.adapterName.isEmpty()) {
                return this._connectionInfo.adapterName;
            }
            return "Communicator";
        }

        public ConnectionInfo getConnectionInfo() {
            return this._connectionInfo;
        }

        public Endpoint getEndpoint() {
            return this._endpoint;
        }

        public EndpointInfo getEndpointInfo() {
            if (this._endpointInfo == null) {
                this._endpointInfo = this._endpoint.getInfo();
            }
            return this._endpointInfo;
        }
    }
}

