/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AsyncResult;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.Exception;
import Ice.Instrumentation.InvocationObserver;
import Ice.LocalException;
import IceInternal.AsyncResultI;
import IceInternal.CallbackBase;
import IceInternal.Instance;
import IceInternal.ObserverHelper;
import IceInternal.OutgoingAsyncBase;
import IceInternal.RetryException;
import java.util.concurrent.Callable;

public class CommunicatorFlushBatch
extends AsyncResultI {
    private int _useCount;

    public static CommunicatorFlushBatch check(AsyncResult asyncResult, Communicator communicator, String string) {
        CommunicatorFlushBatch.check(asyncResult, string);
        if (!(asyncResult instanceof CommunicatorFlushBatch)) {
            throw new IllegalArgumentException("Incorrect AsyncResult object for end_" + string + " method");
        }
        if (asyncResult.getCommunicator() != communicator) {
            throw new IllegalArgumentException("Communicator for call to end_" + string + " does not match communicator that was used to call corresponding begin_" + string + " method");
        }
        return (CommunicatorFlushBatch)asyncResult;
    }

    public CommunicatorFlushBatch(Communicator communicator, Instance instance, String string, CallbackBase callbackBase) {
        super(communicator, instance, string, callbackBase);
        this._observer = ObserverHelper.get(instance, string);
        this._useCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushConnection(final ConnectionI connectionI) {
        AsyncResultI asyncResultI = this;
        synchronized (asyncResultI) {
            ++this._useCount;
        }
        try {
            class FlushBatch
            extends OutgoingAsyncBase {
                public FlushBatch() {
                    super(CommunicatorFlushBatch.this.getCommunicator(), CommunicatorFlushBatch.this._instance, CommunicatorFlushBatch.this.getOperation(), null);
                }

                @Override
                public boolean sent() {
                    if (this._childObserver != null) {
                        this._childObserver.detach();
                        this._childObserver = null;
                    }
                    CommunicatorFlushBatch.this.doCheck(false);
                    return false;
                }

                @Override
                public boolean completed(Exception exception) {
                    if (this._childObserver != null) {
                        this._childObserver.failed(exception.ice_name());
                        this._childObserver.detach();
                        this._childObserver = null;
                    }
                    CommunicatorFlushBatch.this.doCheck(false);
                    return false;
                }

                @Override
                protected InvocationObserver getObserver() {
                    return CommunicatorFlushBatch.this._observer;
                }
            }
            asyncResultI = new FlushBatch();
            int n = connectionI.getBatchRequestQueue().swap(((OutgoingAsyncBase)asyncResultI).getOs());
            if (n == 0) {
                ((FlushBatch)asyncResultI).sent();
            } else if (this._instance.queueRequests()) {
                this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>((FlushBatch)asyncResultI, n){
                    final /* synthetic */ FlushBatch val$flushBatch;
                    final /* synthetic */ int val$batchRequestNum;
                    {
                        this.val$flushBatch = flushBatch;
                        this.val$batchRequestNum = n;
                    }

                    @Override
                    public Void call() throws RetryException {
                        connectionI.sendAsyncRequest(this.val$flushBatch, false, false, this.val$batchRequestNum);
                        return null;
                    }
                });
            } else {
                connectionI.sendAsyncRequest((OutgoingAsyncBase)asyncResultI, false, false, n);
            }
        }
        catch (RetryException retryException) {
            this.doCheck(false);
            throw retryException.get();
        }
        catch (LocalException localException) {
            this.doCheck(false);
            throw localException;
        }
    }

    public void ready() {
        this.doCheck(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheck(boolean bl) {
        CommunicatorFlushBatch communicatorFlushBatch = this;
        synchronized (communicatorFlushBatch) {
            assert (this._useCount > 0);
            if (--this._useCount > 0) {
                return;
            }
        }
        if (this.sent(true)) {
            if (bl) {
                this._sentSynchronously = true;
                this.invokeSent();
            } else {
                this.invokeSentAsync();
            }
        }
    }
}

