/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.Exception;
import Ice.LocalException;
import Ice.Logger;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.SystemException;
import Ice.UnknownException;
import IceInternal.BasicStream;
import IceInternal.DispatchWorkItem;
import IceInternal.Incoming;
import IceInternal.OutgoingAsync;
import IceInternal.OutgoingAsyncBase;
import IceInternal.Protocol;
import IceInternal.ProxyOutgoingAsyncBase;
import IceInternal.Reference;
import IceInternal.RequestHandler;
import IceInternal.ResponseHandler;
import IceInternal.ServantError;
import IceInternal.ServantManager;
import IceInternal.TraceLevels;
import IceInternal.TraceUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class CollocatedRequestHandler
implements RequestHandler,
ResponseHandler {
    private final Reference _reference;
    private final boolean _dispatcher;
    private final boolean _response;
    private final ObjectAdapterI _adapter;
    private final Logger _logger;
    private final TraceLevels _traceLevels;
    private int _requestId;
    private Map<OutgoingAsyncBase, Integer> _sendAsyncRequests = new HashMap<OutgoingAsyncBase, Integer>();
    private Map<Integer, OutgoingAsyncBase> _asyncRequests = new HashMap<Integer, OutgoingAsyncBase>();

    public CollocatedRequestHandler(Reference reference, ObjectAdapter objectAdapter) {
        this._reference = reference;
        this._dispatcher = reference.getInstance().initializationData().dispatcher != null;
        this._adapter = (ObjectAdapterI)objectAdapter;
        this._response = this._reference.getMode() == 0;
        this._logger = this._reference.getInstance().initializationData().logger;
        this._traceLevels = this._reference.getInstance().traceLevels();
        this._requestId = 0;
    }

    @Override
    public RequestHandler update(RequestHandler requestHandler, RequestHandler requestHandler2) {
        return requestHandler == this ? requestHandler2 : this;
    }

    @Override
    public int sendAsyncRequest(ProxyOutgoingAsyncBase proxyOutgoingAsyncBase) {
        return proxyOutgoingAsyncBase.invokeCollocated(this);
    }

    @Override
    public synchronized void asyncRequestCanceled(OutgoingAsyncBase outgoingAsyncBase, LocalException localException) {
        Integer n = this._sendAsyncRequests.remove(outgoingAsyncBase);
        if (n != null) {
            if (n > 0) {
                this._asyncRequests.remove(n);
            }
            if (outgoingAsyncBase.completed(localException)) {
                outgoingAsyncBase.invokeCompletedAsync();
            }
            this._adapter.decDirectCount();
            return;
        }
        if (outgoingAsyncBase instanceof OutgoingAsync) {
            OutgoingAsync outgoingAsync = (OutgoingAsync)outgoingAsyncBase;
            assert (outgoingAsync != null);
            for (Map.Entry<Integer, OutgoingAsyncBase> entry : this._asyncRequests.entrySet()) {
                if (entry.getValue() != outgoingAsync) continue;
                this._asyncRequests.remove(entry.getKey());
                if (outgoingAsyncBase.completed(localException)) {
                    outgoingAsyncBase.invokeCompletedAsync();
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(int n, BasicStream basicStream, byte by, boolean bl) {
        OutgoingAsyncBase outgoingAsyncBase = null;
        CollocatedRequestHandler collocatedRequestHandler = this;
        synchronized (collocatedRequestHandler) {
            assert (this._response);
            basicStream.pos(Protocol.replyHdr.length + 4);
            if (this._traceLevels.protocol >= 1) {
                this.fillInValue(basicStream, 10, basicStream.size());
                TraceUtil.traceRecv(basicStream, this._logger, this._traceLevels);
            }
            if ((outgoingAsyncBase = this._asyncRequests.remove(n)) != null && !outgoingAsyncBase.completed(basicStream)) {
                outgoingAsyncBase = null;
            }
        }
        if (outgoingAsyncBase != null) {
            if (bl) {
                outgoingAsyncBase.invokeCompletedAsync();
            } else {
                outgoingAsyncBase.invokeCompleted();
            }
        }
        this._adapter.decDirectCount();
    }

    @Override
    public void sendNoResponse() {
        this._adapter.decDirectCount();
    }

    @Override
    public boolean systemException(int n, SystemException systemException, boolean bl) {
        this.handleException(n, systemException, bl);
        this._adapter.decDirectCount();
        return true;
    }

    @Override
    public void invokeException(int n, LocalException localException, int n2, boolean bl) {
        this.handleException(n, localException, bl);
        this._adapter.decDirectCount();
    }

    @Override
    public Reference getReference() {
        return this._reference;
    }

    @Override
    public ConnectionI getConnection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int invokeAsyncRequest(OutgoingAsyncBase outgoingAsyncBase, int n, boolean bl) {
        this._adapter.incDirectCount();
        int n2 = 0;
        try {
            CollocatedRequestHandler collocatedRequestHandler = this;
            synchronized (collocatedRequestHandler) {
                outgoingAsyncBase.cancelable(this);
                if (this._response) {
                    n2 = ++this._requestId;
                    this._asyncRequests.put(n2, outgoingAsyncBase);
                }
                this._sendAsyncRequests.put(outgoingAsyncBase, n2);
            }
        }
        catch (java.lang.Exception exception) {
            this._adapter.decDirectCount();
        }
        outgoingAsyncBase.attachCollocatedObserver(this._adapter, n2);
        if (bl) {
            if (!this._response || this._reference.getInstance().queueRequests() || this._reference.getInvocationTimeout() > 0) {
                this._adapter.getThreadPool().dispatch(new InvokeAllAsync(outgoingAsyncBase, outgoingAsyncBase.getOs(), n2, n));
            } else if (this._dispatcher) {
                this._adapter.getThreadPool().dispatchFromThisThread(new InvokeAllAsync(outgoingAsyncBase, outgoingAsyncBase.getOs(), n2, n));
            } else if (this.sentAsync(outgoingAsyncBase)) {
                this.invokeAll(outgoingAsyncBase.getOs(), n2, n);
            }
        } else {
            this._adapter.getThreadPool().dispatch(new InvokeAllAsync(outgoingAsyncBase, outgoingAsyncBase.getOs(), n2, n));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sentAsync(OutgoingAsyncBase outgoingAsyncBase) {
        CollocatedRequestHandler collocatedRequestHandler = this;
        synchronized (collocatedRequestHandler) {
            if (this._sendAsyncRequests.remove(outgoingAsyncBase) == null) {
                return false;
            }
            if (!outgoingAsyncBase.sent()) {
                return true;
            }
        }
        outgoingAsyncBase.invokeSent();
        return true;
    }

    private void invokeAll(BasicStream basicStream, int n, int n2) {
        block14: {
            int n3;
            if (n2 > 0) {
                basicStream.pos(Protocol.requestBatchHdr.length);
            } else {
                basicStream.pos(Protocol.requestHdr.length);
            }
            if (this._traceLevels.protocol >= 1) {
                this.fillInValue(basicStream, 10, basicStream.size());
                if (n > 0) {
                    this.fillInValue(basicStream, 14, n);
                } else if (n2 > 0) {
                    this.fillInValue(basicStream, 14, n2);
                }
                TraceUtil.traceSend(basicStream, this._logger, this._traceLevels);
            }
            ServantManager servantManager = this._adapter.getServantManager();
            try {
                for (n3 = n2 > 0 ? n2 : 1; n3 > 0; --n3) {
                    try {
                        this._adapter.incDirectCount();
                    }
                    catch (ObjectAdapterDeactivatedException objectAdapterDeactivatedException) {
                        this.handleException(n, objectAdapterDeactivatedException, false);
                        break;
                    }
                    Incoming incoming = new Incoming(this._reference.getInstance(), this, null, this._adapter, this._response, 0, n);
                    incoming.invoke(servantManager, basicStream);
                }
            }
            catch (LocalException localException) {
                this.invokeException(n, localException, n3, false);
            }
            catch (ServantError servantError) {
                Throwable throwable = servantError.getCause();
                if (!(throwable instanceof AssertionError) && !(throwable instanceof OutOfMemoryError)) {
                    throw (Error)throwable;
                }
            }
            catch (Error error) {
                UnknownException unknownException = new UnknownException(error);
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                error.printStackTrace(printWriter);
                printWriter.flush();
                unknownException.unknown = stringWriter.toString();
                this._logger.error(unknownException.unknown);
                this.invokeException(n, unknownException, n3, false);
                if (error instanceof AssertionError || error instanceof OutOfMemoryError) break block14;
                throw error;
            }
        }
        this._adapter.decDirectCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(int n, Exception exception, boolean bl) {
        if (n == 0) {
            return;
        }
        OutgoingAsyncBase outgoingAsyncBase = null;
        CollocatedRequestHandler collocatedRequestHandler = this;
        synchronized (collocatedRequestHandler) {
            outgoingAsyncBase = this._asyncRequests.remove(n);
            if (outgoingAsyncBase != null && !outgoingAsyncBase.completed(exception)) {
                outgoingAsyncBase = null;
            }
        }
        if (outgoingAsyncBase != null) {
            if (bl) {
                outgoingAsyncBase.invokeCompletedAsync();
            } else {
                outgoingAsyncBase.invokeCompleted();
            }
        }
    }

    private void fillInValue(BasicStream basicStream, int n, int n2) {
        basicStream.rewriteInt(n2, n);
    }

    private class InvokeAllAsync
    extends DispatchWorkItem {
        private final OutgoingAsyncBase _outAsync;
        private BasicStream _os;
        private final int _requestId;
        private final int _batchRequestNum;

        private InvokeAllAsync(OutgoingAsyncBase outgoingAsyncBase, BasicStream basicStream, int n, int n2) {
            this._outAsync = outgoingAsyncBase;
            this._os = basicStream;
            this._requestId = n;
            this._batchRequestNum = n2;
        }

        @Override
        public void run() {
            if (CollocatedRequestHandler.this.sentAsync(this._outAsync)) {
                CollocatedRequestHandler.this.invokeAll(this._os, this._requestId, this._batchRequestNum);
            }
        }
    }
}

