/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Buffer {
    public ByteBuffer b;
    public ByteBuffer _emptyBuffer;
    private int _size;
    private int _capacity;
    private boolean _direct;
    private int _shrinkCounter;
    private ByteOrder _order;

    public Buffer(boolean bl) {
        this(bl, ByteOrder.LITTLE_ENDIAN);
    }

    Buffer(boolean bl, ByteOrder byteOrder) {
        this.b = this._emptyBuffer = ByteBuffer.allocate(0);
        this._size = 0;
        this._capacity = 0;
        this._direct = bl;
        this._order = byteOrder;
    }

    Buffer(byte[] byArray) {
        this(byArray, ByteOrder.LITTLE_ENDIAN);
    }

    Buffer(byte[] byArray, ByteOrder byteOrder) {
        this._emptyBuffer = ByteBuffer.allocate(0);
        this.b = ByteBuffer.wrap(byArray);
        this.b.order(byteOrder);
        this._size = byArray.length;
        this._capacity = 0;
        this._direct = false;
        this._order = byteOrder;
    }

    Buffer(ByteBuffer byteBuffer) {
        this(byteBuffer, ByteOrder.LITTLE_ENDIAN);
    }

    Buffer(ByteBuffer byteBuffer, ByteOrder byteOrder) {
        this._emptyBuffer = ByteBuffer.allocate(0);
        this.b = byteBuffer;
        this.b.order(byteOrder);
        this._size = byteBuffer.remaining();
        this._capacity = 0;
        this._direct = false;
        this._order = byteOrder;
    }

    public int size() {
        return this._size;
    }

    public boolean empty() {
        return this._size == 0;
    }

    public void clear() {
        this.b = this._emptyBuffer;
        this._size = 0;
        this._capacity = 0;
    }

    public void expand(int n) {
        int n2;
        int n3 = n2 = this.b == this._emptyBuffer ? n : this.b.position() + n;
        if (n2 > this._size) {
            this.resize(n2, false);
        }
    }

    public void resize(int n, boolean bl) {
        assert (this.b == this._emptyBuffer || this._capacity > 0);
        if (n == 0) {
            this.clear();
        } else if (n > this._capacity) {
            this.reserve(n);
        }
        this._size = n;
        if (bl) {
            this.b.limit(this._size);
        }
    }

    public void reset() {
        if (this._size > 0 && this._size * 2 < this._capacity) {
            if (++this._shrinkCounter > 2) {
                this.reserve(this._size);
                this._shrinkCounter = 0;
            }
        } else {
            this._shrinkCounter = 0;
        }
        this._size = 0;
        if (this.b != this._emptyBuffer) {
            this.b.limit(this.b.capacity());
            this.b.position(0);
        }
    }

    private void reserve(int n) {
        if (n > this._capacity) {
            this._capacity = Math.max(n, 2 * this._capacity);
            this._capacity = Math.max(240, this._capacity);
        } else if (n < this._capacity) {
            this._capacity = n;
        } else {
            return;
        }
        try {
            ByteBuffer byteBuffer = this._direct ? ByteBuffer.allocateDirect(this._capacity) : ByteBuffer.allocate(this._capacity);
            if (this.b == this._emptyBuffer) {
                this.b = byteBuffer;
            } else {
                int n2 = this.b.position();
                this.b.position(0);
                this.b.limit(Math.min(this._capacity, this.b.capacity()));
                byteBuffer.put(this.b);
                this.b = byteBuffer;
                this.b.limit(this.b.capacity());
                this.b.position(n2);
            }
            this.b.order(this._order);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this._capacity = this.b.capacity();
            throw outOfMemoryError;
        }
    }
}

