/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BatchRequest;
import Ice.BatchRequestInterceptor;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.ObjectPrx;
import IceInternal.BasicStream;
import IceInternal.Buffer;
import IceInternal.Instance;
import IceInternal.Protocol;

public class BatchRequestQueue {
    private BatchRequestInterceptor _interceptor;
    private BasicStream _batchStream;
    private boolean _batchStreamInUse;
    private boolean _batchStreamCanFlush;
    private int _batchRequestNum;
    private int _batchMarker;
    private BatchRequestI _request;
    private LocalException _exception;
    private int _maxSize;
    private static final int _udpOverhead = 28;

    public BatchRequestQueue(Instance instance, boolean bl) {
        int n;
        InitializationData initializationData = instance.initializationData();
        this._interceptor = initializationData.batchRequestInterceptor;
        this._batchStreamInUse = false;
        this._batchRequestNum = 0;
        this._batchStream = new BasicStream(instance, Protocol.currentProtocolEncoding);
        this._batchStream.writeBlob(Protocol.requestBatchHdr);
        this._batchMarker = this._batchStream.size();
        this._request = new BatchRequestI();
        this._maxSize = instance.batchAutoFlushSize();
        if (this._maxSize > 0 && bl && (n = initializationData.properties.getPropertyAsIntWithDefault("Ice.UDP.SndSize", 65507)) < this._maxSize) {
            this._maxSize = n;
        }
    }

    public synchronized void prepareBatchRequest(BasicStream basicStream) {
        if (this._exception != null) {
            throw (LocalException)this._exception.fillInStackTrace();
        }
        this.waitStreamInUse(false);
        this._batchStreamInUse = true;
        this._batchStream.swap(basicStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBatchRequest(BasicStream basicStream, ObjectPrx objectPrx, String string) {
        assert (this._batchStreamInUse);
        this._batchStream.swap(basicStream);
        try {
            this._batchStreamCanFlush = true;
            if (this._maxSize > 0 && this._batchStream.size() >= this._maxSize) {
                objectPrx.begin_ice_flushBatchRequests();
            }
            assert (this._batchMarker < this._batchStream.size());
            if (this._interceptor != null) {
                this._request.reset(objectPrx, string, this._batchStream.size() - this._batchMarker);
                this._interceptor.enqueue(this._request, this._batchRequestNum, this._batchMarker);
            } else {
                this._batchMarker = this._batchStream.size();
                ++this._batchRequestNum;
            }
        }
        finally {
            BatchRequestQueue batchRequestQueue = this;
            synchronized (batchRequestQueue) {
                this._batchStream.resize(this._batchMarker, false);
                this._batchStreamInUse = false;
                this._batchStreamCanFlush = false;
                this.notifyAll();
            }
        }
    }

    public synchronized void abortBatchRequest(BasicStream basicStream) {
        if (this._batchStreamInUse) {
            this._batchStream.swap(basicStream);
            this._batchStream.resize(this._batchMarker, false);
            this._batchStreamInUse = false;
            this.notifyAll();
        }
    }

    public synchronized int swap(BasicStream basicStream) {
        if (this._batchRequestNum == 0) {
            return 0;
        }
        this.waitStreamInUse(true);
        byte[] byArray = null;
        if (this._batchMarker < this._batchStream.size()) {
            byArray = new byte[this._batchStream.size() - this._batchMarker];
            Buffer buffer = this._batchStream.getBuffer();
            buffer.b.position(this._batchMarker);
            buffer.b.get(byArray);
            this._batchStream.resize(this._batchMarker, false);
        }
        int n = this._batchRequestNum;
        this._batchStream.swap(basicStream);
        this._batchRequestNum = 0;
        this._batchStream.writeBlob(Protocol.requestBatchHdr);
        this._batchMarker = this._batchStream.size();
        if (byArray != null) {
            this._batchStream.writeBlob(byArray);
        }
        return n;
    }

    public synchronized void destroy(LocalException localException) {
        this._exception = localException;
    }

    public synchronized boolean isEmpty() {
        return this._batchStream.size() == Protocol.requestBatchHdr.length;
    }

    private void waitStreamInUse(boolean bl) {
        boolean bl2 = false;
        while (!(!this._batchStreamInUse || bl && this._batchStreamCanFlush)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                bl2 = true;
            }
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
    }

    private void enqueueBatchRequest() {
        assert (this._batchMarker < this._batchStream.size());
        this._batchMarker = this._batchStream.size();
        ++this._batchRequestNum;
    }

    class BatchRequestI
    implements BatchRequest {
        private ObjectPrx _proxy;
        private String _operation;
        private int _size;

        BatchRequestI() {
        }

        public void reset(ObjectPrx objectPrx, String string, int n) {
            this._proxy = objectPrx;
            this._operation = string;
            this._size = n;
        }

        @Override
        public void enqueue() {
            BatchRequestQueue.this.enqueueBatchRequest();
        }

        @Override
        public ObjectPrx getProxy() {
            return this._proxy;
        }

        @Override
        public String getOperation() {
            return this._operation;
        }

        @Override
        public int getSize() {
            return this._size;
        }
    }
}

