/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanOptional;
import Ice.ByteOptional;
import Ice.CompactIdResolver;
import Ice.CompressionException;
import Ice.DoubleOptional;
import Ice.EncapsulationException;
import Ice.EncodingVersion;
import Ice.FloatOptional;
import Ice.FormatType;
import Ice.IllegalMessageSizeException;
import Ice.IntOptional;
import Ice.LocalException;
import Ice.Logger;
import Ice.LongOptional;
import Ice.MarshalException;
import Ice.NoObjectFactoryException;
import Ice.Object;
import Ice.ObjectFactory;
import Ice.ObjectImpl;
import Ice.ObjectPrx;
import Ice.Optional;
import Ice.OptionalFormat;
import Ice.OptionalObject;
import Ice.ShortOptional;
import Ice.SliceInfo;
import Ice.SlicedData;
import Ice.UnknownSlicedObject;
import Ice.UnknownUserException;
import Ice.UnmarshalOutOfBoundsException;
import Ice.UserException;
import IceInternal.Buffer;
import IceInternal.Ex;
import IceInternal.InputStreamWrapper;
import IceInternal.Instance;
import IceInternal.ObjectFactoryManager;
import IceInternal.ObjectInputStream;
import IceInternal.OutputStreamWrapper;
import IceInternal.Patcher;
import IceInternal.Protocol;
import IceInternal.SequencePatcher;
import IceInternal.TraceUtil;
import IceInternal.UserExceptionFactory;
import IceInternal.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.AbstractSequentialList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class BasicStream {
    static final Charset _utf8 = Charset.forName("UTF8");
    private CharsetEncoder _charEncoder = null;
    private Instance _instance;
    private Buffer _buf;
    private java.lang.Object _closure;
    private byte[] _stringBytes;
    private char[] _stringChars;
    private EncodingVersion _encoding;
    private ReadEncaps _readEncapsStack;
    private WriteEncaps _writeEncapsStack;
    private ReadEncaps _readEncapsCache;
    private WriteEncaps _writeEncapsCache;
    private boolean _sliceObjects;
    private int _startSeq;
    private int _minSeqSize;
    private static final int OPTIONAL_END_MARKER = 255;
    private static final byte FLAG_HAS_TYPE_ID_STRING = 1;
    private static final byte FLAG_HAS_TYPE_ID_INDEX = 2;
    private static final byte FLAG_HAS_TYPE_ID_COMPACT = 3;
    private static final byte FLAG_HAS_OPTIONAL_MEMBERS = 4;
    private static final byte FLAG_HAS_INDIRECTION_TABLE = 8;
    private static final byte FLAG_HAS_SLICE_SIZE = 16;
    private static final byte FLAG_IS_LAST_SLICE = 32;
    private static boolean _checkedBZip2 = false;
    private static Constructor<?> _bzInputStreamCtor;
    private static Constructor<?> _bzOutputStreamCtor;

    public BasicStream(Instance instance, EncodingVersion encodingVersion) {
        this(instance, encodingVersion, instance.cacheMessageBuffers() > 1);
    }

    public BasicStream(Instance instance, EncodingVersion encodingVersion, boolean bl) {
        this.initialize(instance, encodingVersion);
        this._buf = new Buffer(bl);
    }

    public BasicStream(Instance instance, EncodingVersion encodingVersion, byte[] byArray) {
        this.initialize(instance, encodingVersion);
        this._buf = new Buffer(byArray);
    }

    public BasicStream(Instance instance, EncodingVersion encodingVersion, ByteBuffer byteBuffer) {
        this.initialize(instance, encodingVersion);
        this._buf = new Buffer(byteBuffer);
    }

    private void initialize(Instance instance, EncodingVersion encodingVersion) {
        this._instance = instance;
        this._closure = null;
        this._encoding = encodingVersion;
        this._readEncapsStack = null;
        this._writeEncapsStack = null;
        this._readEncapsCache = null;
        this._writeEncapsCache = null;
        this._sliceObjects = true;
        this._startSeq = -1;
    }

    public void reset() {
        this._buf.reset();
        this.clear();
    }

    public void clear() {
        if (this._readEncapsStack != null) {
            assert (this._readEncapsStack.next == null);
            this._readEncapsStack.next = this._readEncapsCache;
            this._readEncapsCache = this._readEncapsStack;
            this._readEncapsCache.reset();
            this._readEncapsStack = null;
        }
        if (this._writeEncapsStack != null) {
            assert (this._writeEncapsStack.next == null);
            this._writeEncapsStack.next = this._writeEncapsCache;
            this._writeEncapsCache = this._writeEncapsStack;
            this._writeEncapsCache.reset();
            this._writeEncapsStack = null;
        }
        this._startSeq = -1;
        this._sliceObjects = true;
    }

    public Instance instance() {
        return this._instance;
    }

    public java.lang.Object closure() {
        return this._closure;
    }

    public java.lang.Object closure(java.lang.Object object) {
        java.lang.Object object2 = this._closure;
        this._closure = object;
        return object2;
    }

    public void swap(BasicStream basicStream) {
        assert (this._instance == basicStream._instance);
        Buffer buffer = basicStream._buf;
        basicStream._buf = this._buf;
        this._buf = buffer;
        java.lang.Object object = basicStream._closure;
        basicStream._closure = this._closure;
        this._closure = object;
        this.resetEncaps();
        basicStream.resetEncaps();
        int n = basicStream._startSeq;
        basicStream._startSeq = this._startSeq;
        this._startSeq = n;
        int n2 = basicStream._minSeqSize;
        basicStream._minSeqSize = this._minSeqSize;
        this._minSeqSize = n2;
    }

    public void resetEncaps() {
        this._readEncapsStack = null;
        this._writeEncapsStack = null;
    }

    public void resize(int n, boolean bl) {
        this._buf.resize(n, bl);
        this._buf.b.position(n);
    }

    public Buffer prepareWrite() {
        this._buf.b.limit(this._buf.size());
        this._buf.b.position(0);
        return this._buf;
    }

    public Buffer getBuffer() {
        return this._buf;
    }

    public void startWriteObject(SlicedData slicedData) {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.startInstance(SliceType.ObjectSlice, slicedData);
    }

    public void endWriteObject() {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.endInstance();
    }

    public void startReadObject() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        this._readEncapsStack.decoder.startInstance(SliceType.ObjectSlice);
    }

    public SlicedData endReadObject(boolean bl) {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        return this._readEncapsStack.decoder.endInstance(bl);
    }

    public void startWriteException(SlicedData slicedData) {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.startInstance(SliceType.ExceptionSlice, slicedData);
    }

    public void endWriteException() {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.endInstance();
    }

    public void startReadException() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        this._readEncapsStack.decoder.startInstance(SliceType.ExceptionSlice);
    }

    public SlicedData endReadException(boolean bl) {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        return this._readEncapsStack.decoder.endInstance(bl);
    }

    public void startWriteEncaps() {
        if (this._writeEncapsStack != null) {
            this.startWriteEncaps(this._writeEncapsStack.encoding, this._writeEncapsStack.format);
        } else {
            this.startWriteEncaps(this._encoding, FormatType.DefaultFormat);
        }
    }

    public void startWriteEncaps(EncodingVersion encodingVersion, FormatType formatType) {
        Protocol.checkSupportedEncoding(encodingVersion);
        WriteEncaps writeEncaps = this._writeEncapsCache;
        if (writeEncaps != null) {
            writeEncaps.reset();
            this._writeEncapsCache = this._writeEncapsCache.next;
        } else {
            writeEncaps = new WriteEncaps();
        }
        writeEncaps.next = this._writeEncapsStack;
        this._writeEncapsStack = writeEncaps;
        this._writeEncapsStack.format = formatType;
        this._writeEncapsStack.setEncoding(encodingVersion);
        this._writeEncapsStack.start = this._buf.size();
        this.writeInt(0);
        this._writeEncapsStack.encoding.__write(this);
    }

    public void endWriteEncaps() {
        assert (this._writeEncapsStack != null);
        int n = this._writeEncapsStack.start;
        int n2 = this._buf.size() - n;
        this._buf.b.putInt(n, n2);
        WriteEncaps writeEncaps = this._writeEncapsStack;
        this._writeEncapsStack = writeEncaps.next;
        writeEncaps.next = this._writeEncapsCache;
        this._writeEncapsCache = writeEncaps;
        this._writeEncapsCache.reset();
    }

    public void endWriteEncapsChecked() {
        if (this._writeEncapsStack == null) {
            throw new EncapsulationException("not in an encapsulation");
        }
        this.endWriteEncaps();
    }

    public void writeEmptyEncaps(EncodingVersion encodingVersion) {
        Protocol.checkSupportedEncoding(encodingVersion);
        this.writeInt(6);
        encodingVersion.__write(this);
    }

    public void writeEncaps(byte[] byArray) {
        if (byArray.length < 6) {
            throw new EncapsulationException();
        }
        this.expand(byArray.length);
        this._buf.b.put(byArray);
    }

    public EncodingVersion getWriteEncoding() {
        return this._writeEncapsStack != null ? this._writeEncapsStack.encoding : this._encoding;
    }

    public EncodingVersion startReadEncaps() {
        ReadEncaps readEncaps = this._readEncapsCache;
        if (readEncaps != null) {
            readEncaps.reset();
            this._readEncapsCache = this._readEncapsCache.next;
        } else {
            readEncaps = new ReadEncaps();
        }
        readEncaps.next = this._readEncapsStack;
        this._readEncapsStack = readEncaps;
        this._readEncapsStack.start = this._buf.b.position();
        int n = this.readInt();
        if (n < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (n - 4 > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._readEncapsStack.sz = n;
        EncodingVersion encodingVersion = new EncodingVersion();
        encodingVersion.__read(this);
        Protocol.checkSupportedEncoding(encodingVersion);
        this._readEncapsStack.setEncoding(encodingVersion);
        return encodingVersion;
    }

    public void endReadEncaps() {
        assert (this._readEncapsStack != null);
        if (!this._readEncapsStack.encoding_1_0) {
            this.skipOpts();
            if (this._buf.b.position() != this._readEncapsStack.start + this._readEncapsStack.sz) {
                throw new EncapsulationException();
            }
        } else if (this._buf.b.position() != this._readEncapsStack.start + this._readEncapsStack.sz) {
            if (this._buf.b.position() + 1 != this._readEncapsStack.start + this._readEncapsStack.sz) {
                throw new EncapsulationException();
            }
            try {
                this._buf.b.get();
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw new UnmarshalOutOfBoundsException();
            }
        }
        ReadEncaps readEncaps = this._readEncapsStack;
        this._readEncapsStack = readEncaps.next;
        readEncaps.next = this._readEncapsCache;
        this._readEncapsCache = readEncaps;
        this._readEncapsCache.reset();
    }

    public EncodingVersion skipEmptyEncaps() {
        int n = this.readInt();
        if (n < 6) {
            throw new EncapsulationException();
        }
        if (n - 4 > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        EncodingVersion encodingVersion = new EncodingVersion();
        encodingVersion.__read(this);
        if (encodingVersion.equals(Ice.Util.Encoding_1_0)) {
            if (n != 6) {
                throw new EncapsulationException();
            }
        } else {
            this._buf.b.position(this._buf.b.position() + n - 6);
        }
        return encodingVersion;
    }

    public void endReadEncapsChecked() {
        if (this._readEncapsStack == null) {
            throw new EncapsulationException("not in an encapsulation");
        }
        this.endReadEncaps();
    }

    public byte[] readEncaps(EncodingVersion encodingVersion) {
        int n = this.readInt();
        if (n < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (n - 4 > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        if (encodingVersion != null) {
            encodingVersion.__read(this);
            this._buf.b.position(this._buf.b.position() - 6);
        } else {
            this._buf.b.position(this._buf.b.position() - 4);
        }
        byte[] byArray = new byte[n];
        try {
            this._buf.b.get(byArray);
            return byArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public EncodingVersion getReadEncoding() {
        return this._readEncapsStack != null ? this._readEncapsStack.encoding : this._encoding;
    }

    public int getReadEncapsSize() {
        assert (this._readEncapsStack != null);
        return this._readEncapsStack.sz - 6;
    }

    public EncodingVersion skipEncaps() {
        int n = this.readInt();
        if (n < 6) {
            throw new UnmarshalOutOfBoundsException();
        }
        EncodingVersion encodingVersion = new EncodingVersion();
        encodingVersion.__read(this);
        try {
            this._buf.b.position(this._buf.b.position() + n - 6);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnmarshalOutOfBoundsException();
        }
        return encodingVersion;
    }

    public void startWriteSlice(String string, int n, boolean bl) {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.startSlice(string, n, bl);
    }

    public void endWriteSlice() {
        assert (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null);
        this._writeEncapsStack.encoder.endSlice();
    }

    public String startReadSlice() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        return this._readEncapsStack.decoder.startSlice();
    }

    public void endReadSlice() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        this._readEncapsStack.decoder.endSlice();
    }

    public void skipSlice() {
        assert (this._readEncapsStack != null && this._readEncapsStack.decoder != null);
        this._readEncapsStack.decoder.skipSlice();
    }

    public void readPendingObjects() {
        if (this._readEncapsStack != null && this._readEncapsStack.decoder != null) {
            this._readEncapsStack.decoder.readPendingObjects();
        } else if (this._readEncapsStack != null ? this._readEncapsStack.encoding_1_0 : this._encoding.equals(Ice.Util.Encoding_1_0)) {
            this.skipSize();
        }
    }

    public void writePendingObjects() {
        if (this._writeEncapsStack != null && this._writeEncapsStack.encoder != null) {
            this._writeEncapsStack.encoder.writePendingObjects();
        } else if (this._writeEncapsStack != null ? this._writeEncapsStack.encoding_1_0 : this._encoding.equals(Ice.Util.Encoding_1_0)) {
            this.writeSize(0);
        }
    }

    public void writeSize(int n) {
        if (n > 254) {
            this.expand(5);
            this._buf.b.put((byte)-1);
            this._buf.b.putInt(n);
        } else {
            this.expand(1);
            this._buf.b.put((byte)n);
        }
    }

    public int readSize() {
        try {
            int n = this._buf.b.get();
            if (n == -1) {
                int n2 = this._buf.b.getInt();
                if (n2 < 0) {
                    throw new UnmarshalOutOfBoundsException();
                }
                return n2;
            }
            return n < 0 ? n + 256 : n;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public int readAndCheckSeqSize(int n) {
        int n2 = this.readSize();
        if (n2 == 0) {
            return n2;
        }
        if (this._startSeq == -1 || this._buf.b.position() > this._startSeq + this._minSeqSize) {
            this._startSeq = this._buf.b.position();
            this._minSeqSize = n2 * n;
        } else {
            this._minSeqSize += n2 * n;
        }
        if (this._startSeq + this._minSeqSize > this._buf.size()) {
            throw new UnmarshalOutOfBoundsException();
        }
        return n2;
    }

    public int startSize() {
        int n = this._buf.b.position();
        this.writeInt(0);
        return n;
    }

    public void endSize(int n) {
        assert (n >= 0);
        this.rewriteInt(this._buf.b.position() - n - 4, n);
    }

    public void writeBlob(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.expand(byArray.length);
        this._buf.b.put(byArray);
    }

    public void writeBlob(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        this.expand(n2);
        this._buf.b.put(byArray, n, n2);
    }

    public byte[] readBlob(int n) {
        if (this._buf.b.remaining() < n) {
            throw new UnmarshalOutOfBoundsException();
        }
        byte[] byArray = new byte[n];
        try {
            this._buf.b.get(byArray);
            return byArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public boolean writeOpt(int n, OptionalFormat optionalFormat) {
        assert (this._writeEncapsStack != null);
        if (this._writeEncapsStack.encoder != null) {
            return this._writeEncapsStack.encoder.writeOpt(n, optionalFormat);
        }
        return this.writeOptImpl(n, optionalFormat);
    }

    public boolean readOpt(int n, OptionalFormat optionalFormat) {
        assert (this._readEncapsStack != null);
        if (this._readEncapsStack.decoder != null) {
            return this._readEncapsStack.decoder.readOpt(n, optionalFormat);
        }
        return this.readOptImpl(n, optionalFormat);
    }

    public void writeByte(byte by) {
        this.expand(1);
        this._buf.b.put(by);
    }

    public void writeByte(int n, ByteOptional byteOptional) {
        if (byteOptional != null && byteOptional.isSet()) {
            this.writeByte(n, byteOptional.get());
        }
    }

    public void writeByte(int n, byte by) {
        if (this.writeOpt(n, OptionalFormat.F1)) {
            this.writeByte(by);
        }
    }

    public void rewriteByte(byte by, int n) {
        this._buf.b.put(n, by);
    }

    public void writeByteSeq(byte[] byArray) {
        if (byArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(byArray.length);
            this.expand(byArray.length);
            this._buf.b.put(byArray);
        }
    }

    public void writeByteSeq(int n, Optional<byte[]> optional) {
        if (optional != null && optional.isSet()) {
            this.writeByteSeq(n, optional.get());
        }
    }

    public void writeByteSeq(int n, byte[] byArray) {
        if (this.writeOpt(n, OptionalFormat.VSize)) {
            this.writeByteSeq(byArray);
        }
    }

    public void writeByteBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null || byteBuffer.remaining() == 0) {
            this.writeSize(0);
        } else {
            this.writeSize(byteBuffer.remaining());
            this.expand(byteBuffer.remaining());
            this._buf.b.put(byteBuffer);
        }
    }

    public void writeSerializable(Serializable serializable) {
        if (serializable == null) {
            this.writeSize(0);
            return;
        }
        try {
            OutputStreamWrapper outputStreamWrapper = new OutputStreamWrapper(this);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStreamWrapper);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.close();
            outputStreamWrapper.close();
        }
        catch (Exception exception) {
            throw new MarshalException("cannot serialize object: " + exception);
        }
    }

    public byte readByte() {
        try {
            return this._buf.b.get();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readByte(int n, ByteOptional byteOptional) {
        if (this.readOpt(n, OptionalFormat.F1)) {
            byteOptional.set(this.readByte());
        } else {
            byteOptional.clear();
        }
    }

    public byte[] readByteSeq() {
        try {
            int n = this.readAndCheckSeqSize(1);
            byte[] byArray = new byte[n];
            this._buf.b.get(byArray);
            return byArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readByteSeq(int n, Optional<byte[]> optional) {
        if (this.readOpt(n, OptionalFormat.VSize)) {
            optional.set(this.readByteSeq());
        } else {
            optional.clear();
        }
    }

    public ByteBuffer readByteBuffer() {
        try {
            int n = this.readAndCheckSeqSize(1);
            ByteBuffer byteBuffer = this._buf.b.slice();
            byteBuffer.limit(n);
            this._buf.b.position(this._buf.b.position() + n);
            return byteBuffer.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public Serializable readSerializable() {
        int n = this.readAndCheckSeqSize(1);
        if (n == 0) {
            return null;
        }
        java.io.ObjectInputStream objectInputStream = null;
        try {
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(n, this);
            objectInputStream = new ObjectInputStream(this._instance, inputStreamWrapper);
            Serializable serializable = (Serializable)objectInputStream.readObject();
            return serializable;
        }
        catch (Exception exception) {
            throw new MarshalException("cannot deserialize object", exception);
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    throw new MarshalException("cannot deserialize object", iOException);
                }
            }
        }
    }

    public void writeBool(boolean bl) {
        this.expand(1);
        this._buf.b.put(bl ? (byte)1 : 0);
    }

    public void writeBool(int n, BooleanOptional booleanOptional) {
        if (booleanOptional != null && booleanOptional.isSet()) {
            this.writeBool(n, booleanOptional.get());
        }
    }

    public void writeBool(int n, boolean bl) {
        if (this.writeOpt(n, OptionalFormat.F1)) {
            this.writeBool(bl);
        }
    }

    public void rewriteBool(boolean bl, int n) {
        this._buf.b.put(n, bl ? (byte)1 : 0);
    }

    public void writeBoolSeq(boolean[] blArray) {
        if (blArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(blArray.length);
            this.expand(blArray.length);
            for (boolean bl : blArray) {
                this._buf.b.put(bl ? (byte)1 : 0);
            }
        }
    }

    public void writeBoolSeq(int n, Optional<boolean[]> optional) {
        if (optional != null && optional.isSet()) {
            this.writeBoolSeq(n, optional.get());
        }
    }

    public void writeBoolSeq(int n, boolean[] blArray) {
        if (this.writeOpt(n, OptionalFormat.VSize)) {
            this.writeBoolSeq(blArray);
        }
    }

    public boolean readBool() {
        try {
            return this._buf.b.get() == 1;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readBool(int n, BooleanOptional booleanOptional) {
        if (this.readOpt(n, OptionalFormat.F1)) {
            booleanOptional.set(this.readBool());
        } else {
            booleanOptional.clear();
        }
    }

    public boolean[] readBoolSeq() {
        try {
            int n = this.readAndCheckSeqSize(1);
            boolean[] blArray = new boolean[n];
            for (int i = 0; i < n; ++i) {
                blArray[i] = this._buf.b.get() == 1;
            }
            return blArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readBoolSeq(int n, Optional<boolean[]> optional) {
        if (this.readOpt(n, OptionalFormat.VSize)) {
            optional.set(this.readBoolSeq());
        } else {
            optional.clear();
        }
    }

    public void writeShort(short s) {
        this.expand(2);
        this._buf.b.putShort(s);
    }

    public void writeShort(int n, ShortOptional shortOptional) {
        if (shortOptional != null && shortOptional.isSet()) {
            this.writeShort(n, shortOptional.get());
        }
    }

    public void writeShort(int n, short s) {
        if (this.writeOpt(n, OptionalFormat.F2)) {
            this.writeShort(s);
        }
    }

    public void writeShortSeq(short[] sArray) {
        if (sArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(sArray.length);
            this.expand(sArray.length * 2);
            ShortBuffer shortBuffer = this._buf.b.asShortBuffer();
            shortBuffer.put(sArray);
            this._buf.b.position(this._buf.b.position() + sArray.length * 2);
        }
    }

    public void writeShortSeq(int n, Optional<short[]> optional) {
        if (optional != null && optional.isSet()) {
            this.writeShortSeq(n, optional.get());
        }
    }

    public void writeShortSeq(int n, short[] sArray) {
        if (this.writeOpt(n, OptionalFormat.VSize)) {
            this.writeSize(sArray == null || sArray.length == 0 ? 1 : sArray.length * 2 + (sArray.length > 254 ? 5 : 1));
            this.writeShortSeq(sArray);
        }
    }

    public void writeShortBuffer(ShortBuffer shortBuffer) {
        if (shortBuffer == null || shortBuffer.remaining() == 0) {
            this.writeSize(0);
        } else {
            int n = shortBuffer.remaining();
            this.writeSize(n);
            this.expand(n * 2);
            ShortBuffer shortBuffer2 = this._buf.b.asShortBuffer();
            shortBuffer2.put(shortBuffer);
            this._buf.b.position(this._buf.b.position() + n * 2);
        }
    }

    public short readShort() {
        try {
            return this._buf.b.getShort();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readShort(int n, ShortOptional shortOptional) {
        if (this.readOpt(n, OptionalFormat.F2)) {
            shortOptional.set(this.readShort());
        } else {
            shortOptional.clear();
        }
    }

    public short[] readShortSeq() {
        try {
            int n = this.readAndCheckSeqSize(2);
            short[] sArray = new short[n];
            ShortBuffer shortBuffer = this._buf.b.asShortBuffer();
            shortBuffer.get(sArray);
            this._buf.b.position(this._buf.b.position() + n * 2);
            return sArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readShortSeq(int n, Optional<short[]> optional) {
        if (this.readOpt(n, OptionalFormat.VSize)) {
            this.skipSize();
            optional.set(this.readShortSeq());
        } else {
            optional.clear();
        }
    }

    public ShortBuffer readShortBuffer() {
        try {
            int n = this.readAndCheckSeqSize(2);
            ShortBuffer shortBuffer = this._buf.b.asShortBuffer();
            ShortBuffer shortBuffer2 = shortBuffer.slice();
            shortBuffer2.limit(n);
            this._buf.b.position(this._buf.b.position() + n * 2);
            return shortBuffer2.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeInt(int n) {
        this.expand(4);
        this._buf.b.putInt(n);
    }

    public void writeInt(int n, IntOptional intOptional) {
        if (intOptional != null && intOptional.isSet()) {
            this.writeInt(n, intOptional.get());
        }
    }

    public void writeInt(int n, int n2) {
        if (this.writeOpt(n, OptionalFormat.F4)) {
            this.writeInt(n2);
        }
    }

    public void rewriteInt(int n, int n2) {
        this._buf.b.putInt(n2, n);
    }

    public void writeIntSeq(int[] nArray) {
        if (nArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(nArray.length);
            this.expand(nArray.length * 4);
            IntBuffer intBuffer = this._buf.b.asIntBuffer();
            intBuffer.put(nArray);
            this._buf.b.position(this._buf.b.position() + nArray.length * 4);
        }
    }

    public void writeIntSeq(int n, Optional<int[]> optional) {
        if (optional != null && optional.isSet()) {
            this.writeIntSeq(n, optional.get());
        }
    }

    public void writeIntSeq(int n, int[] nArray) {
        if (this.writeOpt(n, OptionalFormat.VSize)) {
            this.writeSize(nArray == null || nArray.length == 0 ? 1 : nArray.length * 4 + (nArray.length > 254 ? 5 : 1));
            this.writeIntSeq(nArray);
        }
    }

    public void writeIntBuffer(IntBuffer intBuffer) {
        if (intBuffer == null || intBuffer.remaining() == 0) {
            this.writeSize(0);
        } else {
            int n = intBuffer.remaining();
            this.writeSize(n);
            this.expand(n * 4);
            IntBuffer intBuffer2 = this._buf.b.asIntBuffer();
            intBuffer2.put(intBuffer);
            this._buf.b.position(this._buf.b.position() + n * 4);
        }
    }

    public int readInt() {
        try {
            return this._buf.b.getInt();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readInt(int n, IntOptional intOptional) {
        if (this.readOpt(n, OptionalFormat.F4)) {
            intOptional.set(this.readInt());
        } else {
            intOptional.clear();
        }
    }

    public int[] readIntSeq() {
        try {
            int n = this.readAndCheckSeqSize(4);
            int[] nArray = new int[n];
            IntBuffer intBuffer = this._buf.b.asIntBuffer();
            intBuffer.get(nArray);
            this._buf.b.position(this._buf.b.position() + n * 4);
            return nArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readIntSeq(int n, Optional<int[]> optional) {
        if (this.readOpt(n, OptionalFormat.VSize)) {
            this.skipSize();
            optional.set(this.readIntSeq());
        } else {
            optional.clear();
        }
    }

    public IntBuffer readIntBuffer() {
        try {
            int n = this.readAndCheckSeqSize(4);
            IntBuffer intBuffer = this._buf.b.asIntBuffer();
            IntBuffer intBuffer2 = intBuffer.slice();
            intBuffer2.limit(n);
            this._buf.b.position(this._buf.b.position() + n * 4);
            return intBuffer2.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeLong(long l) {
        this.expand(8);
        this._buf.b.putLong(l);
    }

    public void writeLong(int n, LongOptional longOptional) {
        if (longOptional != null && longOptional.isSet()) {
            this.writeLong(n, longOptional.get());
        }
    }

    public void writeLong(int n, long l) {
        if (this.writeOpt(n, OptionalFormat.F8)) {
            this.writeLong(l);
        }
    }

    public void writeLongSeq(long[] lArray) {
        if (lArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(lArray.length);
            this.expand(lArray.length * 8);
            LongBuffer longBuffer = this._buf.b.asLongBuffer();
            longBuffer.put(lArray);
            this._buf.b.position(this._buf.b.position() + lArray.length * 8);
        }
    }

    public void writeLongSeq(int n, Optional<long[]> optional) {
        if (optional != null && optional.isSet()) {
            this.writeLongSeq(n, optional.get());
        }
    }

    public void writeLongSeq(int n, long[] lArray) {
        if (this.writeOpt(n, OptionalFormat.VSize)) {
            this.writeSize(lArray == null || lArray.length == 0 ? 1 : lArray.length * 8 + (lArray.length > 254 ? 5 : 1));
            this.writeLongSeq(lArray);
        }
    }

    public void writeLongBuffer(LongBuffer longBuffer) {
        if (longBuffer == null || longBuffer.remaining() == 0) {
            this.writeSize(0);
        } else {
            int n = longBuffer.remaining();
            this.writeSize(n);
            this.expand(n * 8);
            LongBuffer longBuffer2 = this._buf.b.asLongBuffer();
            longBuffer2.put(longBuffer);
            this._buf.b.position(this._buf.b.position() + n * 8);
        }
    }

    public long readLong() {
        try {
            return this._buf.b.getLong();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readLong(int n, LongOptional longOptional) {
        if (this.readOpt(n, OptionalFormat.F8)) {
            longOptional.set(this.readLong());
        } else {
            longOptional.clear();
        }
    }

    public long[] readLongSeq() {
        try {
            int n = this.readAndCheckSeqSize(8);
            long[] lArray = new long[n];
            LongBuffer longBuffer = this._buf.b.asLongBuffer();
            longBuffer.get(lArray);
            this._buf.b.position(this._buf.b.position() + n * 8);
            return lArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readLongSeq(int n, Optional<long[]> optional) {
        if (this.readOpt(n, OptionalFormat.VSize)) {
            this.skipSize();
            optional.set(this.readLongSeq());
        } else {
            optional.clear();
        }
    }

    public LongBuffer readLongBuffer() {
        try {
            int n = this.readAndCheckSeqSize(8);
            LongBuffer longBuffer = this._buf.b.asLongBuffer();
            LongBuffer longBuffer2 = longBuffer.slice();
            longBuffer2.limit(n);
            this._buf.b.position(this._buf.b.position() + n * 8);
            return longBuffer2.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeFloat(float f) {
        this.expand(4);
        this._buf.b.putFloat(f);
    }

    public void writeFloat(int n, FloatOptional floatOptional) {
        if (floatOptional != null && floatOptional.isSet()) {
            this.writeFloat(n, floatOptional.get());
        }
    }

    public void writeFloat(int n, float f) {
        if (this.writeOpt(n, OptionalFormat.F4)) {
            this.writeFloat(f);
        }
    }

    public void writeFloatSeq(float[] fArray) {
        if (fArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(fArray.length);
            this.expand(fArray.length * 4);
            FloatBuffer floatBuffer = this._buf.b.asFloatBuffer();
            floatBuffer.put(fArray);
            this._buf.b.position(this._buf.b.position() + fArray.length * 4);
        }
    }

    public void writeFloatSeq(int n, Optional<float[]> optional) {
        if (optional != null && optional.isSet()) {
            this.writeFloatSeq(n, optional.get());
        }
    }

    public void writeFloatSeq(int n, float[] fArray) {
        if (this.writeOpt(n, OptionalFormat.VSize)) {
            this.writeSize(fArray == null || fArray.length == 0 ? 1 : fArray.length * 4 + (fArray.length > 254 ? 5 : 1));
            this.writeFloatSeq(fArray);
        }
    }

    public void writeFloatBuffer(FloatBuffer floatBuffer) {
        if (floatBuffer == null || floatBuffer.remaining() == 0) {
            this.writeSize(0);
        } else {
            int n = floatBuffer.remaining();
            this.writeSize(n);
            this.expand(n * 4);
            FloatBuffer floatBuffer2 = this._buf.b.asFloatBuffer();
            floatBuffer2.put(floatBuffer);
            this._buf.b.position(this._buf.b.position() + n * 4);
        }
    }

    public float readFloat() {
        try {
            return this._buf.b.getFloat();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readFloat(int n, FloatOptional floatOptional) {
        if (this.readOpt(n, OptionalFormat.F4)) {
            floatOptional.set(this.readFloat());
        } else {
            floatOptional.clear();
        }
    }

    public float[] readFloatSeq() {
        try {
            int n = this.readAndCheckSeqSize(4);
            float[] fArray = new float[n];
            FloatBuffer floatBuffer = this._buf.b.asFloatBuffer();
            floatBuffer.get(fArray);
            this._buf.b.position(this._buf.b.position() + n * 4);
            return fArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readFloatSeq(int n, Optional<float[]> optional) {
        if (this.readOpt(n, OptionalFormat.VSize)) {
            this.skipSize();
            optional.set(this.readFloatSeq());
        } else {
            optional.clear();
        }
    }

    public FloatBuffer readFloatBuffer() {
        try {
            int n = this.readAndCheckSeqSize(4);
            FloatBuffer floatBuffer = this._buf.b.asFloatBuffer();
            FloatBuffer floatBuffer2 = floatBuffer.slice();
            floatBuffer2.limit(n);
            this._buf.b.position(this._buf.b.position() + n * 4);
            return floatBuffer2.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeDouble(double d) {
        this.expand(8);
        this._buf.b.putDouble(d);
    }

    public void writeDouble(int n, DoubleOptional doubleOptional) {
        if (doubleOptional != null && doubleOptional.isSet()) {
            this.writeDouble(n, doubleOptional.get());
        }
    }

    public void writeDouble(int n, double d) {
        if (this.writeOpt(n, OptionalFormat.F8)) {
            this.writeDouble(d);
        }
    }

    public void writeDoubleSeq(double[] dArray) {
        if (dArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(dArray.length);
            this.expand(dArray.length * 8);
            DoubleBuffer doubleBuffer = this._buf.b.asDoubleBuffer();
            doubleBuffer.put(dArray);
            this._buf.b.position(this._buf.b.position() + dArray.length * 8);
        }
    }

    public void writeDoubleSeq(int n, Optional<double[]> optional) {
        if (optional != null && optional.isSet()) {
            this.writeDoubleSeq(n, optional.get());
        }
    }

    public void writeDoubleSeq(int n, double[] dArray) {
        if (this.writeOpt(n, OptionalFormat.VSize)) {
            this.writeSize(dArray == null || dArray.length == 0 ? 1 : dArray.length * 8 + (dArray.length > 254 ? 5 : 1));
            this.writeDoubleSeq(dArray);
        }
    }

    public void writeDoubleBuffer(DoubleBuffer doubleBuffer) {
        if (doubleBuffer == null || doubleBuffer.remaining() == 0) {
            this.writeSize(0);
        } else {
            int n = doubleBuffer.remaining();
            this.writeSize(n);
            this.expand(n * 8);
            DoubleBuffer doubleBuffer2 = this._buf.b.asDoubleBuffer();
            doubleBuffer2.put(doubleBuffer);
            this._buf.b.position(this._buf.b.position() + n * 8);
        }
    }

    public double readDouble() {
        try {
            return this._buf.b.getDouble();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readDouble(int n, DoubleOptional doubleOptional) {
        if (this.readOpt(n, OptionalFormat.F8)) {
            doubleOptional.set(this.readDouble());
        } else {
            doubleOptional.clear();
        }
    }

    public double[] readDoubleSeq() {
        try {
            int n = this.readAndCheckSeqSize(8);
            double[] dArray = new double[n];
            DoubleBuffer doubleBuffer = this._buf.b.asDoubleBuffer();
            doubleBuffer.get(dArray);
            this._buf.b.position(this._buf.b.position() + n * 8);
            return dArray;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readDoubleSeq(int n, Optional<double[]> optional) {
        if (this.readOpt(n, OptionalFormat.VSize)) {
            this.skipSize();
            optional.set(this.readDoubleSeq());
        } else {
            optional.clear();
        }
    }

    public DoubleBuffer readDoubleBuffer() {
        try {
            int n = this.readAndCheckSeqSize(8);
            DoubleBuffer doubleBuffer = this._buf.b.asDoubleBuffer();
            DoubleBuffer doubleBuffer2 = doubleBuffer.slice();
            doubleBuffer2.limit(n);
            this._buf.b.position(this._buf.b.position() + n * 8);
            return doubleBuffer2.asReadOnlyBuffer();
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void writeString(String string) {
        if (string == null) {
            this.writeSize(0);
        } else {
            int n = string.length();
            if (n > 0) {
                if (this._stringBytes == null || n > this._stringBytes.length) {
                    this._stringBytes = new byte[n];
                }
                if (this._stringChars == null || n > this._stringChars.length) {
                    this._stringChars = new char[n];
                }
                string.getChars(0, n, this._stringChars, 0);
                for (int i = 0; i < n; ++i) {
                    if (this._stringChars[i] > '\u007f') {
                        if (this._charEncoder == null) {
                            this._charEncoder = _utf8.newEncoder();
                        }
                        ByteBuffer byteBuffer = null;
                        try {
                            byteBuffer = this._charEncoder.encode(CharBuffer.wrap(this._stringChars, 0, n));
                        }
                        catch (CharacterCodingException characterCodingException) {
                            throw new MarshalException(characterCodingException);
                        }
                        this.writeSize(byteBuffer.limit());
                        this.expand(byteBuffer.limit());
                        this._buf.b.put(byteBuffer);
                        return;
                    }
                    this._stringBytes[i] = (byte)this._stringChars[i];
                }
                this.writeSize(n);
                this.expand(n);
                this._buf.b.put(this._stringBytes, 0, n);
            } else {
                this.writeSize(0);
            }
        }
    }

    public void writeString(int n, Optional<String> optional) {
        if (optional != null && optional.isSet()) {
            this.writeString(n, optional.get());
        }
    }

    public void writeString(int n, String string) {
        if (this.writeOpt(n, OptionalFormat.VSize)) {
            this.writeString(string);
        }
    }

    public void writeStringSeq(String[] stringArray) {
        if (stringArray == null) {
            this.writeSize(0);
        } else {
            this.writeSize(stringArray.length);
            for (String string : stringArray) {
                this.writeString(string);
            }
        }
    }

    public void writeStringSeq(int n, Optional<String[]> optional) {
        if (optional != null && optional.isSet()) {
            this.writeStringSeq(n, optional.get());
        }
    }

    public void writeStringSeq(int n, String[] stringArray) {
        if (this.writeOpt(n, OptionalFormat.FSize)) {
            int n2 = this.startSize();
            this.writeStringSeq(stringArray);
            this.endSize(n2);
        }
    }

    public String readString() {
        int n = this.readSize();
        if (n == 0) {
            return "";
        }
        if (this._buf.b.remaining() < n) {
            throw new UnmarshalOutOfBoundsException();
        }
        try {
            if (this._stringBytes == null || n > this._stringBytes.length) {
                this._stringBytes = new byte[n];
            }
            if (this._stringChars == null || n > this._stringChars.length) {
                this._stringChars = new char[n];
            }
            this._buf.b.get(this._stringBytes, 0, n);
            for (int i = 0; i < n; ++i) {
                if (this._stringBytes[i] < 0) {
                    return new String(this._stringBytes, 0, n, "UTF8");
                }
                this._stringChars[i] = (char)this._stringBytes[i];
            }
            return new String(this._stringChars, 0, n);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return "";
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new UnmarshalOutOfBoundsException();
        }
    }

    public void readString(int n, Optional<String> optional) {
        if (this.readOpt(n, OptionalFormat.VSize)) {
            optional.set(this.readString());
        } else {
            optional.clear();
        }
    }

    public String[] readStringSeq() {
        int n = this.readAndCheckSeqSize(1);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readString();
        }
        return stringArray;
    }

    public void readStringSeq(int n, Optional<String[]> optional) {
        if (this.readOpt(n, OptionalFormat.FSize)) {
            this.skip(4);
            optional.set(this.readStringSeq());
        } else {
            optional.clear();
        }
    }

    public void writeProxy(ObjectPrx objectPrx) {
        this._instance.proxyFactory().proxyToStream(objectPrx, this);
    }

    public void writeProxy(int n, Optional<ObjectPrx> optional) {
        if (optional != null && optional.isSet()) {
            this.writeProxy(n, optional.get());
        }
    }

    public void writeProxy(int n, ObjectPrx objectPrx) {
        if (this.writeOpt(n, OptionalFormat.FSize)) {
            int n2 = this.startSize();
            this.writeProxy(objectPrx);
            this.endSize(n2);
        }
    }

    public ObjectPrx readProxy() {
        return this._instance.proxyFactory().streamToProxy(this);
    }

    public void readProxy(int n, Optional<ObjectPrx> optional) {
        if (this.readOpt(n, OptionalFormat.FSize)) {
            this.skip(4);
            optional.set(this.readProxy());
        } else {
            optional.clear();
        }
    }

    public void writeEnum(int n, int n2) {
        if (this.isWriteEncoding_1_0()) {
            if (n2 < 127) {
                this.writeByte((byte)n);
            } else if (n2 < Short.MAX_VALUE) {
                this.writeShort((short)n);
            } else {
                this.writeInt(n);
            }
        } else {
            this.writeSize(n);
        }
    }

    public int readEnum(int n) {
        if (this.getReadEncoding().equals(Ice.Util.Encoding_1_0)) {
            if (n < 127) {
                return this.readByte();
            }
            if (n < Short.MAX_VALUE) {
                return this.readShort();
            }
            return this.readInt();
        }
        return this.readSize();
    }

    public void writeObject(Object object) {
        this.initWriteEncaps();
        this._writeEncapsStack.encoder.writeObject(object);
    }

    public <T extends Object> void writeObject(int n, Optional<T> optional) {
        if (optional != null && optional.isSet()) {
            this.writeObject(n, (Object)optional.get());
        }
    }

    public void writeObject(int n, Object object) {
        if (this.writeOpt(n, OptionalFormat.Class)) {
            this.writeObject(object);
        }
    }

    public void readObject(Patcher patcher) {
        this.initReadEncaps();
        this._readEncapsStack.decoder.readObject(patcher);
    }

    public void readObject(int n, Optional<Object> optional) {
        if (this.readOpt(n, OptionalFormat.Class)) {
            OptionalObject optionalObject = new OptionalObject(optional, Object.class, ObjectImpl.ice_staticId());
            this.readObject(optionalObject);
        } else {
            optional.clear();
        }
    }

    public void writeUserException(UserException userException) {
        this.initWriteEncaps();
        this._writeEncapsStack.encoder.writeUserException(userException);
    }

    public void throwException(UserExceptionFactory userExceptionFactory) throws UserException {
        this.initReadEncaps();
        this._readEncapsStack.decoder.throwException(userExceptionFactory);
    }

    public void sliceObjects(boolean bl) {
        this._sliceObjects = bl;
    }

    public boolean readOptImpl(int n, OptionalFormat optionalFormat) {
        int n2;
        OptionalFormat optionalFormat2;
        if (this.isReadEncoding_1_0()) {
            return false;
        }
        while (true) {
            int n3;
            if (this._buf.b.position() >= this._readEncapsStack.start + this._readEncapsStack.sz) {
                return false;
            }
            int n4 = this.readByte();
            int n5 = n3 = n4 < 0 ? n4 + 256 : n4;
            if (n3 == 255) {
                this._buf.b.position(this._buf.b.position() - 1);
                return false;
            }
            optionalFormat2 = OptionalFormat.valueOf(n3 & 7);
            n2 = n3 >> 3;
            if (n2 == 30) {
                n2 = this.readSize();
            }
            if (n2 > n) {
                int n6 = n2 < 30 ? 1 : (n2 < 255 ? 2 : 6);
                this._buf.b.position(this._buf.b.position() - n6);
                return false;
            }
            if (n2 >= n) break;
            this.skipOpt(optionalFormat2);
        }
        if (optionalFormat2 != optionalFormat) {
            throw new MarshalException("invalid optional data member `" + n2 + "': unexpected format");
        }
        return true;
    }

    public boolean writeOptImpl(int n, OptionalFormat optionalFormat) {
        if (this.isWriteEncoding_1_0()) {
            return false;
        }
        int n2 = optionalFormat.value();
        if (n < 30) {
            this.writeByte((byte)(n2 |= n << 3));
        } else {
            this.writeByte((byte)(n2 |= 0xF0));
            this.writeSize(n);
        }
        return true;
    }

    public void skipOpt(OptionalFormat optionalFormat) {
        switch (optionalFormat) {
            case F1: {
                this.skip(1);
                break;
            }
            case F2: {
                this.skip(2);
                break;
            }
            case F4: {
                this.skip(4);
                break;
            }
            case F8: {
                this.skip(8);
                break;
            }
            case Size: {
                this.skipSize();
                break;
            }
            case VSize: {
                this.skip(this.readSize());
                break;
            }
            case FSize: {
                this.skip(this.readInt());
                break;
            }
            case Class: {
                this.readObject(null);
            }
        }
    }

    public void skipOpts() {
        while (this._buf.b.position() < this._readEncapsStack.start + this._readEncapsStack.sz) {
            int n;
            int n2 = this.readByte();
            int n3 = n = n2 < 0 ? n2 + 256 : n2;
            if (n == 255) {
                return;
            }
            OptionalFormat optionalFormat = OptionalFormat.valueOf(n & 7);
            if (n >> 3 == 30) {
                this.skipSize();
            }
            this.skipOpt(optionalFormat);
        }
        return;
    }

    public void skip(int n) {
        if (n > this._buf.b.remaining()) {
            throw new UnmarshalOutOfBoundsException();
        }
        this._buf.b.position(this._buf.b.position() + n);
    }

    public void skipSize() {
        byte by = this.readByte();
        if (by == -1) {
            this.skip(4);
        }
    }

    public int pos() {
        return this._buf.b.position();
    }

    public void pos(int n) {
        this._buf.b.position(n);
    }

    public int size() {
        return this._buf.size();
    }

    public boolean isEmpty() {
        return this._buf.empty();
    }

    public BasicStream compress(int n, int n2) {
        java.lang.Object object;
        assert (BasicStream.compressible());
        int n3 = this.size() - n;
        int n4 = (int)((double)n3 * 1.01 + 600.0);
        byte[] byArray = new byte[n4];
        byte[] byArray2 = null;
        int n5 = 0;
        try {
            byArray2 = this._buf.b.array();
            n5 = this._buf.b.arrayOffset();
        }
        catch (Exception exception) {
            byArray2 = new byte[this.size()];
            this.pos(0);
            this._buf.b.get(byArray2);
        }
        try {
            object = new BufferedOutputStream(byArray);
            ((BufferedOutputStream)object).write(66);
            ((BufferedOutputStream)object).write(90);
            java.lang.Object[] objectArray = new java.lang.Object[]{object, n2};
            OutputStream outputStream = (OutputStream)_bzOutputStreamCtor.newInstance(objectArray);
            outputStream.write(byArray2, n5 + n, n3);
            outputStream.close();
            n4 = ((BufferedOutputStream)object).pos();
        }
        catch (Exception exception) {
            throw new CompressionException("bzip2 compression failure", exception);
        }
        if (n4 >= n3) {
            return null;
        }
        object = new BasicStream(this._instance, this._encoding);
        ((BasicStream)object).resize(n + 4 + n4, false);
        ((BasicStream)object).pos(0);
        ((BasicStream)object)._buf.b.put(byArray2, n5, n);
        ((BasicStream)object).writeInt(this.size());
        ((BasicStream)object)._buf.b.put(byArray, 0, n4);
        return object;
    }

    public BasicStream uncompress(int n, int n2) {
        assert (BasicStream.compressible());
        this.pos(n);
        int n3 = this.readInt();
        if (n3 <= n) {
            throw new IllegalMessageSizeException();
        }
        if (n3 > n2) {
            Ex.throwMemoryLimitException(n3, n2);
        }
        int n4 = this.size() - n - 4;
        byte[] byArray = null;
        int n5 = 0;
        try {
            byArray = this._buf.b.array();
            n5 = this._buf.b.arrayOffset();
        }
        catch (Exception exception) {
            byArray = new byte[this.size()];
            this.pos(0);
            this._buf.b.get(byArray);
        }
        BasicStream basicStream = new BasicStream(this._instance, this._encoding);
        basicStream.resize(n3, false);
        try {
            int n6;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n5 + n + 4, n4);
            byte by = (byte)byteArrayInputStream.read();
            byte by2 = (byte)byteArrayInputStream.read();
            if (by != 66 || by2 != 90) {
                CompressionException compressionException = new CompressionException();
                compressionException.reason = "bzip2 uncompression failure: invalid magic bytes";
                throw compressionException;
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{byteArrayInputStream};
            InputStream inputStream = (InputStream)_bzInputStreamCtor.newInstance(objectArray);
            basicStream.pos(n);
            byte[] byArray2 = new byte[8192];
            while ((n6 = inputStream.read(byArray2)) != -1) {
                basicStream.writeBlob(byArray2, 0, n6);
            }
            inputStream.close();
        }
        catch (Exception exception) {
            throw new CompressionException("bzip2 uncompression failure", exception);
        }
        basicStream.pos(0);
        basicStream._buf.b.put(byArray, n5, n);
        return basicStream;
    }

    public void expand(int n) {
        this._buf.expand(n);
    }

    private String getTypeId(int n) {
        block5: {
            String string = "IceCompactId.TypeId_" + Integer.toString(n);
            Class<?> clazz = this.getConcreteClass(string);
            if (clazz == null) {
                String string2;
                String[] stringArray = this._instance.getPackages();
                int n2 = stringArray.length;
                for (int i = 0; i < n2 && (clazz = this.getConcreteClass((string2 = stringArray[i]) + "." + string)) == null; ++i) {
                }
            }
            if (clazz != null) {
                try {
                    return (String)clazz.getField("typeId").get(null);
                }
                catch (Exception exception) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
        }
        return "";
    }

    private UserException createUserException(String string) {
        UserException userException = null;
        try {
            Class<?> clazz = this.findClass(string);
            if (clazz != null) {
                userException = (UserException)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            throw new MarshalException(exception);
        }
        return userException;
    }

    private Class<?> findClass(String string) throws LinkageError {
        String string2;
        int n;
        Class<?> clazz = null;
        String string3 = this._instance.getClassForType(string);
        boolean bl = false;
        if (string3 == null) {
            string3 = this.typeToClass(string);
            bl = true;
        }
        if ((clazz = this.getConcreteClass(string3)) == null && (n = string.indexOf(58, 2)) != -1) {
            String string4 = string.substring(2, n);
            String string5 = this._instance.initializationData().properties.getProperty("Ice.Package." + string4);
            if (string5.length() > 0) {
                clazz = this.getConcreteClass(string5 + "." + string3);
            }
        }
        if (clazz == null && (string2 = this._instance.initializationData().properties.getProperty("Ice.Default.Package")).length() > 0) {
            clazz = this.getConcreteClass(string2 + "." + string3);
        }
        if (clazz != null && bl) {
            this._instance.addClassForType(string, clazz.getName());
        }
        return clazz;
    }

    private Class<?> getConcreteClass(String string) throws LinkageError {
        int n;
        Class<?> clazz = this._instance.findClass(string);
        if (clazz != null && ((n = clazz.getModifiers()) & 0x200) == 0 && (n & 0x400) == 0) {
            return clazz;
        }
        return null;
    }

    private static String fixKwd(String string) {
        java.lang.Object[] objectArray = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "checkedCast", "class", "clone", "const", "continue", "default", "do", "double", "else", "enum", "equals", "extends", "false", "final", "finalize", "finally", "float", "for", "getClass", "goto", "hashCode", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "notify", "notifyAll", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "toString", "transient", "true", "try", "uncheckedCast", "void", "volatile", "wait", "while"};
        boolean bl = Arrays.binarySearch(objectArray, string) >= 0;
        return bl ? "_" + string : string;
    }

    private String typeToClass(String string) {
        if (!string.startsWith("::")) {
            throw new MarshalException("expected type id but received `" + string + "'");
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 2;
        boolean bl = false;
        while (!bl) {
            String string2;
            int n2 = string.indexOf(58, n);
            if (n2 != -1) {
                string2 = string.substring(n, n2);
                n = n2 + 2;
            } else {
                string2 = string.substring(n);
                bl = true;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(BasicStream.fixKwd(string2));
        }
        return stringBuilder.toString();
    }

    private boolean isReadEncoding_1_0() {
        return this._readEncapsStack != null ? this._readEncapsStack.encoding_1_0 : this._encoding.equals(Ice.Util.Encoding_1_0);
    }

    private boolean isWriteEncoding_1_0() {
        return this._writeEncapsStack != null ? this._writeEncapsStack.encoding_1_0 : this._encoding.equals(Ice.Util.Encoding_1_0);
    }

    private void initReadEncaps() {
        if (this._readEncapsStack == null) {
            this._readEncapsStack = this._readEncapsCache;
            if (this._readEncapsStack != null) {
                this._readEncapsCache = this._readEncapsCache.next;
            } else {
                this._readEncapsStack = new ReadEncaps();
            }
            this._readEncapsStack.setEncoding(this._encoding);
            this._readEncapsStack.sz = this._buf.b.limit();
        }
        if (this._readEncapsStack.decoder == null) {
            ObjectFactoryManager objectFactoryManager = this._instance.servantFactoryManager();
            this._readEncapsStack.decoder = this._readEncapsStack.encoding_1_0 ? new EncapsDecoder10(this, this._sliceObjects, objectFactoryManager) : new EncapsDecoder11(this, this._sliceObjects, objectFactoryManager);
        }
    }

    private void initWriteEncaps() {
        if (this._writeEncapsStack == null) {
            this._writeEncapsStack = this._writeEncapsCache;
            if (this._writeEncapsStack != null) {
                this._writeEncapsCache = this._writeEncapsCache.next;
            } else {
                this._writeEncapsStack = new WriteEncaps();
            }
            this._writeEncapsStack.setEncoding(this._encoding);
        }
        if (this._writeEncapsStack.format == FormatType.DefaultFormat) {
            this._writeEncapsStack.format = this._instance.defaultsAndOverrides().defaultFormat;
        }
        if (this._writeEncapsStack.encoder == null) {
            this._writeEncapsStack.encoder = this._writeEncapsStack.encoding_1_0 ? new EncapsEncoder10(this, this._writeEncapsStack) : new EncapsEncoder11(this, this._writeEncapsStack);
        }
    }

    public static synchronized boolean compressible() {
        if (!_checkedBZip2) {
            _checkedBZip2 = true;
            try {
                Class[] classArray = new Class[1];
                Class<?> clazz = Util.findClass("org.apache.tools.bzip2.CBZip2InputStream", null);
                if (clazz != null) {
                    classArray[0] = InputStream.class;
                    _bzInputStreamCtor = clazz.getDeclaredConstructor(classArray);
                }
                if ((clazz = Util.findClass("org.apache.tools.bzip2.CBZip2OutputStream", null)) != null) {
                    classArray = new Class[]{OutputStream.class, Integer.TYPE};
                    _bzOutputStreamCtor = clazz.getDeclaredConstructor(classArray);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _bzInputStreamCtor != null && _bzOutputStreamCtor != null;
    }

    private static final class WriteEncaps {
        int start;
        FormatType format = FormatType.DefaultFormat;
        EncodingVersion encoding;
        boolean encoding_1_0;
        EncapsEncoder encoder;
        WriteEncaps next;

        private WriteEncaps() {
        }

        void reset() {
            this.encoder = null;
        }

        void setEncoding(EncodingVersion encodingVersion) {
            this.encoding = encodingVersion;
            this.encoding_1_0 = encodingVersion.equals(Ice.Util.Encoding_1_0);
        }
    }

    private static final class ReadEncaps {
        int start;
        int sz;
        EncodingVersion encoding;
        boolean encoding_1_0;
        EncapsDecoder decoder;
        ReadEncaps next;

        private ReadEncaps() {
        }

        void reset() {
            this.decoder = null;
        }

        void setEncoding(EncodingVersion encodingVersion) {
            this.encoding = encodingVersion;
            this.encoding_1_0 = encodingVersion.equals(Ice.Util.Encoding_1_0);
        }
    }

    private static final class EncapsEncoder11
    extends EncapsEncoder {
        private InstanceData _current = null;
        private int _objectIdIndex = 1;

        EncapsEncoder11(BasicStream basicStream, WriteEncaps writeEncaps) {
            super(basicStream, writeEncaps);
        }

        @Override
        void writeObject(Object object) {
            if (object == null) {
                this._stream.writeSize(0);
            } else if (this._current != null && this._encaps.format == FormatType.SlicedFormat) {
                Integer n;
                if (this._current.indirectionTable == null) {
                    this._current.indirectionTable = new ArrayList<Object>();
                    this._current.indirectionMap = new IdentityHashMap();
                }
                if ((n = this._current.indirectionMap.get(object)) == null) {
                    this._current.indirectionTable.add(object);
                    int n2 = this._current.indirectionTable.size();
                    this._current.indirectionMap.put(object, n2);
                    this._stream.writeSize(n2);
                } else {
                    this._stream.writeSize(n);
                }
            } else {
                this.writeInstance(object);
            }
        }

        @Override
        void writeUserException(UserException userException) {
            userException.__write(this._stream);
        }

        @Override
        void startInstance(SliceType sliceType, SlicedData slicedData) {
            this._current = this._current == null ? new InstanceData(null) : (this._current.next == null ? new InstanceData(this._current) : this._current.next);
            this._current.sliceType = sliceType;
            this._current.firstSlice = true;
            if (slicedData != null) {
                this.writeSlicedData(slicedData);
            }
        }

        @Override
        void endInstance() {
            this._current = this._current.previous;
        }

        @Override
        void startSlice(String string, int n, boolean bl) {
            assert ((this._current.indirectionTable == null || this._current.indirectionTable.isEmpty()) && (this._current.indirectionMap == null || this._current.indirectionMap.isEmpty()));
            this._current.sliceFlagsPos = this._stream.pos();
            this._current.sliceFlags = 0;
            if (this._encaps.format == FormatType.SlicedFormat) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 0x10);
            }
            if (bl) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 0x20);
            }
            this._stream.writeByte((byte)0);
            if (this._current.sliceType == SliceType.ObjectSlice) {
                if (this._encaps.format == FormatType.SlicedFormat || this._current.firstSlice) {
                    if (n >= 0) {
                        this._current.sliceFlags = (byte)(this._current.sliceFlags | 3);
                        this._stream.writeSize(n);
                    } else {
                        int n2 = this.registerTypeId(string);
                        if (n2 < 0) {
                            this._current.sliceFlags = (byte)(this._current.sliceFlags | 1);
                            this._stream.writeString(string);
                        } else {
                            this._current.sliceFlags = (byte)(this._current.sliceFlags | 2);
                            this._stream.writeSize(n2);
                        }
                    }
                }
            } else {
                this._stream.writeString(string);
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                this._stream.writeInt(0);
            }
            this._current.writeSlice = this._stream.pos();
            this._current.firstSlice = false;
        }

        @Override
        void endSlice() {
            if ((this._current.sliceFlags & 4) != 0) {
                this._stream.writeByte((byte)-1);
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                int n = this._stream.pos() - this._current.writeSlice + 4;
                this._stream.rewriteInt(n, this._current.writeSlice - 4);
            }
            if (this._current.indirectionTable != null && !this._current.indirectionTable.isEmpty()) {
                assert (this._encaps.format == FormatType.SlicedFormat);
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 8);
                this._stream.writeSize(this._current.indirectionTable.size());
                for (Object object : this._current.indirectionTable) {
                    this.writeInstance(object);
                }
                this._current.indirectionTable.clear();
                this._current.indirectionMap.clear();
            }
            this._stream.rewriteByte(this._current.sliceFlags, this._current.sliceFlagsPos);
        }

        @Override
        boolean writeOpt(int n, OptionalFormat optionalFormat) {
            if (this._current == null) {
                return this._stream.writeOptImpl(n, optionalFormat);
            }
            if (this._stream.writeOptImpl(n, optionalFormat)) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 4);
                return true;
            }
            return false;
        }

        private void writeSlicedData(SlicedData slicedData) {
            assert (slicedData != null);
            if (this._encaps.format != FormatType.SlicedFormat) {
                return;
            }
            for (SliceInfo sliceInfo : slicedData.slices) {
                this.startSlice(sliceInfo.typeId, sliceInfo.compactId, sliceInfo.isLastSlice);
                this._stream.writeBlob(sliceInfo.bytes);
                if (sliceInfo.hasOptionalMembers) {
                    this._current.sliceFlags = (byte)(this._current.sliceFlags | 4);
                }
                if (sliceInfo.objects != null && sliceInfo.objects.length > 0) {
                    if (this._current.indirectionTable == null) {
                        this._current.indirectionTable = new ArrayList<Object>();
                        this._current.indirectionMap = new IdentityHashMap();
                    }
                    for (Object object : sliceInfo.objects) {
                        this._current.indirectionTable.add(object);
                    }
                }
                this.endSlice();
            }
        }

        private void writeInstance(Object object) {
            assert (object != null);
            Integer n = (Integer)this._marshaledMap.get(object);
            if (n != null) {
                this._stream.writeSize(n);
                return;
            }
            this._marshaledMap.put(object, ++this._objectIdIndex);
            try {
                object.ice_preMarshal();
            }
            catch (Exception exception) {
                String string = "exception raised by ice_preMarshal:\n" + Ex.toString(exception);
                this._stream.instance().initializationData().logger.warning(string);
            }
            this._stream.writeSize(1);
            object.__write(this._stream);
        }

        private static final class InstanceData {
            SliceType sliceType;
            boolean firstSlice;
            byte sliceFlags;
            int writeSlice;
            int sliceFlagsPos;
            List<Object> indirectionTable;
            IdentityHashMap<Object, Integer> indirectionMap;
            final InstanceData previous;
            InstanceData next;

            InstanceData(InstanceData instanceData) {
                if (instanceData != null) {
                    instanceData.next = this;
                }
                this.previous = instanceData;
                this.next = null;
            }
        }
    }

    private static final class EncapsEncoder10
    extends EncapsEncoder {
        private SliceType _sliceType = SliceType.NoSlice;
        private int _writeSlice;
        private int _objectIdIndex = 0;
        private IdentityHashMap<Object, Integer> _toBeMarshaledMap = new IdentityHashMap();

        EncapsEncoder10(BasicStream basicStream, WriteEncaps writeEncaps) {
            super(basicStream, writeEncaps);
        }

        @Override
        void writeObject(Object object) {
            if (object != null) {
                this._stream.writeInt(-this.registerObject(object));
            } else {
                this._stream.writeInt(0);
            }
        }

        @Override
        void writeUserException(UserException userException) {
            boolean bl = userException.__usesClasses();
            this._stream.writeBool(bl);
            userException.__write(this._stream);
            if (bl) {
                this.writePendingObjects();
            }
        }

        @Override
        void startInstance(SliceType sliceType, SlicedData slicedData) {
            this._sliceType = sliceType;
        }

        @Override
        void endInstance() {
            if (this._sliceType == SliceType.ObjectSlice) {
                this.startSlice(ObjectImpl.ice_staticId(), -1, true);
                this._stream.writeSize(0);
                this.endSlice();
            }
            this._sliceType = SliceType.NoSlice;
        }

        @Override
        void startSlice(String string, int n, boolean bl) {
            if (this._sliceType == SliceType.ObjectSlice) {
                int n2 = this.registerTypeId(string);
                if (n2 < 0) {
                    this._stream.writeBool(false);
                    this._stream.writeString(string);
                } else {
                    this._stream.writeBool(true);
                    this._stream.writeSize(n2);
                }
            } else {
                this._stream.writeString(string);
            }
            this._stream.writeInt(0);
            this._writeSlice = this._stream.pos();
        }

        @Override
        void endSlice() {
            int n = this._stream.pos() - this._writeSlice + 4;
            this._stream.rewriteInt(n, this._writeSlice - 4);
        }

        @Override
        void writePendingObjects() {
            while (this._toBeMarshaledMap.size() > 0) {
                this._marshaledMap.putAll(this._toBeMarshaledMap);
                IdentityHashMap<Object, Integer> identityHashMap = this._toBeMarshaledMap;
                this._toBeMarshaledMap = new IdentityHashMap();
                this._stream.writeSize(identityHashMap.size());
                for (Map.Entry<Object, Integer> entry : identityHashMap.entrySet()) {
                    this._stream.writeInt(entry.getValue());
                    try {
                        entry.getKey().ice_preMarshal();
                    }
                    catch (Exception exception) {
                        String string = "exception raised by ice_preMarshal:\n" + Ex.toString(exception);
                        this._stream.instance().initializationData().logger.warning(string);
                    }
                    entry.getKey().__write(this._stream);
                }
            }
            this._stream.writeSize(0);
        }

        private int registerObject(Object object) {
            assert (object != null);
            Integer n = this._toBeMarshaledMap.get(object);
            if (n != null) {
                return n;
            }
            n = (Integer)this._marshaledMap.get(object);
            if (n != null) {
                return n;
            }
            this._toBeMarshaledMap.put(object, ++this._objectIdIndex);
            return this._objectIdIndex;
        }
    }

    private static abstract class EncapsEncoder {
        protected final BasicStream _stream;
        protected final WriteEncaps _encaps;
        protected final IdentityHashMap<Object, Integer> _marshaledMap;
        private TreeMap<String, Integer> _typeIdMap;
        private int _typeIdIndex;

        protected EncapsEncoder(BasicStream basicStream, WriteEncaps writeEncaps) {
            this._stream = basicStream;
            this._encaps = writeEncaps;
            this._typeIdIndex = 0;
            this._marshaledMap = new IdentityHashMap();
        }

        abstract void writeObject(Object var1);

        abstract void writeUserException(UserException var1);

        abstract void startInstance(SliceType var1, SlicedData var2);

        abstract void endInstance();

        abstract void startSlice(String var1, int var2, boolean var3);

        abstract void endSlice();

        boolean writeOpt(int n, OptionalFormat optionalFormat) {
            return false;
        }

        void writePendingObjects() {
        }

        protected int registerTypeId(String string) {
            Integer n;
            if (this._typeIdMap == null) {
                this._typeIdMap = new TreeMap();
            }
            if ((n = this._typeIdMap.get(string)) != null) {
                return n;
            }
            this._typeIdMap.put(string, ++this._typeIdIndex);
            return -1;
        }
    }

    private static class EncapsDecoder11
    extends EncapsDecoder {
        private InstanceData _current = null;
        private int _objectIdIndex = 1;
        private TreeMap<Integer, Class<?>> _compactIdCache;

        EncapsDecoder11(BasicStream basicStream, boolean bl, ObjectFactoryManager objectFactoryManager) {
            super(basicStream, bl, objectFactoryManager);
        }

        @Override
        void readObject(Patcher patcher) {
            int n = this._stream.readSize();
            if (n < 0) {
                throw new MarshalException("invalid object id");
            }
            if (n == 0) {
                if (patcher != null) {
                    patcher.patch(null);
                }
            } else if (this._current != null && (this._current.sliceFlags & 8) != 0) {
                if (patcher != null) {
                    if (this._current.indirectPatchList == null) {
                        this._current.indirectPatchList = new ArrayDeque<IndirectPatchEntry>();
                    }
                    IndirectPatchEntry indirectPatchEntry = new IndirectPatchEntry();
                    indirectPatchEntry.index = n - 1;
                    indirectPatchEntry.patcher = patcher;
                    this._current.indirectPatchList.push(indirectPatchEntry);
                }
            } else {
                this.readInstance(n, patcher);
            }
        }

        @Override
        void throwException(UserExceptionFactory userExceptionFactory) throws UserException {
            assert (this._current == null);
            this.push(SliceType.ExceptionSlice);
            this.startSlice();
            String string = this._current.typeId;
            while (true) {
                UserException userException = null;
                if (userExceptionFactory != null) {
                    try {
                        userExceptionFactory.createAndThrow(this._current.typeId);
                    }
                    catch (UserException userException2) {
                        userException = userException2;
                    }
                }
                if (userException == null) {
                    userException = this._stream.createUserException(this._current.typeId);
                }
                if (userException != null) {
                    userException.__read(this._stream);
                    throw userException;
                }
                this.skipSlice();
                if ((this._current.sliceFlags & 0x20) != 0) {
                    if (string.startsWith("::")) {
                        throw new UnknownUserException(string.substring(2));
                    }
                    throw new UnknownUserException(string);
                }
                this.startSlice();
            }
        }

        @Override
        void startInstance(SliceType sliceType) {
            assert (this._current.sliceType == sliceType);
            this._current.skipFirstSlice = true;
        }

        @Override
        SlicedData endInstance(boolean bl) {
            SlicedData slicedData = null;
            if (bl) {
                slicedData = this.readSlicedData();
            }
            if (this._current.slices != null) {
                this._current.slices.clear();
                this._current.indirectionTables.clear();
            }
            this._current = this._current.previous;
            return slicedData;
        }

        @Override
        String startSlice() {
            if (this._current.skipFirstSlice) {
                this._current.skipFirstSlice = false;
                return this._current.typeId;
            }
            this._current.sliceFlags = this._stream.readByte();
            if (this._current.sliceType == SliceType.ObjectSlice) {
                if ((this._current.sliceFlags & 3) == 3) {
                    this._current.typeId = "";
                    this._current.compactId = this._stream.readSize();
                } else if ((this._current.sliceFlags & 3) != 0) {
                    this._current.typeId = this.readTypeId((this._current.sliceFlags & 2) != 0);
                    this._current.compactId = -1;
                } else {
                    this._current.typeId = "";
                    this._current.compactId = -1;
                }
            } else {
                this._current.typeId = this._stream.readString();
                this._current.compactId = -1;
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                this._current.sliceSize = this._stream.readInt();
                if (this._current.sliceSize < 4) {
                    throw new UnmarshalOutOfBoundsException();
                }
            } else {
                this._current.sliceSize = 0;
            }
            return this._current.typeId;
        }

        @Override
        void endSlice() {
            if ((this._current.sliceFlags & 4) != 0) {
                this._stream.skipOpts();
            }
            if ((this._current.sliceFlags & 8) != 0) {
                int[] nArray = new int[this._stream.readAndCheckSeqSize(1)];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.readInstance(this._stream.readSize(), null);
                }
                if (nArray.length == 0) {
                    throw new MarshalException("empty indirection table");
                }
                if ((this._current.indirectPatchList == null || this._current.indirectPatchList.isEmpty()) && (this._current.sliceFlags & 4) == 0) {
                    throw new MarshalException("no references to indirection table");
                }
                if (this._current.indirectPatchList != null) {
                    for (IndirectPatchEntry indirectPatchEntry : this._current.indirectPatchList) {
                        assert (indirectPatchEntry.index >= 0);
                        if (indirectPatchEntry.index >= nArray.length) {
                            throw new MarshalException("indirection out of range");
                        }
                        this.addPatchEntry(nArray[indirectPatchEntry.index], indirectPatchEntry.patcher);
                    }
                    this._current.indirectPatchList.clear();
                }
            }
        }

        @Override
        void skipSlice() {
            int n;
            java.lang.Object object;
            if (this._stream.instance().traceLevels().slicing > 0) {
                Logger logger = this._stream.instance().initializationData().logger;
                object = this._stream.instance().traceLevels().slicingCat;
                if (this._current.sliceType == SliceType.ExceptionSlice) {
                    TraceUtil.traceSlicing("exception", this._current.typeId, (String)object, logger);
                } else {
                    TraceUtil.traceSlicing("object", this._current.typeId, (String)object, logger);
                }
            }
            int n2 = this._stream.pos();
            if ((this._current.sliceFlags & 0x10) != 0) {
                assert (this._current.sliceSize >= 4);
            } else {
                if (this._current.sliceType == SliceType.ObjectSlice) {
                    throw new NoObjectFactoryException("no object factory found and compact format prevents slicing (the sender should use the sliced format instead)", this._current.typeId);
                }
                if (this._current.typeId.startsWith("::")) {
                    throw new UnknownUserException(this._current.typeId.substring(2));
                }
                throw new UnknownUserException(this._current.typeId);
            }
            this._stream.skip(this._current.sliceSize - 4);
            object = new SliceInfo();
            ((SliceInfo)object).typeId = this._current.typeId;
            ((SliceInfo)object).compactId = this._current.compactId;
            ((SliceInfo)object).hasOptionalMembers = (this._current.sliceFlags & 4) != 0;
            ((SliceInfo)object).isLastSlice = (this._current.sliceFlags & 0x20) != 0;
            ByteBuffer byteBuffer = this._stream.getBuffer().b;
            int n3 = n = byteBuffer.position();
            if (((SliceInfo)object).hasOptionalMembers) {
                --n3;
            }
            ((SliceInfo)object).bytes = new byte[n3 - n2];
            byteBuffer.position(n2);
            byteBuffer.get(((SliceInfo)object).bytes);
            byteBuffer.position(n);
            if (this._current.slices == null) {
                this._current.slices = new ArrayList<SliceInfo>();
                this._current.indirectionTables = new ArrayList<int[]>();
            }
            if ((this._current.sliceFlags & 8) != 0) {
                int[] nArray = new int[this._stream.readAndCheckSeqSize(1)];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = this.readInstance(this._stream.readSize(), null);
                }
                this._current.indirectionTables.add(nArray);
            } else {
                this._current.indirectionTables.add(null);
            }
            this._current.slices.add((SliceInfo)object);
        }

        @Override
        boolean readOpt(int n, OptionalFormat optionalFormat) {
            if (this._current == null) {
                return this._stream.readOptImpl(n, optionalFormat);
            }
            if ((this._current.sliceFlags & 4) != 0) {
                return this._stream.readOptImpl(n, optionalFormat);
            }
            return false;
        }

        private int readInstance(int n, Patcher patcher) {
            assert (n > 0);
            if (n > 1) {
                if (patcher != null) {
                    this.addPatchEntry(n, patcher);
                }
                return n;
            }
            this.push(SliceType.ObjectSlice);
            n = ++this._objectIdIndex;
            this.startSlice();
            String string = this._current.typeId;
            Object object = null;
            CompactIdResolver compactIdResolver = this._stream.instance().initializationData().compactIdResolver;
            while (true) {
                boolean bl = false;
                if (this._current.compactId >= 0) {
                    bl = true;
                    if (this._compactIdCache == null) {
                        this._compactIdCache = new TreeMap();
                    } else {
                        Class<?> clazz = this._compactIdCache.get(this._current.compactId);
                        if (clazz != null) {
                            try {
                                object = (Object)clazz.newInstance();
                                bl = false;
                            }
                            catch (Exception exception) {
                                throw new NoObjectFactoryException("no object factory", "compact ID " + this._current.compactId, exception);
                            }
                        }
                    }
                    if (object == null) {
                        this._current.typeId = "";
                        if (compactIdResolver != null) {
                            try {
                                this._current.typeId = compactIdResolver.resolve(this._current.compactId);
                            }
                            catch (LocalException localException) {
                                throw localException;
                            }
                            catch (Throwable throwable) {
                                throw new MarshalException("exception in CompactIdResolver for ID " + this._current.compactId, throwable);
                            }
                        }
                        if (this._current.typeId.isEmpty()) {
                            this._current.typeId = this._stream.getTypeId(this._current.compactId);
                        }
                    }
                }
                if (object == null && !this._current.typeId.isEmpty()) {
                    object = this.newInstance(this._current.typeId);
                }
                if (object != null) {
                    if (!bl) break;
                    assert (this._current.compactId >= 0);
                    this._compactIdCache.put(this._current.compactId, object.getClass());
                    break;
                }
                if (!this._sliceObjects) {
                    throw new NoObjectFactoryException("no object factory found and object slicing is disabled", this._current.typeId);
                }
                this.skipSlice();
                if ((this._current.sliceFlags & 0x20) != 0) {
                    object = this.newInstance(ObjectImpl.ice_staticId());
                    if (object != null) break;
                    object = new UnknownSlicedObject(string);
                    break;
                }
                this.startSlice();
            }
            this.unmarshal(n, object);
            if (this._current == null && this._patchMap != null && !this._patchMap.isEmpty()) {
                throw new MarshalException("index for class received, but no instance");
            }
            if (patcher != null) {
                patcher.patch(object);
            }
            return n;
        }

        private SlicedData readSlicedData() {
            if (this._current.slices == null) {
                return null;
            }
            assert (this._current.slices.size() == this._current.indirectionTables.size());
            for (int i = 0; i < this._current.slices.size(); ++i) {
                int[] nArray = this._current.indirectionTables.get(i);
                SliceInfo sliceInfo = this._current.slices.get(i);
                sliceInfo.objects = new Object[nArray != null ? nArray.length : 0];
                for (int j = 0; j < sliceInfo.objects.length; ++j) {
                    this.addPatchEntry(nArray[j], new SequencePatcher(sliceInfo.objects, Object.class, ObjectImpl.ice_staticId(), j));
                }
            }
            SliceInfo[] sliceInfoArray = new SliceInfo[this._current.slices.size()];
            this._current.slices.toArray(sliceInfoArray);
            return new SlicedData(sliceInfoArray);
        }

        private void push(SliceType sliceType) {
            this._current = this._current == null ? new InstanceData(null) : (this._current.next == null ? new InstanceData(this._current) : this._current.next);
            this._current.sliceType = sliceType;
            this._current.skipFirstSlice = false;
        }

        private static final class InstanceData {
            SliceType sliceType;
            boolean skipFirstSlice;
            List<SliceInfo> slices;
            List<int[]> indirectionTables;
            byte sliceFlags;
            int sliceSize;
            String typeId;
            int compactId;
            Deque<IndirectPatchEntry> indirectPatchList;
            final InstanceData previous;
            InstanceData next;

            InstanceData(InstanceData instanceData) {
                if (instanceData != null) {
                    instanceData.next = this;
                }
                this.previous = instanceData;
                this.next = null;
            }
        }

        private static final class IndirectPatchEntry {
            int index;
            Patcher patcher;

            private IndirectPatchEntry() {
            }
        }
    }

    private static final class EncapsDecoder10
    extends EncapsDecoder {
        private SliceType _sliceType = SliceType.NoSlice;
        private boolean _skipFirstSlice;
        private int _sliceSize;
        private String _typeId;

        EncapsDecoder10(BasicStream basicStream, boolean bl, ObjectFactoryManager objectFactoryManager) {
            super(basicStream, bl, objectFactoryManager);
        }

        @Override
        void readObject(Patcher patcher) {
            assert (patcher != null);
            int n = this._stream.readInt();
            if (n > 0) {
                throw new MarshalException("invalid object id");
            }
            if ((n = -n) == 0) {
                patcher.patch(null);
            } else {
                this.addPatchEntry(n, patcher);
            }
        }

        @Override
        void throwException(UserExceptionFactory userExceptionFactory) throws UserException {
            assert (this._sliceType == SliceType.NoSlice);
            boolean bl = this._stream.readBool();
            this._sliceType = SliceType.ExceptionSlice;
            this._skipFirstSlice = false;
            this.startSlice();
            String string = this._typeId;
            while (true) {
                UserException userException = null;
                if (userExceptionFactory != null) {
                    try {
                        userExceptionFactory.createAndThrow(this._typeId);
                    }
                    catch (UserException userException2) {
                        userException = userException2;
                    }
                }
                if (userException == null) {
                    userException = this._stream.createUserException(this._typeId);
                }
                if (userException != null) {
                    userException.__read(this._stream);
                    if (bl) {
                        this.readPendingObjects();
                    }
                    throw userException;
                }
                this.skipSlice();
                try {
                    this.startSlice();
                }
                catch (UnmarshalOutOfBoundsException unmarshalOutOfBoundsException) {
                    unmarshalOutOfBoundsException.reason = "unknown exception type `" + string + "'";
                    throw unmarshalOutOfBoundsException;
                }
            }
        }

        @Override
        void startInstance(SliceType sliceType) {
            assert (this._sliceType == sliceType);
            this._skipFirstSlice = true;
        }

        @Override
        SlicedData endInstance(boolean bl) {
            if (this._sliceType == SliceType.ObjectSlice) {
                this.startSlice();
                int n = this._stream.readSize();
                if (n != 0) {
                    throw new MarshalException("invalid Object slice");
                }
                this.endSlice();
            }
            this._sliceType = SliceType.NoSlice;
            return null;
        }

        @Override
        String startSlice() {
            if (this._skipFirstSlice) {
                this._skipFirstSlice = false;
                return this._typeId;
            }
            if (this._sliceType == SliceType.ObjectSlice) {
                boolean bl = this._stream.readBool();
                this._typeId = this.readTypeId(bl);
            } else {
                this._typeId = this._stream.readString();
            }
            this._sliceSize = this._stream.readInt();
            if (this._sliceSize < 4) {
                throw new UnmarshalOutOfBoundsException();
            }
            return this._typeId;
        }

        @Override
        void endSlice() {
        }

        @Override
        void skipSlice() {
            if (this._stream.instance().traceLevels().slicing > 0) {
                Logger logger = this._stream.instance().initializationData().logger;
                if (this._sliceType == SliceType.ObjectSlice) {
                    TraceUtil.traceSlicing("object", this._typeId, this._stream.instance().traceLevels().slicingCat, logger);
                } else {
                    TraceUtil.traceSlicing("exception", this._typeId, this._stream.instance().traceLevels().slicingCat, logger);
                }
            }
            assert (this._sliceSize >= 4);
            this._stream.skip(this._sliceSize - 4);
        }

        @Override
        void readPendingObjects() {
            int n;
            do {
                for (int i = n = this._stream.readSize(); i > 0; --i) {
                    this.readInstance();
                }
            } while (n > 0);
            if (this._patchMap != null && !this._patchMap.isEmpty()) {
                throw new MarshalException("index for class received, but no instance");
            }
        }

        private void readInstance() {
            int n = this._stream.readInt();
            if (n <= 0) {
                throw new MarshalException("invalid object id");
            }
            this._sliceType = SliceType.ObjectSlice;
            this._skipFirstSlice = false;
            this.startSlice();
            String string = this._typeId;
            Object object = null;
            while (true) {
                if (this._typeId.equals(ObjectImpl.ice_staticId())) {
                    throw new NoObjectFactoryException("", string);
                }
                object = this.newInstance(this._typeId);
                if (object != null) break;
                if (!this._sliceObjects) {
                    throw new NoObjectFactoryException("no object factory found and object slicing is disabled", this._typeId);
                }
                this.skipSlice();
                this.startSlice();
            }
            this.unmarshal(n, object);
        }
    }

    private static abstract class EncapsDecoder {
        protected final BasicStream _stream;
        protected final boolean _sliceObjects;
        protected ObjectFactoryManager _servantFactoryManager;
        protected TreeMap<Integer, LinkedList<Patcher>> _patchMap;
        private TreeMap<Integer, Object> _unmarshaledMap;
        private TreeMap<Integer, String> _typeIdMap;
        private int _typeIdIndex;
        private List<Object> _objectList;
        private HashMap<String, Class<?>> _typeIdCache;

        EncapsDecoder(BasicStream basicStream, boolean bl, ObjectFactoryManager objectFactoryManager) {
            this._stream = basicStream;
            this._sliceObjects = bl;
            this._servantFactoryManager = objectFactoryManager;
            this._typeIdIndex = 0;
            this._unmarshaledMap = new TreeMap();
        }

        abstract void readObject(Patcher var1);

        abstract void throwException(UserExceptionFactory var1) throws UserException;

        abstract void startInstance(SliceType var1);

        abstract SlicedData endInstance(boolean var1);

        abstract String startSlice();

        abstract void endSlice();

        abstract void skipSlice();

        boolean readOpt(int n, OptionalFormat optionalFormat) {
            return false;
        }

        void readPendingObjects() {
        }

        protected String readTypeId(boolean bl) {
            if (this._typeIdMap == null) {
                this._typeIdMap = new TreeMap();
            }
            if (bl) {
                int n = this._stream.readSize();
                String string = this._typeIdMap.get(n);
                if (string == null) {
                    throw new UnmarshalOutOfBoundsException();
                }
                return string;
            }
            String string = this._stream.readString();
            this._typeIdMap.put(++this._typeIdIndex, string);
            return string;
        }

        protected Class<?> resolveClass(String string) {
            Class<EncapsDecoder> clazz = null;
            if (this._typeIdCache == null) {
                this._typeIdCache = new HashMap();
            } else {
                clazz = this._typeIdCache.get(string);
            }
            if (clazz == EncapsDecoder.class) {
                clazz = null;
            } else if (clazz == null) {
                try {
                    clazz = this._stream.findClass(string);
                    this._typeIdCache.put(string, clazz != null ? clazz : EncapsDecoder.class);
                }
                catch (Exception exception) {
                    throw new NoObjectFactoryException("no object factory", string, exception);
                }
            }
            return clazz;
        }

        protected Object newInstance(String string) {
            Class<?> clazz;
            ObjectFactory objectFactory = this._servantFactoryManager.find(string);
            Object object = null;
            if (objectFactory != null) {
                object = objectFactory.create(string);
            }
            if (object == null && (objectFactory = this._servantFactoryManager.find("")) != null) {
                object = objectFactory.create(string);
            }
            if (object == null && (clazz = this.resolveClass(string)) != null) {
                try {
                    object = (Object)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new NoObjectFactoryException("no object factory", string, exception);
                }
            }
            return object;
        }

        protected void addPatchEntry(int n, Patcher patcher) {
            LinkedList<Patcher> linkedList;
            assert (n > 0);
            Object object = this._unmarshaledMap.get(n);
            if (object != null) {
                patcher.patch(object);
                return;
            }
            if (this._patchMap == null) {
                this._patchMap = new TreeMap();
            }
            if ((linkedList = this._patchMap.get(n)) == null) {
                linkedList = new LinkedList();
                this._patchMap.put(n, linkedList);
            }
            linkedList.add(patcher);
        }

        protected void unmarshal(int n, Object object) {
            java.lang.Object object3;
            this._unmarshaledMap.put(n, object);
            object.__read(this._stream);
            if (this._patchMap != null && (object3 = this._patchMap.get(n)) != null) {
                assert (((LinkedList)object3).size() > 0);
                Iterator object22 = ((AbstractSequentialList)object3).iterator();
                while (object22.hasNext()) {
                    Patcher patcher = (Patcher)object22.next();
                    patcher.patch(object);
                }
                this._patchMap.remove(n);
            }
            if ((this._patchMap == null || this._patchMap.isEmpty()) && this._objectList == null) {
                try {
                    object.ice_postUnmarshal();
                }
                catch (Exception exception) {
                    String string = "exception raised by ice_postUnmarshal:\n" + Ex.toString(exception);
                    this._stream.instance().initializationData().logger.warning(string);
                }
            } else {
                if (this._objectList == null) {
                    this._objectList = new ArrayList<Object>();
                }
                this._objectList.add(object);
                if (this._patchMap == null || this._patchMap.isEmpty()) {
                    for (Object object2 : this._objectList) {
                        try {
                            object2.ice_postUnmarshal();
                        }
                        catch (Exception exception) {
                            String string = "exception raised by ice_postUnmarshal:\n" + Ex.toString(exception);
                            this._stream.instance().initializationData().logger.warning(string);
                        }
                    }
                    this._objectList.clear();
                }
            }
        }
    }

    private static enum SliceType {
        NoSlice,
        ObjectSlice,
        ExceptionSlice;

    }

    private static class BufferedOutputStream
    extends OutputStream {
        private byte[] _data;
        private int _pos;

        BufferedOutputStream(byte[] byArray) {
            this._data = byArray;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            assert (this._data.length - this._pos >= byArray.length);
            System.arraycopy(byArray, 0, this._data, this._pos, byArray.length);
            this._pos += byArray.length;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            assert (this._data.length - this._pos >= n2);
            System.arraycopy(byArray, n, this._data, this._pos, n2);
            this._pos += n2;
        }

        @Override
        public void write(int n) throws IOException {
            assert (this._data.length - this._pos >= 1);
            this._data[this._pos] = (byte)n;
            ++this._pos;
        }

        int pos() {
            return this._pos;
        }
    }
}

