/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ACMClose;
import Ice.ACMHeartbeat;
import Ice.Logger;
import Ice.Properties;

public final class ACMConfig
implements Cloneable {
    public int timeout;
    public ACMHeartbeat heartbeat;
    public ACMClose close;

    ACMConfig(boolean bl) {
        this.timeout = 60000;
        this.heartbeat = ACMHeartbeat.HeartbeatOnInvocation;
        this.close = bl ? ACMClose.CloseOnInvocation : ACMClose.CloseOnInvocationAndIdle;
    }

    public ACMConfig(Properties properties, Logger logger, String string, ACMConfig aCMConfig) {
        assert (string != null);
        String string2 = (string.equals("Ice.ACM.Client") || string.equals("Ice.ACM.Server")) && properties.getProperty(string + ".Timeout").isEmpty() ? string : string + ".Timeout";
        this.timeout = properties.getPropertyAsIntWithDefault(string2, aCMConfig.timeout / 1000) * 1000;
        int n = properties.getPropertyAsIntWithDefault(string + ".Heartbeat", aCMConfig.heartbeat.ordinal());
        ACMHeartbeat[] aCMHeartbeatArray = ACMHeartbeat.values();
        if (n >= 0 && n < aCMHeartbeatArray.length) {
            this.heartbeat = aCMHeartbeatArray[n];
        } else {
            logger.warning("invalid value for property `" + string + ".Heartbeat', default value will be used instead");
            this.heartbeat = aCMConfig.heartbeat;
        }
        ACMClose[] aCMCloseArray = ACMClose.values();
        int n2 = properties.getPropertyAsIntWithDefault(string + ".Close", aCMConfig.close.ordinal());
        if (n2 >= 0 && n2 < aCMCloseArray.length) {
            this.close = aCMCloseArray[n2];
        } else {
            logger.warning("invalid value for property `" + string + ".Close', default value will be used instead");
            this.close = aCMConfig.close;
        }
    }

    public ACMConfig clone() {
        ACMConfig aCMConfig;
        block2: {
            aCMConfig = null;
            try {
                aCMConfig = (ACMConfig)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return aCMConfig;
    }
}

