/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Current;
import Ice.DispatchStatus;
import Ice.FormatType;
import Ice.LogMessage;
import Ice.LogMessageSeqHelper;
import Ice.LogMessageType;
import Ice.LogMessageTypeSeqHelper;
import Ice.LoggerAdmin;
import Ice.Object;
import Ice.ObjectImpl;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.RemoteLoggerAlreadyAttachedException;
import Ice.RemoteLoggerPrx;
import Ice.RemoteLoggerPrxHelper;
import Ice.StringHolder;
import Ice.StringSeqHelper;
import IceInternal.BasicStream;
import IceInternal.Incoming;
import java.util.Arrays;

public abstract class _LoggerAdminDisp
extends ObjectImpl
implements LoggerAdmin {
    public static final String[] __ids = new String[]{"::Ice::LoggerAdmin", "::Ice::Object"};
    private static final String[] __all = new String[]{"attachRemoteLogger", "detachRemoteLogger", "getLog", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    public static final long serialVersionUID = 0L;

    protected void ice_copyStateFrom(Object object) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public boolean ice_isA(String string) {
        return Arrays.binarySearch(__ids, string) >= 0;
    }

    @Override
    public boolean ice_isA(String string, Current current) {
        return Arrays.binarySearch(__ids, string) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return __ids;
    }

    @Override
    public String[] ice_ids(Current current) {
        return __ids;
    }

    @Override
    public String ice_id() {
        return __ids[0];
    }

    @Override
    public String ice_id(Current current) {
        return __ids[0];
    }

    public static String ice_staticId() {
        return __ids[0];
    }

    @Override
    public final void attachRemoteLogger(RemoteLoggerPrx remoteLoggerPrx, LogMessageType[] logMessageTypeArray, String[] stringArray, int n) throws RemoteLoggerAlreadyAttachedException {
        this.attachRemoteLogger(remoteLoggerPrx, logMessageTypeArray, stringArray, n, null);
    }

    @Override
    public final boolean detachRemoteLogger(RemoteLoggerPrx remoteLoggerPrx) {
        return this.detachRemoteLogger(remoteLoggerPrx, null);
    }

    @Override
    public final LogMessage[] getLog(LogMessageType[] logMessageTypeArray, String[] stringArray, int n, StringHolder stringHolder) {
        return this.getLog(logMessageTypeArray, stringArray, n, stringHolder, null);
    }

    public static DispatchStatus ___attachRemoteLogger(LoggerAdmin loggerAdmin, Incoming incoming, Current current) {
        _LoggerAdminDisp.__checkMode(OperationMode.Normal, current.mode);
        BasicStream basicStream = incoming.startReadParams();
        RemoteLoggerPrx remoteLoggerPrx = RemoteLoggerPrxHelper.__read(basicStream);
        LogMessageType[] logMessageTypeArray = LogMessageTypeSeqHelper.read(basicStream);
        String[] stringArray = StringSeqHelper.read(basicStream);
        int n = basicStream.readInt();
        incoming.endReadParams();
        try {
            loggerAdmin.attachRemoteLogger(remoteLoggerPrx, logMessageTypeArray, stringArray, n, current);
            incoming.__writeEmptyParams();
            return DispatchStatus.DispatchOK;
        }
        catch (RemoteLoggerAlreadyAttachedException remoteLoggerAlreadyAttachedException) {
            incoming.__writeUserException(remoteLoggerAlreadyAttachedException, FormatType.DefaultFormat);
            return DispatchStatus.DispatchUserException;
        }
    }

    public static DispatchStatus ___detachRemoteLogger(LoggerAdmin loggerAdmin, Incoming incoming, Current current) {
        _LoggerAdminDisp.__checkMode(OperationMode.Normal, current.mode);
        BasicStream basicStream = incoming.startReadParams();
        RemoteLoggerPrx remoteLoggerPrx = RemoteLoggerPrxHelper.__read(basicStream);
        incoming.endReadParams();
        boolean bl = loggerAdmin.detachRemoteLogger(remoteLoggerPrx, current);
        BasicStream basicStream2 = incoming.__startWriteParams(FormatType.DefaultFormat);
        basicStream2.writeBool(bl);
        incoming.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    public static DispatchStatus ___getLog(LoggerAdmin loggerAdmin, Incoming incoming, Current current) {
        _LoggerAdminDisp.__checkMode(OperationMode.Normal, current.mode);
        BasicStream basicStream = incoming.startReadParams();
        LogMessageType[] logMessageTypeArray = LogMessageTypeSeqHelper.read(basicStream);
        String[] stringArray = StringSeqHelper.read(basicStream);
        int n = basicStream.readInt();
        incoming.endReadParams();
        StringHolder stringHolder = new StringHolder();
        LogMessage[] logMessageArray = loggerAdmin.getLog(logMessageTypeArray, stringArray, n, stringHolder, current);
        BasicStream basicStream2 = incoming.__startWriteParams(FormatType.DefaultFormat);
        basicStream2.writeString((String)stringHolder.value);
        LogMessageSeqHelper.write(basicStream2, logMessageArray);
        incoming.__endWriteParams(true);
        return DispatchStatus.DispatchOK;
    }

    @Override
    public DispatchStatus __dispatch(Incoming incoming, Current current) {
        int n = Arrays.binarySearch(__all, current.operation);
        if (n < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (n) {
            case 0: {
                return _LoggerAdminDisp.___attachRemoteLogger(this, incoming, current);
            }
            case 1: {
                return _LoggerAdminDisp.___detachRemoteLogger(this, incoming, current);
            }
            case 2: {
                return _LoggerAdminDisp.___getLog(this, incoming, current);
            }
            case 3: {
                return _LoggerAdminDisp.___ice_id(this, incoming, current);
            }
            case 4: {
                return _LoggerAdminDisp.___ice_ids(this, incoming, current);
            }
            case 5: {
                return _LoggerAdminDisp.___ice_isA(this, incoming, current);
            }
            case 6: {
                return _LoggerAdminDisp.___ice_ping(this, incoming, current);
            }
        }
        assert (false);
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    @Override
    protected void __writeImpl(BasicStream basicStream) {
        basicStream.startWriteSlice(_LoggerAdminDisp.ice_staticId(), -1, true);
        basicStream.endWriteSlice();
    }

    @Override
    protected void __readImpl(BasicStream basicStream) {
        basicStream.startReadSlice();
        basicStream.endReadSlice();
    }
}

