/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.CommunicatorI;
import Ice.EncodingVersion;
import Ice.Identity;
import Ice.IdentityParseException;
import Ice.InitializationData;
import Ice.InputStream;
import Ice.InputStreamI;
import Ice.Logger;
import Ice.LoggerI;
import Ice.ObjectPrx;
import Ice.OutputStream;
import Ice.OutputStreamI;
import Ice.Properties;
import Ice.PropertiesI;
import Ice.ProtocolVersion;
import Ice.StringSeqHolder;
import Ice.VersionParseException;
import IceInternal.Protocol;
import IceUtilInternal.StringUtil;

public final class Util {
    public static final ProtocolVersion Protocol_1_0 = new ProtocolVersion(1, 0);
    public static final EncodingVersion Encoding_1_0 = new EncodingVersion(1, 0);
    public static final EncodingVersion Encoding_1_1 = new EncodingVersion(1, 1);
    private static Object _processLoggerMutex = new Object();
    private static Logger _processLogger = null;

    public static Properties createProperties() {
        return new PropertiesI();
    }

    public static Properties createProperties(StringSeqHolder stringSeqHolder) {
        return new PropertiesI(stringSeqHolder, null);
    }

    public static Properties createProperties(StringSeqHolder stringSeqHolder, Properties properties) {
        return new PropertiesI(stringSeqHolder, properties);
    }

    public static Properties createProperties(String[] stringArray) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.createProperties(stringSeqHolder);
    }

    public static Properties createProperties(String[] stringArray, Properties properties) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.createProperties(stringSeqHolder, properties);
    }

    public static Communicator initialize(StringSeqHolder stringSeqHolder) {
        return Util.initialize(stringSeqHolder, null);
    }

    public static Communicator initialize(String[] stringArray) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.initialize(stringSeqHolder);
    }

    public static Communicator initialize(StringSeqHolder stringSeqHolder, InitializationData initializationData) {
        initializationData = initializationData == null ? new InitializationData() : initializationData.clone();
        initializationData.properties = Util.createProperties(stringSeqHolder, initializationData.properties);
        CommunicatorI communicatorI = new CommunicatorI(initializationData);
        communicatorI.finishSetup(stringSeqHolder);
        return communicatorI;
    }

    public static Communicator initialize(String[] stringArray, InitializationData initializationData) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.initialize(stringSeqHolder, initializationData);
    }

    public static Communicator initialize(InitializationData initializationData) {
        initializationData = initializationData == null ? new InitializationData() : initializationData.clone();
        CommunicatorI communicatorI = new CommunicatorI(initializationData);
        communicatorI.finishSetup(new StringSeqHolder(new String[0]));
        return communicatorI;
    }

    public static Communicator initialize() {
        return Util.initialize(new InitializationData());
    }

    public static Identity stringToIdentity(String string) {
        Identity identity = new Identity();
        int n = -1;
        int n2 = 0;
        while ((n2 = string.indexOf(47, n2)) != -1) {
            int n3 = 0;
            while (n2 - n3 > 0 && string.charAt(n2 - n3 - 1) == '\\') {
                ++n3;
            }
            if (n3 % 2 == 0) {
                if (n == -1) {
                    n = n2;
                } else {
                    IdentityParseException identityParseException = new IdentityParseException();
                    identityParseException.str = "unescaped backslash in identity `" + string + "'";
                    throw identityParseException;
                }
            }
            ++n2;
        }
        if (n == -1) {
            identity.category = "";
            try {
                identity.name = StringUtil.unescapeString(string, 0, string.length());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IdentityParseException identityParseException = new IdentityParseException();
                identityParseException.str = "invalid identity name `" + string + "': " + illegalArgumentException.getMessage();
                throw identityParseException;
            }
        }
        try {
            identity.category = StringUtil.unescapeString(string, 0, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IdentityParseException identityParseException = new IdentityParseException();
            identityParseException.str = "invalid category in identity `" + string + "': " + illegalArgumentException.getMessage();
            throw identityParseException;
        }
        if (n + 1 < string.length()) {
            try {
                identity.name = StringUtil.unescapeString(string, n + 1, string.length());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IdentityParseException identityParseException = new IdentityParseException();
                identityParseException.str = "invalid name in identity `" + string + "': " + illegalArgumentException.getMessage();
                throw identityParseException;
            }
        } else {
            identity.name = "";
        }
        return identity;
    }

    public static String identityToString(Identity identity) {
        if (identity.category == null || identity.category.length() == 0) {
            return StringUtil.escapeString(identity.name, "/");
        }
        return StringUtil.escapeString(identity.category, "/") + '/' + StringUtil.escapeString(identity.name, "/");
    }

    public static int proxyIdentityCompare(ObjectPrx objectPrx, ObjectPrx objectPrx2) {
        if (objectPrx == null && objectPrx2 == null) {
            return 0;
        }
        if (objectPrx == null && objectPrx2 != null) {
            return -1;
        }
        if (objectPrx != null && objectPrx2 == null) {
            return 1;
        }
        Identity identity = objectPrx.ice_getIdentity();
        Identity identity2 = objectPrx2.ice_getIdentity();
        int n = identity.name.compareTo(identity2.name);
        if (n != 0) {
            return n;
        }
        return identity.category.compareTo(identity2.category);
    }

    public static int proxyIdentityAndFacetCompare(ObjectPrx objectPrx, ObjectPrx objectPrx2) {
        if (objectPrx == null && objectPrx2 == null) {
            return 0;
        }
        if (objectPrx == null && objectPrx2 != null) {
            return -1;
        }
        if (objectPrx != null && objectPrx2 == null) {
            return 1;
        }
        Identity identity = objectPrx.ice_getIdentity();
        Identity identity2 = objectPrx2.ice_getIdentity();
        int n = identity.name.compareTo(identity2.name);
        if (n != 0) {
            return n;
        }
        n = identity.category.compareTo(identity2.category);
        if (n != 0) {
            return n;
        }
        String string = objectPrx.ice_getFacet();
        String string2 = objectPrx2.ice_getFacet();
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    public static InputStream createInputStream(Communicator communicator, byte[] byArray) {
        return new InputStreamI(communicator, byArray, true);
    }

    public static InputStream createInputStream(Communicator communicator, byte[] byArray, EncodingVersion encodingVersion) {
        return new InputStreamI(communicator, byArray, encodingVersion, true);
    }

    public static InputStream wrapInputStream(Communicator communicator, byte[] byArray) {
        return new InputStreamI(communicator, byArray, false);
    }

    public static InputStream wrapInputStream(Communicator communicator, byte[] byArray, EncodingVersion encodingVersion) {
        return new InputStreamI(communicator, byArray, encodingVersion, false);
    }

    public static OutputStream createOutputStream(Communicator communicator) {
        return new OutputStreamI(communicator);
    }

    public static OutputStream createOutputStream(Communicator communicator, EncodingVersion encodingVersion) {
        return new OutputStreamI(communicator, encodingVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getProcessLogger() {
        Object object = _processLoggerMutex;
        synchronized (object) {
            if (_processLogger == null) {
                _processLogger = new LoggerI("", "");
            }
            return _processLogger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProcessLogger(Logger logger) {
        Object object = _processLoggerMutex;
        synchronized (object) {
            _processLogger = logger;
        }
    }

    public static String stringVersion() {
        return "3.6.3";
    }

    public static int intVersion() {
        return 30603;
    }

    public static ProtocolVersion stringToProtocolVersion(String string) {
        return new ProtocolVersion(Util.stringToMajor(string), Util.stringToMinor(string));
    }

    public static EncodingVersion stringToEncodingVersion(String string) {
        return new EncodingVersion(Util.stringToMajor(string), Util.stringToMinor(string));
    }

    public static String protocolVersionToString(ProtocolVersion protocolVersion) {
        return Util.majorMinorToString(protocolVersion.major, protocolVersion.minor);
    }

    public static String encodingVersionToString(EncodingVersion encodingVersion) {
        return Util.majorMinorToString(encodingVersion.major, encodingVersion.minor);
    }

    public static ProtocolVersion currentProtocol() {
        return Protocol.currentProtocol.clone();
    }

    public static EncodingVersion currentEncoding() {
        return Protocol.currentEncoding.clone();
    }

    private static byte stringToMajor(String string) {
        int n;
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            throw new VersionParseException("malformed version value `" + string + "'");
        }
        String string2 = string.substring(0, n2);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionParseException("invalid version value `" + string + "'");
        }
        if (n < 1 || n > 255) {
            throw new VersionParseException("range error in version `" + string + "'");
        }
        return (byte)n;
    }

    private static byte stringToMinor(String string) {
        int n;
        int n2 = string.indexOf(46);
        if (n2 == -1) {
            throw new VersionParseException("malformed version value `" + string + "'");
        }
        String string2 = string.substring(n2 + 1, string.length());
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VersionParseException("invalid version value `" + string + "'");
        }
        if (n < 0 || n > 255) {
            throw new VersionParseException("range error in version `" + string + "'");
        }
        return (byte)n;
    }

    private static String majorMinorToString(byte n, byte n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n < 0 ? n + 255 : n);
        stringBuilder.append(".");
        stringBuilder.append(n2 < 0 ? n2 + 255 : n2);
        return stringBuilder.toString();
    }
}

