/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.InitializationException;
import Ice.Logger;
import Ice.SocketException;
import IceInternal.Network;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public final class SysLoggerI
implements Logger {
    private String _prefix;
    private int _facility;
    private DatagramSocket _socket;
    private InetAddress _host;
    private static int _port = 514;
    private static final int LOG_KERN = 0;
    private static final int LOG_USER = 1;
    private static final int LOG_MAIL = 2;
    private static final int LOG_DAEMON = 3;
    private static final int LOG_AUTH = 4;
    private static final int LOG_SYSLOG = 5;
    private static final int LOG_LPR = 6;
    private static final int LOG_NEWS = 7;
    private static final int LOG_UUCP = 8;
    private static final int LOG_CRON = 9;
    private static final int LOG_AUTHPRIV = 10;
    private static final int LOG_FTP = 11;
    private static final int LOG_LOCAL0 = 16;
    private static final int LOG_LOCAL1 = 17;
    private static final int LOG_LOCAL2 = 18;
    private static final int LOG_LOCAL3 = 19;
    private static final int LOG_LOCAL4 = 20;
    private static final int LOG_LOCAL5 = 21;
    private static final int LOG_LOCAL6 = 22;
    private static final int LOG_LOCAL7 = 23;
    private static final int LOG_ERR = 3;
    private static final int LOG_WARNING = 4;
    private static final int LOG_INFO = 6;

    public SysLoggerI(String string, String string2) {
        int n;
        if (string2.equals("LOG_KERN")) {
            n = 0;
        } else if (string2.equals("LOG_USER")) {
            n = 1;
        } else if (string2.equals("LOG_MAIL")) {
            n = 2;
        } else if (string2.equals("LOG_DAEMON")) {
            n = 3;
        } else if (string2.equals("LOG_AUTH")) {
            n = 4;
        } else if (string2.equals("LOG_SYSLOG")) {
            n = 5;
        } else if (string2.equals("LOG_LPR")) {
            n = 6;
        } else if (string2.equals("LOG_NEWS")) {
            n = 7;
        } else if (string2.equals("LOG_UUCP")) {
            n = 8;
        } else if (string2.equals("LOG_CRON")) {
            n = 9;
        } else if (string2.equals("LOG_AUTHPRIV")) {
            n = 10;
        } else if (string2.equals("LOG_FTP")) {
            n = 11;
        } else if (string2.equals("LOG_LOCAL0")) {
            n = 16;
        } else if (string2.equals("LOG_LOCAL1")) {
            n = 17;
        } else if (string2.equals("LOG_LOCAL2")) {
            n = 18;
        } else if (string2.equals("LOG_LOCAL3")) {
            n = 19;
        } else if (string2.equals("LOG_LOCAL4")) {
            n = 20;
        } else if (string2.equals("LOG_LOCAL5")) {
            n = 21;
        } else if (string2.equals("LOG_LOCAL6")) {
            n = 22;
        } else if (string2.equals("LOG_LOCAL7")) {
            n = 23;
        } else {
            throw new InitializationException("Invalid value for Ice.SyslogFacility: " + string2);
        }
        this.initialize(string, n);
    }

    private SysLoggerI(String string, int n) {
        this.initialize(string, n);
    }

    private void initialize(String string, int n) {
        this._prefix = string;
        this._facility = n;
        try {
            this._host = Network.getLocalAddress(2);
            this._socket = new DatagramSocket();
            this._socket.connect(this._host, _port);
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
    }

    @Override
    public void print(String string) {
        this.log(6, string);
    }

    @Override
    public void trace(String string, String string2) {
        this.log(6, string + ": " + string2);
    }

    @Override
    public void warning(String string) {
        this.log(4, string);
    }

    @Override
    public void error(String string) {
        this.log(3, string);
    }

    @Override
    public String getPrefix() {
        return this._prefix;
    }

    @Override
    public Logger cloneWithPrefix(String string) {
        return new SysLoggerI(string, this._facility);
    }

    private void log(int n, String string) {
        try {
            int n2 = this._facility << 3 | n;
            String string2 = '<' + Integer.toString(n2) + '>' + this._prefix + ": " + string;
            byte[] byArray = string2.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this._host, _port);
            this._socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            throw new SocketException(iOException);
        }
    }
}

