/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.FileException;
import Ice.InitializationException;
import Ice.LocalException;
import Ice.Logger;
import Ice.Properties;
import Ice.StringSeqHolder;
import Ice.SyscallException;
import IceInternal.PropertyNames;
import IceInternal.Util;
import IceUtilInternal.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PropertiesI
implements Properties {
    private static final int ParseStateKey = 0;
    private static final int ParseStateValue = 1;
    private HashMap<String, PropertyValue> _properties = new HashMap();

    @Override
    public synchronized String getProperty(String string) {
        PropertyValue propertyValue = this._properties.get(string);
        if (propertyValue != null) {
            propertyValue.used = true;
            return propertyValue.value;
        }
        return "";
    }

    @Override
    public synchronized String getPropertyWithDefault(String string, String string2) {
        PropertyValue propertyValue = this._properties.get(string);
        if (propertyValue != null) {
            propertyValue.used = true;
            return propertyValue.value;
        }
        return string2;
    }

    @Override
    public int getPropertyAsInt(String string) {
        return this.getPropertyAsIntWithDefault(string, 0);
    }

    @Override
    public synchronized int getPropertyAsIntWithDefault(String string, int n) {
        PropertyValue propertyValue = this._properties.get(string);
        if (propertyValue != null) {
            propertyValue.used = true;
            try {
                return Integer.parseInt(propertyValue.value);
            }
            catch (NumberFormatException numberFormatException) {
                Ice.Util.getProcessLogger().warning("numeric property " + string + " set to non-numeric value, defaulting to " + n);
            }
        }
        return n;
    }

    @Override
    public String[] getPropertyAsList(String string) {
        return this.getPropertyAsListWithDefault(string, null);
    }

    @Override
    public synchronized String[] getPropertyAsListWithDefault(String string, String[] stringArray) {
        PropertyValue propertyValue;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if ((propertyValue = this._properties.get(string)) != null) {
            propertyValue.used = true;
            String[] stringArray2 = StringUtil.splitString(propertyValue.value, ", \t\r\n");
            if (stringArray2 == null) {
                Ice.Util.getProcessLogger().warning("mismatched quotes in property " + string + "'s value, returning default value");
                return stringArray;
            }
            if (stringArray2.length == 0) {
                stringArray2 = stringArray;
            }
            return stringArray2;
        }
        return stringArray;
    }

    @Override
    public synchronized Map<String, String> getPropertiesForPrefix(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, PropertyValue> entry : this._properties.entrySet()) {
            String string2 = entry.getKey();
            if (string.length() != 0 && !string2.startsWith(string)) continue;
            PropertyValue propertyValue = entry.getValue();
            propertyValue.used = true;
            hashMap.put(string2, propertyValue.value);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, String string2) {
        Object object;
        if (string != null) {
            string = string.trim();
        }
        Logger logger = Ice.Util.getProcessLogger();
        if (string == null || string.length() == 0) {
            throw new InitializationException("Attempt to set property with empty key");
        }
        int n = string.indexOf(46);
        if (n != -1) {
            object = string.substring(0, n);
            int n2 = 0;
            while (PropertyNames.validProps[n2] != null) {
                String string3 = PropertyNames.validProps[n2][0].pattern();
                n = string3.indexOf(46);
                assert (n != -1);
                String string4 = string3.substring(0, n - 1);
                boolean bl = false;
                String string5 = "";
                if (string4.toUpperCase().equals(((String)object).toUpperCase())) {
                    boolean bl2 = false;
                    int n3 = 0;
                    while (PropertyNames.validProps[n2][n3] != null && !bl2) {
                        string3 = PropertyNames.validProps[n2][n3].pattern();
                        Pattern pattern = Pattern.compile(string3);
                        Matcher matcher = pattern.matcher(string);
                        bl2 = matcher.matches();
                        if (bl2 && PropertyNames.validProps[n2][n3].deprecated()) {
                            logger.warning("deprecated property: " + string);
                            if (PropertyNames.validProps[n2][n3].deprecatedBy() != null) {
                                string = PropertyNames.validProps[n2][n3].deprecatedBy();
                            }
                        }
                        if (!bl2 && (matcher = (pattern = Pattern.compile(string3.toUpperCase())).matcher(string.toUpperCase())).matches()) {
                            bl2 = true;
                            bl = true;
                            string5 = string3.replaceAll("\\\\", "");
                            break;
                        }
                        ++n3;
                    }
                    if (!bl2) {
                        logger.warning("unknown property: " + string);
                    } else if (bl) {
                        logger.warning("unknown property: `" + string + "'; did you mean `" + string5 + "'");
                    }
                }
                ++n2;
            }
        }
        object = this;
        synchronized (object) {
            if (string2 != null && string2.length() > 0) {
                PropertyValue propertyValue = this._properties.get(string);
                if (propertyValue != null) {
                    propertyValue.value = string2;
                } else {
                    propertyValue = new PropertyValue(string2, false);
                }
                this._properties.put(string, propertyValue);
            } else {
                this._properties.remove(string);
            }
        }
    }

    @Override
    public synchronized String[] getCommandLineOptions() {
        String[] stringArray = new String[this._properties.size()];
        int n = 0;
        for (Map.Entry<String, PropertyValue> entry : this._properties.entrySet()) {
            stringArray[n++] = "--" + entry.getKey() + "=" + entry.getValue().value;
        }
        assert (n == stringArray.length);
        return stringArray;
    }

    @Override
    public String[] parseCommandLineOptions(String string, String[] stringArray) {
        if (string.length() > 0 && string.charAt(string.length() - 1) != '.') {
            string = string + '.';
        }
        string = "--" + string;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            if (string2.startsWith(string)) {
                if (string2.indexOf(61) == -1) {
                    string2 = string2 + "=1";
                }
                this.parseLine(string2.substring(2));
                continue;
            }
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public String[] parseIceCommandLineOptions(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = 0;
        while (PropertyNames.clPropNames[n] != null) {
            stringArray2 = this.parseCommandLineOptions(PropertyNames.clPropNames[n], stringArray2);
            ++n;
        }
        return stringArray2;
    }

    @Override
    public void load(String string) {
        if (System.getProperty("os.name").startsWith("Windows") && string.startsWith("HKLM\\")) {
            String string2 = "reg query " + string;
            try {
                String[] stringArray;
                int n;
                Process process = Runtime.getRuntime().exec(string2);
                process.waitFor();
                if (process.exitValue() != 0) {
                    InitializationException initializationException = new InitializationException();
                    initializationException.reason = "Could not read Windows registry key `" + string + "'";
                    throw initializationException;
                }
                InputStream inputStream = process.getInputStream();
                StringWriter stringWriter = new StringWriter();
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
                for (String string3 : stringArray = stringWriter.toString().split("\n")) {
                    int n2 = string3.indexOf("REG_SZ");
                    if (n2 != -1) {
                        this.setProperty(string3.substring(0, n2).trim(), string3.substring(n2 + 6, string3.length()).trim());
                        continue;
                    }
                    n2 = string3.indexOf("REG_EXPAND_SZ");
                    if (n2 == -1) continue;
                    String string4 = string3.substring(0, n2).trim();
                    string3 = string3.substring(n2 + 13, string3.length()).trim();
                    while (true) {
                        int n3 = string3.indexOf("%", 0);
                        int n4 = string3.indexOf("%", n3 + 1);
                        if (n3 == -1 || n4 == -1) break;
                        String string5 = string3.substring(n3 + 1, n4);
                        String string6 = System.getenv(string5);
                        if (string6 == null) {
                            string6 = "";
                        }
                        string5 = "%" + string5 + "%";
                        while ((string3 = string3.replace(string5, string6)).indexOf(string5) != -1) {
                        }
                    }
                    this.setProperty(string4, string3);
                }
            }
            catch (LocalException localException) {
                throw localException;
            }
            catch (Exception exception) {
                throw new InitializationException("Could not read Windows registry key `" + string + "'", exception);
            }
        }
        PushbackInputStream pushbackInputStream = null;
        try {
            InputStream inputStream = Util.openResource(this.getClass().getClassLoader(), string);
            if (inputStream == null) {
                FileException fileException = new FileException();
                fileException.path = string;
                throw fileException;
            }
            byte[] byArray = new byte[3];
            pushbackInputStream = new PushbackInputStream(inputStream, byArray.length);
            int n = pushbackInputStream.read(byArray, 0, byArray.length);
            if ((n < 3 || byArray[0] != -17 || byArray[1] != -69 || byArray[2] != -65) && n > 0) {
                pushbackInputStream.unread(byArray, 0, n);
            }
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)pushbackInputStream, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            this.parse(bufferedReader);
        }
        catch (IOException iOException) {
            throw new FileException(0, string, iOException);
        }
        finally {
            if (pushbackInputStream != null) {
                try {
                    pushbackInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public synchronized Properties _clone() {
        return new PropertiesI(this);
    }

    public synchronized List<String> getUnusedProperties() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, PropertyValue> entry : this._properties.entrySet()) {
            PropertyValue propertyValue = entry.getValue();
            if (propertyValue.used) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    PropertiesI(PropertiesI propertiesI) {
        for (Map.Entry<String, PropertyValue> entry : propertiesI._properties.entrySet()) {
            this._properties.put(entry.getKey(), new PropertyValue(entry.getValue()));
        }
    }

    PropertiesI() {
    }

    PropertiesI(StringSeqHolder stringSeqHolder, Properties properties) {
        if (properties != null) {
            for (Map.Entry<String, PropertyValue> entry : ((PropertiesI)properties)._properties.entrySet()) {
                this._properties.put(entry.getKey(), new PropertyValue(entry.getValue()));
            }
        }
        boolean bl = false;
        for (int i = 0; i < ((String[])stringSeqHolder.value).length; ++i) {
            if (!((String[])stringSeqHolder.value)[i].startsWith("--Ice.Config")) continue;
            String string = ((String[])stringSeqHolder.value)[i];
            if (string.indexOf(61) == -1) {
                string = string + "=1";
            }
            this.parseLine(string.substring(2));
            bl = true;
            String[] stringArray = new String[((String[])stringSeqHolder.value).length - 1];
            System.arraycopy(stringSeqHolder.value, 0, stringArray, 0, i);
            if (i < ((String[])stringSeqHolder.value).length - 1) {
                System.arraycopy(stringSeqHolder.value, i + 1, stringArray, i, ((String[])stringSeqHolder.value).length - i - 1);
            }
            stringSeqHolder.value = stringArray;
        }
        if (!bl) {
            boolean bl2 = bl = !this._properties.containsKey("Ice.Config");
        }
        if (bl) {
            this.loadConfig();
        }
        stringSeqHolder.value = this.parseIceCommandLineOptions((String[])stringSeqHolder.value);
    }

    private void parse(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                this.parseLine(string);
            }
        }
        catch (IOException iOException) {
            throw new SyscallException(iOException);
        }
    }

    private void parseLine(String string) {
        String string2 = "";
        String string3 = "";
        int n = 0;
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            block0 : switch (n) {
                case 0: {
                    switch (c) {
                        case '\\': {
                            if (i < string.length() - 1) {
                                c = string.charAt(++i);
                                switch (c) {
                                    case '#': 
                                    case '=': 
                                    case '\\': {
                                        string2 = string2 + string4;
                                        string4 = "";
                                        string2 = string2 + c;
                                        break block0;
                                    }
                                    case ' ': {
                                        if (string2.length() == 0) break block0;
                                        string4 = string4 + c;
                                        break block0;
                                    }
                                }
                                string2 = string2 + string4;
                                string4 = "";
                                string2 = string2 + '\\';
                                string2 = string2 + c;
                                break block0;
                            }
                            string2 = string2 + string4;
                            string2 = string2 + c;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (string2.length() == 0) break block0;
                            string4 = string4 + c;
                            break block0;
                        }
                        case '=': {
                            string4 = "";
                            n = 1;
                            break block0;
                        }
                        case '#': {
                            bl = true;
                            break block0;
                        }
                    }
                    string2 = string2 + string4;
                    string4 = "";
                    string2 = string2 + c;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            if (i < string.length() - 1) {
                                c = string.charAt(++i);
                                switch (c) {
                                    case '#': 
                                    case '=': 
                                    case '\\': {
                                        string3 = string3 + (string3.length() == 0 ? string5 : string4);
                                        string4 = "";
                                        string5 = "";
                                        string3 = string3 + c;
                                        break block0;
                                    }
                                    case ' ': {
                                        string4 = string4 + c;
                                        string5 = string5 + c;
                                        break block0;
                                    }
                                }
                                string3 = string3 + (string3.length() == 0 ? string5 : string4);
                                string4 = "";
                                string5 = "";
                                string3 = string3 + '\\';
                                string3 = string3 + c;
                                break block0;
                            }
                            string3 = string3 + (string3.length() == 0 ? string5 : string4);
                            string3 = string3 + c;
                            break block0;
                        }
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if (string3.length() == 0) break block0;
                            string4 = string4 + c;
                            break block0;
                        }
                        case '#': {
                            bl = true;
                            break block0;
                        }
                    }
                    string3 = string3 + (string3.length() == 0 ? string5 : string4);
                    string4 = "";
                    string5 = "";
                    string3 = string3 + c;
                }
            }
            if (bl) break;
        }
        string3 = string3 + string5;
        if (n == 0 && string2.length() != 0 || n == 1 && string2.length() == 0) {
            Ice.Util.getProcessLogger().warning("invalid config file entry: \"" + string + "\"");
            return;
        }
        if (string2.length() == 0) {
            return;
        }
        this.setProperty(string2, string3);
    }

    private void loadConfig() {
        String string = this.getProperty("Ice.Config");
        if (string.length() == 0 || string.equals("1")) {
            try {
                string = System.getenv("ICE_CONFIG");
                if (string == null) {
                    string = "";
                }
            }
            catch (SecurityException securityException) {
                string = "";
            }
        }
        if (string.length() > 0) {
            for (String string2 : string.split(",")) {
                this.load(string2.trim());
            }
            this._properties.put("Ice.Config", new PropertyValue(string, true));
        }
    }

    static class PropertyValue {
        public String value;
        public boolean used;

        public PropertyValue(PropertyValue propertyValue) {
            this.value = propertyValue.value;
            this.used = propertyValue.used;
        }

        public PropertyValue(String string, boolean bl) {
            this.value = string;
            this.used = bl;
        }
    }
}

