/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.InitializationException;
import Ice.NotRegisteredException;
import Ice.Plugin;
import Ice.PluginFactory;
import Ice.PluginInitializationException;
import Ice.PluginManager;
import Ice.Properties;
import Ice.StringSeqHolder;
import IceInternal.Instance;
import IceInternal.Util;
import IceUtilInternal.Options;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public final class PluginManagerI
implements PluginManager {
    private static String _kindOfObject = "plugin";
    private Communicator _communicator;
    private Instance _instance;
    private List<PluginInfo> _plugins = new ArrayList<PluginInfo>();
    private boolean _initialized;
    private Map<String, ClassLoader> _classLoaders;

    @Override
    public synchronized void initializePlugins() {
        if (this._initialized) {
            InitializationException initializationException = new InitializationException();
            initializationException.reason = "plug-ins already initialized";
            throw initializationException;
        }
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        try {
            for (PluginInfo pluginInfo : this._plugins) {
                try {
                    pluginInfo.plugin.initialize();
                }
                catch (PluginInitializationException pluginInitializationException) {
                    throw pluginInitializationException;
                }
                catch (RuntimeException runtimeException) {
                    PluginInitializationException pluginInitializationException = new PluginInitializationException();
                    pluginInitializationException.reason = "plugin `" + pluginInfo.name + "' initialization failed";
                    pluginInitializationException.initCause(runtimeException);
                    throw pluginInitializationException;
                }
                arrayList.add(pluginInfo.plugin);
            }
        }
        catch (RuntimeException runtimeException) {
            ListIterator listIterator = arrayList.listIterator(arrayList.size());
            while (listIterator.hasPrevious()) {
                Plugin plugin = (Plugin)listIterator.previous();
                try {
                    plugin.destroy();
                }
                catch (RuntimeException runtimeException2) {}
            }
            throw runtimeException;
        }
        this._initialized = true;
    }

    @Override
    public synchronized String[] getPlugins() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PluginInfo pluginInfo : this._plugins) {
            arrayList.add(pluginInfo.name);
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public synchronized Plugin getPlugin(String string) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        Plugin plugin = this.findPlugin(string);
        if (plugin != null) {
            return plugin;
        }
        NotRegisteredException notRegisteredException = new NotRegisteredException();
        notRegisteredException.id = string;
        notRegisteredException.kindOfObject = _kindOfObject;
        throw notRegisteredException;
    }

    @Override
    public synchronized void addPlugin(String string, Plugin plugin) {
        if (this._communicator == null) {
            throw new CommunicatorDestroyedException();
        }
        if (this.findPlugin(string) != null) {
            AlreadyRegisteredException alreadyRegisteredException = new AlreadyRegisteredException();
            alreadyRegisteredException.id = string;
            alreadyRegisteredException.kindOfObject = _kindOfObject;
            throw alreadyRegisteredException;
        }
        PluginInfo pluginInfo = new PluginInfo();
        pluginInfo.name = string;
        pluginInfo.plugin = plugin;
        this._plugins.add(pluginInfo);
    }

    @Override
    public synchronized void destroy() {
        if (this._communicator != null) {
            if (this._initialized) {
                ListIterator<PluginInfo> listIterator = this._plugins.listIterator(this._plugins.size());
                while (listIterator.hasPrevious()) {
                    PluginInfo pluginInfo = listIterator.previous();
                    try {
                        pluginInfo.plugin.destroy();
                    }
                    catch (RuntimeException runtimeException) {
                        Ice.Util.getProcessLogger().warning("unexpected exception raised by plug-in `" + pluginInfo.name + "' destruction:\n" + runtimeException.toString());
                    }
                }
            }
            this._communicator = null;
        }
        this._plugins.clear();
        if (this._classLoaders != null) {
            this._classLoaders.clear();
        }
    }

    public PluginManagerI(Communicator communicator, Instance instance) {
        this._communicator = communicator;
        this._instance = instance;
        this._initialized = false;
    }

    public void loadPlugins(StringSeqHolder stringSeqHolder) {
        Object object;
        assert (this._communicator != null);
        Properties properties = this._communicator.getProperties();
        Map<String, String> map = properties.getPropertiesForPrefix("Ice.Plugin.");
        String[] stringArray = properties.getPropertyAsList("Ice.PluginLoadOrder");
        for (String string : stringArray) {
            Object object2;
            if (this.findPlugin(string) != null) {
                object = new PluginInitializationException();
                ((PluginInitializationException)object).reason = "plug-in `" + string + "' already loaded";
                throw object;
            }
            object = "Ice.Plugin." + string + ".java";
            boolean bl = map.containsKey(object);
            if (bl) {
                map.remove("Ice.Plugin." + string);
            } else {
                object = "Ice.Plugin." + string;
                bl = map.containsKey(object);
            }
            if (!bl) {
                object2 = new PluginInitializationException();
                ((PluginInitializationException)object2).reason = "plug-in `" + string + "' not defined";
                throw object2;
            }
            object2 = map.get(object);
            this.loadPlugin(string, (String)object2, stringSeqHolder);
            map.remove(object);
        }
        while (!map.isEmpty()) {
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            Map.Entry entry = (Map.Entry)iterator.next();
            String string = ((String)entry.getKey()).substring("Ice.Plugin.".length());
            int n = string.lastIndexOf(46);
            if (n != -1) {
                object = string.substring(n + 1);
                if (((String)object).equals("cpp") || ((String)object).equals("clr")) {
                    iterator.remove();
                } else if (((String)object).equals("java")) {
                    string = string.substring(0, n);
                    this.loadPlugin(string, (String)entry.getValue(), stringSeqHolder);
                    iterator.remove();
                    map.remove("Ice.Plugin." + string);
                } else {
                    n = -1;
                }
            }
            if (n != -1) continue;
            object = (String)entry.getValue();
            iterator.remove();
            String string2 = map.remove("Ice.Plugin." + string + ".java");
            if (string2 != null) {
                object = string2;
            }
            this.loadPlugin(string, (String)object, stringSeqHolder);
        }
    }

    private void loadPlugin(String string, String string2, StringSeqHolder stringSeqHolder) {
        Object object;
        Class<?> clazz;
        String string3;
        String[] stringArray;
        assert (this._communicator != null);
        try {
            stringArray = Options.split(string2);
        }
        catch (Options.BadQuote badQuote) {
            throw new PluginInitializationException("invalid arguments for plug-in `" + string + "':\n" + badQuote.getMessage());
        }
        assert (stringArray.length > 0);
        String string4 = stringArray[0];
        boolean bl = System.getProperty("os.name").startsWith("Windows");
        boolean bl2 = false;
        int n = string4.indexOf(58);
        if (bl) {
            if (n == 1 && string4.length() > 2 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(string4.charAt(0)) != -1 && (string4.charAt(2) == '\\' || string4.charAt(2) == '/')) {
                bl2 = true;
                n = string4.indexOf(58, n + 1);
            }
            if (!bl2) {
                bl2 = string4.startsWith("\\\\");
            }
        } else {
            bl2 = string4.startsWith("/");
        }
        if (n == -1 && bl2 || n != -1 && string4.length() <= n + 1) {
            throw new PluginInitializationException("invalid entry point for plug-in `" + string + "':\n" + string4);
        }
        String string5 = null;
        if (n == -1) {
            string3 = string4;
        } else {
            string5 = string4.substring(0, n).trim();
            string3 = string4.substring(n + 1).trim();
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        stringArray = stringArray2;
        Properties properties = this._communicator.getProperties();
        stringArray = properties.parseCommandLineOptions(string, stringArray);
        stringSeqHolder.value = properties.parseCommandLineOptions(string, (String[])stringSeqHolder.value);
        PluginFactory pluginFactory = null;
        try {
            clazz = null;
            if (string5 != null) {
                try {
                    if (!bl2) {
                        string5 = new File(System.getProperty("user.dir") + File.separator + string5).getCanonicalPath();
                    }
                    if (!string5.endsWith(File.separator) && !string5.toLowerCase().endsWith(".jar")) {
                        string5 = string5 + File.separator;
                    }
                    string5 = URLEncoder.encode(string5, "UTF-8");
                    object = null;
                    if (this._classLoaders == null) {
                        this._classLoaders = new HashMap<String, ClassLoader>();
                    } else {
                        object = this._classLoaders.get(string5);
                    }
                    if (object == null) {
                        URL[] uRLArray = new URL[]{new URL("file:///" + string5)};
                        object = this._instance.initializationData().classLoader != null ? new URLClassLoader(uRLArray, this._instance.initializationData().classLoader) : new URLClassLoader(uRLArray);
                        this._classLoaders.put(string5, (ClassLoader)object);
                    }
                    clazz = ((ClassLoader)object).loadClass(string3);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new PluginInitializationException("invalid entry point format `" + string2 + "'", malformedURLException);
                }
                catch (IOException iOException) {
                    throw new PluginInitializationException("invalid path in entry point `" + string2 + "'", iOException);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            } else {
                clazz = Util.getInstance(this._communicator).findClass(string3);
            }
            if (clazz == null) {
                throw new PluginInitializationException("class " + string3 + " not found");
            }
            object = clazz.newInstance();
            try {
                pluginFactory = (PluginFactory)object;
            }
            catch (ClassCastException classCastException) {
                throw new PluginInitializationException("class " + string3 + " does not implement Ice.PluginFactory", classCastException);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PluginInitializationException("unable to access default constructor in class " + string3, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new PluginInitializationException("unable to instantiate class " + string3, instantiationException);
        }
        clazz = null;
        try {
            clazz = pluginFactory.create(this._communicator, string, stringArray);
        }
        catch (PluginInitializationException pluginInitializationException) {
            throw pluginInitializationException;
        }
        catch (Throwable throwable) {
            throw new PluginInitializationException("exception in factory " + string3, throwable);
        }
        if (clazz == null) {
            throw new PluginInitializationException("failure in factory " + string3);
        }
        object = new PluginInfo();
        ((PluginInfo)object).name = string;
        ((PluginInfo)object).plugin = clazz;
        this._plugins.add((PluginInfo)object);
    }

    private Plugin findPlugin(String string) {
        for (PluginInfo pluginInfo : this._plugins) {
            if (!string.equals(pluginInfo.name)) continue;
            return pluginInfo.plugin;
        }
        return null;
    }

    static class PluginInfo {
        String name;
        Plugin plugin;

        PluginInfo() {
        }
    }
}

