/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.EncodingVersion;
import Ice.FormatType;
import Ice.MarshalException;
import Ice.Object;
import Ice.ObjectPrx;
import Ice.OptionalFormat;
import Ice.OutputStream;
import Ice.SlicedData;
import Ice.UserException;
import IceInternal.BasicStream;
import IceInternal.Buffer;
import IceInternal.Instance;
import IceInternal.Util;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class OutputStreamI
implements OutputStream {
    private Communicator _communicator;
    private BasicStream _os;

    public OutputStreamI(Communicator communicator) {
        this._communicator = communicator;
        Instance instance = Util.getInstance(communicator);
        this._os = new BasicStream(instance, instance.defaultsAndOverrides().defaultEncoding, false);
        this._os.closure(this);
    }

    public OutputStreamI(Communicator communicator, EncodingVersion encodingVersion) {
        this._communicator = communicator;
        Instance instance = Util.getInstance(communicator);
        this._os = new BasicStream(instance, encodingVersion, false);
        this._os.closure(this);
    }

    public OutputStreamI(Communicator communicator, BasicStream basicStream) {
        this._communicator = communicator;
        this._os = basicStream;
        this._os.closure(this);
    }

    @Override
    public Communicator communicator() {
        return this._communicator;
    }

    @Override
    public void writeBool(boolean bl) {
        this._os.writeBool(bl);
    }

    @Override
    public void writeBoolSeq(boolean[] blArray) {
        this._os.writeBoolSeq(blArray);
    }

    @Override
    public void writeByte(byte by) {
        this._os.writeByte(by);
    }

    @Override
    public void writeByteSeq(byte[] byArray) {
        this._os.writeByteSeq(byArray);
    }

    @Override
    public void writeByteBuffer(ByteBuffer byteBuffer) {
        this._os.writeByteBuffer(byteBuffer);
    }

    @Override
    public void writeSerializable(Serializable serializable) {
        this._os.writeSerializable(serializable);
    }

    @Override
    public void writeShort(short s) {
        this._os.writeShort(s);
    }

    @Override
    public void writeShortSeq(short[] sArray) {
        this._os.writeShortSeq(sArray);
    }

    @Override
    public void writeShortBuffer(ShortBuffer shortBuffer) {
        this._os.writeShortBuffer(shortBuffer);
    }

    @Override
    public void writeInt(int n) {
        this._os.writeInt(n);
    }

    @Override
    public void writeIntSeq(int[] nArray) {
        this._os.writeIntSeq(nArray);
    }

    @Override
    public void writeIntBuffer(IntBuffer intBuffer) {
        this._os.writeIntBuffer(intBuffer);
    }

    @Override
    public void writeLong(long l) {
        this._os.writeLong(l);
    }

    @Override
    public void writeLongSeq(long[] lArray) {
        this._os.writeLongSeq(lArray);
    }

    @Override
    public void writeLongBuffer(LongBuffer longBuffer) {
        this._os.writeLongBuffer(longBuffer);
    }

    @Override
    public void writeFloat(float f) {
        this._os.writeFloat(f);
    }

    @Override
    public void writeFloatSeq(float[] fArray) {
        this._os.writeFloatSeq(fArray);
    }

    @Override
    public void writeFloatBuffer(FloatBuffer floatBuffer) {
        this._os.writeFloatBuffer(floatBuffer);
    }

    @Override
    public void writeDouble(double d) {
        this._os.writeDouble(d);
    }

    @Override
    public void writeDoubleSeq(double[] dArray) {
        this._os.writeDoubleSeq(dArray);
    }

    @Override
    public void writeDoubleBuffer(DoubleBuffer doubleBuffer) {
        this._os.writeDoubleBuffer(doubleBuffer);
    }

    @Override
    public void writeString(String string) {
        this._os.writeString(string);
    }

    @Override
    public void writeStringSeq(String[] stringArray) {
        this._os.writeStringSeq(stringArray);
    }

    @Override
    public void writeSize(int n) {
        if (n < 0) {
            throw new MarshalException();
        }
        this._os.writeSize(n);
    }

    @Override
    public void writeProxy(ObjectPrx objectPrx) {
        this._os.writeProxy(objectPrx);
    }

    @Override
    public void writeObject(Object object) {
        this._os.writeObject(object);
    }

    @Override
    public void writeEnum(int n, int n2) {
        this._os.writeEnum(n, n2);
    }

    @Override
    public void writeException(UserException userException) {
        this._os.writeUserException(userException);
    }

    @Override
    public void startObject(SlicedData slicedData) {
        this._os.startWriteObject(slicedData);
    }

    @Override
    public void endObject() {
        this._os.endWriteObject();
    }

    @Override
    public void startException(SlicedData slicedData) {
        this._os.startWriteException(slicedData);
    }

    @Override
    public void endException() {
        this._os.endWriteException();
    }

    @Override
    public void startSlice(String string, int n, boolean bl) {
        this._os.startWriteSlice(string, n, bl);
    }

    @Override
    public void endSlice() {
        this._os.endWriteSlice();
    }

    @Override
    public void startEncapsulation(EncodingVersion encodingVersion, FormatType formatType) {
        this._os.startWriteEncaps(encodingVersion, formatType);
    }

    @Override
    public void startEncapsulation() {
        this._os.startWriteEncaps();
    }

    @Override
    public void endEncapsulation() {
        this._os.endWriteEncapsChecked();
    }

    @Override
    public EncodingVersion getEncoding() {
        return this._os.getWriteEncoding();
    }

    @Override
    public void writePendingObjects() {
        this._os.writePendingObjects();
    }

    @Override
    public boolean writeOptional(int n, OptionalFormat optionalFormat) {
        return this._os.writeOpt(n, optionalFormat);
    }

    @Override
    public int pos() {
        return this._os.pos();
    }

    @Override
    public void rewrite(int n, int n2) {
        this._os.rewriteInt(n, n2);
    }

    @Override
    public int startSize() {
        return this._os.startSize();
    }

    @Override
    public void endSize(int n) {
        this._os.endSize(n);
    }

    @Override
    public byte[] finished() {
        Buffer buffer = this._os.prepareWrite();
        byte[] byArray = new byte[buffer.b.limit()];
        buffer.b.get(byArray);
        return byArray;
    }

    @Override
    public void reset(boolean bl) {
        this._os.clear();
        Buffer buffer = this._os.getBuffer();
        if (bl) {
            buffer.clear();
        } else {
            buffer.reset();
        }
        buffer.b.position(0);
    }

    @Override
    public void destroy() {
        if (this._os != null) {
            this._os = null;
        }
    }
}

