/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.BooleanOptional;
import Ice.ByteOptional;
import Ice.DoubleOptional;
import Ice.FloatOptional;
import Ice.IntOptional;
import Ice.LongOptional;
import Ice.ShortOptional;

public class Optional<T> {
    private T _value;
    private boolean _isSet;

    public Optional() {
        this._isSet = false;
    }

    public Optional(T t) {
        this._value = t;
        this._isSet = true;
    }

    public Optional(Optional<T> optional) {
        this._value = optional._value;
        this._isSet = optional._isSet;
    }

    public T get() {
        if (!this._isSet) {
            throw new IllegalStateException("no value is set");
        }
        return this._value;
    }

    public void set(T t) {
        this._value = t;
        this._isSet = true;
    }

    public void set(Optional<T> optional) {
        this._value = optional._value;
        this._isSet = optional._isSet;
    }

    public boolean isSet() {
        return this._isSet;
    }

    public void clear() {
        this._isSet = false;
        this._value = null;
    }

    public static <T> Optional<T> O(T t) {
        return new Optional<T>(t);
    }

    public static BooleanOptional O(boolean bl) {
        return new BooleanOptional(bl);
    }

    public static ByteOptional O(byte by) {
        return new ByteOptional(by);
    }

    public static ShortOptional O(short s) {
        return new ShortOptional(s);
    }

    public static IntOptional O(int n) {
        return new IntOptional(n);
    }

    public static LongOptional O(long l) {
        return new LongOptional(l);
    }

    public static FloatOptional O(float f) {
        return new FloatOptional(f);
    }

    public static DoubleOptional O(double d) {
        return new DoubleOptional(d);
    }
}

