/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AdapterAlreadyActiveException;
import Ice.AdapterNotFoundException;
import Ice.AlreadyRegisteredException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.Endpoint;
import Ice.EndpointParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.IllegalServantException;
import Ice.InitializationException;
import Ice.InvalidReplicaGroupIdException;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.LocatorRegistryPrx;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterIdInUseException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.OperationInterruptedException;
import Ice.Properties;
import Ice.ProxyParseException;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.ServantLocator;
import IceInternal.ACMConfig;
import IceInternal.CommunicatorFlushBatch;
import IceInternal.EndpointI;
import IceInternal.IncomingConnectionFactory;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.ObjectAdapterFactory;
import IceInternal.PropertyNames;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceInternal.ServantManager;
import IceInternal.ThreadPool;
import IceInternal.TraceLevels;
import IceUtilInternal.Assert;
import IceUtilInternal.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ObjectAdapterI
implements ObjectAdapter {
    private static String[] _suffixes = new String[]{"ACM", "ACM.Timeout", "ACM.Heartbeat", "ACM.Close", "AdapterId", "Endpoints", "Locator", "Locator.EncodingVersion", "Locator.EndpointSelection", "Locator.ConnectionCached", "Locator.PreferSecure", "Locator.CollocationOptimized", "Locator.Router", "MessageSizeMax", "PublishedEndpoints", "ReplicaGroupId", "Router", "Router.EncodingVersion", "Router.EndpointSelection", "Router.ConnectionCached", "Router.PreferSecure", "Router.CollocationOptimized", "Router.Locator", "Router.Locator.EndpointSelection", "Router.Locator.ConnectionCached", "Router.Locator.PreferSecure", "Router.Locator.CollocationOptimized", "Router.Locator.LocatorCacheTimeout", "Router.Locator.InvocationTimeout", "Router.LocatorCacheTimeout", "Router.InvocationTimeout", "ProxyOptions", "ThreadPool.Size", "ThreadPool.SizeMax", "ThreadPool.SizeWarn", "ThreadPool.StackSize", "ThreadPool.Serialize"};
    private static final int StateUninitialized = 0;
    private static final int StateHeld = 1;
    private static final int StateActivating = 2;
    private static final int StateActive = 3;
    private static final int StateDeactivating = 4;
    private static final int StateDeactivated = 5;
    private static final int StateDestroying = 6;
    private static final int StateDestroyed = 7;
    private int _state = 0;
    private Instance _instance;
    private Communicator _communicator;
    private ObjectAdapterFactory _objectAdapterFactory;
    private ThreadPool _threadPool;
    private ACMConfig _acm;
    private ServantManager _servantManager;
    private final String _name;
    private final String _id;
    private final String _replicaGroupId;
    private Reference _reference;
    private List<IncomingConnectionFactory> _incomingConnectionFactories = new ArrayList<IncomingConnectionFactory>();
    private List<EndpointI> _routerEndpoints = new ArrayList<EndpointI>();
    private RouterInfo _routerInfo = null;
    private List<EndpointI> _publishedEndpoints = new ArrayList<EndpointI>();
    private LocatorInfo _locatorInfo;
    private int _directCount;
    private boolean _noConfig;
    private final int _messageSizeMax;

    @Override
    public String getName() {
        return this._noConfig ? "" : this._name;
    }

    @Override
    public Communicator getCommunicator() {
        return this._communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() {
        java.lang.Object object;
        LocatorInfo locatorInfo = null;
        boolean bl = false;
        java.lang.Object object2 = this;
        synchronized (object2) {
            this.checkForDeactivation();
            if (this._state != 0) {
                for (IncomingConnectionFactory incomingConnectionFactory : this._incomingConnectionFactories) {
                    incomingConnectionFactory.activate();
                }
                return;
            }
            this._state = 2;
            locatorInfo = this._locatorInfo;
            if (!this._noConfig) {
                object = this._instance.initializationData().properties;
                bl = object.getPropertyAsInt("Ice.PrintAdapterReady") > 0;
            }
        }
        try {
            object2 = new Identity();
            ((Identity)object2).name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy((Identity)object2));
        }
        catch (LocalException localException) {
            object = this;
            synchronized (object) {
                this._state = 0;
                this.notifyAll();
            }
            throw localException;
        }
        if (bl) {
            System.out.println(this._name + " ready");
        }
        object2 = this;
        synchronized (object2) {
            assert (this._state == 2);
            this._state = 3;
            this.notifyAll();
            for (IncomingConnectionFactory incomingConnectionFactory : this._incomingConnectionFactories) {
                incomingConnectionFactory.activate();
            }
        }
    }

    @Override
    public synchronized void hold() {
        this.checkForDeactivation();
        this._state = 1;
        for (IncomingConnectionFactory incomingConnectionFactory : this._incomingConnectionFactories) {
            incomingConnectionFactory.hold();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForHold() {
        ArrayList<IncomingConnectionFactory> arrayList;
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            arrayList = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
        }
        for (IncomingConnectionFactory incomingConnectionFactory : arrayList) {
            try {
                incomingConnectionFactory.waitUntilHolding();
            }
            catch (InterruptedException interruptedException) {
                throw new OperationInterruptedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        java.lang.Object object = this;
        synchronized (object) {
            while (this._state == 2) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationInterruptedException();
                }
            }
            if (this._state > 4) {
                return;
            }
            this._state = 4;
        }
        if (this._routerInfo != null) {
            this._instance.routerManager().erase(this._routerInfo.getRouter());
            this._routerInfo.setAdapter(null);
        }
        try {
            this.updateLocatorRegistry(this._locatorInfo, null);
        }
        catch (LocalException localException) {
            // empty catch block
        }
        for (IncomingConnectionFactory incomingConnectionFactory : this._incomingConnectionFactories) {
            incomingConnectionFactory.destroy();
        }
        this._instance.outgoingConnectionFactory().removeAdapter(this);
        object = this;
        synchronized (object) {
            this._state = 5;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForDeactivate() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        try {
            ArrayList<IncomingConnectionFactory> arrayList;
            ObjectAdapterI objectAdapterI = this;
            synchronized (objectAdapterI) {
                while (this._state < 5 || this._directCount > 0) {
                    this.wait();
                }
                if (this._state > 5) {
                    return;
                }
                arrayList = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
            }
            for (IncomingConnectionFactory incomingConnectionFactory : arrayList) {
                incomingConnectionFactory.waitUntilFinished();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new OperationInterruptedException();
        }
    }

    @Override
    public synchronized boolean isDeactivated() {
        return this._state >= 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        this.deactivate();
        this.waitForDeactivate();
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            assert (this._state >= 5);
            while (this._state == 6) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationInterruptedException();
                }
            }
            if (this._state == 7) {
                return;
            }
            this._state = 6;
        }
        this._servantManager.destroy();
        if (this._threadPool != null) {
            this._threadPool.destroy();
            try {
                this._threadPool.joinWithAllThreads();
            }
            catch (InterruptedException interruptedException) {
                throw new OperationInterruptedException();
            }
        }
        this._objectAdapterFactory.removeObjectAdapter(this);
        objectAdapterI = this;
        synchronized (objectAdapterI) {
            this._incomingConnectionFactories.clear();
            this._instance = null;
            this._threadPool = null;
            this._routerEndpoints = null;
            this._routerInfo = null;
            this._publishedEndpoints = null;
            this._locatorInfo = null;
            this._reference = null;
            this._objectAdapterFactory = null;
            this._state = 7;
            this.notifyAll();
        }
    }

    @Override
    public ObjectPrx add(Object object, Identity identity) {
        return this.addFacet(object, identity, "");
    }

    @Override
    public synchronized ObjectPrx addFacet(Object object, Identity identity, String string) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(identity);
        ObjectAdapterI.checkServant(object);
        Identity identity2 = new Identity();
        identity2.category = identity.category;
        identity2.name = identity.name;
        this._servantManager.addServant(object, identity2, string);
        return this.newProxy(identity2, string);
    }

    @Override
    public ObjectPrx addWithUUID(Object object) {
        return this.addFacetWithUUID(object, "");
    }

    @Override
    public ObjectPrx addFacetWithUUID(Object object, String string) {
        Identity identity = new Identity();
        identity.category = "";
        identity.name = UUID.randomUUID().toString();
        return this.addFacet(object, identity, string);
    }

    @Override
    public synchronized void addDefaultServant(Object object, String string) {
        ObjectAdapterI.checkServant(object);
        this.checkForDeactivation();
        this._servantManager.addDefaultServant(object, string);
    }

    @Override
    public Object remove(Identity identity) {
        return this.removeFacet(identity, "");
    }

    @Override
    public synchronized Object removeFacet(Identity identity, String string) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(identity);
        return this._servantManager.removeServant(identity, string);
    }

    @Override
    public synchronized Map<String, Object> removeAllFacets(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(identity);
        return this._servantManager.removeAllFacets(identity);
    }

    @Override
    public synchronized Object removeDefaultServant(String string) {
        this.checkForDeactivation();
        return this._servantManager.removeDefaultServant(string);
    }

    @Override
    public Object find(Identity identity) {
        return this.findFacet(identity, "");
    }

    @Override
    public synchronized Object findFacet(Identity identity, String string) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(identity);
        return this._servantManager.findServant(identity, string);
    }

    @Override
    public synchronized Map<String, Object> findAllFacets(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(identity);
        return this._servantManager.findAllFacets(identity);
    }

    @Override
    public synchronized Object findByProxy(ObjectPrx objectPrx) {
        this.checkForDeactivation();
        Reference reference = ((ObjectPrxHelperBase)objectPrx).__reference();
        return this.findFacet(reference.getIdentity(), reference.getFacet());
    }

    @Override
    public synchronized Object findDefaultServant(String string) {
        this.checkForDeactivation();
        return this._servantManager.findDefaultServant(string);
    }

    @Override
    public synchronized void addServantLocator(ServantLocator servantLocator, String string) {
        this.checkForDeactivation();
        this._servantManager.addServantLocator(servantLocator, string);
    }

    @Override
    public synchronized ServantLocator removeServantLocator(String string) {
        this.checkForDeactivation();
        return this._servantManager.removeServantLocator(string);
    }

    @Override
    public synchronized ServantLocator findServantLocator(String string) {
        this.checkForDeactivation();
        return this._servantManager.findServantLocator(string);
    }

    @Override
    public synchronized ObjectPrx createProxy(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(identity);
        return this.newProxy(identity, "");
    }

    @Override
    public synchronized ObjectPrx createDirectProxy(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(identity);
        return this.newDirectProxy(identity, "");
    }

    @Override
    public synchronized ObjectPrx createIndirectProxy(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(identity);
        return this.newIndirectProxy(identity, "", this._id);
    }

    @Override
    public synchronized void setLocator(LocatorPrx locatorPrx) {
        this.checkForDeactivation();
        this._locatorInfo = this._instance.locatorManager().get(locatorPrx);
    }

    @Override
    public synchronized LocatorPrx getLocator() {
        if (this._locatorInfo == null) {
            return null;
        }
        return this._locatorInfo.getLocator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshPublishedEndpoints() {
        List<EndpointI> list;
        LocatorInfo locatorInfo = null;
        java.lang.Object object = this;
        synchronized (object) {
            this.checkForDeactivation();
            list = this._publishedEndpoints;
            this._publishedEndpoints = this.parsePublishedEndpoints();
            locatorInfo = this._locatorInfo;
        }
        try {
            object = new Identity();
            ((Identity)object).name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy((Identity)object));
        }
        catch (LocalException localException) {
            ObjectAdapterI objectAdapterI = this;
            synchronized (objectAdapterI) {
                this._publishedEndpoints = list;
                throw localException;
            }
        }
    }

    @Override
    public synchronized Endpoint[] getEndpoints() {
        ArrayList<EndpointI> arrayList = new ArrayList<EndpointI>();
        for (IncomingConnectionFactory incomingConnectionFactory : this._incomingConnectionFactories) {
            arrayList.add(incomingConnectionFactory.endpoint());
        }
        return arrayList.toArray(new Endpoint[0]);
    }

    @Override
    public synchronized Endpoint[] getPublishedEndpoints() {
        return this._publishedEndpoints.toArray(new Endpoint[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(ObjectPrx objectPrx) {
        Reference reference = ((ObjectPrxHelperBase)objectPrx).__reference();
        if (reference.isWellKnown()) {
            return this._servantManager.hasServant(reference.getIdentity());
        }
        if (reference.isIndirect()) {
            return reference.getAdapterId().equals(this._id) || reference.getAdapterId().equals(this._replicaGroupId);
        }
        EndpointI[] endpointIArray = reference.getEndpoints();
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            for (EndpointI endpointI : endpointIArray) {
                for (EndpointI endpointI2 : this._publishedEndpoints) {
                    if (!endpointI.equivalent(endpointI2)) continue;
                    return true;
                }
                for (IncomingConnectionFactory incomingConnectionFactory : this._incomingConnectionFactories) {
                    if (!endpointI.equivalent(incomingConnectionFactory.endpoint())) continue;
                    return true;
                }
            }
            if (this._routerInfo != null && this._routerInfo.getRouter().equals(objectPrx.ice_getRouter())) {
                for (EndpointI endpointI : endpointIArray) {
                    for (EndpointI endpointI3 : this._routerEndpoints) {
                        if (!endpointI.equivalent(endpointI3)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAsyncBatchRequests(CommunicatorFlushBatch communicatorFlushBatch) {
        ArrayList<IncomingConnectionFactory> arrayList;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            arrayList = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
        }
        for (IncomingConnectionFactory incomingConnectionFactory : arrayList) {
            incomingConnectionFactory.flushAsyncBatchRequests(communicatorFlushBatch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionObservers() {
        ArrayList<IncomingConnectionFactory> arrayList;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            arrayList = new ArrayList<IncomingConnectionFactory>(this._incomingConnectionFactories);
        }
        for (IncomingConnectionFactory incomingConnectionFactory : arrayList) {
            incomingConnectionFactory.updateConnectionObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThreadObservers() {
        ThreadPool threadPool = null;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            threadPool = this._threadPool;
        }
        if (threadPool != null) {
            threadPool.updateObservers();
        }
    }

    public synchronized void incDirectCount() {
        this.checkForDeactivation();
        assert (this._directCount >= 0);
        ++this._directCount;
    }

    public synchronized void decDirectCount() {
        assert (this._instance != null);
        assert (this._directCount > 0);
        if (--this._directCount == 0) {
            this.notifyAll();
        }
    }

    public ThreadPool getThreadPool() {
        assert (this._instance != null);
        if (this._threadPool != null) {
            return this._threadPool;
        }
        return this._instance.serverThreadPool();
    }

    public ServantManager getServantManager() {
        return this._servantManager;
    }

    public ACMConfig getACM() {
        assert (this._instance != null);
        return this._acm;
    }

    public int messageSizeMax() {
        return this._messageSizeMax;
    }

    public ObjectAdapterI(Instance instance, Communicator communicator, ObjectAdapterFactory objectAdapterFactory, String string, RouterPrx routerPrx, boolean bl) {
        java.lang.Object object;
        this._instance = instance;
        this._communicator = communicator;
        this._objectAdapterFactory = objectAdapterFactory;
        this._servantManager = new ServantManager(instance, string);
        this._name = string;
        this._directCount = 0;
        this._noConfig = bl;
        if (this._noConfig) {
            this._id = "";
            this._replicaGroupId = "";
            this._reference = this._instance.referenceFactory().create("dummy -t", "");
            this._acm = this._instance.serverACM();
            this._messageSizeMax = this._instance.messageSizeMax();
            return;
        }
        Properties properties = this._instance.initializationData().properties;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = this.filterProperties(arrayList);
        if (arrayList.size() != 0 && properties.getPropertyAsIntWithDefault("Ice.Warn.UnknownProperties", 1) > 0) {
            object = new StringBuffer("found unknown properties for object adapter `");
            ((StringBuffer)object).append(this._name);
            ((StringBuffer)object).append("':");
            for (String object2 : arrayList) {
                ((StringBuffer)object).append("\n    ");
                ((StringBuffer)object).append(object2);
            }
            this._instance.initializationData().logger.warning(((StringBuffer)object).toString());
        }
        if (routerPrx == null && bl2) {
            this._state = 7;
            this._instance = null;
            this._incomingConnectionFactories = null;
            object = new InitializationException();
            ((InitializationException)object).reason = "object adapter `" + this._name + "' requires configuration";
            throw object;
        }
        this._id = properties.getProperty(this._name + ".AdapterId");
        this._replicaGroupId = properties.getProperty(this._name + ".ReplicaGroupId");
        object = properties.getPropertyWithDefault(this._name + ".ProxyOptions", "-t");
        try {
            this._reference = this._instance.referenceFactory().create("dummy " + (String)object, "");
        }
        catch (ProxyParseException proxyParseException) {
            InitializationException n2 = new InitializationException();
            n2.reason = "invalid proxy options `" + (String)object + "' for object adapter `" + this._name + "'";
            throw n2;
        }
        this._acm = new ACMConfig(properties, communicator.getLogger(), this._name + ".ACM", instance.serverACM());
        int n = instance.messageSizeMax() / 1024;
        int n2 = properties.getPropertyAsIntWithDefault(this._name + ".MessageSizeMax", n);
        this._messageSizeMax = n2 < 1 || n2 > 0x1FFFFF ? Integer.MAX_VALUE : n2 * 1024;
        try {
            n = properties.getPropertyAsInt(this._name + ".ThreadPool.Size");
            int n3 = properties.getPropertyAsInt(this._name + ".ThreadPool.SizeMax");
            if (n > 0 || n3 > 0) {
                this._threadPool = new ThreadPool(this._instance, this._name + ".ThreadPool", 0);
            }
            if (routerPrx == null) {
                routerPrx = RouterPrxHelper.uncheckedCast(this._instance.proxyFactory().propertyToProxy(string + ".Router"));
            }
            if (routerPrx != null) {
                this._routerInfo = this._instance.routerManager().get(routerPrx);
                if (this._routerInfo != null) {
                    EndpointI[] endpointIArray;
                    if (this._routerInfo.getAdapter() != null) {
                        throw new AlreadyRegisteredException("object adapter with router", this._instance.identityToString(routerPrx.ice_getIdentity()));
                    }
                    for (EndpointI endpointI : endpointIArray = this._routerInfo.getServerEndpoints()) {
                        this._routerEndpoints.add(endpointI);
                    }
                    Collections.sort(this._routerEndpoints);
                    int n4 = 0;
                    while (n4 < this._routerEndpoints.size() - 1) {
                        EndpointI endpointI;
                        EndpointI endpointI2 = this._routerEndpoints.get(n4);
                        if (endpointI2.equals(endpointI = this._routerEndpoints.get(n4 + 1))) {
                            this._routerEndpoints.remove(n4);
                            continue;
                        }
                        ++n4;
                    }
                    this._routerInfo.setAdapter(this);
                    this._instance.outgoingConnectionFactory().setRouterInfo(this._routerInfo);
                }
            } else {
                List<EndpointI> list = this.parseEndpoints(properties.getProperty(this._name + ".Endpoints"), true);
                for (EndpointI endpointI : list) {
                    IncomingConnectionFactory incomingConnectionFactory = new IncomingConnectionFactory(instance, endpointI, this);
                    this._incomingConnectionFactories.add(incomingConnectionFactory);
                }
                if (list.size() == 0) {
                    TraceLevels traceLevels = this._instance.traceLevels();
                    if (traceLevels.network >= 2) {
                        this._instance.initializationData().logger.trace(traceLevels.networkCat, "created adapter `" + string + "' without endpoints");
                    }
                }
                this._publishedEndpoints = this.parsePublishedEndpoints();
            }
            if (properties.getProperty(this._name + ".Locator").length() > 0) {
                this.setLocator(LocatorPrxHelper.uncheckedCast(this._instance.proxyFactory().propertyToProxy(this._name + ".Locator")));
            } else {
                this.setLocator(this._instance.referenceFactory().getDefaultLocator());
            }
        }
        catch (LocalException localException) {
            this.destroy();
            throw localException;
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            if (this._state < 5) {
                this._instance.initializationData().logger.warning("object adapter `" + this.getName() + "' has not been deactivated");
            } else if (this._state != 7) {
                this._instance.initializationData().logger.warning("object adapter `" + this.getName() + "' has not been destroyed");
            } else {
                Assert.FinalizerAssert(this._threadPool == null);
                Assert.FinalizerAssert(this._directCount == 0);
            }
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private ObjectPrx newProxy(Identity identity, String string) {
        if (this._id.length() == 0) {
            return this.newDirectProxy(identity, string);
        }
        if (this._replicaGroupId.length() == 0) {
            return this.newIndirectProxy(identity, string, this._id);
        }
        return this.newIndirectProxy(identity, string, this._replicaGroupId);
    }

    private ObjectPrx newDirectProxy(Identity identity, String string) {
        int n = this._publishedEndpoints.size();
        EndpointI[] endpointIArray = new EndpointI[n + this._routerEndpoints.size()];
        this._publishedEndpoints.toArray(endpointIArray);
        for (int i = 0; i < this._routerEndpoints.size(); ++i) {
            endpointIArray[n + i] = this._routerEndpoints.get(i);
        }
        Reference reference = this._instance.referenceFactory().create(identity, string, this._reference, endpointIArray);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    private ObjectPrx newIndirectProxy(Identity identity, String string, String string2) {
        Reference reference = this._instance.referenceFactory().create(identity, string, this._reference, string2);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    private void checkForDeactivation() {
        if (this._state >= 4) {
            ObjectAdapterDeactivatedException objectAdapterDeactivatedException = new ObjectAdapterDeactivatedException();
            objectAdapterDeactivatedException.name = this.getName();
            throw objectAdapterDeactivatedException;
        }
    }

    private static void checkIdentity(Identity identity) {
        if (identity.name == null || identity.name.length() == 0) {
            throw new IllegalIdentityException(identity);
        }
        if (identity.category == null) {
            identity.category = "";
        }
    }

    private static void checkServant(Object object) {
        if (object == null) {
            throw new IllegalServantException("cannot add null servant to Object Adapter");
        }
    }

    private List<EndpointI> parseEndpoints(String string, boolean bl) {
        int n;
        int n2 = 0;
        ArrayList<EndpointI> arrayList = new ArrayList<EndpointI>();
        while (n2 < string.length() && (n = StringUtil.findFirstNotOf(string, " \t\n\r", n2)) != -1) {
            n2 = n;
            while (true) {
                if ((n2 = string.indexOf(58, n2)) == -1) {
                    n2 = string.length();
                    break;
                }
                boolean bl2 = false;
                int n3 = n;
                while ((n3 = string.indexOf(34, n3)) != -1 && n2 >= n3) {
                    ++n3;
                    if ((n3 = string.indexOf(34, n3)) == -1) break;
                    if (n2 < n3) {
                        bl2 = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl2) break;
                ++n2;
            }
            if (n2 == n) {
                ++n2;
                continue;
            }
            String string2 = string.substring(n, n2);
            EndpointI endpointI = this._instance.endpointFactoryManager().create(string2, bl);
            if (endpointI == null) {
                EndpointParseException endpointParseException = new EndpointParseException();
                endpointParseException.str = "invalid object adapter endpoint `" + string2 + "'";
                throw endpointParseException;
            }
            arrayList.add(endpointI);
            ++n2;
        }
        return arrayList;
    }

    private List<EndpointI> parsePublishedEndpoints() {
        String string = this._instance.initializationData().properties.getProperty(this._name + ".PublishedEndpoints");
        List<EndpointI> list = this.parseEndpoints(string, false);
        if (list.isEmpty()) {
            for (IncomingConnectionFactory incomingConnectionFactory : this._incomingConnectionFactories) {
                list.addAll(incomingConnectionFactory.endpoint().expand());
            }
        }
        if (this._instance.traceLevels().network >= 1 && !list.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer("published endpoints for object adapter `");
            stringBuffer.append(this._name);
            stringBuffer.append("':\n");
            boolean bl = true;
            for (EndpointI endpointI : list) {
                if (!bl) {
                    stringBuffer.append(":");
                }
                stringBuffer.append(endpointI.toString());
                bl = false;
            }
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
        }
        return list;
    }

    private void updateLocatorRegistry(LocatorInfo locatorInfo, ObjectPrx objectPrx) {
        if (this._id.length() == 0 || locatorInfo == null) {
            return;
        }
        LocatorRegistryPrx locatorRegistryPrx = locatorInfo.getLocatorRegistry();
        if (locatorRegistryPrx == null) {
            return;
        }
        try {
            if (this._replicaGroupId.length() == 0) {
                locatorRegistryPrx.setAdapterDirectProxy(this._id, objectPrx);
            } else {
                locatorRegistryPrx.setReplicatedAdapterDirectProxy(this._id, this._replicaGroupId, objectPrx);
            }
        }
        catch (AdapterNotFoundException adapterNotFoundException) {
            Serializable serializable;
            if (this._instance.traceLevels().location >= 1) {
                serializable = new StringBuilder(128);
                ((StringBuilder)serializable).append("couldn't update object adapter `");
                ((StringBuilder)serializable).append(this._id);
                ((StringBuilder)serializable).append("' endpoints with the locator registry:\n");
                ((StringBuilder)serializable).append("the object adapter is not known to the locator registry");
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, ((StringBuilder)serializable).toString());
            }
            serializable = new NotRegisteredException();
            ((NotRegisteredException)serializable).kindOfObject = "object adapter";
            ((NotRegisteredException)serializable).id = this._id;
            throw serializable;
        }
        catch (InvalidReplicaGroupIdException invalidReplicaGroupIdException) {
            Serializable serializable;
            if (this._instance.traceLevels().location >= 1) {
                serializable = new StringBuilder(128);
                ((StringBuilder)serializable).append("couldn't update object adapter `");
                ((StringBuilder)serializable).append(this._id);
                ((StringBuilder)serializable).append("' endpoints with the locator registry:\n");
                ((StringBuilder)serializable).append("the replica group `");
                ((StringBuilder)serializable).append(this._replicaGroupId);
                ((StringBuilder)serializable).append("' is not known to the locator registry");
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, ((StringBuilder)serializable).toString());
            }
            serializable = new NotRegisteredException();
            ((NotRegisteredException)serializable).kindOfObject = "replica group";
            ((NotRegisteredException)serializable).id = this._replicaGroupId;
            throw serializable;
        }
        catch (AdapterAlreadyActiveException adapterAlreadyActiveException) {
            Serializable serializable;
            if (this._instance.traceLevels().location >= 1) {
                serializable = new StringBuilder(128);
                ((StringBuilder)serializable).append("couldn't update object adapter `");
                ((StringBuilder)serializable).append(this._id);
                ((StringBuilder)serializable).append("' endpoints with the locator registry:\n");
                ((StringBuilder)serializable).append("the object adapter endpoints are already set");
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, ((StringBuilder)serializable).toString());
            }
            serializable = new ObjectAdapterIdInUseException();
            ((ObjectAdapterIdInUseException)serializable).id = this._id;
            throw serializable;
        }
        catch (ObjectAdapterDeactivatedException objectAdapterDeactivatedException) {
        }
        catch (CommunicatorDestroyedException communicatorDestroyedException) {
        }
        catch (LocalException localException) {
            if (this._instance.traceLevels().location >= 1) {
                StringBuilder stringBuilder = new StringBuilder(128);
                stringBuilder.append("couldn't update object adapter `");
                stringBuilder.append(this._id);
                stringBuilder.append("' endpoints with the locator registry:\n");
                stringBuilder.append(localException.toString());
                this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, stringBuilder.toString());
            }
            throw localException;
        }
        if (this._instance.traceLevels().location >= 1) {
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("updated object adapter `");
            stringBuilder.append(this._id);
            stringBuilder.append("' endpoints with the locator registry\n");
            stringBuilder.append("endpoints = ");
            if (objectPrx != null) {
                Endpoint[] endpointArray = objectPrx.ice_getEndpoints();
                for (int i = 0; i < endpointArray.length; ++i) {
                    stringBuilder.append(endpointArray[i].toString());
                    if (i + 1 >= endpointArray.length) continue;
                    stringBuilder.append(":");
                }
            }
            this._instance.initializationData().logger.trace(this._instance.traceLevels().locationCat, stringBuilder.toString());
        }
    }

    boolean filterProperties(List<String> list) {
        boolean bl = true;
        String string = this._name + ".";
        boolean bl2 = false;
        while (PropertyNames.clPropNames[bl2] != null) {
            if (string.startsWith(PropertyNames.clPropNames[bl2] + ".")) {
                bl = false;
                break;
            }
            bl2 += 1;
        }
        bl2 = true;
        Map<String, String> map = this._instance.initializationData().properties.getPropertiesForPrefix(string);
        for (String string2 : map.keySet()) {
            boolean bl3 = false;
            for (String string3 : _suffixes) {
                if (!string2.equals(string + string3)) continue;
                bl2 = false;
                bl3 = true;
                break;
            }
            if (bl3 || !bl) continue;
            list.add(string2);
        }
        return bl2;
    }
}

