/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.InitializationException;
import Ice.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LoggerI
implements Logger {
    String _prefix = "";
    String _formattedPrefix = "";
    String _file = "";
    String _lineSeparator;
    DateFormat _date;
    SimpleDateFormat _time;
    FileOutputStream _out = null;

    public LoggerI(String string, String string2) {
        this._prefix = string;
        if (string.length() > 0) {
            this._formattedPrefix = string + ": ";
        }
        this._lineSeparator = System.getProperty("line.separator");
        this._date = DateFormat.getDateInstance(3);
        this._time = new SimpleDateFormat(" HH:mm:ss:SSS");
        if (string2.length() != 0) {
            this._file = string2;
            try {
                this._out = new FileOutputStream(new File(this._file), true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InitializationException("FileLogger: cannot open " + this._file);
            }
        }
    }

    @Override
    public void print(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(string);
        this.write(stringBuilder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("-- ");
        LoggerI loggerI = this;
        synchronized (loggerI) {
            stringBuilder.append(this._date.format(new Date()));
            stringBuilder.append(this._time.format(new Date()));
        }
        stringBuilder.append(' ');
        stringBuilder.append(this._formattedPrefix);
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(string2);
        this.write(stringBuilder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warning(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("-! ");
        LoggerI loggerI = this;
        synchronized (loggerI) {
            stringBuilder.append(this._date.format(new Date()));
            stringBuilder.append(this._time.format(new Date()));
        }
        stringBuilder.append(' ');
        stringBuilder.append(this._formattedPrefix);
        stringBuilder.append("warning: ");
        stringBuilder.append(Thread.currentThread().getName());
        stringBuilder.append(": ");
        stringBuilder.append(string);
        this.write(stringBuilder, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(String string) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("!! ");
        LoggerI loggerI = this;
        synchronized (loggerI) {
            stringBuilder.append(this._date.format(new Date()));
            stringBuilder.append(this._time.format(new Date()));
        }
        stringBuilder.append(' ');
        stringBuilder.append(this._formattedPrefix);
        stringBuilder.append("error: ");
        stringBuilder.append(Thread.currentThread().getName());
        stringBuilder.append(": ");
        stringBuilder.append(string);
        this.write(stringBuilder, true);
    }

    @Override
    public String getPrefix() {
        return this._prefix;
    }

    @Override
    public Logger cloneWithPrefix(String string) {
        return new LoggerI(string, this._file);
    }

    private void write(StringBuilder stringBuilder, boolean bl) {
        if (bl) {
            int n = 0;
            while ((n = stringBuilder.indexOf("\n", n)) != -1) {
                stringBuilder.insert(n + 1, "   ");
                ++n;
            }
        }
        stringBuilder.append(this._lineSeparator);
        if (this._out == null) {
            System.err.print(stringBuilder.toString());
        } else {
            try {
                this._out.write(stringBuilder.toString().getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

