/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.ContextHelper;
import Ice.ImplicitContext;
import Ice.InitializationException;
import IceInternal.BasicStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ImplicitContextI
implements ImplicitContext {
    public static ImplicitContextI create(String string) {
        if (string.equals("None") || string.equals("")) {
            return null;
        }
        if (string.equals("Shared")) {
            return new Shared();
        }
        if (string.equals("PerThread")) {
            return new PerThread();
        }
        throw new InitializationException("'" + string + "' is not a valid value for Ice.ImplicitContext");
    }

    public abstract void write(Map<String, String> var1, BasicStream var2);

    abstract Map<String, String> combine(Map<String, String> var1);

    static class PerThread
    extends ImplicitContextI {
        private Map<Thread, Map<String, String>> _map = Collections.synchronizedMap(new HashMap());

        PerThread() {
        }

        @Override
        public Map<String, String> getContext() {
            Map<String, String> map = this._map.get(Thread.currentThread());
            if (map == null) {
                map = new HashMap<String, String>();
            }
            return map;
        }

        @Override
        public void setContext(Map<String, String> map) {
            if (map == null || map.isEmpty()) {
                this._map.remove(Thread.currentThread());
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>(map);
                this._map.put(Thread.currentThread(), hashMap);
            }
        }

        @Override
        public boolean containsKey(String string) {
            Map<String, String> map;
            if (string == null) {
                string = "";
            }
            if ((map = this._map.get(Thread.currentThread())) == null) {
                return false;
            }
            return map.containsKey(string);
        }

        @Override
        public String get(String string) {
            Map<String, String> map;
            if (string == null) {
                string = "";
            }
            if ((map = this._map.get(Thread.currentThread())) == null) {
                return "";
            }
            String string2 = map.get(string);
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @Override
        public String put(String string, String string2) {
            String string3;
            Thread thread;
            Map<String, String> map;
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if ((map = this._map.get(thread = Thread.currentThread())) == null) {
                map = new HashMap<String, String>();
                this._map.put(thread, map);
            }
            if ((string3 = map.put(string, string2)) == null) {
                string3 = "";
            }
            return string3;
        }

        @Override
        public String remove(String string) {
            Map<String, String> map;
            if (string == null) {
                string = "";
            }
            if ((map = this._map.get(Thread.currentThread())) == null) {
                return null;
            }
            String string2 = map.remove(string);
            if (string2 == null) {
                string2 = "";
            }
            return string2;
        }

        @Override
        public void write(Map<String, String> map, BasicStream basicStream) {
            Map<String, String> map2 = this._map.get(Thread.currentThread());
            if (map2 == null || map2.isEmpty()) {
                ContextHelper.write(basicStream, map);
            } else if (map.isEmpty()) {
                ContextHelper.write(basicStream, map2);
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>(map2);
                hashMap.putAll(map);
                ContextHelper.write(basicStream, hashMap);
            }
        }

        @Override
        Map<String, String> combine(Map<String, String> map) {
            Map<String, String> map2 = this._map.get(Thread.currentThread());
            HashMap<String, String> hashMap = new HashMap<String, String>(map2);
            hashMap.putAll(map);
            return hashMap;
        }
    }

    static class Shared
    extends ImplicitContextI {
        private Map<String, String> _context = new HashMap<String, String>();

        Shared() {
        }

        @Override
        public synchronized Map<String, String> getContext() {
            return new HashMap<String, String>(this._context);
        }

        @Override
        public synchronized void setContext(Map<String, String> map) {
            this._context.clear();
            if (map != null && !map.isEmpty()) {
                this._context.putAll(map);
            }
        }

        @Override
        public synchronized boolean containsKey(String string) {
            if (string == null) {
                string = "";
            }
            return this._context.containsKey(string);
        }

        @Override
        public synchronized String get(String string) {
            String string2;
            if (string == null) {
                string = "";
            }
            if ((string2 = this._context.get(string)) == null) {
                string2 = "";
            }
            return string2;
        }

        @Override
        public synchronized String put(String string, String string2) {
            String string3;
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if ((string3 = this._context.put(string, string2)) == null) {
                string3 = "";
            }
            return string3;
        }

        @Override
        public synchronized String remove(String string) {
            String string2;
            if (string == null) {
                string = "";
            }
            if ((string2 = this._context.remove(string)) == null) {
                string2 = "";
            }
            return string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(Map<String, String> map, BasicStream basicStream) {
            if (map.isEmpty()) {
                Shared shared = this;
                synchronized (shared) {
                    ContextHelper.write(basicStream, this._context);
                }
            }
            Map<String, String> map2 = null;
            Shared shared = this;
            synchronized (shared) {
                map2 = this._context.isEmpty() ? map : this.combine(map);
            }
            ContextHelper.write(basicStream, map2);
        }

        @Override
        synchronized Map<String, String> combine(Map<String, String> map) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this._context);
            hashMap.putAll(map);
            return hashMap;
        }
    }
}

