/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.ACM;
import Ice.ACMClose;
import Ice.ACMHeartbeat;
import Ice.AsyncResult;
import Ice.BadMagicException;
import Ice.Callback;
import Ice.Callback_Connection_flushBatchRequests;
import Ice.CloseConnectionException;
import Ice.CloseTimeoutException;
import Ice.Communicator;
import Ice.CommunicatorDestroyedException;
import Ice.ConnectTimeoutException;
import Ice.Connection;
import Ice.ConnectionCallback;
import Ice.ConnectionInfo;
import Ice.ConnectionLostException;
import Ice.ConnectionNotValidatedException;
import Ice.ConnectionTimeoutException;
import Ice.DatagramLimitException;
import Ice.EncodingVersion;
import Ice.Endpoint;
import Ice.Exception;
import Ice.FeatureNotSupportedException;
import Ice.ForcedCloseConnectionException;
import Ice.Identity;
import Ice.IllegalMessageSizeException;
import Ice.InitializationData;
import Ice.Instrumentation.ConnectionObserver;
import Ice.Instrumentation.ConnectionState;
import Ice.IntOptional;
import Ice.LocalException;
import Ice.Logger;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterI;
import Ice.ObjectPrx;
import Ice.OperationInterruptedException;
import Ice.Optional;
import Ice.ProtocolVersion;
import Ice.SocketException;
import Ice.SyscallException;
import Ice.SystemException;
import Ice.TimeoutException;
import Ice.UnknownException;
import Ice.UnknownMessageException;
import Ice.UnmarshalOutOfBoundsException;
import IceInternal.ACMConfig;
import IceInternal.ACMMonitor;
import IceInternal.BasicStream;
import IceInternal.BatchRequestQueue;
import IceInternal.Buffer;
import IceInternal.CallbackBase;
import IceInternal.CancellationHandler;
import IceInternal.ConnectionFlushBatch;
import IceInternal.Connector;
import IceInternal.DefaultsAndOverrides;
import IceInternal.DispatchWorkItem;
import IceInternal.EndpointI;
import IceInternal.EventHandler;
import IceInternal.Ex;
import IceInternal.Functional_BoolCallback;
import IceInternal.Functional_CallbackBase;
import IceInternal.Functional_GenericCallback1;
import IceInternal.Functional_VoidCallback;
import IceInternal.Incoming;
import IceInternal.Instance;
import IceInternal.OutgoingAsync;
import IceInternal.OutgoingAsyncBase;
import IceInternal.Protocol;
import IceInternal.ResponseHandler;
import IceInternal.RetryException;
import IceInternal.ServantError;
import IceInternal.ServantManager;
import IceInternal.ThreadPool;
import IceInternal.ThreadPoolCurrent;
import IceInternal.Time;
import IceInternal.TraceLevels;
import IceInternal.TraceUtil;
import IceInternal.Transceiver;
import IceUtilInternal.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.channels.SelectableChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ConnectionI
extends EventHandler
implements Connection,
ResponseHandler,
CancellationHandler {
    public static final int ObjectAdapterDeactivated = 0;
    public static final int CommunicatorDestroyed = 1;
    private static final String __flushBatchRequests_name = "flushBatchRequests";
    private static final int StateNotInitialized = 0;
    private static final int StateNotValidated = 1;
    private static final int StateActive = 2;
    private static final int StateHolding = 3;
    private static final int StateClosing = 4;
    private static final int StateClosingPending = 5;
    private static final int StateClosed = 6;
    private static final int StateFinished = 7;
    private Communicator _communicator;
    private final Instance _instance;
    private ACMMonitor _monitor;
    private final Transceiver _transceiver;
    private String _desc;
    private final String _type;
    private final Connector _connector;
    private final EndpointI _endpoint;
    private ObjectAdapter _adapter;
    private ServantManager _servantManager;
    private final boolean _dispatcher;
    private final Logger _logger;
    private final TraceLevels _traceLevels;
    private final ThreadPool _threadPool;
    private final ScheduledExecutorService _timer;
    private final Runnable _writeTimeout;
    private Future<?> _writeTimeoutFuture;
    private final Runnable _readTimeout;
    private Future<?> _readTimeoutFuture;
    private StartCallback _startCallback = null;
    private final boolean _warn;
    private final boolean _warnUdp;
    private long _acmLastActivity;
    private final int _compressionLevel;
    private int _nextRequestId;
    private Map<Integer, OutgoingAsyncBase> _asyncRequests = new HashMap<Integer, OutgoingAsyncBase>();
    private LocalException _exception;
    private final int _messageSizeMax;
    private BatchRequestQueue _batchRequestQueue;
    private LinkedList<OutgoingMessage> _sendStreams = new LinkedList();
    private BasicStream _readStream;
    private boolean _readHeader;
    private BasicStream _writeStream;
    private ConnectionObserver _observer;
    private int _readStreamPos;
    private int _writeStreamPos;
    private int _dispatchCount;
    private int _state;
    private boolean _shutdownInitiated = false;
    private boolean _initialized = false;
    private boolean _validated = false;
    private Incoming _incomingCache;
    private final Object _incomingCacheMutex = new Object();
    private ProtocolVersion _readProtocol = new ProtocolVersion();
    private EncodingVersion _readProtocolEncoding = new EncodingVersion();
    private int _cacheBuffers;
    private ConnectionInfo _info;
    private ConnectionCallback _callback;
    private static ConnectionState[] connectionStateMap = new ConnectionState[]{ConnectionState.ConnectionStateValidating, ConnectionState.ConnectionStateValidating, ConnectionState.ConnectionStateActive, ConnectionState.ConnectionStateHolding, ConnectionState.ConnectionStateClosing, ConnectionState.ConnectionStateClosing, ConnectionState.ConnectionStateClosed, ConnectionState.ConnectionStateClosed};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartCallback startCallback) {
        try {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                if (this._state >= 6) {
                    assert (this._exception != null);
                    throw (LocalException)this._exception.fillInStackTrace();
                }
                if (!this.initialize(0) || !this.validate(0)) {
                    this._startCallback = startCallback;
                    return;
                }
                this.setState(3);
            }
        }
        catch (LocalException localException) {
            this.exception(localException);
            startCallback.connectionStartFailed(this, this._exception);
            return;
        }
        startCallback.connectionStartCompleted(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAndWait() throws InterruptedException {
        try {
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                if (this._state >= 6) {
                    assert (this._exception != null);
                    throw (LocalException)this._exception.fillInStackTrace();
                }
                if (!this.initialize(0) || !this.validate(0)) {
                    while (this._state <= 1) {
                        this.wait();
                    }
                    if (this._state >= 4) {
                        assert (this._exception != null);
                        throw (LocalException)this._exception.fillInStackTrace();
                    }
                }
                this.setState(3);
            }
        }
        catch (LocalException localException) {
            this.exception(localException);
            this.waitUntilFinished();
        }
    }

    public synchronized void activate() {
        if (this._state <= 1) {
            return;
        }
        if (this._acmLastActivity > 0L) {
            this._acmLastActivity = Time.currentMonotonicTimeMillis();
        }
        this.setState(2);
    }

    public synchronized void hold() {
        if (this._state <= 1) {
            return;
        }
        this.setState(3);
    }

    public synchronized void destroy(int n) {
        switch (n) {
            case 0: {
                this.setState(4, new ObjectAdapterDeactivatedException());
                break;
            }
            case 1: {
                this.setState(4, new CommunicatorDestroyedException());
            }
        }
    }

    @Override
    public synchronized void close(boolean bl) {
        if (Thread.interrupted()) {
            throw new OperationInterruptedException();
        }
        if (bl) {
            this.setState(6, new ForcedCloseConnectionException());
        } else {
            while (!this._asyncRequests.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new OperationInterruptedException();
                }
            }
            this.setState(4, new CloseConnectionException());
        }
    }

    public synchronized boolean isActiveOrHolding() {
        return this._state > 1 && this._state < 4;
    }

    public synchronized boolean isFinished() {
        if (this._state != 7 || this._dispatchCount != 0) {
            return false;
        }
        assert (this._state == 7);
        return true;
    }

    public synchronized void throwException() {
        if (this._exception != null) {
            assert (this._state >= 4);
            throw (LocalException)this._exception.fillInStackTrace();
        }
    }

    public synchronized void waitUntilHolding() throws InterruptedException {
        while (this._state < 3 || this._dispatchCount > 0) {
            this.wait();
        }
    }

    public synchronized void waitUntilFinished() throws InterruptedException {
        while (this._state < 7 || this._dispatchCount > 0) {
            this.wait();
        }
        assert (this._state == 7);
        this._adapter = null;
    }

    public synchronized void updateObserver() {
        if (this._state < 1 || this._state > 6) {
            return;
        }
        assert (this._instance.initializationData().observer != null);
        this._observer = this._instance.initializationData().observer.getConnectionObserver(this.initConnectionInfo(), this._endpoint, this.toConnectionState(this._state), this._observer);
        if (this._observer != null) {
            this._observer.attach();
        } else {
            this._writeStreamPos = -1;
            this._readStreamPos = -1;
        }
    }

    public synchronized void monitor(long l, ACMConfig aCMConfig) {
        if (this._state != 2) {
            return;
        }
        if ((aCMConfig.heartbeat == ACMHeartbeat.HeartbeatAlways || aCMConfig.heartbeat != ACMHeartbeat.HeartbeatOff && this._writeStream.isEmpty() && l >= this._acmLastActivity + (long)(aCMConfig.timeout / 4)) && (aCMConfig.heartbeat != ACMHeartbeat.HeartbeatOnInvocation || this._dispatchCount > 0)) {
            this.heartbeat();
        }
        if (this._readStream.size() > 14 || !this._writeStream.isEmpty()) {
            return;
        }
        if (aCMConfig.close != ACMClose.CloseOff && l >= this._acmLastActivity + (long)aCMConfig.timeout) {
            if (aCMConfig.close == ACMClose.CloseOnIdleForceful || aCMConfig.close != ACMClose.CloseOnIdle && !this._asyncRequests.isEmpty()) {
                this.setState(6, new ConnectionTimeoutException());
            } else if (aCMConfig.close != ACMClose.CloseOnInvocation && this._dispatchCount == 0 && this._batchRequestQueue.isEmpty() && this._asyncRequests.isEmpty()) {
                this.setState(4, new ConnectionTimeoutException());
            }
        }
    }

    public synchronized int sendAsyncRequest(OutgoingAsyncBase outgoingAsyncBase, boolean bl, boolean bl2, int n) throws RetryException {
        int n2;
        BasicStream basicStream = outgoingAsyncBase.getOs();
        if (this._exception != null) {
            throw new RetryException((LocalException)this._exception.fillInStackTrace());
        }
        assert (this._state > 1);
        assert (this._state < 4);
        this._transceiver.checkSendSize(basicStream.getBuffer());
        outgoingAsyncBase.cancelable(this);
        int n3 = 0;
        if (bl2) {
            if ((n3 = this._nextRequestId++) <= 0) {
                this._nextRequestId = 1;
                n3 = this._nextRequestId++;
            }
            basicStream.pos(14);
            basicStream.writeInt(n3);
        } else if (n > 0) {
            basicStream.pos(14);
            basicStream.writeInt(n);
        }
        outgoingAsyncBase.attachRemoteObserver(this.initConnectionInfo(), this._endpoint, n3);
        try {
            n2 = this.sendMessage(new OutgoingMessage(outgoingAsyncBase, basicStream, bl, n3));
        }
        catch (LocalException localException) {
            this.setState(6, localException);
            assert (this._exception != null);
            throw (LocalException)this._exception.fillInStackTrace();
        }
        if (bl2) {
            this._asyncRequests.put(n3, outgoingAsyncBase);
        }
        return n2;
    }

    public BatchRequestQueue getBatchRequestQueue() {
        return this._batchRequestQueue;
    }

    @Override
    public void flushBatchRequests() {
        this.end_flushBatchRequests(this.begin_flushBatchRequests());
    }

    @Override
    public AsyncResult begin_flushBatchRequests() {
        return this.begin_flushBatchRequestsInternal(null);
    }

    @Override
    public AsyncResult begin_flushBatchRequests(Callback callback) {
        return this.begin_flushBatchRequestsInternal(callback);
    }

    @Override
    public AsyncResult begin_flushBatchRequests(Callback_Connection_flushBatchRequests callback_Connection_flushBatchRequests) {
        return this.begin_flushBatchRequestsInternal(callback_Connection_flushBatchRequests);
    }

    @Override
    public AsyncResult begin_flushBatchRequests(Functional_VoidCallback functional_VoidCallback, Functional_GenericCallback1<Exception> functional_GenericCallback1, Functional_BoolCallback functional_BoolCallback) {
        return this.begin_flushBatchRequestsInternal(new Functional_CallbackBase(false, functional_GenericCallback1, functional_BoolCallback){

            @Override
            public final void __completed(AsyncResult asyncResult) {
                try {
                    asyncResult.getConnection().end_flushBatchRequests(asyncResult);
                }
                catch (Exception exception) {
                    this.__exceptionCb.apply(exception);
                }
            }
        });
    }

    private AsyncResult begin_flushBatchRequestsInternal(CallbackBase callbackBase) {
        ConnectionFlushBatch connectionFlushBatch = new ConnectionFlushBatch(this, this._communicator, this._instance, __flushBatchRequests_name, callbackBase);
        connectionFlushBatch.invoke();
        return connectionFlushBatch;
    }

    @Override
    public void end_flushBatchRequests(AsyncResult asyncResult) {
        ConnectionFlushBatch connectionFlushBatch = ConnectionFlushBatch.check(asyncResult, this, __flushBatchRequests_name);
        connectionFlushBatch.__wait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setCallback(final ConnectionCallback connectionCallback) {
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            if (this._state >= 6) {
                if (connectionCallback != null) {
                    this._threadPool.dispatch(new DispatchWorkItem(this){

                        @Override
                        public void run() {
                            try {
                                connectionCallback.closed(ConnectionI.this);
                            }
                            catch (Exception exception) {
                                ConnectionI.this._logger.error("connection callback exception:\n" + exception + '\n' + ConnectionI.this._desc);
                            }
                        }
                    });
                }
            } else {
                this._callback = connectionCallback;
            }
        }
    }

    @Override
    public synchronized void setACM(IntOptional intOptional, Optional<ACMClose> optional, Optional<ACMHeartbeat> optional2) {
        if (this._monitor == null || this._state >= 6) {
            return;
        }
        if (this._state == 2) {
            this._monitor.remove(this);
        }
        this._monitor = this._monitor.acm(intOptional, optional, optional2);
        if (this._monitor.getACM().timeout <= 0) {
            this._acmLastActivity = -1L;
        } else if (this._state == 2 && this._acmLastActivity == -1L) {
            this._acmLastActivity = Time.currentMonotonicTimeMillis();
        }
        if (this._state == 2) {
            this._monitor.add(this);
        }
    }

    @Override
    public synchronized ACM getACM() {
        return this._monitor != null ? this._monitor.getACM() : new ACM(0, ACMClose.CloseOff, ACMHeartbeat.HeartbeatOff);
    }

    @Override
    public synchronized void asyncRequestCanceled(OutgoingAsyncBase outgoingAsyncBase, LocalException localException) {
        Object object;
        if (this._state >= 6) {
            return;
        }
        Iterator iterator = this._sendStreams.iterator();
        while (iterator.hasNext()) {
            object = (OutgoingMessage)iterator.next();
            if (((OutgoingMessage)object).outAsync != outgoingAsyncBase) continue;
            if (((OutgoingMessage)object).requestId > 0) {
                this._asyncRequests.remove(((OutgoingMessage)object).requestId);
            }
            if (localException instanceof ConnectionTimeoutException) {
                this.setState(6, localException);
            } else {
                ((OutgoingMessage)object).canceled();
                if (object != this._sendStreams.getFirst()) {
                    iterator.remove();
                }
                if (outgoingAsyncBase.completed(localException)) {
                    outgoingAsyncBase.invokeCompletedAsync();
                }
            }
            return;
        }
        if (outgoingAsyncBase instanceof OutgoingAsync) {
            object = (OutgoingAsync)outgoingAsyncBase;
            Iterator<OutgoingAsyncBase> iterator2 = this._asyncRequests.values().iterator();
            while (iterator2.hasNext()) {
                if (iterator2.next() != object) continue;
                if (localException instanceof ConnectionTimeoutException) {
                    this.setState(6, localException);
                } else {
                    iterator2.remove();
                    if (outgoingAsyncBase.completed(localException)) {
                        outgoingAsyncBase.invokeCompletedAsync();
                    }
                }
                return;
            }
        }
    }

    @Override
    public synchronized void sendResponse(int n, BasicStream basicStream, byte by, boolean bl) {
        assert (this._state > 1);
        try {
            if (--this._dispatchCount == 0) {
                if (this._state == 7) {
                    this.reap();
                }
                this.notifyAll();
            }
            if (this._state >= 6) {
                assert (this._exception != null);
                throw (LocalException)this._exception.fillInStackTrace();
            }
            this.sendMessage(new OutgoingMessage(basicStream, by != 0, true));
            if (this._state == 4 && this._dispatchCount == 0) {
                this.initiateShutdown();
            }
        }
        catch (LocalException localException) {
            this.setState(6, localException);
        }
    }

    @Override
    public synchronized void sendNoResponse() {
        assert (this._state > 1);
        try {
            if (--this._dispatchCount == 0) {
                if (this._state == 7) {
                    this.reap();
                }
                this.notifyAll();
            }
            if (this._state >= 6) {
                assert (this._exception != null);
                throw (LocalException)this._exception.fillInStackTrace();
            }
            if (this._state == 4 && this._dispatchCount == 0) {
                this.initiateShutdown();
            }
        }
        catch (LocalException localException) {
            this.setState(6, localException);
        }
    }

    @Override
    public boolean systemException(int n, SystemException systemException, boolean bl) {
        return false;
    }

    @Override
    public synchronized void invokeException(int n, LocalException localException, int n2, boolean bl) {
        this.setState(6, localException);
        if (n2 > 0) {
            assert (this._dispatchCount > 0);
            this._dispatchCount -= n2;
            assert (this._dispatchCount >= 0);
            if (this._dispatchCount == 0) {
                if (this._state == 7) {
                    this.reap();
                }
                this.notifyAll();
            }
        }
    }

    public EndpointI endpoint() {
        return this._endpoint;
    }

    public Connector connector() {
        return this._connector;
    }

    @Override
    public synchronized void setAdapter(ObjectAdapter objectAdapter) {
        if (this._state <= 1 || this._state >= 4) {
            return;
        }
        this._adapter = objectAdapter;
        if (this._adapter != null) {
            this._servantManager = ((ObjectAdapterI)this._adapter).getServantManager();
            if (this._servantManager == null) {
                this._adapter = null;
            }
        } else {
            this._servantManager = null;
        }
    }

    @Override
    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    @Override
    public Endpoint getEndpoint() {
        return this._endpoint;
    }

    @Override
    public ObjectPrx createProxy(Identity identity) {
        return this._instance.proxyFactory().referenceToProxy(this._instance.referenceFactory().create(identity, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void message(ThreadPoolCurrent threadPoolCurrent) {
        StartCallback startCallback = null;
        LinkedList<OutgoingMessage> linkedList = null;
        MessageInfo messageInfo = null;
        int n = 0;
        Object object = this;
        synchronized (object) {
            if (this._state >= 6) {
                return;
            }
            if (!threadPoolCurrent.ioReady()) {
                return;
            }
            int n2 = threadPoolCurrent.operation;
            try {
                Buffer buffer;
                this.unscheduleTimeout(threadPoolCurrent.operation);
                int n3 = 0;
                int n4 = 0;
                if ((n2 & 4) != 0) {
                    buffer = this._writeStream.getBuffer();
                    if (this._observer != null) {
                        this.observerStartWrite(buffer);
                    }
                    n3 = this.write(buffer);
                    if (this._observer != null && (n3 & 4) == 0) {
                        this.observerFinishWrite(buffer);
                    }
                }
                while ((n2 & 1) != 0) {
                    buffer = this._readStream.getBuffer();
                    if (this._observer != null && !this._readHeader) {
                        this.observerStartRead(buffer);
                    }
                    if (((n4 = this.read(buffer)) & 1) != 0) break;
                    if (this._observer != null && !this._readHeader) {
                        assert (!buffer.b.hasRemaining());
                        this.observerFinishRead(buffer);
                    }
                    if (this._readHeader) {
                        int n5;
                        this._readHeader = false;
                        if (this._observer != null) {
                            this._observer.receivedBytes(14);
                        }
                        if ((n5 = this._readStream.pos()) < 14) {
                            throw new IllegalMessageSizeException();
                        }
                        this._readStream.pos(0);
                        byte[] byArray = new byte[]{this._readStream.readByte(), this._readStream.readByte(), this._readStream.readByte(), this._readStream.readByte()};
                        if (byArray[0] != Protocol.magic[0] || byArray[1] != Protocol.magic[1] || byArray[2] != Protocol.magic[2] || byArray[3] != Protocol.magic[3]) {
                            BadMagicException badMagicException = new BadMagicException();
                            badMagicException.badMagic = byArray;
                            throw badMagicException;
                        }
                        this._readProtocol.__read(this._readStream);
                        Protocol.checkSupportedProtocol(this._readProtocol);
                        this._readProtocolEncoding.__read(this._readStream);
                        Protocol.checkSupportedProtocolEncoding(this._readProtocolEncoding);
                        this._readStream.readByte();
                        this._readStream.readByte();
                        int n6 = this._readStream.readInt();
                        if (n6 < 14) {
                            throw new IllegalMessageSizeException();
                        }
                        if (n6 > this._messageSizeMax) {
                            Ex.throwMemoryLimitException(n6, this._messageSizeMax);
                        }
                        if (n6 > this._readStream.size()) {
                            this._readStream.resize(n6, true);
                        }
                        this._readStream.pos(n5);
                    }
                    if (this._readStream.pos() == this._readStream.size()) break;
                    if (!this._endpoint.datagram()) continue;
                    throw new DatagramLimitException();
                }
                int n7 = n4 | n3;
                assert ((n2 &= ~n7) != 0 || n7 != 0);
                if (this._state <= 1) {
                    if (n7 != 0) {
                        this.scheduleTimeout(n7);
                        this._threadPool.update(this, threadPoolCurrent.operation, n7);
                        return;
                    }
                    if (this._state == 0 && !this.initialize(threadPoolCurrent.operation)) {
                        return;
                    }
                    if (this._state <= 1 && !this.validate(threadPoolCurrent.operation)) {
                        return;
                    }
                    this._threadPool.unregister(this, threadPoolCurrent.operation);
                    this.setState(3);
                    if (this._startCallback != null) {
                        startCallback = this._startCallback;
                        this._startCallback = null;
                        if (startCallback != null) {
                            ++n;
                        }
                    }
                } else {
                    assert (this._state <= 5);
                    if ((n2 & 1) != 0) {
                        messageInfo = new MessageInfo(threadPoolCurrent.stream);
                        n7 |= this.parseMessage(messageInfo);
                        n += messageInfo.messageDispatchCount;
                    }
                    if ((n2 & 4) != 0) {
                        linkedList = new LinkedList<OutgoingMessage>();
                        n7 |= this.sendNextMessage(linkedList);
                        if (!linkedList.isEmpty()) {
                            ++n;
                        } else {
                            linkedList = null;
                        }
                    }
                    if (this._state < 6) {
                        this.scheduleTimeout(n7);
                        this._threadPool.update(this, threadPoolCurrent.operation, n7);
                    }
                }
                if (this._acmLastActivity > 0L) {
                    this._acmLastActivity = Time.currentMonotonicTimeMillis();
                }
                if (n == 0) {
                    return;
                }
                this._dispatchCount += n;
                threadPoolCurrent.ioCompleted();
            }
            catch (DatagramLimitException datagramLimitException) {
                if (this._warnUdp) {
                    this._logger.warning("maximum datagram size of " + this._readStream.pos() + " exceeded");
                }
                this._readStream.resize(14, true);
                this._readStream.pos(0);
                this._readHeader = true;
                return;
            }
            catch (SocketException socketException) {
                this.setState(6, socketException);
                return;
            }
            catch (LocalException localException) {
                if (this._endpoint.datagram()) {
                    if (this._warn) {
                        String string = "datagram connection exception:\n" + localException + '\n' + this._desc;
                        this._logger.warning(string);
                    }
                    this._readStream.resize(14, true);
                    this._readStream.pos(0);
                    this._readHeader = true;
                } else {
                    this.setState(6, localException);
                }
                return;
            }
        }
        if (!this._dispatcher) {
            this.dispatch(startCallback, linkedList, messageInfo);
        } else {
            if (messageInfo != null && messageInfo.heartbeatCallback == null) {
                assert (messageInfo.stream == threadPoolCurrent.stream);
                object = messageInfo.stream;
                messageInfo.stream = new BasicStream(this._instance, Protocol.currentProtocolEncoding);
                messageInfo.stream.swap((BasicStream)object);
            }
            object = startCallback;
            LinkedList<OutgoingMessage> linkedList2 = linkedList;
            MessageInfo messageInfo2 = messageInfo;
            this._threadPool.dispatchFromThisThread(new DispatchWorkItem(this, (StartCallback)object, linkedList2, messageInfo2){
                final /* synthetic */ StartCallback val$finalStartCB;
                final /* synthetic */ List val$finalSentCBs;
                final /* synthetic */ MessageInfo val$finalInfo;
                {
                    this.val$finalStartCB = startCallback;
                    this.val$finalSentCBs = list;
                    this.val$finalInfo = messageInfo;
                    super(connection);
                }

                @Override
                public void run() {
                    ConnectionI.this.dispatch(this.val$finalStartCB, this.val$finalSentCBs, this.val$finalInfo);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(StartCallback startCallback, List<OutgoingMessage> list, MessageInfo messageInfo) {
        int n = 0;
        if (startCallback != null) {
            startCallback.connectionStartCompleted(this);
            ++n;
        }
        if (list != null) {
            for (OutgoingMessage object : list) {
                object.outAsync.invokeSent();
            }
            ++n;
        }
        if (messageInfo != null) {
            if (messageInfo.outAsync != null) {
                messageInfo.outAsync.invokeCompleted();
                ++n;
            }
            if (messageInfo.heartbeatCallback != null) {
                try {
                    messageInfo.heartbeatCallback.heartbeat(this);
                }
                catch (Exception exception) {
                    this._logger.error("connection callback exception:\n" + exception + '\n' + this._desc);
                }
                ++n;
            }
            if (messageInfo.invokeNum > 0) {
                this.invokeAll(messageInfo.stream, messageInfo.invokeNum, messageInfo.requestId, messageInfo.compress, messageInfo.servantManager, messageInfo.adapter);
            }
        }
        if (n > 0) {
            boolean bl = false;
            ConnectionI connectionI = this;
            synchronized (connectionI) {
                this._dispatchCount -= n;
                if (this._dispatchCount == 0) {
                    if (this._state == 4) {
                        if (this._instance.queueRequests()) {
                            bl = true;
                        } else {
                            try {
                                this.initiateShutdown();
                            }
                            catch (LocalException localException) {
                                this.setState(6, localException);
                            }
                        }
                    } else if (this._state == 7) {
                        this.reap();
                    }
                    if (!bl) {
                        this.notifyAll();
                    }
                }
            }
            if (bl) {
                this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        ConnectionI connectionI = ConnectionI.this;
                        synchronized (connectionI) {
                            try {
                                ConnectionI.this.initiateShutdown();
                            }
                            catch (LocalException localException) {
                                ConnectionI.this.setState(6, localException);
                            }
                            ConnectionI.this.notifyAll();
                        }
                        return null;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(ThreadPoolCurrent threadPoolCurrent, final boolean bl) {
        ConnectionI connectionI = this;
        synchronized (connectionI) {
            assert (this._state == 6);
            this.unscheduleTimeout(5);
        }
        if (this._startCallback == null && this._sendStreams.isEmpty() && this._asyncRequests.isEmpty() && this._callback == null) {
            this.finish(bl);
            return;
        }
        threadPoolCurrent.ioCompleted();
        if (!this._dispatcher) {
            this.finish(bl);
        } else {
            this._threadPool.dispatchFromThisThread(new DispatchWorkItem(this){

                @Override
                public void run() {
                    ConnectionI.this.finish(bl);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(boolean bl) {
        Object object;
        if (!this._initialized) {
            if (this._instance.traceLevels().network >= 2) {
                object = new StringBuffer("failed to ");
                ((StringBuffer)object).append(this._connector != null ? "establish" : "accept");
                ((StringBuffer)object).append(" ");
                ((StringBuffer)object).append(this._endpoint.protocol());
                ((StringBuffer)object).append(" connection\n");
                ((StringBuffer)object).append(this.toString());
                ((StringBuffer)object).append("\n");
                ((StringBuffer)object).append(this._exception);
                this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, ((StringBuffer)object).toString());
            }
        } else if (this._instance.traceLevels().network >= 1) {
            object = new StringBuffer("closed ");
            ((StringBuffer)object).append(this._endpoint.protocol());
            ((StringBuffer)object).append(" connection\n");
            ((StringBuffer)object).append(this.toString());
            if (!(this._exception instanceof CloseConnectionException || this._exception instanceof ForcedCloseConnectionException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException)) {
                ((StringBuffer)object).append("\n");
                ((StringBuffer)object).append(this._exception);
            }
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, ((StringBuffer)object).toString());
        }
        if (bl) {
            this._transceiver.close();
        }
        if (this._startCallback != null) {
            if (this._instance.queueRequests()) {
                this._instance.getQueueExecutor().executeNoThrow(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ConnectionI.this._startCallback.connectionStartFailed(ConnectionI.this, ConnectionI.this._exception);
                        return null;
                    }
                });
            } else {
                this._startCallback.connectionStartFailed(this, this._exception);
            }
            this._startCallback = null;
        }
        if (!this._sendStreams.isEmpty()) {
            if (!this._writeStream.isEmpty()) {
                object = this._sendStreams.getFirst();
                this._writeStream.swap(((OutgoingMessage)object).stream);
            }
            for (OutgoingMessage object2 : this._sendStreams) {
                object2.completed(this._exception);
                if (object2.requestId <= 0) continue;
                this._asyncRequests.remove(object2.requestId);
            }
            this._sendStreams.clear();
        }
        for (OutgoingAsyncBase outgoingAsyncBase : this._asyncRequests.values()) {
            if (!outgoingAsyncBase.completed(this._exception)) continue;
            outgoingAsyncBase.invokeCompleted();
        }
        this._asyncRequests.clear();
        this._writeStream.clear();
        this._writeStream.getBuffer().clear();
        this._readStream.clear();
        this._readStream.getBuffer().clear();
        if (this._callback != null) {
            try {
                this._callback.closed(this);
            }
            catch (Exception exception) {
                this._logger.error("connection callback exception:\n" + exception + '\n' + this._desc);
            }
            this._callback = null;
        }
        object = this;
        synchronized (object) {
            this.setState(7);
            if (this._dispatchCount == 0) {
                this.reap();
            }
        }
    }

    @Override
    public String toString() {
        return this._toString();
    }

    @Override
    public SelectableChannel fd() {
        return this._transceiver.fd();
    }

    public synchronized void timedOut() {
        if (this._state <= 1) {
            this.setState(6, new ConnectTimeoutException());
        } else if (this._state < 4) {
            this.setState(6, new TimeoutException());
        } else if (this._state < 6) {
            this.setState(6, new CloseTimeoutException());
        }
    }

    @Override
    public String type() {
        return this._type;
    }

    @Override
    public int timeout() {
        return this._endpoint.timeout();
    }

    @Override
    public synchronized ConnectionInfo getInfo() {
        if (this._state >= 6) {
            throw (LocalException)this._exception.fillInStackTrace();
        }
        return this.initConnectionInfo();
    }

    @Override
    public synchronized void setBufferSize(int n, int n2) {
        if (this._state >= 6) {
            throw (LocalException)this._exception.fillInStackTrace();
        }
        this._transceiver.setBufferSize(n, n2);
        this._info = null;
    }

    @Override
    public String _toString() {
        return this._desc;
    }

    public synchronized void exception(LocalException localException) {
        this.setState(6, localException);
    }

    public ConnectionI(Communicator communicator, Instance instance, ACMMonitor aCMMonitor, Transceiver transceiver, Connector connector, EndpointI endpointI, ObjectAdapterI objectAdapterI) {
        this._communicator = communicator;
        this._instance = instance;
        this._monitor = aCMMonitor;
        this._transceiver = transceiver;
        this._desc = transceiver.toString();
        this._type = transceiver.protocol();
        this._connector = connector;
        this._endpoint = endpointI;
        this._adapter = objectAdapterI;
        InitializationData initializationData = instance.initializationData();
        this._dispatcher = initializationData.dispatcher != null;
        this._logger = initializationData.logger;
        this._traceLevels = instance.traceLevels();
        this._timer = instance.timer();
        this._writeTimeout = new TimeoutCallback();
        this._writeTimeoutFuture = null;
        this._readTimeout = new TimeoutCallback();
        this._readTimeoutFuture = null;
        this._warn = initializationData.properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
        this._warnUdp = instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Datagrams") > 0;
        this._cacheBuffers = instance.cacheMessageBuffers();
        this._acmLastActivity = this._monitor != null && this._monitor.getACM().timeout > 0 ? Time.currentMonotonicTimeMillis() : -1L;
        this._nextRequestId = 1;
        this._messageSizeMax = objectAdapterI != null ? objectAdapterI.messageSizeMax() : instance.messageSizeMax();
        this._batchRequestQueue = new BatchRequestQueue(instance, this._endpoint.datagram());
        this._readStream = new BasicStream(instance, Protocol.currentProtocolEncoding);
        this._readHeader = false;
        this._readStreamPos = -1;
        this._writeStream = new BasicStream(instance, Protocol.currentProtocolEncoding);
        this._writeStreamPos = -1;
        this._dispatchCount = 0;
        this._state = 0;
        int n = initializationData.properties.getPropertyAsIntWithDefault("Ice.Compression.Level", 1);
        if (n < 1) {
            n = 1;
        } else if (n > 9) {
            n = 9;
        }
        this._compressionLevel = n;
        this._servantManager = objectAdapterI != null ? objectAdapterI.getServantManager() : null;
        try {
            this._threadPool = objectAdapterI != null ? objectAdapterI.getThreadPool() : this._instance.clientThreadPool();
            this._threadPool.initialize(this);
        }
        catch (LocalException localException) {
            throw localException;
        }
        catch (java.lang.Exception exception) {
            throw new SyscallException(exception);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._startCallback == null);
            Assert.FinalizerAssert(this._state == 7);
            Assert.FinalizerAssert(this._dispatchCount == 0);
            Assert.FinalizerAssert(this._sendStreams.isEmpty());
            Assert.FinalizerAssert(this._asyncRequests.isEmpty());
        }
        catch (java.lang.Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    private void setState(int n, LocalException localException) {
        assert (n >= 4);
        if (this._state == n) {
            return;
        }
        if (this._exception == null) {
            assert (this._state != 6);
            this._exception = localException;
            if (!(!this._warn || !this._validated || this._exception instanceof CloseConnectionException || this._exception instanceof ForcedCloseConnectionException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException || this._exception instanceof ConnectionLostException && this._state >= 4)) {
                this.warning("connection exception", this._exception);
            }
        }
        this.setState(n);
    }

    private void setState(int n) {
        Object object;
        if (this._endpoint.datagram() && n == 4) {
            n = 6;
        }
        if (this._state <= 1 && n == 4) {
            n = 6;
        }
        if (this._state == n) {
            return;
        }
        try {
            switch (n) {
                case 0: {
                    assert (false);
                    break;
                }
                case 1: {
                    if (this._state == 0) break;
                    assert (this._state == 6);
                    return;
                }
                case 2: {
                    if (this._state != 3 && this._state != 1) {
                        return;
                    }
                    this._threadPool.register(this, 1);
                    break;
                }
                case 3: {
                    if (this._state != 2 && this._state != 1) {
                        return;
                    }
                    if (this._state != 2) break;
                    this._threadPool.unregister(this, 1);
                    break;
                }
                case 4: 
                case 5: {
                    if (this._state < 5) break;
                    return;
                }
                case 6: {
                    if (this._state == 7) {
                        return;
                    }
                    this._batchRequestQueue.destroy(this._exception);
                    if (!this._threadPool.finish(this, false)) break;
                    this._transceiver.close();
                    break;
                }
                case 7: {
                    assert (this._state == 6);
                    this._communicator = null;
                }
            }
        }
        catch (LocalException localException) {
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            localException.printStackTrace(printWriter);
            printWriter.flush();
            String string = "unexpected connection exception:\n " + this._desc + "\n" + ((StringWriter)object).toString();
            this._instance.initializationData().logger.error(string);
        }
        if (this._monitor != null) {
            if (n == 2) {
                if (this._acmLastActivity > 0L) {
                    this._acmLastActivity = Time.currentMonotonicTimeMillis();
                }
                this._monitor.add(this);
            } else if (this._state == 2) {
                this._monitor.remove(this);
            }
        }
        if (this._instance.initializationData().observer != null) {
            ConnectionState connectionState = this.toConnectionState(this._state);
            if (connectionState != (object = this.toConnectionState(n))) {
                this._observer = this._instance.initializationData().observer.getConnectionObserver(this.initConnectionInfo(), this._endpoint, (ConnectionState)((Object)object), this._observer);
                if (this._observer != null) {
                    this._observer.attach();
                } else {
                    this._writeStreamPos = -1;
                    this._readStreamPos = -1;
                }
            }
            if (!(this._observer == null || n != 6 || this._exception == null || this._exception instanceof CloseConnectionException || this._exception instanceof ForcedCloseConnectionException || this._exception instanceof ConnectionTimeoutException || this._exception instanceof CommunicatorDestroyedException || this._exception instanceof ObjectAdapterDeactivatedException || this._exception instanceof ConnectionLostException && this._state >= 4)) {
                this._observer.failed(this._exception.ice_name());
            }
        }
        this._state = n;
        this.notifyAll();
        if (this._state == 4 && this._dispatchCount == 0) {
            try {
                this.initiateShutdown();
            }
            catch (LocalException localException) {
                this.setState(6, localException);
            }
        }
    }

    private void initiateShutdown() {
        assert (this._state == 4);
        assert (this._dispatchCount == 0);
        if (this._shutdownInitiated) {
            return;
        }
        this._shutdownInitiated = true;
        if (!this._endpoint.datagram()) {
            BasicStream basicStream = new BasicStream(this._instance, Protocol.currentProtocolEncoding);
            basicStream.writeBlob(Protocol.magic);
            Protocol.currentProtocol.__write(basicStream);
            Protocol.currentProtocolEncoding.__write(basicStream);
            basicStream.writeByte((byte)4);
            basicStream.writeByte((byte)0);
            basicStream.writeInt(14);
            if ((this.sendMessage(new OutgoingMessage(basicStream, false, false)) & 1) > 0) {
                this.setState(5);
                int n = this._transceiver.closing(true, this._exception);
                if (n != 0) {
                    this.scheduleTimeout(n);
                    this._threadPool.register(this, n);
                }
            }
        }
    }

    private void heartbeat() {
        block4: {
            assert (this._state == 2);
            if (!this._endpoint.datagram()) {
                BasicStream basicStream = new BasicStream(this._instance, Protocol.currentProtocolEncoding);
                basicStream.writeBlob(Protocol.magic);
                Protocol.currentProtocol.__write(basicStream);
                Protocol.currentProtocolEncoding.__write(basicStream);
                basicStream.writeByte((byte)3);
                basicStream.writeByte((byte)0);
                basicStream.writeInt(14);
                try {
                    OutgoingMessage outgoingMessage = new OutgoingMessage(basicStream, false, false);
                    this.sendMessage(outgoingMessage);
                }
                catch (LocalException localException) {
                    this.setState(6, localException);
                    if ($assertionsDisabled || this._exception != null) break block4;
                    throw new AssertionError();
                }
            }
        }
    }

    private boolean initialize(int n) {
        int n2 = this._transceiver.initialize(this._readStream.getBuffer(), this._writeStream.getBuffer(), this._hasMoreData);
        if (n2 != 0) {
            this.scheduleTimeout(n2);
            this._threadPool.update(this, n, n2);
            return false;
        }
        this._desc = this._transceiver.toString();
        this._initialized = true;
        this.setState(1);
        return true;
    }

    private boolean validate(int n) {
        if (!this._endpoint.datagram()) {
            if (this._adapter != null) {
                int n2;
                if (this._writeStream.isEmpty()) {
                    this._writeStream.writeBlob(Protocol.magic);
                    Protocol.currentProtocol.__write(this._writeStream);
                    Protocol.currentProtocolEncoding.__write(this._writeStream);
                    this._writeStream.writeByte((byte)3);
                    this._writeStream.writeByte((byte)0);
                    this._writeStream.writeInt(14);
                    TraceUtil.traceSend(this._writeStream, this._logger, this._traceLevels);
                    this._writeStream.prepareWrite();
                }
                if (this._observer != null) {
                    this.observerStartWrite(this._writeStream.getBuffer());
                }
                if (this._writeStream.pos() != this._writeStream.size() && (n2 = this.write(this._writeStream.getBuffer())) != 0) {
                    this.scheduleTimeout(n2);
                    this._threadPool.update(this, n, n2);
                    return false;
                }
                if (this._observer != null) {
                    this.observerFinishWrite(this._writeStream.getBuffer());
                }
            } else {
                int n3;
                if (this._readStream.isEmpty()) {
                    this._readStream.resize(14, true);
                    this._readStream.pos(0);
                }
                if (this._observer != null) {
                    this.observerStartRead(this._readStream.getBuffer());
                }
                if (this._readStream.pos() != this._readStream.size() && (n3 = this.read(this._readStream.getBuffer())) != 0) {
                    this.scheduleTimeout(n3);
                    this._threadPool.update(this, n, n3);
                    return false;
                }
                if (this._observer != null) {
                    this.observerFinishRead(this._readStream.getBuffer());
                }
                assert (this._readStream.pos() == 14);
                this._readStream.pos(0);
                byte[] byArray = this._readStream.readBlob(4);
                if (byArray[0] != Protocol.magic[0] || byArray[1] != Protocol.magic[1] || byArray[2] != Protocol.magic[2] || byArray[3] != Protocol.magic[3]) {
                    BadMagicException badMagicException = new BadMagicException();
                    badMagicException.badMagic = byArray;
                    throw badMagicException;
                }
                this._readProtocol.__read(this._readStream);
                Protocol.checkSupportedProtocol(this._readProtocol);
                this._readProtocolEncoding.__read(this._readStream);
                Protocol.checkSupportedProtocolEncoding(this._readProtocolEncoding);
                byte by = this._readStream.readByte();
                if (by != 3) {
                    throw new ConnectionNotValidatedException();
                }
                this._readStream.readByte();
                int n4 = this._readStream.readInt();
                if (n4 != 14) {
                    throw new IllegalMessageSizeException();
                }
                TraceUtil.traceRecv(this._readStream, this._logger, this._traceLevels);
                this._validated = true;
            }
        }
        this._writeStream.resize(0, false);
        this._writeStream.pos(0);
        this._readStream.resize(14, true);
        this._readStream.pos(0);
        this._readHeader = true;
        if (this._instance.traceLevels().network >= 1) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._endpoint.datagram()) {
                stringBuffer.append("starting to ");
                stringBuffer.append(this._connector != null ? "send" : "receive");
                stringBuffer.append(" ");
                stringBuffer.append(this._endpoint.protocol());
                stringBuffer.append(" messages\n");
                stringBuffer.append(this._transceiver.toDetailedString());
            } else {
                stringBuffer.append(this._connector != null ? "established" : "accepted");
                stringBuffer.append(" ");
                stringBuffer.append(this._endpoint.protocol());
                stringBuffer.append(" connection\n");
                stringBuffer.append(this.toString());
            }
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
        }
        return true;
    }

    private int sendNextMessage(List<OutgoingMessage> list) {
        if (this._sendStreams.isEmpty()) {
            return 0;
        }
        if (this._state == 5 && this._writeStream.pos() == 0) {
            OutgoingMessage outgoingMessage = this._sendStreams.getFirst();
            this._writeStream.swap(outgoingMessage.stream);
            return 0;
        }
        assert (!this._writeStream.isEmpty() && this._writeStream.pos() == this._writeStream.size());
        try {
            while (true) {
                int n;
                OutgoingMessage outgoingMessage = this._sendStreams.getFirst();
                this._writeStream.swap(outgoingMessage.stream);
                if (outgoingMessage.sent()) {
                    list.add(outgoingMessage);
                }
                this._sendStreams.removeFirst();
                if (this._sendStreams.isEmpty()) break;
                if (this._state >= 5) {
                    return 0;
                }
                outgoingMessage = this._sendStreams.getFirst();
                assert (!outgoingMessage.prepared);
                BasicStream basicStream = outgoingMessage.stream;
                outgoingMessage.stream = this.doCompress(basicStream, outgoingMessage.compress);
                outgoingMessage.stream.prepareWrite();
                outgoingMessage.prepared = true;
                if (outgoingMessage.outAsync != null) {
                    TraceUtil.trace("sending asynchronous request", basicStream, this._logger, this._traceLevels);
                } else {
                    TraceUtil.traceSend(basicStream, this._logger, this._traceLevels);
                }
                this._writeStream.swap(outgoingMessage.stream);
                if (this._observer != null) {
                    this.observerStartWrite(this._writeStream.getBuffer());
                }
                if (this._writeStream.pos() != this._writeStream.size() && (n = this.write(this._writeStream.getBuffer())) != 0) {
                    return n;
                }
                if (this._observer == null) continue;
                this.observerFinishWrite(this._writeStream.getBuffer());
            }
            if (this._state == 4 && this._shutdownInitiated) {
                this.setState(5);
                int n = this._transceiver.closing(true, this._exception);
                if (n != 0) {
                    return n;
                }
            }
        }
        catch (LocalException localException) {
            this.setState(6, localException);
        }
        return 0;
    }

    private int sendMessage(OutgoingMessage outgoingMessage) {
        int n;
        assert (this._state < 6);
        if (!this._sendStreams.isEmpty()) {
            outgoingMessage.adopt();
            this._sendStreams.addLast(outgoingMessage);
            return 0;
        }
        assert (!outgoingMessage.prepared);
        BasicStream basicStream = outgoingMessage.stream;
        outgoingMessage.stream = this.doCompress(basicStream, outgoingMessage.compress);
        outgoingMessage.stream.prepareWrite();
        outgoingMessage.prepared = true;
        if (outgoingMessage.outAsync != null) {
            TraceUtil.trace("sending asynchronous request", basicStream, this._logger, this._traceLevels);
        } else {
            TraceUtil.traceSend(basicStream, this._logger, this._traceLevels);
        }
        if (this._observer != null) {
            this.observerStartWrite(outgoingMessage.stream.getBuffer());
        }
        if ((n = this.write(outgoingMessage.stream.getBuffer())) == 0) {
            if (this._observer != null) {
                this.observerFinishWrite(outgoingMessage.stream.getBuffer());
            }
            int n2 = 1;
            if (outgoingMessage.sent()) {
                n2 |= 2;
            }
            if (this._acmLastActivity > 0L) {
                this._acmLastActivity = Time.currentMonotonicTimeMillis();
            }
            return n2;
        }
        outgoingMessage.adopt();
        this._writeStream.swap(outgoingMessage.stream);
        this._sendStreams.addLast(outgoingMessage);
        this.scheduleTimeout(n);
        this._threadPool.register(this, n);
        return 0;
    }

    private BasicStream doCompress(BasicStream basicStream, boolean bl) {
        BasicStream basicStream2;
        boolean bl2 = false;
        if (bl) {
            bl2 = BasicStream.compressible();
        }
        if (bl2 && basicStream.size() >= 100 && (basicStream2 = basicStream.compress(14, this._compressionLevel)) != null) {
            basicStream2.pos(9);
            basicStream2.writeByte((byte)2);
            basicStream2.pos(10);
            basicStream2.writeInt(basicStream2.size());
            basicStream.pos(9);
            basicStream.writeByte((byte)2);
            basicStream.writeInt(basicStream2.size());
            return basicStream2;
        }
        basicStream.pos(9);
        basicStream.writeByte((byte)(bl2 ? 1 : 0));
        basicStream.pos(10);
        basicStream.writeInt(basicStream.size());
        return basicStream;
    }

    private int parseMessage(MessageInfo messageInfo) {
        assert (this._state > 1 && this._state < 6);
        this._readStream.swap(messageInfo.stream);
        this._readStream.resize(14, true);
        this._readStream.pos(0);
        this._readHeader = true;
        assert (messageInfo.stream.pos() == messageInfo.stream.size());
        this._validated = true;
        try {
            messageInfo.stream.pos(8);
            byte by = messageInfo.stream.readByte();
            messageInfo.compress = messageInfo.stream.readByte();
            if (messageInfo.compress == 2) {
                if (BasicStream.compressible()) {
                    messageInfo.stream = messageInfo.stream.uncompress(14, this._messageSizeMax);
                } else {
                    FeatureNotSupportedException featureNotSupportedException = new FeatureNotSupportedException();
                    featureNotSupportedException.unsupportedFeature = "Cannot uncompress compressed message: org.apache.tools.bzip2.CBZip2OutputStream was not found";
                    throw featureNotSupportedException;
                }
            }
            messageInfo.stream.pos(14);
            switch (by) {
                case 4: {
                    TraceUtil.traceRecv(messageInfo.stream, this._logger, this._traceLevels);
                    if (this._endpoint.datagram()) {
                        if (this._warn) {
                            this._logger.warning("ignoring close connection message for datagram connection:\n" + this._desc);
                        }
                        break;
                    }
                    this.setState(5, new CloseConnectionException());
                    int n = this._transceiver.closing(false, this._exception);
                    if (n != 0) {
                        return n;
                    }
                    this.setState(6);
                    break;
                }
                case 0: {
                    if (this._state >= 4) {
                        TraceUtil.trace("received request during closing\n(ignored by server, client will retry)", messageInfo.stream, this._logger, this._traceLevels);
                        break;
                    }
                    TraceUtil.traceRecv(messageInfo.stream, this._logger, this._traceLevels);
                    messageInfo.requestId = messageInfo.stream.readInt();
                    messageInfo.invokeNum = 1;
                    messageInfo.servantManager = this._servantManager;
                    messageInfo.adapter = this._adapter;
                    ++messageInfo.messageDispatchCount;
                    break;
                }
                case 1: {
                    if (this._state >= 4) {
                        TraceUtil.trace("received batch request during closing\n(ignored by server, client will retry)", messageInfo.stream, this._logger, this._traceLevels);
                        break;
                    }
                    TraceUtil.traceRecv(messageInfo.stream, this._logger, this._traceLevels);
                    messageInfo.invokeNum = messageInfo.stream.readInt();
                    if (messageInfo.invokeNum < 0) {
                        messageInfo.invokeNum = 0;
                        throw new UnmarshalOutOfBoundsException();
                    }
                    messageInfo.servantManager = this._servantManager;
                    messageInfo.adapter = this._adapter;
                    messageInfo.messageDispatchCount += messageInfo.invokeNum;
                    break;
                }
                case 2: {
                    TraceUtil.traceRecv(messageInfo.stream, this._logger, this._traceLevels);
                    messageInfo.requestId = messageInfo.stream.readInt();
                    OutgoingAsyncBase outgoingAsyncBase = this._asyncRequests.remove(messageInfo.requestId);
                    if (outgoingAsyncBase != null && outgoingAsyncBase.completed(messageInfo.stream)) {
                        messageInfo.outAsync = outgoingAsyncBase;
                        ++messageInfo.messageDispatchCount;
                    }
                    this.notifyAll();
                    break;
                }
                case 3: {
                    TraceUtil.traceRecv(messageInfo.stream, this._logger, this._traceLevels);
                    if (this._callback != null) {
                        messageInfo.heartbeatCallback = this._callback;
                        ++messageInfo.messageDispatchCount;
                    }
                    break;
                }
                default: {
                    TraceUtil.trace("received unknown message\n(invalid, closing connection)", messageInfo.stream, this._logger, this._traceLevels);
                    throw new UnknownMessageException();
                }
            }
        }
        catch (LocalException localException) {
            if (this._endpoint.datagram()) {
                if (this._warn) {
                    this._logger.warning("datagram connection exception:\n" + localException + '\n' + this._desc);
                }
            }
            this.setState(6, localException);
        }
        return this._state == 3 ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeAll(BasicStream basicStream, int n, int n2, byte by, ServantManager servantManager, ObjectAdapter objectAdapter) {
        Incoming incoming = null;
        try {
            while (n > 0) {
                boolean bl = !this._endpoint.datagram() && n2 != 0;
                incoming = this.getIncoming(objectAdapter, bl, by, n2);
                incoming.invoke(servantManager, basicStream);
                --n;
                this.reclaimIncoming(incoming);
                incoming = null;
            }
            basicStream.clear();
            if (incoming == null) return;
        }
        catch (LocalException localException) {
            this.invokeException(n2, localException, n, false);
            return;
            catch (ServantError servantError) {
                Throwable throwable = servantError.getCause();
                if (!(throwable instanceof AssertionError) && !(throwable instanceof OutOfMemoryError)) {
                    throw (Error)throwable;
                }
                if (incoming == null) return;
                this.reclaimIncoming(incoming);
                return;
                {
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                }
                catch (Error error) {
                    UnknownException unknownException = new UnknownException(error);
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    error.printStackTrace(printWriter);
                    printWriter.flush();
                    unknownException.unknown = stringWriter.toString();
                    this._logger.error(unknownException.unknown);
                    this.invokeException(n2, unknownException, n, false);
                    if (!(error instanceof AssertionError) && !(error instanceof OutOfMemoryError)) {
                        throw error;
                    }
                    if (incoming == null) return;
                    this.reclaimIncoming(incoming);
                    return;
                }
            }
            finally {
                if (incoming != null) {
                    this.reclaimIncoming(incoming);
                }
            }
        }
        this.reclaimIncoming(incoming);
        return;
    }

    private void scheduleTimeout(int n) {
        block12: {
            int n2;
            if (this._state < 2) {
                DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
                n2 = defaultsAndOverrides.overrideConnectTimeout ? defaultsAndOverrides.overrideConnectTimeoutValue : this._endpoint.timeout();
            } else if (this._state < 5) {
                if (this._readHeader) {
                    n &= 0xFFFFFFFE;
                }
                n2 = this._endpoint.timeout();
            } else {
                DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
                n2 = defaultsAndOverrides.overrideCloseTimeout ? defaultsAndOverrides.overrideCloseTimeoutValue : this._endpoint.timeout();
            }
            if (n2 < 0) {
                return;
            }
            try {
                if ((n & 1) != 0) {
                    if (this._readTimeoutFuture != null) {
                        this._readTimeoutFuture.cancel(false);
                    }
                    this._readTimeoutFuture = this._timer.schedule(this._readTimeout, (long)n2, TimeUnit.MILLISECONDS);
                }
                if ((n & 0xC) != 0) {
                    if (this._writeTimeoutFuture != null) {
                        this._writeTimeoutFuture.cancel(false);
                    }
                    this._writeTimeoutFuture = this._timer.schedule(this._writeTimeout, (long)n2, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable throwable) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError();
            }
        }
    }

    private void unscheduleTimeout(int n) {
        if ((n & 1) != 0 && this._readTimeoutFuture != null) {
            this._readTimeoutFuture.cancel(false);
            this._readTimeoutFuture = null;
        }
        if ((n & 0xC) != 0 && this._writeTimeoutFuture != null) {
            this._writeTimeoutFuture.cancel(false);
            this._writeTimeoutFuture = null;
        }
    }

    private ConnectionInfo initConnectionInfo() {
        if (this._state > 0 && this._info != null) {
            return this._info;
        }
        try {
            this._info = this._transceiver.getInfo();
        }
        catch (LocalException localException) {
            this._info = new ConnectionInfo();
        }
        this._info.connectionId = this._endpoint.connectionId();
        this._info.adapterName = this._adapter != null ? this._adapter.getName() : "";
        this._info.incoming = this._connector == null;
        return this._info;
    }

    private ConnectionState toConnectionState(int n) {
        return connectionStateMap[n];
    }

    private void warning(String string, java.lang.Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        String string2 = string + ":\n" + this._desc + "\n" + stringWriter.toString();
        this._logger.warning(string2);
    }

    private void observerStartRead(Buffer buffer) {
        if (this._readStreamPos >= 0) {
            assert (!buffer.empty());
            this._observer.receivedBytes(buffer.b.position() - this._readStreamPos);
        }
        this._readStreamPos = buffer.empty() ? -1 : buffer.b.position();
    }

    private void observerFinishRead(Buffer buffer) {
        if (this._readStreamPos == -1) {
            return;
        }
        assert (buffer.b.position() >= this._readStreamPos);
        this._observer.receivedBytes(buffer.b.position() - this._readStreamPos);
        this._readStreamPos = -1;
    }

    private void observerStartWrite(Buffer buffer) {
        if (this._writeStreamPos >= 0) {
            assert (!buffer.empty());
            this._observer.sentBytes(buffer.b.position() - this._writeStreamPos);
        }
        this._writeStreamPos = buffer.empty() ? -1 : buffer.b.position();
    }

    private void observerFinishWrite(Buffer buffer) {
        if (this._writeStreamPos == -1) {
            return;
        }
        if (buffer.b.position() > this._writeStreamPos) {
            this._observer.sentBytes(buffer.b.position() - this._writeStreamPos);
        }
        this._writeStreamPos = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Incoming getIncoming(ObjectAdapter objectAdapter, boolean bl, byte by, int n) {
        Incoming incoming = null;
        if (this._cacheBuffers > 0) {
            Object object = this._incomingCacheMutex;
            synchronized (object) {
                if (this._incomingCache == null) {
                    incoming = new Incoming(this._instance, this, this, objectAdapter, bl, by, n);
                } else {
                    incoming = this._incomingCache;
                    this._incomingCache = this._incomingCache.next;
                    incoming.reset(this._instance, this, this, objectAdapter, bl, by, n);
                    incoming.next = null;
                }
            }
        } else {
            incoming = new Incoming(this._instance, this, this, objectAdapter, bl, by, n);
        }
        return incoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reclaimIncoming(Incoming incoming) {
        if (this._cacheBuffers > 0) {
            Object object = this._incomingCacheMutex;
            synchronized (object) {
                incoming.next = this._incomingCache;
                this._incomingCache = incoming;
                this._incomingCache.reclaim();
            }
        }
    }

    private void reap() {
        if (this._monitor != null) {
            this._monitor.reap(this);
        }
        if (this._observer != null) {
            this._observer.detach();
        }
    }

    private int read(Buffer buffer) {
        int n = buffer.b.position();
        int n2 = this._transceiver.read(buffer, this._hasMoreData);
        if (this._instance.traceLevels().network >= 3 && buffer.b.position() != n) {
            StringBuffer stringBuffer = new StringBuffer("received ");
            if (this._endpoint.datagram()) {
                stringBuffer.append(buffer.b.limit());
            } else {
                stringBuffer.append(buffer.b.position() - n);
                stringBuffer.append(" of ");
                stringBuffer.append(buffer.b.limit() - n);
            }
            stringBuffer.append(" bytes via ");
            stringBuffer.append(this._endpoint.protocol());
            stringBuffer.append("\n");
            stringBuffer.append(this.toString());
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
        }
        return n2;
    }

    private int write(Buffer buffer) {
        int n = buffer.b.position();
        int n2 = this._transceiver.write(buffer);
        if (this._instance.traceLevels().network >= 3 && buffer.b.position() != n) {
            StringBuffer stringBuffer = new StringBuffer("sent ");
            stringBuffer.append(buffer.b.position() - n);
            if (!this._endpoint.datagram()) {
                stringBuffer.append(" of ");
                stringBuffer.append(buffer.b.limit() - n);
            }
            stringBuffer.append(" bytes via ");
            stringBuffer.append(this._endpoint.protocol());
            stringBuffer.append("\n");
            stringBuffer.append(this.toString());
            this._instance.initializationData().logger.trace(this._instance.traceLevels().networkCat, stringBuffer.toString());
        }
        return n2;
    }

    private static class OutgoingMessage {
        public BasicStream stream;
        public OutgoingAsyncBase outAsync;
        public boolean compress;
        public int requestId;
        boolean adopt;
        boolean prepared;

        OutgoingMessage(BasicStream basicStream, boolean bl, boolean bl2) {
            this.stream = basicStream;
            this.compress = bl;
            this.adopt = bl2;
            this.requestId = 0;
        }

        OutgoingMessage(OutgoingAsyncBase outgoingAsyncBase, BasicStream basicStream, boolean bl, int n) {
            this.stream = basicStream;
            this.compress = bl;
            this.outAsync = outgoingAsyncBase;
            this.requestId = n;
        }

        public void canceled() {
            assert (this.outAsync != null);
            this.outAsync = null;
        }

        public void adopt() {
            if (this.adopt) {
                BasicStream basicStream = new BasicStream(this.stream.instance(), Protocol.currentProtocolEncoding);
                basicStream.swap(this.stream);
                this.stream = basicStream;
                this.adopt = false;
            }
        }

        public boolean sent() {
            if (this.outAsync != null) {
                return this.outAsync.sent();
            }
            return false;
        }

        public void completed(LocalException localException) {
            if (this.outAsync != null && this.outAsync.completed(localException)) {
                this.outAsync.invokeCompleted();
            }
        }
    }

    private static class MessageInfo {
        BasicStream stream;
        int invokeNum;
        int requestId;
        byte compress;
        ServantManager servantManager;
        ObjectAdapter adapter;
        OutgoingAsyncBase outAsync;
        ConnectionCallback heartbeatCallback;
        int messageDispatchCount;

        MessageInfo(BasicStream basicStream) {
            this.stream = basicStream;
        }
    }

    private class TimeoutCallback
    implements Runnable {
        private TimeoutCallback() {
        }

        @Override
        public void run() {
            ConnectionI.this.timedOut();
        }
    }

    public static interface StartCallback {
        public void connectionStartCompleted(ConnectionI var1);

        public void connectionStartFailed(ConnectionI var1, LocalException var2);
    }
}

