/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.LoggerI;
import Ice.OperationInterruptedException;
import Ice.SignalPolicy;
import Ice.StringSeqHolder;
import Ice.Util;
import IceInternal.Ex;

public abstract class Application {
    protected static String _appName;
    protected static Communicator _communicator;
    protected static AppHook _appHook;
    protected static final Object _mutex;
    protected static boolean _callbackInProgress;
    protected static boolean _destroyed;
    protected static boolean _interrupted;
    protected static SignalPolicy _signalPolicy;

    public Application() {
    }

    public Application(SignalPolicy signalPolicy) {
        _signalPolicy = signalPolicy;
    }

    public final int main(String string, String[] stringArray) {
        return this.main(string, stringArray, new InitializationData());
    }

    public final int main(String string, String[] stringArray, String string2) {
        if (Util.getProcessLogger() instanceof LoggerI) {
            Util.setProcessLogger(new LoggerI(string, ""));
        }
        InitializationData initializationData = new InitializationData();
        if (string2 != null) {
            try {
                initializationData.properties = Util.createProperties();
                initializationData.properties.load(string2);
            }
            catch (LocalException localException) {
                Util.getProcessLogger().error(Ex.toString(localException));
                return 1;
            }
            catch (Exception exception) {
                Util.getProcessLogger().error("unknown exception: " + Ex.toString(exception));
                return 1;
            }
        }
        return this.main(string, stringArray, initializationData);
    }

    public final int main(String string, String[] stringArray, InitializationData initializationData) {
        if (Util.getProcessLogger() instanceof LoggerI) {
            Util.setProcessLogger(new LoggerI(string, ""));
        }
        if (_communicator != null) {
            Util.getProcessLogger().error("only one instance of the Application class can be used");
            return 1;
        }
        _appName = string;
        InitializationData initializationData2 = initializationData != null ? initializationData.clone() : new InitializationData();
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        try {
            initializationData2.properties = Util.createProperties(stringSeqHolder, initializationData2.properties);
        }
        catch (LocalException localException) {
            Util.getProcessLogger().error(Ex.toString(localException));
            return 1;
        }
        catch (Exception exception) {
            Util.getProcessLogger().error("unknown exception: " + Ex.toString(exception));
            return 1;
        }
        _appName = initializationData2.properties.getPropertyWithDefault("Ice.ProgramName", _appName);
        if (!initializationData2.properties.getProperty("Ice.ProgramName").equals("") && Util.getProcessLogger() instanceof LoggerI) {
            Util.setProcessLogger(new LoggerI(initializationData2.properties.getProperty("Ice.ProgramName"), ""));
        }
        return this.doMain(stringSeqHolder, initializationData2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doMain(StringSeqHolder stringSeqHolder, InitializationData initializationData) {
        int n = 0;
        try {
            _communicator = Util.initialize(stringSeqHolder, initializationData);
            if (_signalPolicy == SignalPolicy.HandleSignals) {
                Application.destroyOnInterrupt();
            }
            n = this.run((String[])stringSeqHolder.value);
        }
        catch (LocalException localException) {
            Util.getProcessLogger().error(Ex.toString(localException));
            n = 1;
        }
        catch (Exception exception) {
            Util.getProcessLogger().error("unknown exception: " + Ex.toString(exception));
            n = 1;
        }
        catch (Error error) {
            Util.getProcessLogger().error("Java error: " + Ex.toString(error));
            n = 1;
        }
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Application.defaultInterrupt();
        }
        Object object = _mutex;
        synchronized (object) {
            boolean bl = false;
            while (_callbackInProgress) {
                try {
                    _mutex.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            if (_destroyed) {
                _communicator = null;
            } else {
                _destroyed = true;
            }
        }
        if (_communicator != null) {
            try {
                try {
                    _communicator.destroy();
                }
                catch (OperationInterruptedException operationInterruptedException) {
                    Util.getProcessLogger().error(Ex.toString(operationInterruptedException));
                    _communicator.destroy();
                }
            }
            catch (LocalException localException) {
                Util.getProcessLogger().error(Ex.toString(localException));
                n = 1;
            }
            catch (Exception exception) {
                Util.getProcessLogger().error("unknown exception: " + Ex.toString(exception));
                n = 1;
            }
            _communicator = null;
        }
        object = _mutex;
        synchronized (object) {
            if (_appHook != null) {
                _appHook.done();
            }
        }
        return n;
    }

    public abstract int run(String[] var1);

    public static String appName() {
        return _appName;
    }

    public static Communicator communicator() {
        return _communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyOnInterrupt() {
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Object object = _mutex;
            synchronized (object) {
                block6: {
                    try {
                        Application.changeHook(new DestroyHook());
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (_communicator == null) break block6;
                        _communicator.destroy();
                    }
                }
            }
        }
        Util.getProcessLogger().warning("interrupt method called on Application configured to not handle interrupts.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownOnInterrupt() {
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Object object = _mutex;
            synchronized (object) {
                block6: {
                    try {
                        Application.changeHook(new ShutdownHook());
                    }
                    catch (IllegalStateException illegalStateException) {
                        if (_communicator == null) break block6;
                        _communicator.shutdown();
                    }
                }
            }
        }
        Util.getProcessLogger().warning("interrupt method called on Application configured to not handle interrupts.");
    }

    public static void setInterruptHook(Thread thread) {
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            try {
                Application.changeHook(new CustomHook(thread));
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            Util.getProcessLogger().warning("interrupt method called on Application configured to not handle interrupts.");
        }
    }

    public static void defaultInterrupt() {
        if (_signalPolicy == SignalPolicy.HandleSignals) {
            Application.changeHook(null);
        } else {
            Util.getProcessLogger().warning("interrupt method called on Application configured to not handle interrupts.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean interrupted() {
        Object object = _mutex;
        synchronized (object) {
            return _interrupted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeHook(AppHook appHook) {
        Object object = _mutex;
        synchronized (object) {
            try {
                if (_appHook != null) {
                    Runtime.getRuntime().removeShutdownHook(_appHook);
                    _appHook.done();
                    _appHook = null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (appHook != null) {
                Runtime.getRuntime().addShutdownHook(appHook);
                _appHook = appHook;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setCallbackInProgress(boolean bl) {
        Object object = _mutex;
        synchronized (object) {
            if (_destroyed) {
                return false;
            }
            _callbackInProgress = true;
            _destroyed = bl;
            _interrupted = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCallbackInProgress() {
        Object object = _mutex;
        synchronized (object) {
            _callbackInProgress = false;
            _mutex.notify();
        }
    }

    static {
        _mutex = new Object();
        _callbackInProgress = false;
        _destroyed = false;
        _interrupted = false;
        _signalPolicy = SignalPolicy.HandleSignals;
    }

    static class CustomHook
    extends AppHook {
        private Thread _hook;

        CustomHook(Thread thread) {
            this._hook = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                if (!Application.setCallbackInProgress(false)) {
                    return;
                }
                this._hook.run();
                Application.clearCallbackInProgress();
            }
        }
    }

    static class ShutdownHook
    extends AppHook {
        ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                if (!Application.setCallbackInProgress(false)) {
                    return;
                }
                Communicator communicator = Application.communicator();
                if (communicator != null) {
                    communicator.shutdown();
                }
                Application.clearCallbackInProgress();
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    static class DestroyHook
    extends AppHook {
        DestroyHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                if (!Application.setCallbackInProgress(true)) {
                    return;
                }
                Communicator communicator = Application.communicator();
                if (communicator != null) {
                    communicator.destroy();
                }
                Application.clearCallbackInProgress();
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    public static class AppHook
    extends Thread {
        protected boolean _done = false;
        protected final Object _doneMutex = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            Object object = this._doneMutex;
            synchronized (object) {
                this._done = true;
                this._doneMutex.notify();
            }
        }
    }
}

