/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.conic.Circle2D;
import math.geom2d.conic.Conic2D;
import math.geom2d.conic.Conics2D;
import math.geom2d.conic.EllipseArc2D;
import math.geom2d.conic.EllipseShape2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.GenericDomain2D;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.polygon.LinearRing2D;
import math.utils.EqualUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ellipse2D
extends AbstractSmoothCurve2D
implements EllipseShape2D,
Cloneable {
    protected double xc;
    protected double yc;
    protected double r1;
    protected double r2;
    protected double theta = 0.0;
    protected boolean direct = true;

    public static Ellipse2D create(Point2D focus1, Point2D focus2, double chord) {
        double x1 = focus1.x();
        double y1 = focus1.y();
        double x2 = focus2.x();
        double y2 = focus2.y();
        double xc = (x1 + x2) / 2.0;
        double yc = (y1 + y2) / 2.0;
        double theta = Angle2D.horizontalAngle(x1, y1, x2, y2);
        double dist = focus1.distance(focus2);
        double r1 = chord / 2.0;
        double r2 = Math.sqrt(chord * chord - dist * dist) / 2.0;
        return new Ellipse2D(xc, yc, r1, r2, theta);
    }

    @Deprecated
    public static Ellipse2D create(Point2D center, double l1, double l2) {
        return new Ellipse2D(center.x(), center.y(), l1, l2, 0.0, true);
    }

    @Deprecated
    public static Ellipse2D create(Point2D center, double l1, double l2, double theta) {
        return new Ellipse2D(center.x(), center.y(), l1, l2, theta, true);
    }

    public static Ellipse2D create(Point2D center, double l1, double l2, double theta, boolean direct) {
        return new Ellipse2D(center.x(), center.y(), l1, l2, theta, direct);
    }

    @Deprecated
    public static Ellipse2D create(java.awt.geom.Ellipse2D ellipse) {
        return new Ellipse2D(new Point2D(ellipse.getCenterX(), ellipse.getCenterY()), ellipse.getWidth() / 2.0, ellipse.getHeight() / 2.0);
    }

    public static Ellipse2D reduceCentered(double[] coefs) {
        double r2;
        double r1;
        double theta;
        double A = coefs[0];
        double B = coefs[1];
        double C = coefs[2];
        if (Math.abs(A - C) < 1.0E-12) {
            theta = 0.7853981633974483;
        } else {
            theta = Math.atan2(B, A - C) / 2.0;
            if (B < 0.0) {
                theta -= Math.PI;
            }
            theta = Angle2D.formatAngle(theta);
        }
        double[] coefs2 = Conics2D.transformCentered(coefs, AffineTransform2D.createRotation(-theta));
        double f = 1.0;
        if (coefs2.length > 5) {
            f = Math.abs(coefs[5]);
        }
        assert (Math.abs(coefs2[1] / f) < 1.0E-12) : "Second conic coefficient should be zero";
        if (coefs2[0] < coefs2[2]) {
            r1 = Math.sqrt(f / coefs2[0]);
            r2 = Math.sqrt(f / coefs2[2]);
        } else {
            r1 = Math.sqrt(f / coefs2[2]);
            r2 = Math.sqrt(f / coefs2[0]);
            theta = Angle2D.formatAngle(theta + 1.5707963267948966);
            theta = Math.min(theta, Angle2D.formatAngle(theta + Math.PI));
        }
        return new Ellipse2D(0.0, 0.0, r1, r2, theta);
    }

    public static Ellipse2D transformCentered(Ellipse2D ellipse, AffineTransform2D trans) {
        double r1 = ellipse.r1;
        double r2 = ellipse.r2;
        double theta = ellipse.theta;
        double r1Sq = r1 * r1;
        double r2Sq = r2 * r2;
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        double cotSq = cot * cot;
        double sitSq = sit * sit;
        double A = cotSq / r1Sq + sitSq / r2Sq;
        double B = 2.0 * cot * sit * (1.0 / r1Sq - 1.0 / r2Sq);
        double C = cotSq / r2Sq + sitSq / r1Sq;
        double[] coefs = new double[]{A, B, C};
        double[] coefs2 = Conics2D.transformCentered(coefs, trans);
        return Ellipse2D.reduceCentered(coefs2);
    }

    public Ellipse2D() {
        this(0.0, 0.0, 1.0, 1.0, 0.0, true);
    }

    public Ellipse2D(Point2D center, double l1, double l2) {
        this(center.x(), center.y(), l1, l2, 0.0, true);
    }

    public Ellipse2D(double xc, double yc, double l1, double l2) {
        this(xc, yc, l1, l2, 0.0, true);
    }

    public Ellipse2D(Point2D center, double l1, double l2, double theta) {
        this(center.x(), center.y(), l1, l2, theta, true);
    }

    public Ellipse2D(double xc, double yc, double l1, double l2, double theta) {
        this(xc, yc, l1, l2, theta, true);
    }

    public Ellipse2D(double xc, double yc, double l1, double l2, double theta, boolean direct) {
        this.xc = xc;
        this.yc = yc;
        this.r1 = l1;
        this.r2 = l2;
        this.theta = theta;
        this.direct = direct;
    }

    public Ellipse2D(java.awt.geom.Ellipse2D ellipse) {
        this(new Point2D(ellipse.getCenterX(), ellipse.getCenterY()), ellipse.getWidth() / 2.0, ellipse.getHeight() / 2.0);
    }

    public double getRho(double angle) {
        double cot = Math.cos(angle - this.theta);
        double sit = Math.cos(angle - this.theta);
        return this.r1 * this.r2 / Math.hypot(this.r2 * cot, this.r1 * sit);
    }

    public Point2D projectedPoint(Point2D point) {
        Vector2D polar = this.projectedVector(point, 1.0E-12);
        return new Point2D(point.x() + polar.x(), point.y() + polar.y());
    }

    public Vector2D projectedVector(Point2D point, double eMax) {
        boolean inside;
        double theta;
        double lb;
        double la;
        double ot = 0.3333333333333333;
        double x = point.x() - this.xc;
        double y = point.y() - this.yc;
        if (this.r1 >= this.r2) {
            la = this.r1;
            lb = this.r2;
            theta = this.theta;
        } else {
            la = this.r2;
            lb = this.r1;
            theta = this.theta + 1.5707963267948966;
            double tmp = x;
            x = -y;
            y = tmp;
        }
        double cot = Math.cos(theta);
        double sit = Math.sin(theta);
        double tmpx = x;
        double tmpy = y;
        x = tmpx * cot - tmpy * sit;
        y = tmpx * sit + tmpy * cot;
        double ae = la;
        double f = 1.0 - lb / la;
        double e2 = f * (2.0 - f);
        double g = 1.0 - f;
        double g2 = g * g;
        double ae2 = ae * ae;
        double z = y;
        double z2 = y * y;
        double r = x;
        double r2 = x * x;
        double g2r2ma2 = g2 * (r2 - ae2);
        double g2r2ma2pz2 = g2r2ma2 + z2;
        double dist = Math.sqrt(r2 + z2);
        boolean bl = inside = g2r2ma2pz2 <= 0.0;
        if (dist < 1.0E-10 * ae) {
            System.out.println("point at the center");
            return Vector2D.createPolar(r, 0.0);
        }
        double cz = r / dist;
        double sz = z / dist;
        double t = z / (dist + r);
        double a = 1.0 - e2 * cz * cz;
        double b = g2 * r * cz + z * sz;
        double c = g2r2ma2pz2;
        double b2 = b * b;
        double ac = a * c;
        double k = c / (b + Math.sqrt(b2 - ac));
        double phi = Math.atan2(z - k * sz, g2 * (r - k * cz));
        if (Math.abs(k) < 1.0E-10 * dist) {
            return Vector2D.createPolar(k, phi);
        }
        int iterations = 0;
        while (iterations < 100) {
            double tildePhi;
            double tildeT;
            double R;
            double Q;
            double D;
            a = g2r2ma2pz2 + g2 * (2.0 * r + k) * k;
            b = -4.0 * k * z / a;
            c = 2.0 * (g2r2ma2pz2 + (1.0 + e2) * k * k) / a;
            double d = b;
            if ((D = (Q = (3.0 * (c += t * (b += t)) - (b2 = b * b)) / 9.0) * Q * Q + (R = (b * (9.0 * c - 2.0 * b2) - 27.0 * (d += t * c)) / 54.0) * R) >= 0.0) {
                double rootD = Math.sqrt(D);
                double rMr = R - rootD;
                double rPr = R + rootD;
                tildeT = (rPr > 0.0 ? Math.pow(rPr, ot) : -Math.pow(-rPr, ot)) + (rMr > 0.0 ? Math.pow(rMr, ot) : -Math.pow(-rMr, ot)) - b * ot;
                double tildeT2 = tildeT * tildeT;
                double tildeT2P1 = 1.0 + tildeT2;
                tildePhi = Math.atan2(z * tildeT2P1 - 2.0 * k * tildeT, g2 * (r * tildeT2P1 - k * (1.0 - tildeT2)));
            } else {
                double alpha;
                double qRoot = Math.sqrt(Q = -Q);
                tildeT = 2.0 * qRoot * Math.cos((alpha = Math.acos(R / (Q * qRoot))) * ot) - b * ot;
                double tildeT2 = tildeT * tildeT;
                double tildeT2P1 = 1.0 + tildeT2;
                tildePhi = Math.atan2(z * tildeT2P1 - 2.0 * k * tildeT, g2 * (r * tildeT2P1 - k * (1.0 - tildeT2)));
                if (tildePhi * phi < 0.0 && (tildePhi = Math.atan2(z * (tildeT2P1 = 1.0 + (tildeT2 = (tildeT = 2.0 * qRoot * Math.cos((alpha + Math.PI * 2) * ot) - b * ot) * tildeT)) - 2.0 * k * tildeT, g2 * (r * tildeT2P1 - k * (1.0 - tildeT2)))) * phi < 0.0) {
                    tildeT = 2.0 * qRoot * Math.cos((alpha + Math.PI * 4) * ot) - b * ot;
                    tildeT2 = tildeT * tildeT;
                    tildeT2P1 = 1.0 + tildeT2;
                    tildePhi = Math.atan2(z * tildeT2P1 - 2.0 * k * tildeT, g2 * (r * tildeT2P1 - k * (1.0 - tildeT2)));
                }
            }
            double dPhi = Math.abs(0.5 * (tildePhi - phi));
            phi = 0.5 * (phi + tildePhi);
            double cPhi = Math.cos(phi);
            double sPhi = Math.sin(phi);
            double coeff = Math.sqrt(1.0 - e2 * sPhi * sPhi);
            b = ae / coeff;
            double dR = r - cPhi * b;
            double dZ = z - sPhi * b * g2;
            k = Math.hypot(dR, dZ);
            if (inside) {
                k = -k;
            }
            t = dZ / (k + dR);
            if (dPhi < 1.0E-14) {
                if (this.r1 >= this.r2) {
                    return Vector2D.createPolar(-k, phi + theta);
                }
                return Vector2D.createPolar(-k, phi + theta - 1.5707963267948966);
            }
            ++iterations;
        }
        System.out.println("Ellipse.getProjectedVector() did not converge");
        return Vector2D.createPolar(k, phi);
    }

    public Ellipse2D parallel(double d) {
        return new Ellipse2D(this.xc, this.yc, Math.abs(this.r1 + d), Math.abs(this.r2 + d), this.theta, this.direct);
    }

    @Override
    public boolean isDirect() {
        return this.direct;
    }

    @Override
    public boolean isCircle() {
        return Math.abs(this.r1 - this.r2) < 1.0E-12;
    }

    public double semiMajorAxisLength() {
        return this.r1;
    }

    public double semiMinorAxisLength() {
        return this.r2;
    }

    @Override
    public Point2D center() {
        return new Point2D(this.xc, this.yc);
    }

    public Point2D focus1() {
        double theta;
        double b;
        double a;
        if (this.r1 > this.r2) {
            a = this.r1;
            b = this.r2;
            theta = this.theta;
        } else {
            a = this.r2;
            b = this.r1;
            theta = this.theta + 1.5707963267948966;
        }
        return Point2D.createPolar(this.xc, this.yc, Math.sqrt(a * a - b * b), theta + Math.PI);
    }

    public Point2D focus2() {
        double theta;
        double b;
        double a;
        if (this.r1 > this.r2) {
            a = this.r1;
            b = this.r2;
            theta = this.theta;
        } else {
            a = this.r2;
            b = this.r1;
            theta = this.theta + 1.5707963267948966;
        }
        return Point2D.createPolar(this.xc, this.yc, Math.sqrt(a * a - b * b), theta);
    }

    public Vector2D vector1() {
        return new Vector2D(Math.cos(this.theta), Math.sin(this.theta));
    }

    public Vector2D vector2() {
        if (this.direct) {
            return new Vector2D(-Math.sin(this.theta), Math.cos(this.theta));
        }
        return new Vector2D(Math.sin(this.theta), -Math.cos(this.theta));
    }

    public double angle() {
        return this.theta;
    }

    @Override
    public Conic2D.Type conicType() {
        if (Math.abs(this.r1 - this.r2) < 1.0E-12) {
            return Conic2D.Type.CIRCLE;
        }
        return Conic2D.Type.ELLIPSE;
    }

    @Override
    public double[] conicCoefficients() {
        double r1Sq = this.r1 * this.r1;
        double r2Sq = this.r2 * this.r2;
        double sint = Math.sin(this.theta);
        double cost = Math.cos(this.theta);
        double sin2t = 2.0 * sint * cost;
        double sintSq = sint * sint;
        double costSq = cost * cost;
        double xcSq = this.xc * this.xc;
        double ycSq = this.yc * this.yc;
        double r1SqInv = 1.0 / r1Sq;
        double r2SqInv = 1.0 / r2Sq;
        double a = costSq / r1Sq + sintSq / r2Sq;
        double b = (r2Sq - r1Sq) * sin2t / (r1Sq * r2Sq);
        double c = costSq / r2Sq + sintSq / r1Sq;
        double d = -this.yc * b - 2.0 * this.xc * a;
        double e = -this.xc * b - 2.0 * this.yc * c;
        double f = -1.0 + (xcSq + ycSq) * (r1SqInv + r2SqInv) / 2.0 + (costSq - sintSq) * (xcSq - ycSq) * (r1SqInv - r2SqInv) / 2.0 + this.xc * this.yc * (r1SqInv - r2SqInv) * sin2t;
        return new double[]{a, b, c, d, e, f};
    }

    @Override
    public double eccentricity() {
        double a = Math.max(this.r1, this.r2);
        double b = Math.min(this.r1, this.r2);
        double r = b / a;
        return Math.sqrt(1.0 - r * r);
    }

    @Override
    public Domain2D domain() {
        return new GenericDomain2D(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(this.xc - this.r1, this.yc - this.r2, 2.0 * this.r1, 2.0 * this.r2);
        AffineTransform trans = AffineTransform.getRotateInstance(this.theta, this.xc, this.yc);
        Shape shape = trans.createTransformedShape(ellipse);
        g2.fill(shape);
    }

    @Override
    public double windingAngle(Point2D point) {
        if (this.signedDistance(point) > 0.0) {
            return 0.0;
        }
        return this.direct ? Math.PI * 2 : Math.PI * -2;
    }

    @Override
    public boolean isInside(Point2D point) {
        double yp;
        AffineTransform2D rot = AffineTransform2D.createRotation(this.xc, this.yc, -this.theta);
        Point2D pt = rot.transform(point);
        double xp = (pt.x() - this.xc) / this.r1;
        return xp * xp + (yp = (pt.y() - this.yc) / this.r2) * yp < 1.0 ^ !this.direct;
    }

    @Override
    public double signedDistance(Point2D point) {
        double dist = this.asPolyline(180).distance(point);
        return this.isInside(point) ? -dist : dist;
    }

    @Override
    public double signedDistance(double x, double y) {
        return this.signedDistance(new Point2D(x, y));
    }

    @Override
    public Vector2D tangent(double t) {
        if (!this.direct) {
            t = -t;
        }
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        if (this.direct) {
            return new Vector2D(-this.r1 * Math.sin(t) * cot - this.r2 * Math.cos(t) * sit, -this.r1 * Math.sin(t) * sit + this.r2 * Math.cos(t) * cot);
        }
        return new Vector2D(this.r1 * Math.sin(t) * cot + this.r2 * Math.cos(t) * sit, this.r1 * Math.sin(t) * sit - this.r2 * Math.cos(t) * cot);
    }

    @Override
    public double curvature(double t) {
        if (!this.direct) {
            t = -t;
        }
        double cot = Math.cos(t);
        double sit = Math.sin(t);
        double k = this.r1 * this.r2 / Math.pow(Math.hypot(this.r2 * cot, this.r1 * sit), 3.0);
        return this.direct ? k : -k;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public LinearRing2D asPolyline(int n) {
        return this.asPolylineClosed(n);
    }

    @Override
    public boolean isBounded() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public double t0() {
        return 0.0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return Math.PI * 2;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        if (!this.direct) {
            t = -t;
        }
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        return new Point2D(this.xc + this.r1 * Math.cos(t) * cot - this.r2 * Math.sin(t) * sit, this.yc + this.r1 * Math.cos(t) * sit + this.r2 * Math.sin(t) * cot);
    }

    @Override
    public Point2D firstPoint() {
        return new Point2D(this.xc + this.r1 * Math.cos(this.theta), this.yc + this.r1 * Math.sin(this.theta));
    }

    @Override
    public Point2D lastPoint() {
        return new Point2D(this.xc + this.r1 * Math.cos(this.theta), this.yc + this.r1 * Math.sin(this.theta));
    }

    private Point2D toUnitCircle(Point2D point) {
        double xp = point.x();
        double yp = point.y();
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        double xp1 = (xp -= this.xc) * cot + (yp -= this.yc) * sit;
        double yp1 = -xp * sit + yp * cot;
        xp = xp1;
        yp = yp1;
        xp /= this.r1;
        yp /= this.r2;
        if (!this.direct) {
            yp = -yp;
        }
        return new Point2D(xp, yp);
    }

    @Override
    public double position(Point2D point) {
        Point2D p2 = this.toUnitCircle(point);
        double xp = p2.x();
        double yp = p2.y();
        double angle = Angle2D.horizontalAngle(xp, yp);
        if (Math.abs(Math.hypot(xp, yp) - 1.0) < 1.0E-12) {
            return angle;
        }
        return Double.NaN;
    }

    @Override
    public double project(Point2D point) {
        Point2D p2 = this.toUnitCircle(point);
        double xp = p2.x();
        double yp = p2.y();
        double angle = Angle2D.horizontalAngle(xp, yp);
        return angle;
    }

    @Override
    public Ellipse2D reverse() {
        return new Ellipse2D(this.xc, this.yc, this.r1, this.r2, this.theta, !this.direct);
    }

    public Collection<? extends Ellipse2D> continuousCurves() {
        return Ellipse2D.wrapCurve(this);
    }

    @Override
    public EllipseArc2D subCurve(double t0, double t1) {
        double extent;
        double startAngle;
        if (this.direct) {
            startAngle = t0;
            extent = Angle2D.formatAngle(t1 - t0);
        } else {
            extent = -Angle2D.formatAngle(t1 - t0);
            startAngle = Angle2D.formatAngle(-t0);
        }
        return new EllipseArc2D(this, startAngle, extent);
    }

    @Override
    public double distance(Point2D point) {
        return this.asPolyline(180).distance(point);
    }

    @Override
    public double distance(double x, double y) {
        return this.distance(new Point2D(x, y));
    }

    @Override
    public CurveSet2D<? extends SmoothOrientedCurve2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<AbstractSmoothCurve2D> result = new CurveArray2D<AbstractSmoothCurve2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (curve2D instanceof EllipseArc2D) {
                result.add((EllipseArc2D)curve2D);
            }
            if (!(curve2D instanceof Ellipse2D)) continue;
            result.add((Ellipse2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D boundingBox() {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        double xm = Math.hypot(this.r1 * cot, this.r2 * sit);
        double ym = Math.hypot(this.r1 * sit, this.r2 * cot);
        return new Box2D(this.xc - xm, this.xc + xm, this.yc - ym, this.yc + ym);
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        AffineTransform2D sca = AffineTransform2D.createScaling(this.r1, this.r2);
        AffineTransform2D rot = AffineTransform2D.createRotation(this.theta);
        AffineTransform2D tra = AffineTransform2D.createTranslation(this.xc, this.yc);
        Circle2D circle = new Circle2D(0.0, 0.0, 1.0);
        AffineTransform2D toUnit = sca.chain(rot).chain(tra).invert();
        LinearShape2D line2 = line.transform(toUnit);
        Collection<Point2D> points = circle.intersections(line2);
        if (points.size() == 0) {
            return points;
        }
        ArrayList<Point2D> res = new ArrayList<Point2D>(points.size());
        for (Point2D point : points) {
            res.add(this.point(circle.position(point)));
        }
        return res;
    }

    @Override
    public Ellipse2D transform(AffineTransform2D trans) {
        Ellipse2D result = Ellipse2D.transformCentered(this, trans);
        Point2D center = this.center().transform(trans);
        result.xc = center.x();
        result.yc = center.y();
        result.direct = !(this.direct ^ trans.isDirect());
        return result;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean contains(double x, double y) {
        return this.distance(x, y) < 1.0E-12;
    }

    public GeneralPath getGeneralPath() {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        GeneralPath path = new GeneralPath();
        path.moveTo((float)(this.xc + this.r1 * cot), (float)(this.yc + this.r1 * sit));
        return this.appendPath(path);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        double cot = Math.cos(this.theta);
        double sit = Math.sin(this.theta);
        if (this.direct) {
            double t = 0.1;
            while (t <= Math.PI * 2) {
                path.lineTo((float)(this.xc + this.r1 * Math.cos(t) * cot - this.r2 * Math.sin(t) * sit), (float)(this.yc + this.r2 * Math.sin(t) * cot + this.r1 * Math.cos(t) * sit));
                t += 0.1;
            }
        } else {
            double t = 0.1;
            while (t <= Math.PI * 2) {
                path.lineTo((float)(this.xc + this.r1 * Math.cos(t) * cot + this.r2 * Math.sin(t) * sit), (float)(this.yc - this.r2 * Math.sin(t) * cot + this.r1 * Math.cos(t) * sit));
                t += 0.1;
            }
        }
        path.lineTo((float)(this.xc + this.r1 * cot), (float)(this.yc + this.r1 * sit));
        return path;
    }

    @Override
    public void draw(Graphics2D g2) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double(this.xc - this.r1, this.yc - this.r2, 2.0 * this.r1, 2.0 * this.r2);
        AffineTransform trans = AffineTransform.getRotateInstance(this.theta, this.xc, this.yc);
        g2.draw(trans.createTransformedShape(ellipse));
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ellipse2D)) {
            return false;
        }
        Ellipse2D ell = (Ellipse2D)obj;
        if (!ell.center().almostEquals(this.center(), eps)) {
            return false;
        }
        if (Math.abs(ell.r1 - this.r1) > eps) {
            return false;
        }
        if (Math.abs(ell.r2 - this.r2) > eps) {
            return false;
        }
        if (!Angle2D.almostEquals(ell.angle(), this.angle(), eps)) {
            return false;
        }
        return ell.isDirect() == this.isDirect();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ellipse2D)) {
            return false;
        }
        Ellipse2D that = (Ellipse2D)obj;
        if (!EqualUtils.areEqual(this.xc, that.xc)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.yc, that.yc)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.r1, that.r1)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.r2, that.r2)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.theta, that.theta)) {
            return false;
        }
        return this.direct == that.direct;
    }

    @Override
    public Ellipse2D clone() {
        return new Ellipse2D(this.xc, this.yc, this.r1, this.r2, this.theta, this.direct);
    }

    public String toString() {
        return String.format("Ellipse2D(%f,%f,%f,%f,%f,%s)", this.xc, this.yc, this.r1, this.r2, this.theta, this.direct ? "true" : "false");
    }
}

