/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import ch.epfl.biop.CirclesBasedSpine;
import fiji.process3d.EDT;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.plugin.filter.MaximumFinder;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class MaxInscribedCircles {
    private ImagePlus imp;
    private double minimumDiameter;
    private double spineClosenessTolerance;
    private double spineMinimumSimilarity;
    private boolean getSpine;
    private boolean useSelectionOnly;
    private boolean appendPositionToName;
    private List<Roi> circles;
    private List<Roi> spines;
    private List<Roi> spineParts;

    MaxInscribedCircles() {
    }

    public static Builder builder(ImagePlus imp) {
        return new Builder(imp);
    }

    public void process() {
        this.circles = new ArrayList<Roi>();
        this.spines = new ArrayList<Roi>();
        this.spineParts = new ArrayList<Roi>();
        int nSlices = this.imp.getStackSize();
        int start = this.useSelectionOnly ? this.imp.getCurrentSlice() : 1;
        int end = this.useSelectionOnly ? this.imp.getCurrentSlice() : nSlices;
        Roi roi = this.useSelectionOnly ? this.imp.getRoi() : null;
        for (int i = start; i <= end; ++i) {
            IJ.log((String)("Processing Slice " + i + " of " + nSlices));
            ImagePlus tmpImp = new ImagePlus(this.imp.getTitle() + " - Slice " + i, this.imp.getStack().getProcessor(i));
            tmpImp.setRoi(roi);
            List<Roi> circles = MaxInscribedCircles.findCircles(tmpImp, this.minimumDiameter, this.useSelectionOnly);
            for (Roi r : circles) {
                r.setPosition(i);
                if (!this.appendPositionToName) continue;
                r.setName(r.getName() + "-P_" + i);
            }
            if (circles.size() == 0) {
                IJ.log((String)"No circles found, consider decreasing 'Minimum Circle Diameter'.");
            }
            this.circles.addAll(circles);
            if (this.getSpine && circles.size() == 1) {
                IJ.log((String)"A single circle was found. Spine cannot be computed, consider decreasing 'Minimum Circle Diameter'.");
            }
            if (!this.getSpine || circles.size() <= 1) continue;
            CirclesBasedSpine sbs = new CirclesBasedSpine.Settings(tmpImp).circles(circles).closenessTolerance(this.spineClosenessTolerance).minSimilarity(this.spineMinimumSimilarity).showCircles(false).build();
            PolygonRoi spine = sbs.getSpine();
            if (spine != null) {
                spine.setPosition(i);
                if (this.appendPositionToName) {
                    spine.setName(spine.getName() + "-P_" + i);
                }
                Overlay ov = tmpImp.getOverlay();
                for (Roi r : ov) {
                    if (this.appendPositionToName) {
                        r.setName(r.getName() + "-P_" + i);
                    }
                    r.setPosition(i);
                    this.spineParts.add(r);
                }
                this.spines.add((Roi)spine);
                continue;
            }
            IJ.log((String)"No spine found");
        }
    }

    public List<Roi> getCircles() {
        return this.circles;
    }

    public List<Roi> getSpines() {
        return this.spines;
    }

    public List<Roi> getSpineParts() {
        return this.spineParts;
    }

    public static List<Roi> findCircles(ImagePlus imp, double minD, boolean isSelectionOnly) {
        ImageProcessor ip;
        int offsetY;
        int offsetX;
        IJ.showStatus((String)"Finding Largest Inscribed Circles based on Distance Map...");
        ArrayList<Roi> allrois = new ArrayList<Roi>();
        Roi sel = imp.getRoi();
        if (sel != null && sel.isArea()) {
            ImageProcessor iptmp;
            offsetX = sel.getBounds().x;
            offsetY = sel.getBounds().y;
            if (isSelectionOnly) {
                iptmp = sel.getMask().resize(sel.getPolygon().getBounds().width * 2);
            } else {
                iptmp = imp.getProcessor().resize(sel.getPolygon().getBounds().width * 2);
                sel.setLocation(offsetX, offsetY);
            }
            ip = new ByteProcessor(iptmp.getWidth() + 4, iptmp.getHeight() + 4);
            ip.copyBits(iptmp, 2, 2, 3);
            --offsetX;
            --offsetY;
        } else {
            ip = imp.getProcessor().resize(imp.getWidth() * 2);
            offsetX = 0;
            offsetY = 0;
        }
        ImageStack tmpstk = new ImageStack(ip.getWidth(), ip.getHeight());
        tmpstk.addSlice(ip);
        EDT edt = new EDT();
        boolean done = false;
        while (!done) {
            MaximumFinder mf = new MaximumFinder();
            ImageProcessor dist_map_ip = edt.compute(tmpstk).getProcessor();
            Polygon points = mf.getMaxima(dist_map_ip, 1.0, false);
            ArrayList<Point2D.Double> hits = MaxInscribedCircles.getSortedPoints(points, minD, dist_map_ip);
            done = true;
            for (int k = 0; k < hits.size(); ++k) {
                boolean is_draw = true;
                Point2D.Double p = hits.get(k);
                double r = dist_map_ip.getInterpolatedValue(p.x, p.y);
                ArrayList<Point2D.Double> neigh = MaxInscribedCircles.findNeighbors(p, hits, dist_map_ip);
                if (neigh.size() > 1) {
                    for (Point2D.Double pp : neigh) {
                        double r2 = dist_map_ip.getInterpolatedValue(pp.x, pp.y);
                        if (!(r < r2)) continue;
                        is_draw = false;
                        break;
                    }
                }
                if (is_draw) {
                    double posx = p.x - r;
                    double posy = p.y - r;
                    OvalRoi circ = new OvalRoi(posx, posy, r * 2.0, r * 2.0);
                    ip.fill((Roi)circ);
                    posx = (p.x - r) / 2.0;
                    posy = (p.y - r) / 2.0;
                    circ = new OvalRoi(posx, posy, r, r);
                    circ.setName(String.format("Circle-r_%.3f", r));
                    circ.setStrokeWidth(1.0f);
                    circ.setLocation(posx + (double)offsetX, posy + (double)offsetY);
                    allrois.add((Roi)circ);
                    done = false;
                }
                if (minD != 0.0) continue;
                return allrois;
            }
        }
        IJ.showStatus((String)"Done...");
        return allrois;
    }

    private static ArrayList<Point2D.Double> getSortedPoints(Polygon points, double minD, ImageProcessor ip) {
        int ind;
        ArrayList<Point2D.Double> hits = new ArrayList<Point2D.Double>(points.npoints);
        List<Point2D.Double> tmpList = new ArrayList<Point2D.Double>(points.npoints);
        for (ind = 0; ind < points.npoints; ++ind) {
            double r = ip.getInterpolatedValue((double)points.xpoints[ind], (double)points.ypoints[ind]);
            if (!(r > minD)) continue;
            hits.add(new Point2D.Double(points.xpoints[ind], points.ypoints[ind]));
        }
        hits.sort((p1, p2) -> Double.compare(ip.getInterpolatedValue(p2.x, p2.y), ip.getInterpolatedValue(p1.x, p1.y)));
        ind = 0;
        for (int i = 1; i < hits.size(); ++i) {
            Point2D.Double p = (Point2D.Double)hits.get(i);
            if (!(ip.getInterpolatedValue(p.x, p.y) < ip.getInterpolatedValue(((Point2D.Double)hits.get((int)0)).x, ((Point2D.Double)hits.get((int)0)).y))) continue;
            ind = i;
            break;
        }
        tmpList.addAll(hits);
        if (ind > 0) {
            tmpList = hits.subList(0, ind);
        }
        return new ArrayList<Point2D.Double>(tmpList);
    }

    public static ArrayList<Point2D.Double> findNeighbors(Point2D.Double p, ArrayList<Point2D.Double> hits, ImageProcessor ip) {
        ArrayList<Point2D.Double> neighbors = new ArrayList<Point2D.Double>();
        double r = ip.getInterpolatedValue(p.x, p.y);
        for (Point2D.Double k : hits) {
            double r2;
            double dist = p.distance(k);
            if (!(dist < r + (r2 = ip.getInterpolatedValue(k.x, k.y)))) continue;
            neighbors.add(k);
        }
        return neighbors;
    }

    public static class Builder {
        private final ImagePlus imp;
        private double minimumDiameter = 10.0;
        private double spineClosenessTolerance = 10.0;
        private double spineMinimumSimilarity = 0.5;
        private boolean useSelectionOnly = false;
        private boolean getSpine = false;
        private boolean appendPositionToName = true;

        Builder(ImagePlus imp) {
            this.imp = imp;
        }

        public Builder minimumDiameter(double minimumDiameter) {
            if (minimumDiameter == 0.0) {
                IJ.log((String)"Minimum diameter is 0, returning largest circle only");
            }
            this.minimumDiameter = minimumDiameter;
            return this;
        }

        public Builder useSelectionOnly(boolean useSelectionOnly) {
            if (this.imp.getRoi() == null) {
                IJ.log((String)"No selection found, using mask instead");
                useSelectionOnly = false;
            }
            this.useSelectionOnly = useSelectionOnly;
            return this;
        }

        public Builder appendPositionToName(boolean appendPositionToName) {
            this.appendPositionToName = appendPositionToName;
            return this;
        }

        public Builder spineClosenessTolerance(double closenessTolerance) {
            if (closenessTolerance < 1.0) {
                throw new IllegalArgumentException("Closeness tolerance must be larger than 1 pixel");
            }
            this.spineClosenessTolerance = closenessTolerance;
            return this;
        }

        public Builder spineMinimumSimilarity(double minimumSimilarity) {
            this.spineMinimumSimilarity = minimumSimilarity;
            return this;
        }

        public Builder getSpine(boolean getSpine) {
            this.getSpine = getSpine;
            return this;
        }

        public MaxInscribedCircles build() {
            MaxInscribedCircles mic = new MaxInscribedCircles();
            mic.imp = this.imp;
            mic.minimumDiameter = this.minimumDiameter;
            mic.spineClosenessTolerance = this.spineClosenessTolerance;
            mic.spineMinimumSimilarity = this.spineMinimumSimilarity;
            mic.getSpine = this.getSpine;
            mic.useSelectionOnly = this.useSelectionOnly;
            mic.appendPositionToName = this.appendPositionToName;
            return mic;
        }
    }
}

