/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import ch.epfl.biop.MaxInscribedCircles;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.ResultsTable;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class CirclesBasedSpine {
    private Overlay ov = new Overlay();
    private ImagePlus imp;
    private int minCircleDiameter;
    private PolygonRoi spine = null;
    private Boolean isShowCircles;
    private double minSimilarity = 0.5;
    private double closenessTolerance = 10.0;
    private List<Roi> circles = null;

    public CirclesBasedSpine(Settings settings) {
        this.imp = settings.image;
        this.minCircleDiameter = settings.minCircleDiameter;
        this.isShowCircles = settings.isShowCircles;
        this.minSimilarity = settings.minSimilarity;
        this.closenessTolerance = settings.closenessTolerance;
        this.circles = settings.circles;
    }

    public PolygonRoi getSpine() {
        List<Roi> adjCircles;
        Roi circle2;
        if (this.circles.isEmpty()) {
            this.circles = MaxInscribedCircles.findCircles(this.imp, this.minCircleDiameter, false);
        }
        if (this.isShowCircles.booleanValue()) {
            for (Roi circle2 : this.circles) {
                this.ov.add(circle2);
            }
        }
        if ((adjCircles = this.getAdjacentCircles(this.circles, circle2 = this.circles.get(0), this.imp)).size() < 1) {
            IJ.log((String)"Error: No Adjacent Circles found. Consider decreasing 'Minimum Circle Diameter' or increasing 'Closeness Tolerance'");
            return null;
        }
        Roi circleB = Collections.max(adjCircles, Comparator.comparing(c -> c.getFloatWidth()));
        Point2D pointA = this.getCentroid(circle2);
        Point2D pointB = this.getCentroid(circleB);
        this.ov.add((Roi)this.makeLine(circle2, circleB, new Color(128, 255, 128)));
        List<Point2D> spineB = this.iterateSpine(this.circles, circleB, circle2);
        Collections.reverse(spineB);
        spineB.add(pointA);
        spineB.add(pointB);
        spineB.addAll(this.iterateSpine(this.circles, circle2, circleB));
        float[] xPoints = this.toFloatArray(spineB.stream().mapToDouble(m -> m.getX()).toArray());
        float[] yPoints = this.toFloatArray(spineB.stream().mapToDouble(m -> m.getY()).toArray());
        this.spine = new PolygonRoi(xPoints, yPoints, 6);
        int pos = circle2.getPosition();
        this.spine.setName("Spine");
        return this.spine;
    }

    private Point2D getCentroid(Roi circle) {
        double[] c = circle.getContourCentroid();
        Point2D.Double centroid = new Point2D.Double(c[0], c[1]);
        return centroid;
    }

    float[] toFloatArray(double[] arr) {
        if (arr == null) {
            return null;
        }
        int n = arr.length;
        float[] ret = new float[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = (float)arr[i];
        }
        return ret;
    }

    List<Point2D> iterateSpine(List<Roi> circles, Roi circleA, Roi circleB) {
        Boolean done = false;
        ArrayList<Point2D> spinePoints = new ArrayList<Point2D>();
        while (!done.booleanValue()) {
            circles.remove(circleA);
            Point2D vectorA = this.getVector(circleA, circleB);
            Roi finalCircleB = circleB;
            List theCircles = this.getAdjacentCircles(circles, circleB, this.imp).stream().filter(c -> {
                Point2D vectorB = this.getVector(finalCircleB, (Roi)c);
                return this.similarity(vectorA, vectorB) > this.minSimilarity;
            }).collect(Collectors.toList());
            if (!theCircles.isEmpty()) {
                Roi circleC = Collections.max(theCircles, Comparator.comparing(c -> c.getFloatWidth()));
                Line line = this.makeLine(circleB, circleC, new Color(128, 255, 128));
                this.ov.add((Roi)line);
                spinePoints.add(this.getCentroid(circleC));
                circles.remove(circleB);
                circleA = circleB;
                circleB = circleC;
                continue;
            }
            done = true;
            Line line = this.makeEndLine(circleB, vectorA);
            this.ov.add((Roi)line);
            spinePoints.add(new Point2D.Double(line.getFloatPolygon().xpoints[2], line.getFloatPolygon().ypoints[2]));
        }
        this.imp.setOverlay(this.ov);
        return spinePoints;
    }

    ResultsTable getSpineResults() {
        ResultsTable rt = ResultsTable.getResultsTable() == null ? new ResultsTable() : ResultsTable.getResultsTable();
        double length = this.spine.getLength();
        double width = this.circles.get(0).getFloatWidth();
        rt.incrementCounter();
        rt.addLabel(this.imp.getTitle());
        rt.addValue("Length", length);
        rt.addValue("Width", this.imp.getCalibration().getX(width));
        rt.show("Results");
        return rt;
    }

    Roi addToOverlay(Roi roi) {
        Roi nRoi = (Roi)roi.clone();
        nRoi.setStrokeColor(new Color(255, 0, 0));
        nRoi.setStrokeWidth(3.0f);
        return nRoi;
    }

    List<Roi> getAdjacentCircles(List<Roi> circles, Roi circle, ImagePlus imp) {
        double r0 = circle.getFloatWidth() / 2.0;
        Point2D c0 = this.getCentroid(circle);
        List<Roi> adjacent = circles.stream().filter(c -> {
            double r1 = c.getFloatWidth() / 2.0;
            Point2D c1 = this.getCentroid((Roi)c);
            return c1.distance(c0) < r1 + r0 + this.closenessTolerance && c1.distance(c0) > 0.0 && this.allLineInMask(c0, c1, imp);
        }).collect(Collectors.toList());
        return adjacent;
    }

    Point2D getVector(Roi circleA, Roi circleB) {
        Point2D A = this.getCentroid(circleA);
        Point2D B = this.getCentroid(circleB);
        Point2D.Double C = new Point2D.Double(B.getX() - A.getX(), B.getY() - A.getY());
        return C;
    }

    Line makeLine(Roi circleA, Roi circleB, Color color) {
        Point2D ca = this.getCentroid(circleA);
        Point2D cb = this.getCentroid(circleB);
        Line line = new Line(ca.getX(), ca.getY(), cb.getX(), cb.getY());
        line.setStrokeColor(color);
        line.setStrokeWidth(2.0f);
        line.setPosition(circleA.getPosition());
        line.setName("SpinePart");
        return line;
    }

    Line makeEndLine(Roi circle, Point2D vector) {
        Point2D c1 = this.getCentroid(circle);
        double r1 = circle.getFloatWidth() / 2.0;
        double magnitude = vector.distance(0.0, 0.0);
        Point2D.Double c2 = new Point2D.Double(c1.getX() + r1 * vector.getX() / magnitude, c1.getY() + r1 * vector.getY() / magnitude);
        Boolean inMask = this.imp.getProcessor().getf((int)Math.round(((Point2D)c2).getX()), (int)Math.round(((Point2D)c2).getY())) == 255.0f;
        int i = 1;
        while (inMask.booleanValue()) {
            c2 = new Point2D.Double(c1.getX() + (r1 + (double)i) * vector.getX() / magnitude, c1.getY() + (r1 + (double)i) * vector.getY() / magnitude);
            inMask = this.imp.getProcessor().getf((int)Math.round(((Point2D)c2).getX()), (int)Math.round(((Point2D)c2).getY())) == 255.0f;
            ++i;
        }
        OvalRoi c = new OvalRoi(((Point2D)c2).getX() - 10.0, ((Point2D)c2).getY() - 10.0, 20.0, 20.0);
        return this.makeLine(circle, (Roi)c, new Color(255, 0, 0));
    }

    double similarity(Point2D p1, Point2D p2) {
        return (p1.getX() * p2.getX() + p1.getY() * p2.getY()) / (Math.sqrt(p1.getX() * p1.getX() + p1.getY() * p1.getY()) * Math.sqrt(p2.getX() * p2.getX() + p2.getY() * p2.getY()));
    }

    boolean allLineInMask(Point2D c0, Point2D c1, ImagePlus imp) {
        double[] values = imp.getProcessor().getLine(c0.getX(), c0.getY(), c1.getX(), c1.getY());
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == 255.0) continue;
            return false;
        }
        return true;
    }

    public static class Settings {
        private final ImagePlus image;
        private int minCircleDiameter = 10;
        private Boolean isShowCircles = false;
        private double minSimilarity = 0.5;
        private double closenessTolerance = 10.0;
        private List<Roi> circles = new ArrayList<Roi>();

        public Settings(ImagePlus image) {
            this.image = image;
        }

        public Settings minCircleDiameter(int circleD) {
            this.minCircleDiameter = circleD;
            return this;
        }

        public Settings showCircles(Boolean showCircles) {
            this.isShowCircles = showCircles;
            return this;
        }

        public Settings minSimilarity(double similarity) {
            this.minSimilarity = similarity;
            return this;
        }

        public Settings closenessTolerance(double tol) {
            this.closenessTolerance = tol;
            return this;
        }

        public Settings circles(List<Roi> circles) {
            this.circles = circles;
            return this;
        }

        public CirclesBasedSpine build() {
            return new CirclesBasedSpine(this);
        }
    }
}

