/*
 * Decompiled with CFR 0.152.
 */
import ch.epfl.biop.MaxInscribedCircles;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import java.util.List;
import net.imagej.ImageJ;

public class Max_Inscribed_Circles
implements PlugIn {
    private boolean isSelectionOnly;
    private boolean isGetSpine;
    private double minSimilarity = 0.5;
    private double closenessTolerance = 10.0;
    private double minDiameter;
    private boolean appendPositionToName = false;

    public void run(String arg) {
        this.getParameters();
        ImagePlus imp = IJ.getImage();
        if (!imp.getProcessor().isBinary() && imp.getRoi() == null) {
            IJ.error((String)"Need selection or a binary image!");
        }
        this.showDialog();
        this.setParameters();
        RoiManager rm = RoiManager.getInstance();
        if (rm == null) {
            rm = new RoiManager();
        }
        rm.setVisible(true);
        Overlay finalOverlay = new Overlay();
        MaxInscribedCircles mic = MaxInscribedCircles.builder(imp).minimumDiameter(this.minDiameter).useSelectionOnly(this.isSelectionOnly).getSpine(this.isGetSpine).spineClosenessTolerance(this.closenessTolerance).spineMinimumSimilarity(this.minSimilarity).appendPositionToName(this.appendPositionToName).build();
        mic.process();
        List<Roi> rois = mic.getCircles();
        List<Roi> spines = mic.getSpines();
        List<Roi> spineParts = mic.getSpineParts();
        for (Roi roi : rois) {
            rm.addRoi(roi);
        }
        for (Roi roi : spines) {
            rm.addRoi(roi);
        }
        for (Roi roi : spineParts) {
            finalOverlay.add(roi);
        }
        imp.setOverlay(finalOverlay);
    }

    private void showDialog() {
        GenericDialog gd = new GenericDialog("Find Largest Circles");
        gd.addNumericField("Minimum_Disk Diameter (px)", this.minDiameter, 1);
        gd.addMessage("Set to 0 to get only the largest inscribed circle");
        gd.addCheckbox("Use selection instead of mask", this.isSelectionOnly);
        gd.addCheckbox("Get Spine", this.isGetSpine);
        gd.addMessage("Spine Detection Settings");
        gd.addNumericField("Minimum_Similarity", 0.5, 2);
        gd.addNumericField("Closeness Tolerance", 5.0, 0);
        gd.addCheckbox("Append Position to ROI Name", this.appendPositionToName);
        gd.showDialog();
        if (!gd.wasCanceled()) {
            this.minDiameter = gd.getNextNumber();
            this.isSelectionOnly = gd.getNextBoolean();
            this.isGetSpine = gd.getNextBoolean();
            this.minSimilarity = gd.getNextNumber();
            this.closenessTolerance = gd.getNextNumber();
            this.appendPositionToName = gd.getNextBoolean();
        }
    }

    private void getParameters() {
        this.minDiameter = Prefs.get((String)"biop.max.inscribed.minDiameter", (double)this.minDiameter);
        this.isSelectionOnly = Prefs.get((String)"biop.max.inscribed.isSelOnly", (boolean)this.isSelectionOnly);
        this.isGetSpine = Prefs.get((String)"biop.max.inscribed.isGetSpine", (boolean)this.isGetSpine);
        this.minSimilarity = Prefs.get((String)"biop.max.inscribed.minSimilarity", (double)this.minSimilarity);
        this.closenessTolerance = Prefs.get((String)"biop.max.inscribed.closenessTolerance", (double)this.closenessTolerance);
        this.appendPositionToName = Prefs.get((String)"biop.max.inscribed.isAddName", (boolean)this.appendPositionToName);
    }

    private void setParameters() {
        Prefs.set((String)"biop.max.inscribed.minDiameter", (double)this.minDiameter);
        Prefs.set((String)"biop.max.inscribed.isSelOnly", (boolean)this.isSelectionOnly);
        Prefs.set((String)"biop.max.inscribed.isGetSpine", (boolean)this.isGetSpine);
        Prefs.set((String)"biop.max.inscribed.minSimilarity", (double)this.minSimilarity);
        Prefs.set((String)"biop.max.inscribed.closenessTolerance", (double)this.closenessTolerance);
        Prefs.set((String)"biop.max.inscribed.isAddName", (boolean)this.appendPositionToName);
    }

    public static void main(String[] args) {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        ImagePlus imp = IJ.createImage((String)"Untitled", (String)"8-bit black", (int)256, (int)256, (int)1);
        imp.setRoi(45, 59, 70, 88);
        IJ.setForegroundColor((int)255, (int)255, (int)255);
        IJ.run((ImagePlus)imp, (String)"Fill", (String)"slice");
        imp.setRoi((Roi)new OvalRoi(156, 68, 54, 95));
        IJ.run((ImagePlus)imp, (String)"Fill", (String)"slice");
        imp.show();
    }
}

