/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.ij2command;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.Duplicator;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.imagej.ImageJ;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Image Analysis>ROIs>ROIs to Measurement Image")
public class Rois2MeasurementMap
implements Command {
    @Parameter
    ImagePlus imp;
    @Parameter
    RoiManager rm;
    @Parameter(label="Measure", choices={"Area", "Angle", "AngleVert", "AR", "Circ.", "Major", "Minor", "Mean", "Median", "Mode", "Min", "Max", "Perim.", "Pattern", "xCenterOfMass", "yCenterOfMass"})
    String column_name;
    @Parameter(label="If Pattern, please specify a regex capture group,\n(will take first group, must be numerical, 'Track-(\\d*):.*' )", required=false)
    String pattern = "Track-(\\d*):.*";
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus results_imp;

    public void run() {
        this.results_imp = this.R2M(this.imp);
    }

    private ImagePlus R2M(ImagePlus imp) {
        ImagePlus imp2 = imp.duplicate();
        if (imp.getBitDepth() == 32) {
            IJ.run((ImagePlus)imp2, (String)"16-bit", (String)"");
        }
        int stackN = imp2.getImageStackSize();
        boolean isStack = false;
        if (stackN > 1) {
            isStack = true;
        }
        for (int i = 0; i < stackN; ++i) {
            imp2.getStack().getProcessor(i + 1).setValue(0.0);
            imp2.getStack().getProcessor(i + 1).fill();
        }
        IJ.run((ImagePlus)imp2, (String)"32-bit", (String)"");
        Roi[] rois = this.rm.getRoisAsArray();
        for (int i = 0; i < rois.length; ++i) {
            double filling_value = 0.0;
            if (isStack) {
                imp.setPosition(rois[i].getPosition());
                imp2.setPosition(rois[i].getPosition());
            }
            ImageProcessor ip = imp.getProcessor();
            ip.setRoi(rois[i]);
            ImageProcessor ip2 = imp2.getProcessor();
            ip2.setRoi(rois[i]);
            ImageStatistics ip_stats = ip.getStatistics();
            switch (this.column_name) {
                case "Area": {
                    filling_value = ip_stats.area;
                    break;
                }
                case "Angle": {
                    filling_value = ip_stats.angle;
                    break;
                }
                case "AngleVert": {
                    filling_value = ip_stats.angle - 90.0;
                    break;
                }
                case "AR": {
                    filling_value = ip_stats.major / ip_stats.minor;
                    break;
                }
                case "Circ.": {
                    filling_value = Math.PI * 4 * ip_stats.area / Math.pow(rois[i].getLength(), 2.0);
                    break;
                }
                case "Major": {
                    filling_value = ip_stats.major;
                    break;
                }
                case "Minor": {
                    filling_value = ip_stats.minor;
                    break;
                }
                case "Mean": {
                    filling_value = ip_stats.mean;
                    break;
                }
                case "Median": {
                    filling_value = ip_stats.median;
                    break;
                }
                case "Mode": {
                    filling_value = ip_stats.dmode;
                    break;
                }
                case "Min": {
                    filling_value = ip_stats.min;
                    break;
                }
                case "Max": {
                    filling_value = ip_stats.max;
                    break;
                }
                case "Perim.": {
                    filling_value = rois[i].getLength();
                    break;
                }
                case "Pattern": {
                    String roi_name = rois[i].getName();
                    Pattern r = Pattern.compile(this.pattern);
                    Matcher m = r.matcher(roi_name);
                    if (!m.find()) break;
                    String group = m.group(1);
                    try {
                        filling_value = Float.parseFloat(group);
                    }
                    catch (Exception e) {
                        System.err.println("Issue with your pattern! Can't get a numerical value from it");
                        e.printStackTrace();
                        filling_value = 0.0;
                    }
                    break;
                }
                case "xCenterOfMass": {
                    filling_value = ip_stats.xCenterOfMass;
                    break;
                }
                case "yCenterOfMass": {
                    filling_value = ip_stats.yCenterOfMass;
                }
            }
            ip2.setValue(filling_value);
            ip2.fill(rois[i]);
            imp2.setProcessor(ip2);
        }
        imp2.setTitle(this.column_name + "_Image");
        imp2.setRoi(0, 0, imp2.getWidth(), imp2.getHeight());
        return imp2;
    }

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        RoiManager rm = RoiManager.getRoiManager();
        Boolean test_with_single_image = false;
        ImagePlus imp = new ImagePlus();
        if (test_with_single_image.booleanValue()) {
            imp = IJ.openImage((String)"http://imagej.nih.gov/ij/images/blobs.gif");
            imp.show();
            IJ.run((ImagePlus)imp, (String)"Invert LUT", (String)"");
            IJ.setAutoThreshold((ImagePlus)imp, (String)"Default dark");
            IJ.run((ImagePlus)imp, (String)"Analyze Particles...", (String)"  show=Nothing add");
        } else {
            ImagePlus stk_imp = IJ.openImage((String)"http://wsr.imagej.net/images/confocal-series.zip");
            imp = new Duplicator().run(stk_imp, 1, 1, 1, stk_imp.getNSlices(), 1, 1);
            IJ.run((ImagePlus)imp, (String)"Median...", (String)"radius=2 stack");
            imp.show();
            IJ.setAutoThreshold((ImagePlus)imp, (String)"Default dark");
            IJ.run((ImagePlus)imp, (String)"Convert to Mask", (String)"method=Default background=Dark calculate black");
            IJ.run((ImagePlus)imp, (String)"Analyze Particles...", (String)"  show=Nothing add stack");
        }
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Area", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Angle", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "AngleVert", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "AR", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Circ.", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Major", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Minor", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Mean", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Median", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Mode", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Min", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Max", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "Perim.", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "xCenterOfMass", "pattern", ""}).get();
        ij.command().run(Rois2MeasurementMap.class, true, new Object[]{"column_name", "yCenterOfMass", "pattern", ""}).get();
        IJ.run((String)"Tile", (String)"");
    }
}

