/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.ij2command;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.Duplicator;
import ij.plugin.frame.RoiManager;
import net.imagej.ImageJ;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Image Analysis>ROIs>ROIs to Label image")
public class Rois2Labels
implements Command {
    @Parameter
    ImagePlus imp;
    @Parameter
    RoiManager rm;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus label_imp;

    public void run() {
        int[] dimensions = this.imp.getDimensions();
        int nChannels = dimensions[2];
        int nSlices = dimensions[3];
        int nFrames = dimensions[4];
        if (nChannels > 1 && nSlices > 1 || nChannels > 1 && nFrames > 1 || nSlices > 1 && nFrames > 1) {
            System.err.println("" + this.imp.getTitle() + " is a hyperstack (multi c , z or t), please prepare a stack (single c, either z-stack or t-stack) from it.");
            return;
        }
        this.label_imp = this.R2L(this.imp);
    }

    private ImagePlus R2L(ImagePlus imp) {
        int i;
        ImagePlus label_imp = imp.duplicate();
        Roi[] rois = this.rm.getRoisAsArray();
        int stackN = label_imp.getImageStackSize();
        boolean isStack = false;
        if (stackN > 1) {
            isStack = true;
        }
        if (rois.length < 255) {
            IJ.run((ImagePlus)label_imp, (String)"8-bit", (String)"");
        } else if (rois.length > 255 && rois.length < 65535) {
            IJ.run((ImagePlus)label_imp, (String)"16-bit", (String)"");
        } else {
            IJ.run((ImagePlus)label_imp, (String)"32-bit", (String)"");
        }
        for (i = 0; i < stackN; ++i) {
            label_imp.getStack().getProcessor(i + 1).setValue(0.0);
            label_imp.getStack().getProcessor(i + 1).fill();
        }
        for (i = 0; i < rois.length; ++i) {
            if (isStack) {
                label_imp.setPosition(rois[i].getPosition());
            }
            label_imp.getProcessor().setValue((double)(i + 1));
            label_imp.getProcessor().fill(rois[i]);
        }
        label_imp.setTitle("ROIs2Label_" + imp.getTitle());
        return label_imp;
    }

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        Boolean test_with_single_image = true;
        if (test_with_single_image.booleanValue()) {
            ImagePlus imp = IJ.openImage((String)"http://imagej.nih.gov/ij/images/blobs.gif");
            imp.show();
            IJ.setAutoThreshold((ImagePlus)imp, (String)"Default");
            IJ.run((ImagePlus)imp, (String)"Analyze Particles...", (String)"  show=Nothing add");
        } else {
            ImagePlus stk_imp = IJ.openImage((String)"http://wsr.imagej.net/images/confocal-series.zip");
            ImagePlus c1_imp = new Duplicator().run(stk_imp, 1, 1, 1, stk_imp.getNSlices(), 1, 1);
            c1_imp.show();
            IJ.setAutoThreshold((ImagePlus)c1_imp, (String)"Default dark");
            IJ.run((ImagePlus)c1_imp, (String)"Analyze Particles...", (String)"  show=Nothing add stack");
        }
        ij.command().run(Rois2Labels.class, true, new Object[0]);
    }
}

