/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.ij2command;

import ch.epfl.biop.ij2command.Labels2CompositeRois;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.Wand;
import ij.plugin.Duplicator;
import ij.plugin.frame.RoiManager;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.util.ArrayList;
import java.util.stream.IntStream;
import net.imagej.ImageJ;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Image Analysis>ROIs>Label image to ROIs")
public class Labels2Rois
implements Command {
    @Parameter
    ImagePlus imp;
    @Parameter
    RoiManager rm;
    ArrayList<Roi> rois;

    public void run() {
        ImagePlus copy = this.imp.duplicate();
        this.rm.reset();
        this.rois = new ArrayList();
        int[] dimensions = copy.getDimensions();
        int nChannels = dimensions[2];
        int nSlices = dimensions[3];
        int nFrames = dimensions[4];
        if (copy.isRGB()) {
            System.out.println("" + copy.getTitle() + " is an RGB image. Labels might be inconsistent. Check the results to ensure they are what you expect.");
        }
        if (nChannels > 1 && nSlices > 1 || nChannels > 1 && nFrames > 1 || nSlices > 1 && nFrames > 1) {
            System.err.println("" + copy.getTitle() + " is a hyperstack (multi c , z or t), please prepare a stack (single c, either z-stack or t-stack) from it.");
            return;
        }
        for (int i = 0; i < copy.getImageStackSize(); ++i) {
            ImageProcessor ip = copy.getImageStack().getProcessor(i + 1);
            this.L2R(ip, i + 1);
        }
        for (Roi r : this.rois) {
            this.rm.add((ImagePlus)null, r, -1);
        }
    }

    private void L2R(ImageProcessor ip, int position) {
        if (ip instanceof ColorProcessor) {
            ip = Labels2CompositeRois.getRGBPixels((ColorProcessor)ip);
        }
        Wand wand = new Wand(ip);
        int width = ip.getWidth();
        int height = ip.getHeight();
        int[] pixel_width = new int[width];
        int[] pixel_height = new int[height];
        IntStream.range(0, width - 1).forEach(val -> {
            pixel_width[val] = val;
        });
        IntStream.range(0, height - 1).forEach(val -> {
            pixel_height[val] = val;
        });
        ip.setColor(0);
        for (int y_coord : pixel_height) {
            for (int x_coord : pixel_width) {
                float val2 = ip.getf(x_coord, y_coord);
                if (!((double)val2 > 0.0)) continue;
                wand.autoOutline(x_coord, y_coord, (double)val2, (double)val2);
                if (wand.npoints <= 0) continue;
                PolygonRoi roi = new PolygonRoi(wand.xpoints, wand.ypoints, wand.npoints, 3);
                roi.setPosition(position);
                String roiName = String.format("%04d", position) + " - ID " + String.format("%04d", new Float(val2).intValue());
                roi.setName(roiName);
                this.rois.add((Roi)roi);
                ip.fill((Roi)roi);
            }
        }
    }

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        Boolean test_with_single_image = false;
        if (test_with_single_image.booleanValue()) {
            ImagePlus imp = IJ.openImage((String)"http://imagej.nih.gov/ij/images/blobs.gif");
            imp.show();
            IJ.setAutoThreshold((ImagePlus)imp, (String)"Default");
            IJ.run((ImagePlus)imp, (String)"Analyze Particles...", (String)"  show=[Count Masks]");
        } else {
            ImagePlus stk_imp = IJ.openImage((String)"http://wsr.imagej.net/images/confocal-series.zip");
            ImagePlus c1_imp = new Duplicator().run(stk_imp, 1, 1, 1, stk_imp.getNSlices(), 1, 1);
            IJ.run((ImagePlus)c1_imp, (String)"Median...", (String)"radius=2 stack");
            c1_imp.show();
            IJ.setAutoThreshold((ImagePlus)c1_imp, (String)"Default dark");
            IJ.run((ImagePlus)c1_imp, (String)"Convert to Mask", (String)"method=Default background=Dark calculate black");
            IJ.run((ImagePlus)c1_imp, (String)"Analyze Particles...", (String)"  show=[Count Masks] stack");
        }
        ij.command().run(Labels2Rois.class, true, new Object[0]);
    }
}

