/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.ij2command;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.filter.ThresholdToSelection;
import ij.plugin.frame.RoiManager;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.ImageJ;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type=Command.class, menuPath="Plugins>BIOP>Image Analysis>ROIs>Label image to composite ROIs")
public class Labels2CompositeRois
implements Command {
    @Parameter
    ImagePlus imp;
    @Parameter
    RoiManager rm;
    private static Logger log = LoggerFactory.getLogger(Labels2CompositeRois.class);

    public static void main(String ... args) throws Exception {
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
    }

    public void run() {
        long start = System.currentTimeMillis();
        DecimalFormat df = new DecimalFormat("#.##");
        this.rm.reset();
        if (this.imp.getNDimensions() > 3) {
            log.error(this.imp.getTitle() + " is a hyperstack (multi c , z or t), please prepare a stack (single c, either z-stack or t-stack) from it.");
            return;
        }
        if (this.imp.isRGB()) {
            log.warn(this.imp.getTitle() + " is an RGB image. Labels might be inconsistent. Check the results to ensure they are what you expect.");
        }
        List allRois = IntStream.range(0, this.imp.getImageStackSize()).parallel().mapToObj(i -> Labels2CompositeRois.L2Rp(this.imp.getStack().getProcessor(i + 1), i + 1)).flatMap(r -> r.stream()).collect(Collectors.toList());
        log.info("Adding " + allRois.size() + " Rois to the ROI Manager");
        for (Roi r2 : allRois) {
            this.rm.add((ImagePlus)null, r2, -1);
        }
        long end = System.currentTimeMillis();
        log.info("Label extraction took " + df.format((end - start) / 1000L) + " s");
    }

    public static List<Roi> L2Rp(ImageProcessor ip, int position) {
        log.info("Getting Labels for Slice " + position);
        ip = ip instanceof ColorProcessor ? Labels2CompositeRois.getRGBPixels((ColorProcessor)ip) : ip.convertToFloatProcessor();
        float[] pixels = (float[])ip.getPixels();
        double max = ip.getMax();
        HashSet<Float> labels = new HashSet<Float>(1000);
        for (int j = 0; j < pixels.length; ++j) {
            labels.add(Float.valueOf(pixels[j]));
        }
        labels.remove(new Float(0.0f));
        ImageProcessor finalIp = ip;
        List<Roi> rois = labels.parallelStream().map(lab -> {
            ImageProcessor ip2 = (ImageProcessor)finalIp.clone();
            ip2.setThreshold((double)lab.floatValue(), (double)lab.floatValue(), 2);
            Roi roi = new ThresholdToSelection().convert(ip2);
            roi.setPosition(position);
            String roiName = String.format("%04d", position) + " - ID " + String.format("%04d", lab.intValue());
            roi.setName(roiName);
            return roi;
        }).collect(Collectors.toList());
        return rois;
    }

    protected static FloatProcessor getRGBPixels(ColorProcessor ip) {
        int[] pixels = (int[])ip.getPixels();
        float[] fp = new float[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            fp[i] = (float)pixels[i] + (float)Math.pow(2.0, 24.0);
        }
        return new FloatProcessor(ip.getWidth(), ip.getHeight(), fp);
    }
}

