/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.metrics;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.ThreadUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.scijava.vecmath.Point3f;
import trainableSegmentation.metrics.ClassificationStatistics;
import trainableSegmentation.metrics.ClusteredWarpingMismatches;
import trainableSegmentation.metrics.Metrics;
import trainableSegmentation.metrics.PixelError;
import trainableSegmentation.metrics.RandError;
import trainableSegmentation.metrics.WarpingResults;
import trainableSegmentation.utils.Utils;

public class WarpingError
extends Metrics {
    public static final double SIMPLE_POINT_THRESHOLD = 0.0;
    public static final int MERGE = 1;
    public static final int SPLIT = 2;
    public static final int HOLE_ADDITION = 4;
    public static final int OBJECT_DELETION = 8;
    public static final int OBJECT_ADDITION = 16;
    public static final int HOLE_DELETION = 32;
    public static final int DEFAULT_FLAGS = 63;
    private ImagePlus mask = null;
    private int flags = 63;

    public WarpingError(ImagePlus originalLabels, ImagePlus proposedLabels) {
        super(originalLabels, proposedLabels);
    }

    public WarpingError(ImagePlus originalLabels, ImagePlus proposedLabels, ImagePlus mask) {
        super(originalLabels, proposedLabels);
        this.mask = mask;
    }

    public WarpingError(ImagePlus originalLabels, ImagePlus proposedLabels, ImagePlus mask, int flags) {
        super(originalLabels, proposedLabels);
        this.mask = mask;
        this.flags = flags;
    }

    @Override
    public double getMetricValue(double binaryThreshold) {
        WarpingResults[] wrs;
        if (this.verbose) {
            IJ.log((String)"  Warping ground truth...");
        }
        if (null == (wrs = this.simplePointWarp2dMT(this.originalLabels, this.proposedLabels, this.mask, binaryThreshold))) {
            return -1.0;
        }
        double error = 0.0;
        for (int j = 0; j < wrs.length; ++j) {
            error += wrs[j].warpingError;
        }
        if (wrs.length != 0) {
            return error / (double)wrs.length;
        }
        return -1.0;
    }

    public double getMetricValue(double binaryThreshold, boolean clusterByError) {
        int j;
        ClusteredWarpingMismatches[] cwm;
        if (this.verbose) {
            IJ.log((String)"  Warping ground truth...");
        }
        if (null == (cwm = this.getClusteredWarpingMismatches(this.originalLabels, this.proposedLabels, this.mask, binaryThreshold, clusterByError, -1))) {
            return -1.0;
        }
        double error = 0.0;
        double count = this.originalLabels.getWidth() * this.originalLabels.getHeight() * this.originalLabels.getImageStackSize();
        if ((this.flags & 4) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfHoleAdditions;
            }
        }
        if ((this.flags & 0x20) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfHoleDeletions;
            }
        }
        if ((this.flags & 1) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfMergers;
            }
        }
        if ((this.flags & 0x10) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfObjectAdditions;
            }
        }
        if ((this.flags & 8) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfObjectDeletions;
            }
        }
        if ((this.flags & 2) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfSplits;
            }
        }
        if (count != 0.0) {
            return error / count;
        }
        return -1.0;
    }

    public double getMetricValue(double binaryThreshold, boolean clusterByError, int radius) {
        int j;
        ClusteredWarpingMismatches[] cwm;
        if (this.verbose) {
            IJ.log((String)"  Warping ground truth...");
        }
        if (null == (cwm = this.getClusteredWarpingMismatches(this.originalLabels, this.proposedLabels, this.mask, binaryThreshold, clusterByError, radius))) {
            return -1.0;
        }
        double error = 0.0;
        double count = this.originalLabels.getWidth() * this.originalLabels.getHeight() * this.originalLabels.getImageStackSize();
        if ((this.flags & 4) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfHoleAdditions;
            }
        }
        if ((this.flags & 0x20) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfHoleDeletions;
            }
        }
        if ((this.flags & 1) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfMergers;
            }
        }
        if ((this.flags & 0x10) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfObjectAdditions;
            }
        }
        if ((this.flags & 8) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfObjectDeletions;
            }
        }
        if ((this.flags & 2) != 0) {
            for (j = 0; j < cwm.length; ++j) {
                error += (double)cwm[j].numOfSplits;
            }
        }
        if (count != 0.0) {
            return error / count;
        }
        return -1.0;
    }

    public ArrayList<int[]> getSplitsAndMergers(double minThreshold, double maxThreshold, double stepThreshold, boolean clusterByError) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<int[]> listOfSplitsAndMergers = new ArrayList<int[]>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            ClusteredWarpingMismatches[] cwm;
            if (this.verbose) {
                IJ.log((String)("  Calculating splits and mergers for threshold value " + String.format("%.3f", th) + "..."));
            }
            if (null == (cwm = this.getClusteredWarpingMismatches(this.originalLabels, this.proposedLabels, this.mask, th, clusterByError, -1))) {
                return null;
            }
            int[] splitsAndMergers = new int[2];
            for (int j = 0; j < cwm.length; ++j) {
                splitsAndMergers[0] = splitsAndMergers[0] + cwm[j].numOfSplits;
                splitsAndMergers[1] = splitsAndMergers[1] + cwm[j].numOfMergers;
            }
            listOfSplitsAndMergers.add(splitsAndMergers);
            if (!this.verbose) continue;
            IJ.log((String)("  # splits = " + splitsAndMergers[0] + ", # mergers = " + splitsAndMergers[1]));
        }
        return listOfSplitsAndMergers;
    }

    public ArrayList<int[]> getSplitsAndMergers(double minThreshold, double maxThreshold, double stepThreshold, boolean clusterByError, int radius) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<int[]> listOfSplitsAndMergers = new ArrayList<int[]>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            ClusteredWarpingMismatches[] cwm;
            if (this.verbose) {
                IJ.log((String)("  Calculating splits and mergers for threshold value " + String.format("%.3f", th) + "..."));
            }
            if (null == (cwm = this.getClusteredWarpingMismatches(this.originalLabels, this.proposedLabels, this.mask, th, clusterByError, radius))) {
                return null;
            }
            int[] splitsAndMergers = new int[2];
            for (int j = 0; j < cwm.length; ++j) {
                splitsAndMergers[0] = splitsAndMergers[0] + cwm[j].numOfSplits;
                splitsAndMergers[1] = splitsAndMergers[1] + cwm[j].numOfMergers;
            }
            listOfSplitsAndMergers.add(splitsAndMergers);
            if (!this.verbose) continue;
            IJ.log((String)("  # splits = " + splitsAndMergers[0] + ", # mergers = " + splitsAndMergers[1]));
        }
        return listOfSplitsAndMergers;
    }

    public double getMinimumSplitsAndMergersErrorValue(double minThreshold, double maxThreshold, double stepThreshold, boolean clusterByError) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return -1.0;
        }
        this.flags = 3;
        double minError = Double.MAX_VALUE;
        double bestTh = minThreshold;
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating splits and mergers for threshold value " + String.format("%.3f", th) + "..."));
            }
            double error = this.getMetricValue(th, clusterByError);
            if (this.verbose) {
                IJ.log((String)("    error = " + error));
            }
            if (!(error < minError)) continue;
            minError = error;
            bestTh = th;
        }
        if (this.verbose) {
            IJ.log((String)(" **  Minimum error = " + minError + ", with threshold = " + bestTh + " **\n"));
        }
        return minError;
    }

    public double getMinimumSplitsAndMergersErrorValue(double minThreshold, double maxThreshold, double stepThreshold, boolean clusterByError, int radius) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return -1.0;
        }
        this.flags = 3;
        double minError = Double.MAX_VALUE;
        double bestTh = minThreshold;
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating splits and mergers for threshold value " + String.format("%.3f", th) + "..."));
            }
            double error = this.getMetricValue(th, clusterByError, radius);
            if (this.verbose) {
                IJ.log((String)("    error = " + error));
            }
            if (!(error < minError)) continue;
            minError = error;
            bestTh = th;
        }
        if (this.verbose) {
            IJ.log((String)(" **  Minimum error = " + minError + ", with threshold = " + bestTh + " **\n"));
        }
        return minError;
    }

    public double getPixelErrorMaximalFScore(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<ClassificationStatistics> stats = this.getPrecisionRecallStats(minThreshold, maxThreshold, stepThreshold);
        double maxFScore = 0.0;
        double th = 0.0;
        double bestTh = 0.0;
        for (ClassificationStatistics stat : stats) {
            if (stat.fScore > maxFScore) {
                maxFScore = stat.fScore;
                bestTh = th;
            }
            th += stepThreshold;
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best F-score = " + maxFScore + ", with threshold = " + bestTh + " **\n"));
        }
        return maxFScore;
    }

    public ArrayList<ClassificationStatistics> getPrecisionRecallStats(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<ClassificationStatistics> cs = new ArrayList<ClassificationStatistics>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating warping error statistics for threshold value " + String.format("%.3f", th) + "..."));
            }
            WarpingResults[] wrs = this.simplePointWarp2dMT(this.originalLabels, this.proposedLabels, this.mask, th);
            ImageStack is = new ImageStack(this.originalLabels.getWidth(), this.originalLabels.getHeight());
            for (int i = 0; i < wrs.length; ++i) {
                is.addSlice("warped source slice " + (i + 1), wrs[i].warpedSource.getProcessor());
            }
            ImagePlus warpedSource = new ImagePlus("warped source", is);
            PixelError pixelError = new PixelError(warpedSource, this.proposedLabels);
            ClassificationStatistics stats = pixelError.getPrecisionRecallStats(th);
            if (this.verbose) {
                IJ.log((String)("   F-score = " + stats.fScore));
            }
            cs.add(stats);
        }
        return cs;
    }

    public ArrayList<ClassificationStatistics> getPrecisionRecallStatsSplitsAndMergers(double minThreshold, double maxThreshold, double stepThreshold, final int radius, boolean bordersArePositive, boolean visualize) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<ClassificationStatistics> cs = new ArrayList<ClassificationStatistics>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating warping error statistics for threshold value " + String.format("%.3f", th) + "..."));
            }
            final WarpingResults[] wrs = this.simplePointWarp2dMT(this.originalLabels, this.proposedLabels, this.mask, th);
            ImageStack is = new ImageStack(this.originalLabels.getWidth(), this.originalLabels.getHeight());
            for (int slice = 1; slice <= wrs.length; ++slice) {
                is.addSlice("warped source slice " + slice, wrs[slice - 1].warpedSource.getProcessor());
            }
            final ImagePlus warpedSource = new ImagePlus("warped source", is);
            final AtomicInteger ai = new AtomicInteger(0);
            final int n_cpus = Prefs.getThreads();
            final int depth = is.getSize();
            final int dec = (int)Math.ceil((double)depth / (double)n_cpus);
            Thread[] threads = ThreadUtil.createThreadArray((int)n_cpus);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(){

                    @Override
                    public void run() {
                        int k = ai.getAndIncrement();
                        while (k < n_cpus) {
                            int zmin = dec * k;
                            int zmax = dec * (k + 1);
                            if (zmin < 0) {
                                zmin = 0;
                            }
                            if (zmax > depth) {
                                zmax = depth;
                            }
                            WarpingError.this.revertSplitAndMergers(wrs, warpedSource, radius, zmin, zmax);
                            k = ai.getAndIncrement();
                        }
                    }
                };
            }
            ThreadUtil.startAndJoin((Thread[])threads);
            ImagePlus proposal = this.proposedLabels;
            if (bordersArePositive) {
                for (int slice = 1; slice <= warpedSource.getImageStackSize(); ++slice) {
                    float[] pix = (float[])warpedSource.getImageStack().getProcessor(slice).getPixels();
                    for (int kk = 0; kk < pix.length; ++kk) {
                        pix[kk] = pix[kk] == 0.0f ? 1.0f : 0.0f;
                    }
                }
                proposal = this.proposedLabels.duplicate();
                IJ.run((ImagePlus)proposal, (String)"Invert", (String)"stack");
            }
            if (visualize) {
                proposal.show();
                warpedSource.show();
            }
            PixelError pixelError = new PixelError(warpedSource, proposal);
            ClassificationStatistics stats = pixelError.getPrecisionRecallStats(th);
            if (this.verbose) {
                IJ.log((String)("   F-score = " + stats.fScore));
            }
            cs.add(stats);
        }
        return cs;
    }

    public ClassificationStatistics[] getPrecisionRecallStatsSplitsAndMergersPerSlice(double th, final int radius, boolean bordersArePositive) {
        if (this.verbose) {
            IJ.log((String)("  Calculating warping error statistics for threshold value " + String.format("%.3f", th) + "..."));
        }
        final WarpingResults[] wrs = this.simplePointWarp2dMT(this.originalLabels, this.proposedLabels, this.mask, th);
        ImageStack is = new ImageStack(this.originalLabels.getWidth(), this.originalLabels.getHeight());
        for (int slice = 1; slice <= wrs.length; ++slice) {
            is.addSlice("warped source slice " + slice, wrs[slice - 1].warpedSource.getProcessor());
        }
        final ImagePlus warpedSource = new ImagePlus("warped source", is);
        final AtomicInteger ai = new AtomicInteger(0);
        final int n_cpus = Prefs.getThreads();
        final int depth = is.getSize();
        final int dec = (int)Math.ceil((double)depth / (double)n_cpus);
        Thread[] threads = ThreadUtil.createThreadArray((int)n_cpus);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    int k = ai.getAndIncrement();
                    while (k < n_cpus) {
                        int zmin = dec * k;
                        int zmax = dec * (k + 1);
                        if (zmin < 0) {
                            zmin = 0;
                        }
                        if (zmax > depth) {
                            zmax = depth;
                        }
                        WarpingError.this.revertSplitAndMergers(wrs, warpedSource, radius, zmin, zmax);
                        k = ai.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        ImagePlus proposal = this.proposedLabels;
        if (bordersArePositive) {
            for (int slice = 1; slice <= warpedSource.getImageStackSize(); ++slice) {
                float[] pix = (float[])warpedSource.getImageStack().getProcessor(slice).getPixels();
                for (int kk = 0; kk < pix.length; ++kk) {
                    pix[kk] = pix[kk] == 0.0f ? 1.0f : 0.0f;
                }
            }
            proposal = this.proposedLabels.duplicate();
            IJ.run((ImagePlus)proposal, (String)"Invert", (String)"stack");
        }
        PixelError pixelError = new PixelError(warpedSource, proposal);
        ClassificationStatistics[] stats = pixelError.getPrecisionRecallStatsPerSlice(th);
        return stats;
    }

    void revertSplitAndMergers(WarpingResults[] wrs, ImagePlus warpedSource, int radius, int zmin, int zmax) {
        for (int i = zmin; i < zmax; ++i) {
            if (zmin == 0) {
                IJ.showProgress((int)(i + 1), (int)zmax);
            }
            ImageProcessor ip = warpedSource.getImageStack().getProcessor(i + 1);
            int[] mismatchesLabels = this.classifyMismatches2d(wrs[i].warpedSource, wrs[i].mismatches, radius);
            for (int k = 0; k < mismatchesLabels.length; ++k) {
                if (mismatchesLabels[k] == 1 || mismatchesLabels[k] == 2) continue;
                Point3f p = wrs[i].mismatches.get(k);
                int x = (int)p.x;
                int y = (int)p.y;
                if (ip.getf(x, y) == 0.0f) {
                    ip.setf(x, y, 1.0f);
                    continue;
                }
                ip.setf(x, y, 0.0f);
            }
        }
    }

    public double getDualPixelErrorMaximalFScore(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<ClassificationStatistics> stats = this.getDualPrecisionRecallStats(minThreshold, maxThreshold, stepThreshold);
        double maxFScore = 0.0;
        double th = 0.0;
        double bestTh = 0.0;
        for (ClassificationStatistics stat : stats) {
            if (stat.fScore > maxFScore) {
                maxFScore = stat.fScore;
                bestTh = th;
            }
            th += stepThreshold;
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best F-score = " + maxFScore + ", with threshold = " + bestTh + " **\n"));
        }
        return maxFScore;
    }

    public ArrayList<ClassificationStatistics> getDualPrecisionRecallStats(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<ClassificationStatistics> cs = new ArrayList<ClassificationStatistics>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating warping error statistics for threshold value " + String.format("%.3f", th) + "..."));
            }
            WarpingResults[] wrs = this.simplePointWarp2dMT(this.originalLabels, this.proposedLabels, this.mask, th);
            ImageStack is = new ImageStack(this.originalLabels.getWidth(), this.originalLabels.getHeight());
            for (int i = 0; i < wrs.length; ++i) {
                is.addSlice("warped source slice " + (i + 1), wrs[i].warpedSource.getProcessor());
            }
            ImagePlus warpedSource = new ImagePlus("warped source", is);
            PixelError pixelError = new PixelError(warpedSource, this.proposedLabels);
            ClassificationStatistics stats = pixelError.getPrecisionRecallStats(th);
            double max = this.proposedLabels.getImageStack().getProcessor(1) instanceof ByteProcessor ? 255.0 : 1.0;
            ImagePlus proposal8bit = this.proposedLabels.duplicate();
            IJ.setThreshold((ImagePlus)proposal8bit, (double)(th + 1.0E-5), (double)max);
            IJ.run((ImagePlus)proposal8bit, (String)"Convert to Mask", (String)"  black");
            wrs = this.simplePointWarp2dMT(proposal8bit, this.originalLabels, this.mask, th);
            is = new ImageStack(this.originalLabels.getWidth(), this.originalLabels.getHeight());
            for (int i = 0; i < wrs.length; ++i) {
                is.addSlice("warped source slice " + (i + 1), wrs[i].warpedSource.getProcessor());
            }
            warpedSource = new ImagePlus("warped source", is);
            pixelError = new PixelError(warpedSource, this.originalLabels);
            ClassificationStatistics statsInverse = pixelError.getPrecisionRecallStats(th);
            stats.metricValue = (stats.metricValue + statsInverse.metricValue) / 2.0;
            ClassificationStatistics finalStats = new ClassificationStatistics(stats.truePositives + statsInverse.truePositives, stats.trueNegatives + statsInverse.trueNegatives, stats.falsePositives + statsInverse.falsePositives, stats.falseNegatives + statsInverse.falseNegatives, (stats.metricValue + statsInverse.metricValue) / 2.0);
            if (this.verbose) {
                IJ.log((String)("   F-score = " + finalStats.fScore));
            }
            cs.add(finalStats);
        }
        return cs;
    }

    public ArrayList<ClassificationStatistics> getRandIndexStats(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<ClassificationStatistics> cs = new ArrayList<ClassificationStatistics>();
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating warping error statistics for threshold value " + String.format("%.3f", th) + "..."));
            }
            WarpingResults[] wrs = this.simplePointWarp2dMT(this.originalLabels, this.proposedLabels, this.mask, th);
            ImageStack is = new ImageStack(this.originalLabels.getWidth(), this.originalLabels.getHeight());
            for (int i = 0; i < wrs.length; ++i) {
                is.addSlice("warped source slice " + (i + 1), wrs[i].warpedSource.getProcessor());
            }
            ImagePlus warpedSource = new ImagePlus("warped source", is);
            RandError randError = new RandError(warpedSource, this.proposedLabels);
            ClassificationStatistics stats = randError.getRandIndexStats(th);
            if (this.verbose) {
                IJ.log((String)("   F-score = " + stats.fScore));
            }
            cs.add(stats);
        }
        return cs;
    }

    public double getRandIndexMaximalFScore(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<ClassificationStatistics> stats = this.getRandIndexStats(minThreshold, maxThreshold, stepThreshold);
        double maxFScore = 0.0;
        double th = 0.0;
        double bestTh = 0.0;
        for (ClassificationStatistics stat : stats) {
            if (stat.fScore > maxFScore) {
                maxFScore = stat.fScore;
                bestTh = th;
            }
            th += stepThreshold;
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best F-score = " + maxFScore + ", with threshold = " + bestTh + " **\n"));
        }
        return maxFScore;
    }

    public boolean simple2DBertrand(ImagePlus im, int n) {
        float[] input = new float[27];
        float[] center = (float[])im.getProcessor().getPixels();
        for (int i = 0; i < 9; ++i) {
            input[i + 9] = center[i];
        }
        switch (n) {
            case 4: {
                return this.simple3d(input, 6);
            }
            case 8: {
                return this.simple3d(input, 26);
            }
        }
        IJ.error((String)"Non valid adjacency value");
        return false;
    }

    public boolean simple2D(ImagePlus im, int n) {
        ImagePlus invertedIm = new ImagePlus("inverted", im.getProcessor().duplicate());
        float[] pix = (float[])invertedIm.getProcessor().getPixels();
        for (int i = 0; i < pix.length; ++i) {
            pix[i] = pix[i] == 0.0f ? 1.0f : 0.0f;
        }
        switch (n) {
            case 4: {
                return this.topo(im, 4) == 1 && this.topo(invertedIm, 8) == 1;
            }
            case 8: {
                return this.topo(im, 8) == 1 && this.topo(invertedIm, 4) == 1;
            }
        }
        IJ.error((String)"Non valid adjacency value");
        return false;
    }

    public int topo(ImagePlus im, int adjacency) {
        ImageProcessor components = null;
        ImagePlus im2 = new ImagePlus("copy of im", im.getProcessor().duplicate());
        switch (adjacency) {
            case 4: {
                if (im.getStack().getSize() > 1) {
                    IJ.error((String)"n=4 is valid for a 2d image");
                    return -1;
                }
                if (im.getProcessor().getWidth() > 3 || im.getProcessor().getHeight() > 3) {
                    IJ.error((String)"must be 3x3 image patch");
                    return -1;
                }
                im2.getProcessor().set(1, 1, 0);
                components = Utils.connectedComponents((ImagePlus)im2, (int)adjacency).allRegions.getProcessor();
                components.set(0, 0, 0);
                components.set(0, 2, 0);
                components.set(1, 1, 0);
                components.set(2, 0, 0);
                components.set(2, 2, 0);
                break;
            }
            case 8: {
                if (im.getStack().getSize() > 1) {
                    IJ.error((String)"n=8 is valid for a 2d image");
                    return -1;
                }
                if (im.getProcessor().getWidth() > 3 || im.getProcessor().getHeight() > 3) {
                    IJ.error((String)"must be 3x3 image patch");
                    return -1;
                }
                im2.getProcessor().set(1, 1, 0);
                components = Utils.connectedComponents((ImagePlus)im2, (int)adjacency).allRegions.getProcessor();
                break;
            }
            default: {
                IJ.error((String)"Non valid adjacency value");
                return -1;
            }
        }
        if (null == components) {
            return -1;
        }
        int t = 0;
        ArrayList<Integer> uniqueId = new ArrayList<Integer>();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                t = components.get(i, j);
                if (t == 0 || uniqueId.contains(t)) continue;
                uniqueId.add(t);
            }
        }
        return uniqueId.size();
    }

    public WarpingResults simplePointWarp2d(ImageProcessor source, ImageProcessor target, ImageProcessor mask, double binaryThreshold) {
        ImagePlus maskReal;
        if (binaryThreshold < 0.0 || binaryThreshold > 1.01) {
            binaryThreshold = 0.5;
        }
        int width = target.getWidth();
        int height = target.getHeight();
        ImageProcessor ip = target.createProcessor(width + 2, height + 2);
        ip.insert(target, 1, 1);
        ImagePlus targetReal = new ImagePlus("target_real", ip.duplicate());
        ImagePlus targetBin = new ImagePlus("target_aux", ip.duplicate());
        ip = target.createProcessor(width + 2, height + 2);
        ip.insert(source, 1, 1);
        ImagePlus sourceReal = new ImagePlus("source_real", ip.duplicate());
        if (null != mask) {
            ip = target.createProcessor(width + 2, height + 2);
            ip.insert(mask, 1, 1);
            maskReal = new ImagePlus("mask_real", ip.duplicate());
        } else {
            maskReal = null;
        }
        float[] sourceRealPix = (float[])sourceReal.getProcessor().getPixels();
        for (int i = 0; i < sourceRealPix.length; ++i) {
            if (!(sourceRealPix[i] > 0.0f)) continue;
            sourceRealPix[i] = 1.0f;
        }
        float[] targetBinPix = (float[])targetBin.getProcessor().getPixels();
        for (int i = 0; i < targetBinPix.length; ++i) {
            targetBinPix[i] = (double)targetBinPix[i] <= binaryThreshold ? 0.0f : 1.0f;
        }
        double diff = Double.MIN_VALUE;
        double diff_before = 0.0;
        WarpingResults result = new WarpingResults();
        while (true) {
            float[] mask_pixels;
            ImageProcessor missclass_points_image = sourceReal.getProcessor().duplicate();
            missclass_points_image.copyBits(targetBin.getProcessor(), 0, 0, 8);
            diff_before = diff;
            float[] pixels = (float[])missclass_points_image.getPixels();
            float[] fArray = mask_pixels = null != maskReal ? (float[])maskReal.getProcessor().getPixels() : new float[pixels.length];
            if (null == maskReal) {
                Arrays.fill(mask_pixels, 1.0f);
            }
            diff = 0.0;
            for (int k = 0; k < pixels.length; ++k) {
                if (pixels[k] == 0.0f || mask_pixels[k] == 0.0f) continue;
                diff += 1.0;
            }
            if (diff == 0.0) {
                result.mismatches = new ArrayList();
                break;
            }
            if (diff == diff_before) break;
            ArrayList<Point3f> mismatches = new ArrayList<Point3f>();
            float[] realTargetPix = (float[])targetReal.getProcessor().getPixels();
            for (int x = 1; x < width + 1; ++x) {
                for (int y = 1; y < height + 1; ++y) {
                    if (pixels[x + y * (width + 2)] == 0.0f || mask_pixels[x + y * (width + 2)] == 0.0f) continue;
                    mismatches.add(new Point3f((float)x, (float)y, (float)Math.abs((double)realTargetPix[x + y * (width + 2)] - binaryThreshold)));
                }
            }
            if (mismatches.size() > 1) {
                Collections.sort(mismatches, new Comparator<Point3f>(){

                    @Override
                    public int compare(Point3f o1, Point3f o2) {
                        return Float.compare(o2.z, o1.z);
                    }
                });
            }
            for (Point3f p : mismatches) {
                int x = (int)p.x;
                int y = (int)p.y;
                if ((double)p.z < 0.0) continue;
                double[] val = new double[]{sourceRealPix[x - 1 + (y - 1) * (width + 2)], sourceRealPix[x + (y - 1) * (width + 2)], sourceRealPix[x + 1 + (y - 1) * (width + 2)], sourceRealPix[x - 1 + y * (width + 2)], sourceRealPix[x + y * (width + 2)], sourceRealPix[x + 1 + y * (width + 2)], sourceRealPix[x - 1 + (y + 1) * (width + 2)], sourceRealPix[x + (y + 1) * (width + 2)], sourceRealPix[x + 1 + (y + 1) * (width + 2)]};
                double pix = val[4];
                ImagePlus patch = new ImagePlus("patch", (ImageProcessor)new FloatProcessor(3, 3, val));
                if (!this.simple2DBertrand(patch, 4)) continue;
                sourceRealPix[x + y * (width + 2)] = pix > 0.0 ? 0.0f : 1.0f;
            }
            result.mismatches = mismatches;
        }
        ip = source.createProcessor(width, height);
        ip.insert(sourceReal.getProcessor(), -1, -1);
        sourceReal.setProcessor(ip.duplicate());
        ArrayList<Point3f> mismatches = new ArrayList<Point3f>();
        for (Point3f p : result.mismatches) {
            mismatches.add(new Point3f(p.x - 1.0f, p.y - 1.0f, p.z));
        }
        sourceReal.setTitle("Warped source");
        result.mismatches = mismatches;
        result.warpedSource = sourceReal;
        result.warpingError = diff / (double)(width * height);
        return result;
    }

    public Callable<WarpingResults> simplePointWarp2DConcurrent(final ImageProcessor source, final ImageProcessor target, final ImageProcessor mask, final double binaryThreshold) {
        return new Callable<WarpingResults>(){

            @Override
            public WarpingResults call() {
                return WarpingError.this.simplePointWarp2d(source, target, mask, binaryThreshold);
            }
        };
    }

    public Callable<WarpingResults> simplePointWarp2DConcurrent(final ImageProcessor source, final ImageProcessor target, final ImageProcessor mask, final double binaryThreshold, final boolean calculateMismatchImage, final int radius) {
        return new Callable<WarpingResults>(){

            @Override
            public WarpingResults call() {
                WarpingResults wr = WarpingError.this.simplePointWarp2d(source, target, mask, binaryThreshold);
                if (calculateMismatchImage) {
                    wr.classifiedMismatches = WarpingError.this.getMismatchImage(wr, radius);
                }
                return wr;
            }
        };
    }

    public ImagePlus getMismatchImage(WarpingResults wr, int radius) {
        int[] mismatchesLabels = this.classifyMismatches2d(wr.warpedSource, wr.mismatches, radius);
        ByteProcessor bp = new ByteProcessor(wr.warpedSource.getWidth(), wr.warpedSource.getHeight());
        for (int i = 0; i < wr.mismatches.size(); ++i) {
            Point3f p = wr.mismatches.get(i);
            bp.set((int)p.x, (int)p.y, mismatchesLabels[i]);
        }
        return new ImagePlus("Mismatches", (ImageProcessor)bp);
    }

    public ImagePlus getMismatchImage(WarpingResults wr, int radius, int flags) {
        int[] mismatchesLabels = this.classifyMismatches2d(wr.warpedSource, wr.mismatches, radius);
        ByteProcessor bp = new ByteProcessor(wr.warpedSource.getWidth(), wr.warpedSource.getHeight());
        for (int i = 0; i < wr.mismatches.size(); ++i) {
            Point3f p = wr.mismatches.get(i);
            bp.set((int)p.x, (int)p.y, mismatchesLabels[i] & flags);
        }
        return new ImagePlus("Mismatches", (ImageProcessor)bp);
    }

    public ImagePlus getMismatchImage(WarpingResults wr, int[] mismatchesLabels, int flags) {
        ByteProcessor bp = new ByteProcessor(wr.warpedSource.getWidth(), wr.warpedSource.getHeight());
        for (int i = 0; i < wr.mismatches.size(); ++i) {
            Point3f p = wr.mismatches.get(i);
            bp.set((int)p.x, (int)p.y, mismatchesLabels[i] & flags);
        }
        return new ImagePlus("Mismatches", (ImageProcessor)bp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus simplePointWarp2dMT(ImagePlus source, ImagePlus target, ImagePlus mask, double binaryThreshold, ArrayList<Point3f>[] mismatches) {
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight() || source.getImageStackSize() != target.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return null;
        }
        ImageStack sourceSlices = source.getImageStack();
        ImageStack targetSlices = target.getImageStack();
        ImageStack maskSlices = null != mask ? mask.getImageStack() : null;
        ImageStack warpedSource = new ImageStack(source.getWidth(), source.getHeight());
        if (null == mismatches) {
            mismatches = new ArrayList[sourceSlices.getSize()];
        }
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<WarpingResults>> futures = new ArrayList<Future<WarpingResults>>();
        try {
            for (int i = 1; i <= sourceSlices.getSize(); ++i) {
                futures.add(exe.submit(this.simplePointWarp2DConcurrent(sourceSlices.getProcessor(i), targetSlices.getProcessor(i), null != maskSlices ? maskSlices.getProcessor(i) : null, binaryThreshold)));
            }
            double warpingError = 0.0;
            int i = 0;
            for (Future future : futures) {
                WarpingResults wr = (WarpingResults)future.get();
                if (null != wr.warpedSource) {
                    warpedSource.addSlice("warped source " + i, wr.warpedSource.getProcessor());
                }
                if (wr.warpingError != -1.0) {
                    warpingError += wr.warpingError;
                }
                if (null != wr.mismatches) {
                    mismatches[i] = wr.mismatches;
                }
                ++i;
            }
            if (this.verbose) {
                IJ.log((String)("Warping error = " + warpingError / (double)sourceSlices.getSize()));
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when warping ground truth in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return new ImagePlus("warped source", warpedSource);
    }

    public ImagePlus simplePointWarp2d(ImagePlus source, ImagePlus target, ImagePlus mask, double binaryThreshold) {
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight() || source.getImageStackSize() != target.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return null;
        }
        ImageStack sourceSlices = source.getImageStack();
        ImageStack targetSlices = target.getImageStack();
        ImageStack maskSlices = null != mask ? mask.getImageStack() : null;
        ImageStack warpedSource = new ImageStack(source.getWidth(), source.getHeight());
        double warpingError = 0.0;
        for (int i = 1; i <= sourceSlices.getSize(); ++i) {
            WarpingResults wr = this.simplePointWarp2d(sourceSlices.getProcessor(i), targetSlices.getProcessor(i), null != mask ? maskSlices.getProcessor(i) : null, binaryThreshold);
            if (null != wr.warpedSource) {
                warpedSource.addSlice("warped source " + i, wr.warpedSource.getProcessor());
            }
            if (wr.warpingError == -1.0) continue;
            warpingError += wr.warpingError;
        }
        return new ImagePlus("warped source", warpedSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WarpingResults[] simplePointWarp2dMT(ImagePlus source, ImagePlus target, ImagePlus mask, double binaryThreshold) {
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight() || source.getImageStackSize() != target.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return null;
        }
        ImageStack sourceSlices = source.getImageStack();
        ImageStack targetSlices = target.getImageStack();
        ImageStack maskSlices = null != mask ? mask.getImageStack() : null;
        WarpingResults[] wrs = new WarpingResults[source.getImageStackSize()];
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<WarpingResults>> futures = new ArrayList<Future<WarpingResults>>();
        try {
            int i;
            for (i = 1; i <= sourceSlices.getSize(); ++i) {
                futures.add(exe.submit(this.simplePointWarp2DConcurrent(sourceSlices.getProcessor(i).convertToFloat(), targetSlices.getProcessor(i).convertToFloat(), null != maskSlices ? maskSlices.getProcessor(i) : null, binaryThreshold)));
            }
            i = 0;
            for (Future future : futures) {
                wrs[i] = (WarpingResults)future.get();
                ++i;
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when warping ground truth in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return wrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WarpingResults[] simplePointWarp2dMT(double binaryThreshold, boolean clusterByError, boolean calculateMismatchImage, int radius) {
        ImageStack sourceSlices = this.originalLabels.getImageStack();
        ImageStack targetSlices = this.proposedLabels.getImageStack();
        ImageStack maskSlices = null != this.mask ? this.mask.getImageStack() : null;
        WarpingResults[] wrs = new WarpingResults[this.originalLabels.getImageStackSize()];
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<WarpingResults>> futures = new ArrayList<Future<WarpingResults>>();
        try {
            int i;
            for (i = 1; i <= sourceSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getWarpingResultsConcurrent(sourceSlices.getProcessor(i).convertToFloat(), targetSlices.getProcessor(i).convertToFloat(), null != maskSlices ? maskSlices.getProcessor(i) : null, binaryThreshold, clusterByError, radius, this.flags, calculateMismatchImage)));
            }
            i = 0;
            for (Future future : futures) {
                wrs[i] = (WarpingResults)future.get();
                ++i;
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when warping ground truth in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return wrs;
    }

    public double warpingErrorSingleThread(ImagePlus label, ImagePlus proposal, ImagePlus mask, double binaryThreshold) {
        ImagePlus warpedLabels = this.simplePointWarp2d(label, proposal, mask, binaryThreshold);
        if (null == warpedLabels) {
            return -1.0;
        }
        double error = 0.0;
        double count = 0.0;
        for (int j = 1; j <= proposal.getImageStackSize(); ++j) {
            float[] proposalPixels = (float[])proposal.getImageStack().getProcessor(j).getPixels();
            float[] warpedPixels = (float[])warpedLabels.getImageStack().getProcessor(j).getPixels();
            for (int i = 0; i < proposalPixels.length; ++i) {
                float thresholdedProposal;
                count += 1.0;
                float f = thresholdedProposal = (double)proposalPixels[i] <= binaryThreshold ? 0.0f : 1.0f;
                if (warpedPixels[i] == thresholdedProposal) continue;
                error += 1.0;
            }
        }
        if (count != 0.0) {
            return error / count;
        }
        return -1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusteredWarpingMismatches[] getClusteredWarpingMismatches(ImagePlus source, ImagePlus target, ImagePlus mask, double binaryThreshold, boolean clusterByError, int radius) {
        if (source.getWidth() != target.getWidth() || source.getHeight() != target.getHeight() || source.getImageStackSize() != target.getImageStackSize()) {
            IJ.log((String)"Error: label and training image sizes do not fit.");
            return null;
        }
        ImageStack sourceSlices = source.getImageStack();
        ImageStack targetSlices = target.getImageStack();
        ImageStack maskSlices = null != mask ? mask.getImageStack() : null;
        ClusteredWarpingMismatches[] cwm = new ClusteredWarpingMismatches[source.getImageStackSize()];
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<ClusteredWarpingMismatches>> futures = new ArrayList<Future<ClusteredWarpingMismatches>>();
        try {
            int i;
            for (i = 1; i <= sourceSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getClusteredWarpingMismatchesConcurrent(sourceSlices.getProcessor(i).convertToFloat(), targetSlices.getProcessor(i).convertToFloat(), null != maskSlices ? maskSlices.getProcessor(i) : null, binaryThreshold, clusterByError, radius)));
            }
            i = 0;
            for (Future future : futures) {
                cwm[i] = (ClusteredWarpingMismatches)future.get();
                ++i;
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when getting the clustered warping mismatches in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return cwm;
    }

    public Callable<ClusteredWarpingMismatches> getClusteredWarpingMismatchesConcurrent(final ImageProcessor source, final ImageProcessor target, final ImageProcessor mask, final double binaryThreshold, final boolean clusterByError, final int radius) {
        return new Callable<ClusteredWarpingMismatches>(){

            @Override
            public ClusteredWarpingMismatches call() {
                WarpingResults wr = WarpingError.this.simplePointWarp2d(source, target, mask, binaryThreshold);
                int[] mismatchesLabels = WarpingError.this.classifyMismatches2d(wr.warpedSource, wr.mismatches, radius);
                if (clusterByError) {
                    return WarpingError.this.clusterMismatchesByError(wr.warpedSource, wr.mismatches, mismatchesLabels);
                }
                return WarpingError.this.clusterMismatchesByType(mismatchesLabels);
            }
        };
    }

    public Callable<WarpingResults> getWarpingResultsConcurrent(final ImageProcessor source, final ImageProcessor target, final ImageProcessor mask, final double binaryThreshold, final boolean clusterByError, final int radius, final int flags, final boolean calculateMismatchImage) {
        return new Callable<WarpingResults>(){

            @Override
            public WarpingResults call() {
                WarpingResults wr = WarpingError.this.simplePointWarp2d(source, target, mask, binaryThreshold);
                int[] mismatchesLabels = WarpingError.this.classifyMismatches2d(wr.warpedSource, wr.mismatches, radius);
                if (calculateMismatchImage) {
                    wr.classifiedMismatches = WarpingError.this.getMismatchImage(wr, mismatchesLabels, flags);
                }
                ClusteredWarpingMismatches cwm = null;
                cwm = clusterByError ? WarpingError.this.clusterMismatchesByError(wr.warpedSource, wr.mismatches, mismatchesLabels) : WarpingError.this.clusterMismatchesByType(mismatchesLabels);
                double error = 0.0;
                double count = source.getWidth() * source.getHeight();
                if ((flags & 4) != 0) {
                    error += (double)cwm.numOfHoleAdditions;
                }
                if ((flags & 0x20) != 0) {
                    error += (double)cwm.numOfHoleDeletions;
                }
                if ((flags & 1) != 0) {
                    error += (double)cwm.numOfMergers;
                }
                if ((flags & 0x10) != 0) {
                    error += (double)cwm.numOfObjectAdditions;
                }
                if ((flags & 8) != 0) {
                    error += (double)cwm.numOfObjectDeletions;
                }
                if ((flags & 2) != 0) {
                    error += (double)cwm.numOfSplits;
                }
                wr.warpingError = error / count;
                return wr;
            }
        };
    }

    public int[] classifyMismatches2d(ImagePlus warpedLabels, ArrayList<Point3f> mismatches, int radius) {
        int[] pointClassification = new int[mismatches.size()];
        int radiusToUse = radius;
        if (radius < 1 || radius > warpedLabels.getWidth() || radius > warpedLabels.getHeight()) {
            radiusToUse = -1;
        }
        ImageProcessor components = Utils.connectedComponents((ImagePlus)new ImagePlus((String)"8-bit warped labels", (ImageProcessor)warpedLabels.getProcessor().convertToByte((boolean)true)), (int)4).allRegions.getProcessor();
        int n = 0;
        for (Point3f p : mismatches) {
            int x = (int)p.x;
            int y = (int)p.y;
            ArrayList<Integer> neighborhood = this.getNeighborhood(components, new Point(x, y), 1, 1);
            ArrayList<Integer> uniqueId = new ArrayList<Integer>();
            for (Integer neighbor : neighborhood) {
                if (uniqueId.contains(neighbor)) continue;
                uniqueId.add(neighbor);
            }
            if (uniqueId.size() == 1 && (Integer)uniqueId.get(0) == 0) {
                pointClassification[n] = components.getf(x, y) != 0.0f ? 8 : 16;
            } else if (uniqueId.size() == 1 && (Integer)uniqueId.get(0) != 0) {
                pointClassification[n] = components.getf(x, y) != 0.0f ? 4 : 32;
            } else if (uniqueId.size() == 2) {
                if (components.getf(x, y) == 0.0f) {
                    pointClassification[n] = 4;
                } else {
                    ByteProcessor warpedPixels2 = (ByteProcessor)warpedLabels.getProcessor().duplicate().convertToByte(true);
                    Point pixelOfInterest = new Point(x, y);
                    if (radiusToUse != -1) {
                        warpedPixels2 = new ByteProcessor(2 * radiusToUse + 1, 2 * radiusToUse + 1);
                        int i = x - radiusToUse;
                        int l = 0;
                        while (i <= x + radiusToUse) {
                            int j = y - radiusToUse;
                            int k = 0;
                            while (j <= y + radiusToUse) {
                                warpedPixels2.set(l, k, warpedLabels.getProcessor().getPixel(i, j) == 0 ? 0 : 255);
                                ++j;
                                ++k;
                            }
                            ++i;
                            ++l;
                        }
                        pixelOfInterest = new Point(radiusToUse, radiusToUse);
                    }
                    warpedPixels2.set(pixelOfInterest.x, pixelOfInterest.y, 0);
                    ImageProcessor components2 = Utils.connectedComponents((ImagePlus)new ImagePlus((String)"8-bit warped labels", (ImageProcessor)warpedPixels2), (int)4).allRegions.getProcessor();
                    ArrayList<Integer> neighborhood2 = this.getNeighborhood(components2, pixelOfInterest, 1, 1);
                    ArrayList<Integer> uniqueId2 = new ArrayList<Integer>();
                    for (Integer neighbor : neighborhood2) {
                        if (uniqueId2.contains(neighbor)) continue;
                        uniqueId2.add(neighbor);
                    }
                    pointClassification[n] = uniqueId2.size() > 2 ? 2 : 32;
                }
            } else {
                pointClassification[n] = components.getf(x, y) == 0.0f ? 1 : 2;
            }
            ++n;
        }
        return pointClassification;
    }

    public int[] classifyMismatches2d(ImagePlus warpedLabels, ArrayList<Point3f> mismatches, double falsePositives, double falseNegatives, int flags) {
        int[] pointClassification = new int[mismatches.size()];
        ImageProcessor components = Utils.connectedComponents((ImagePlus)new ImagePlus((String)"8-bit warped labels", (ImageProcessor)warpedLabels.getProcessor().convertToByte((boolean)true)), (int)4).allRegions.getProcessor();
        int n = 0;
        for (Point3f p : mismatches) {
            int x = (int)p.x;
            int y = (int)p.y;
            ArrayList<Integer> neighborhood = this.getNeighborhood(components, new Point(x, y), 1, 1);
            ArrayList<Integer> uniqueId = new ArrayList<Integer>();
            for (Integer neighbor : neighborhood) {
                if (uniqueId.contains(neighbor)) continue;
                uniqueId.add(neighbor);
            }
            if (uniqueId.size() == 1 && (Integer)uniqueId.get(0) == 0) {
                if (components.getf(x, y) != 0.0f) {
                    pointClassification[n] = 8;
                    if ((flags & 8) != 0) {
                        falseNegatives += 1.0;
                    }
                } else {
                    pointClassification[n] = 16;
                    if ((flags & 0x10) != 0) {
                        falsePositives += 1.0;
                    }
                }
            } else if (uniqueId.size() == 1 && (Integer)uniqueId.get(0) != 0) {
                if (components.getf(x, y) != 0.0f) {
                    pointClassification[n] = 4;
                    if ((flags & 4) != 0) {
                        falseNegatives += 1.0;
                    }
                } else {
                    pointClassification[n] = 32;
                    if ((flags & 0x20) != 0) {
                        falsePositives += 1.0;
                    }
                }
            } else if (uniqueId.size() == 2) {
                if (components.getf(x, y) == 0.0f) {
                    pointClassification[n] = 4;
                    if ((flags & 4) != 0) {
                        falsePositives += 1.0;
                    }
                } else {
                    ByteProcessor warpedPixels2;
                    warpedPixels2.set(x, y, (warpedPixels2 = (ByteProcessor)warpedLabels.getProcessor().duplicate().convertToByte(true)).get(x, y) != 0 ? 0 : 255);
                    ImageProcessor components2 = Utils.connectedComponents((ImagePlus)new ImagePlus((String)"8-bit warped labesl", (ImageProcessor)warpedPixels2), (int)4).allRegions.getProcessor();
                    ArrayList<Integer> neighborhood2 = this.getNeighborhood(components2, new Point(x, y), 1, 1);
                    ArrayList<Integer> uniqueId2 = new ArrayList<Integer>();
                    for (Integer neighbor : neighborhood2) {
                        if (uniqueId2.contains(neighbor)) continue;
                        uniqueId2.add(neighbor);
                    }
                    if (uniqueId2.size() > 2) {
                        pointClassification[n] = 2;
                        if ((flags & 2) != 0) {
                            falseNegatives += 1.0;
                        }
                    } else {
                        pointClassification[n] = 32;
                        if ((flags & 0x20) != 0) {
                            falseNegatives += 1.0;
                        }
                    }
                }
            } else if (components.getf(x, y) == 0.0f) {
                pointClassification[n] = 1;
                if ((flags & 1) != 0) {
                    falsePositives += 1.0;
                }
            } else {
                pointClassification[n] = 2;
                if ((flags & 2) != 0) {
                    falseNegatives += 1.0;
                }
            }
            ++n;
        }
        return pointClassification;
    }

    public ClusteredWarpingMismatches clusterMismatchesByError(ImagePlus warpedLabels, ArrayList<Point3f> mismatches, int[] mismatchClassification) {
        ByteProcessor[] binaryMismatches = new ByteProcessor[8];
        int width = warpedLabels.getWidth();
        int height = warpedLabels.getHeight();
        for (int i = 0; i < 8; ++i) {
            binaryMismatches[i] = new ByteProcessor(width, height);
        }
        int[] connectivity = new int[]{4, 4, 8, 4, 4, 8, 4, 4};
        block9: for (int i = 0; i < mismatchClassification.length; ++i) {
            int x = (int)mismatches.get((int)i).x;
            int y = (int)mismatches.get((int)i).y;
            switch (mismatchClassification[i]) {
                case 16: {
                    binaryMismatches[0].set(x, y, 255);
                    continue block9;
                }
                case 32: {
                    if (warpedLabels.getProcessor().getf(x, y) == 0.0f) {
                        binaryMismatches[1].set(x, y, 255);
                        continue block9;
                    }
                    binaryMismatches[7].set(x, y, 255);
                    continue block9;
                }
                case 1: {
                    binaryMismatches[2].set(x, y, 255);
                    continue block9;
                }
                case 4: {
                    if (warpedLabels.getProcessor().getf(x, y) == 0.0f) {
                        binaryMismatches[3].set(x, y, 255);
                        continue block9;
                    }
                    binaryMismatches[5].set(x, y, 255);
                    continue block9;
                }
                case 8: {
                    binaryMismatches[4].set(x, y, 255);
                    continue block9;
                }
                case 2: {
                    binaryMismatches[6].set(x, y, 255);
                    continue block9;
                }
            }
        }
        int[] componentsPerCase = new int[8];
        for (int i = 0; i < 8; ++i) {
            ImagePlus im = new ImagePlus("components case " + i, (ImageProcessor)binaryMismatches[i]);
            componentsPerCase[i] = Utils.connectedComponents((ImagePlus)im, (int)connectivity[i]).regionInfo.size();
        }
        return new ClusteredWarpingMismatches(componentsPerCase[0], componentsPerCase[1] + componentsPerCase[7], componentsPerCase[2], componentsPerCase[3] + componentsPerCase[5], componentsPerCase[4], componentsPerCase[6]);
    }

    public ClusteredWarpingMismatches clusterMismatchesByType(int[] mismatchClassification) {
        int numOfObjectAdditions = 0;
        int numOfHoleDeletions = 0;
        int numOfMergers = 0;
        int numOfHoleAdditions = 0;
        int numOfObjectDeletions = 0;
        int numOfSplits = 0;
        block8: for (int i = 0; i < mismatchClassification.length; ++i) {
            switch (mismatchClassification[i]) {
                case 16: {
                    ++numOfObjectAdditions;
                    continue block8;
                }
                case 32: {
                    ++numOfHoleDeletions;
                    continue block8;
                }
                case 1: {
                    ++numOfMergers;
                    continue block8;
                }
                case 4: {
                    ++numOfHoleAdditions;
                    continue block8;
                }
                case 8: {
                    ++numOfObjectDeletions;
                    continue block8;
                }
                case 2: {
                    ++numOfSplits;
                    continue block8;
                }
                default: {
                    IJ.log((String)"Unrecognized mismatch classification!");
                }
            }
        }
        return new ClusteredWarpingMismatches(numOfObjectAdditions, numOfHoleDeletions, numOfMergers, numOfHoleAdditions, numOfObjectDeletions, numOfSplits);
    }

    public ArrayList<Integer> getNeighborhood(ImageProcessor image, Point p, int x_offset, int y_offset) {
        ArrayList<Integer> neighborhood = new ArrayList<Integer>();
        for (int j = p.y - y_offset; j <= p.y + y_offset; ++j) {
            for (int i = p.x - x_offset; i <= p.x + x_offset; ++i) {
                if (i == p.x && j == p.y || j < 0 || j >= image.getHeight() || i < 0 || i >= image.getWidth()) continue;
                neighborhood.add(image.get(i, j));
            }
        }
        return neighborhood;
    }

    int nca(float[] input, int con, int space) {
        switch (con) {
            case 6: {
                int tsum = (int)input[4] + (int)input[10] + (int)input[12] + (int)input[14] + (int)input[16] + (int)input[22];
                return space == 1 ? 6 * space - tsum : tsum;
            }
            case 18: {
                int tsum = (int)input[1] + (int)input[3] + (int)input[4] + (int)input[5] + (int)input[7] + (int)input[9] + (int)input[10] + (int)input[11] + (int)input[12] + (int)input[14] + (int)input[15] + (int)input[16] + (int)input[17] + (int)input[19] + (int)input[21] + (int)input[22] + (int)input[23] + (int)input[25];
                return space == 1 ? 18 * space - tsum : tsum;
            }
            case 26: {
                int tsum = (int)input[0] + (int)input[1] + (int)input[2] + (int)input[3] + (int)input[4] + (int)input[5] + (int)input[6] + (int)input[7] + (int)input[8] + (int)input[9] + (int)input[10] + (int)input[11] + (int)input[12] + (int)input[14] + (int)input[15] + (int)input[16] + (int)input[17] + (int)input[18] + (int)input[19] + (int)input[20] + (int)input[21] + (int)input[22] + (int)input[23] + (int)input[24] + (int)input[25] + (int)input[26];
                return space == 1 ? 26 * space - tsum : tsum;
            }
        }
        return 0;
    }

    int ncb(float[] input, char ctyp, int con, int space) {
        int[][][] a6m = new int[][][]{new int[][]{{0, 1, 0}, {1, 5, 1}, {0, 1, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
        int[][][] a18m = new int[][][]{new int[][]{{0, 0, 0}, {0, 1, 1}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 1}, {0, 0, 0}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
        int[][][] a26m = new int[][][]{new int[][]{{0, 0, 0}, {0, 1, 1}, {0, 1, 1}}, new int[][]{{0, 0, 0}, {0, 0, 1}, {0, 1, 1}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
        int[][][] b18m = new int[][][]{new int[][]{{0, 1, 0}, {0, 1, 9}, {0, 1, 0}}, new int[][]{{0, 1, 1}, {0, 0, 1}, {0, 1, 1}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
        int[][][] b26m = new int[][][]{new int[][]{{0, 0, 0}, {0, 1, 1}, {0, 1, 7}}, new int[][]{{0, 0, 0}, {0, 0, 1}, {0, 1, 1}}, new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}};
        int[] tsuma = new int[12];
        if (ctyp == 'a') {
            switch (con) {
                case 6: {
                    for (int x = 0; x < 3; ++x) {
                        for (int y = 0; y < 3; ++y) {
                            for (int z = 0; z < 3; ++z) {
                                tsuma[0] = (int)((float)tsuma[0] + (float)a6m[x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[1] = (int)((float)tsuma[1] + (float)a6m[2 - x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[2] = (int)((float)tsuma[2] + (float)a6m[y][x][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[3] = (int)((float)tsuma[3] + (float)a6m[2 - y][x][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[4] = (int)((float)tsuma[4] + (float)a6m[z][y][x] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[5] = (int)((float)tsuma[5] + (float)a6m[2 - z][y][x] * input[x + y * 3 + z * 3 * 3]);
                            }
                        }
                    }
                    int tsum = 0;
                    for (int i = 0; i < 6; ++i) {
                        tsum += tsuma[i] == 5 - space ? 1 : 0;
                    }
                    return tsum;
                }
                case 18: {
                    for (int x = 0; x < 3; ++x) {
                        for (int y = 0; y < 3; ++y) {
                            for (int z = 0; z < 3; ++z) {
                                tsuma[0] = (int)((float)tsuma[0] + (float)a18m[x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[1] = (int)((float)tsuma[1] + (float)a18m[x][y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[2] = (int)((float)tsuma[2] + (float)a18m[2 - x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[3] = (int)((float)tsuma[3] + (float)a18m[2 - x][y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[4] = (int)((float)tsuma[4] + (float)a18m[y][x][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[5] = (int)((float)tsuma[5] + (float)a18m[y][x][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[6] = (int)((float)tsuma[6] + (float)a18m[2 - y][x][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[7] = (int)((float)tsuma[7] + (float)a18m[2 - y][x][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[8] = (int)((float)tsuma[8] + (float)a18m[x][z][y] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[9] = (int)((float)tsuma[9] + (float)a18m[x][z][2 - y] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[10] = (int)((float)tsuma[10] + (float)a18m[2 - x][z][y] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[11] = (int)((float)tsuma[11] + (float)a18m[2 - x][z][2 - y] * input[x + y * 3 + z * 3 * 3]);
                            }
                        }
                    }
                    int tsum = 0;
                    for (int i = 0; i < 12; ++i) {
                        tsum += tsuma[i] == 3 - 3 * space ? 1 : 0;
                    }
                    return tsum;
                }
                case 26: {
                    for (int x = 0; x < 3; ++x) {
                        for (int y = 0; y < 3; ++y) {
                            for (int z = 0; z < 3; ++z) {
                                tsuma[0] = (int)((float)tsuma[0] + (float)a26m[x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[1] = (int)((float)tsuma[1] + (float)a26m[2 - x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[2] = (int)((float)tsuma[2] + (float)a26m[x][2 - y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[3] = (int)((float)tsuma[3] + (float)a26m[x][y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[4] = (int)((float)tsuma[4] + (float)a26m[2 - x][2 - y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[5] = (int)((float)tsuma[5] + (float)a26m[x][2 - y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[6] = (int)((float)tsuma[6] + (float)a26m[2 - x][y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[7] = (int)((float)tsuma[7] + (float)a26m[2 - x][2 - y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                            }
                        }
                    }
                    int tsum = 0;
                    for (int i = 0; i < 8; ++i) {
                        tsum += tsuma[i] == 7 - 7 * space ? 1 : 0;
                    }
                    return tsum;
                }
            }
            return 0;
        }
        if (ctyp == 'b') {
            switch (con) {
                case 18: {
                    for (int x = 0; x < 3; ++x) {
                        for (int y = 0; y < 3; ++y) {
                            for (int z = 0; z < 3; ++z) {
                                tsuma[0] = (int)((float)tsuma[0] + (float)b18m[x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[1] = (int)((float)tsuma[1] + (float)b18m[x][y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[2] = (int)((float)tsuma[2] + (float)b18m[2 - x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[3] = (int)((float)tsuma[3] + (float)b18m[2 - x][y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[4] = (int)((float)tsuma[4] + (float)b18m[y][x][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[5] = (int)((float)tsuma[5] + (float)b18m[y][x][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[6] = (int)((float)tsuma[6] + (float)b18m[2 - y][x][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[7] = (int)((float)tsuma[7] + (float)b18m[2 - y][x][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[8] = (int)((float)tsuma[8] + (float)b18m[x][z][y] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[9] = (int)((float)tsuma[9] + (float)b18m[x][z][2 - y] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[10] = (int)((float)tsuma[10] + (float)b18m[2 - x][z][y] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[11] = (int)((float)tsuma[11] + (float)b18m[2 - x][z][2 - y] * input[x + y * 3 + z * 3 * 3]);
                            }
                        }
                    }
                    int tsum = 0;
                    for (int i = 0; i < 12; ++i) {
                        tsum += tsuma[i] == 9 - space ? 1 : 0;
                    }
                    return tsum;
                }
                case 26: {
                    for (int x = 0; x < 3; ++x) {
                        for (int y = 0; y < 3; ++y) {
                            for (int z = 0; z < 3; ++z) {
                                tsuma[0] = (int)((float)tsuma[0] + (float)b26m[x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[1] = (int)((float)tsuma[1] + (float)b26m[2 - x][y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[2] = (int)((float)tsuma[2] + (float)b26m[x][2 - y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[3] = (int)((float)tsuma[3] + (float)b26m[x][y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[4] = (int)((float)tsuma[4] + (float)b26m[2 - x][2 - y][z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[5] = (int)((float)tsuma[5] + (float)b26m[x][2 - y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[6] = (int)((float)tsuma[6] + (float)b26m[2 - x][y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                                tsuma[7] = (int)((float)tsuma[7] + (float)b26m[2 - x][2 - y][2 - z] * input[x + y * 3 + z * 3 * 3]);
                            }
                        }
                    }
                    int tsum = 0;
                    for (int i = 0; i < 8; ++i) {
                        tsum += tsuma[i] == 7 - space ? 1 : 0;
                    }
                    return tsum;
                }
            }
            return 0;
        }
        return 0;
    }

    boolean simple3d(float[] input, int region) {
        boolean simple = false;
        if (region == 26) {
            simple = false;
            if (this.nca(input, 6, 1) == 1) {
                simple = true;
            } else if (this.nca(input, 26, 0) == 1) {
                simple = true;
            } else if (this.ncb(input, 'b', 26, 0) == 0) {
                if (this.nca(input, 18, 0) == 1) {
                    simple = true;
                } else if (this.ncb(input, 'a', 6, 1) == 0 && this.ncb(input, 'b', 18, 0) == 0 && this.nca(input, 6, 1) - this.ncb(input, 'a', 18, 1) + this.ncb(input, 'a', 26, 1) == 1) {
                    simple = true;
                }
            }
        } else if (region == 6) {
            float[] input2 = new float[27];
            for (int i = 0; i < 27; ++i) {
                input2[i] = input[i] == 1.0f ? 0.0f : 1.0f;
            }
            simple = false;
            if (this.nca(input2, 6, 1) == 1) {
                simple = true;
            } else if (this.nca(input2, 26, 0) == 1) {
                simple = true;
            } else if (this.ncb(input2, 'b', 26, 0) == 0) {
                if (this.nca(input2, 18, 0) == 1) {
                    simple = true;
                } else if (this.ncb(input2, 'a', 6, 1) == 0 && this.ncb(input2, 'b', 18, 0) == 0 && this.nca(input2, 6, 1) - this.ncb(input2, 'a', 18, 1) + this.ncb(input2, 'a', 26, 1) == 1) {
                    simple = true;
                }
            }
        }
        return simple;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            WarpingError.dumpSyntax();
            System.exit(1);
        } else if (args[0].equals("-help")) {
            WarpingError.dumpSyntax();
        } else if (args[0].equals("-splitsAndMergers")) {
            System.out.println(WarpingError.splitsAndMergersCommandLine(args));
        } else {
            WarpingError.dumpSyntax();
        }
        System.exit(0);
    }

    static double splitsAndMergersCommandLine(String[] args) {
        if (args.length != 8) {
            WarpingError.dumpSyntax();
            return -1.0;
        }
        ImagePlus label = new ImagePlus(args[1]);
        ImagePlus proposal = new ImagePlus(args[2]);
        double minThreshold = Double.parseDouble(args[3]);
        double maxThreshold = Double.parseDouble(args[4]);
        double stepThreshold = Double.parseDouble(args[5]);
        boolean clusterByError = Boolean.parseBoolean(args[6]);
        int radius = Integer.parseInt(args[7]);
        WarpingError we = new WarpingError(label, proposal);
        we.setVerboseMode(false);
        return we.getMinimumSplitsAndMergersErrorValue(minThreshold, maxThreshold, stepThreshold, clusterByError, radius);
    }

    private static void dumpSyntax() {
        System.out.println("Purpose: calculate warping error between proposed and original labels.\n");
        System.out.println("Usage: WarpingError ");
        System.out.println("  -help                      : show this message");
        System.out.println("");
        System.out.println("  -splitsAndMergers          : calculate the splits and mergers ratio over a set of thresholds");
        System.out.println("          labels             : image with the original labels");
        System.out.println("          proposal           : image with the proposed labels");
        System.out.println("          minThreshold       : minimum threshold value to binarize the proposal");
        System.out.println("          maxThreshold       : maximum threshold value to binarize the proposal");
        System.out.println("          stepThreshold      : threshold step value to use during binarization");
        System.out.println("          clusterMistakes    : boolean flag to cluster or not the mistakes by type of error");
        System.out.println("          radius             : radius of the search neighborhood to decide simple points classification\n");
        System.out.println("Examples:");
        System.out.println("Calculate the splits and mergers ratio between proposed and original labels over a set of");
        System.out.println("thresholds (from 0.0 to 1.0 in steps of 0.1) without clustering the mistakes and using a \nradius of 20 pixels:");
        System.out.println("   WarpingError -splitsAndMergers original-labels.tif proposed-labels.tif 0.0 1.0 0.1 false 20");
    }

    public WarpingResults getWarpingResults(double binaryThreshold, boolean clusterByError, boolean calculateMismatchImage, int radius) {
        WarpingResults[] wrs;
        if (this.verbose) {
            IJ.log((String)"  Warping ground truth...");
        }
        if (null == (wrs = this.simplePointWarp2dMT(binaryThreshold, clusterByError, calculateMismatchImage, radius))) {
            return null;
        }
        WarpingResults result = new WarpingResults();
        result.warpingError = 0.0;
        ImageStack is = new ImageStack(this.originalLabels.getWidth(), this.originalLabels.getHeight());
        ImageStack is2 = calculateMismatchImage ? new ImageStack(this.originalLabels.getWidth(), this.originalLabels.getHeight()) : null;
        for (int i = 0; i < wrs.length; ++i) {
            result.warpingError += wrs[i].warpingError;
            is.addSlice("warped source slice " + (i + 1), wrs[i].warpedSource.getProcessor());
            if (!calculateMismatchImage) continue;
            is2.addSlice("Mismatches slice " + (i + 1), wrs[i].classifiedMismatches.getProcessor());
        }
        result.warpedSource = new ImagePlus("warped source", is);
        if (calculateMismatchImage) {
            result.classifiedMismatches = new ImagePlus("Classified mismatches", is2);
        }
        if (wrs.length != 0) {
            result.warpingError /= (double)wrs.length;
        }
        return result;
    }
}

