/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.metrics;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.util.ThreadUtil;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import trainableSegmentation.metrics.ClassificationStatistics;
import trainableSegmentation.metrics.Metrics;
import trainableSegmentation.utils.Utils;
import trainableSegmentation.utils.WatershedTransform2D;

public class RandError
extends Metrics {
    public RandError(ImagePlus originalLabels, ImagePlus proposedLabels) {
        super(originalLabels, proposedLabels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMetricValue(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double randError = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getRandErrorConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                randError += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating standard Rand error in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return randError / (double)labelSlices.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getForegroundRestrictedMetricValue(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double randError = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<Double>> futures = new ArrayList<Future<Double>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getForegroundRestrictedRandErrorConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                randError += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating rand error in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return randError / (double)labelSlices.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassificationStatistics getRandIndexStats(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double randIndex = 0.0;
        double tp = 0.0;
        double tn = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<ClassificationStatistics>> futures = new ArrayList<Future<ClassificationStatistics>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getRandIndexStatsConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                ClassificationStatistics cs = (ClassificationStatistics)future.get();
                randIndex += cs.metricValue;
                tp += cs.truePositives;
                tn += cs.trueNegatives;
                fp += cs.falsePositives;
                fn += cs.falseNegatives;
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating standard Rand index stats in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return new ClassificationStatistics(tp, tn, fp, fn, randIndex / (double)labelSlices.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassificationStatistics getForegroundRestrictedRandIndexStats(double binaryThreshold) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double randIndex = 0.0;
        double tp = 0.0;
        double tn = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<ClassificationStatistics>> futures = new ArrayList<Future<ClassificationStatistics>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getForegroundRestrictedRandIndexStatsConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                ClassificationStatistics cs = (ClassificationStatistics)future.get();
                randIndex += cs.metricValue;
                tp += cs.truePositives;
                tn += cs.trueNegatives;
                fp += cs.falsePositives;
                fn += cs.falseNegatives;
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating foreground-restricted Rand index stats in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        return new ClassificationStatistics(tp, tn, fp, fn, randIndex / (double)labelSlices.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassificationStatistics getForegroundRestrictedRandAfterThinningStats(double binaryThreshold, boolean perSliceAverage) {
        ImageStack labelSlices = this.originalLabels.getImageStack();
        ImageStack proposalSlices = this.proposedLabels.getImageStack();
        double randIndex = 0.0;
        double tp = 0.0;
        double tn = 0.0;
        double fp = 0.0;
        double fn = 0.0;
        double fScore = 0.0;
        ExecutorService exe = Executors.newFixedThreadPool(Prefs.getThreads());
        ArrayList<Future<ClassificationStatistics>> futures = new ArrayList<Future<ClassificationStatistics>>();
        try {
            for (int i = 1; i <= labelSlices.getSize(); ++i) {
                futures.add(exe.submit(this.getForegroundRestrictedRandAfterThinningStatsConcurrent(labelSlices.getProcessor(i).convertToFloat(), proposalSlices.getProcessor(i).convertToFloat(), binaryThreshold)));
            }
            for (Future future : futures) {
                ClassificationStatistics cs = (ClassificationStatistics)future.get();
                randIndex += cs.metricValue;
                tp += cs.truePositives;
                tn += cs.trueNegatives;
                fp += cs.falsePositives;
                fn += cs.falseNegatives;
                fScore += cs.fScore;
            }
        }
        catch (Exception ex) {
            IJ.log((String)"Error when calculating foreground-restricted Rand score stats after thinning in a concurrent way.");
            ex.printStackTrace();
        }
        finally {
            exe.shutdown();
        }
        ClassificationStatistics cs = new ClassificationStatistics(tp, tn, fp, fn, randIndex / (double)labelSlices.getSize());
        if (perSliceAverage) {
            cs.fScore = fScore / (double)labelSlices.getSize();
        }
        return cs;
    }

    public ClassificationStatistics[] getForegroundRestrictedRandIndexStatsPerSlice(final double binaryThreshold) {
        final ImageStack labelSlices = this.originalLabels.getImageStack();
        final ImageStack proposalSlices = this.proposedLabels.getImageStack();
        final ClassificationStatistics[] cs = new ClassificationStatistics[this.originalLabels.getImageStackSize()];
        final AtomicInteger ai = new AtomicInteger(0);
        final int n_cpus = Prefs.getThreads();
        final int depth = cs.length;
        final int dec = (int)Math.ceil((double)depth / (double)n_cpus);
        Thread[] threads = ThreadUtil.createThreadArray((int)n_cpus);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(){

                @Override
                public void run() {
                    int k = ai.getAndIncrement();
                    while (k < n_cpus) {
                        int zmin = dec * k;
                        int zmax = dec * (k + 1);
                        if (zmin < 0) {
                            zmin = 0;
                        }
                        if (zmax > depth) {
                            zmax = depth;
                        }
                        for (int i = zmin; i < zmax; ++i) {
                            if (zmin == 0) {
                                IJ.showProgress((int)(i + 1), (int)zmax);
                            }
                            cs[i] = RandError.this.getForegroundRestrictedRandIndexStatsN2(labelSlices.getProcessor(i + 1).convertToFloat(), proposalSlices.getProcessor(i + 1).convertToFloat(), binaryThreshold);
                        }
                        k = ai.getAndIncrement();
                    }
                }
            };
        }
        ThreadUtil.startAndJoin((Thread[])threads);
        IJ.showProgress((double)1.0);
        return cs;
    }

    public ArrayList<ClassificationStatistics> getRandIndexStats(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<ClassificationStatistics> cs = new ArrayList<ClassificationStatistics>();
        double bestFscore = 0.0;
        double bestTh = minThreshold;
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating standard Rand index statistics for threshold value " + String.format("%.3f", th) + "..."));
            }
            cs.add(this.getRandIndexStats(th));
            double fScore = cs.get((int)(cs.size() - 1)).fScore;
            if (fScore > bestFscore) {
                bestFscore = fScore;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    F-score = " + fScore));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best F-score = " + bestFscore + ", with threshold = " + bestTh + " **\n"));
        }
        return cs;
    }

    public ArrayList<ClassificationStatistics> getForegroundRestrictedRandIndexStats(double minThreshold, double maxThreshold, double stepThreshold) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<ClassificationStatistics> cs = new ArrayList<ClassificationStatistics>();
        double bestFscore = 0.0;
        double bestTh = minThreshold;
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating foreground-restricted Rand index statistics for threshold value " + String.format("%.3f", th) + "..."));
            }
            cs.add(this.getForegroundRestrictedRandIndexStats(th));
            double fScore = cs.get((int)(cs.size() - 1)).fScore;
            if (fScore > bestFscore) {
                bestFscore = fScore;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    F-score = " + fScore));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best F-score = " + bestFscore + ", with threshold = " + bestTh + " **\n"));
        }
        return cs;
    }

    public ArrayList<ClassificationStatistics> getForegroundRestrictedRandAfterThinningStats(double minThreshold, double maxThreshold, double stepThreshold, boolean perSliceAverage) {
        if (minThreshold < 0.0 || minThreshold > maxThreshold || maxThreshold > 1.0) {
            IJ.log((String)"Error: unvalid threshold values.");
            return null;
        }
        ArrayList<ClassificationStatistics> cs = new ArrayList<ClassificationStatistics>();
        double bestFscore = 0.0;
        double bestTh = minThreshold;
        for (double th = minThreshold; th <= maxThreshold; th += stepThreshold) {
            if (this.verbose) {
                IJ.log((String)("  Calculating Rand score statistics after border thinning for threshold value " + String.format("%.3f", th) + "..."));
            }
            cs.add(this.getForegroundRestrictedRandAfterThinningStats(th, perSliceAverage));
            double fScore = cs.get((int)(cs.size() - 1)).fScore;
            if (fScore > bestFscore) {
                bestFscore = fScore;
                bestTh = th;
            }
            if (!this.verbose) continue;
            IJ.log((String)("    V_Rand = " + fScore));
        }
        if (this.verbose) {
            IJ.log((String)(" ** Best V_Rand = " + bestFscore + ", with threshold = " + String.format("%.3f", bestTh) + " **\n"));
        }
        return cs;
    }

    public Callable<Double> getRandErrorConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                return RandError.this.randError(image1, image2, binaryThreshold);
            }
        };
    }

    public Callable<Double> getForegroundRestrictedRandErrorConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<Double>(){

            @Override
            public Double call() {
                return RandError.this.foregroundRestrictedRandError(image1, image2, binaryThreshold);
            }
        };
    }

    public Callable<ClassificationStatistics> getRandIndexStatsConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<ClassificationStatistics>(){

            @Override
            public ClassificationStatistics call() {
                return RandError.this.randIndexStats(image1, image2, binaryThreshold);
            }
        };
    }

    public Callable<ClassificationStatistics> getForegroundRestrictedRandIndexStatsConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<ClassificationStatistics>(){

            @Override
            public ClassificationStatistics call() {
                return RandError.this.getForegroundRestrictedRandIndexStatsN2(image1, image2, binaryThreshold);
            }
        };
    }

    public Callable<ClassificationStatistics> getForegroundRestrictedRandAfterThinningStatsConcurrent(final ImageProcessor image1, final ImageProcessor image2, final double binaryThreshold) {
        return new Callable<ClassificationStatistics>(){

            @Override
            public ClassificationStatistics call() {
                return RandError.this.getForegroundRestrictedRandAfterThinningStatsN2(image1, image2, binaryThreshold);
            }
        };
    }

    public double randError(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return 1.0 - this.classicRandIndex(components1, components2);
    }

    public double foregroundRestrictedRandError(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return 1.0 - this.foregroundRestrictedRandIndex(components1, components2);
    }

    public ClassificationStatistics randIndexStats(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return this.getRandIndexStats(components1, components2);
    }

    public ClassificationStatistics getForegroundRestrictedRandIndexStatsN2(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        ShortProcessor components2 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"proposal labels", (ImageProcessor)binaryProposal), (int)4).allRegions.getProcessor();
        return this.getForegroundRestrictedRandIndexStatsN2(components1, components2);
    }

    public ClassificationStatistics getForegroundRestrictedRandAfterThinningStatsN2(ImageProcessor label, ImageProcessor proposal, double binaryThreshold) {
        ByteProcessor binaryLabel = new ByteProcessor(label.getWidth(), label.getHeight());
        ByteProcessor binaryProposal = new ByteProcessor(label.getWidth(), label.getHeight());
        for (int x = 0; x < label.getWidth(); ++x) {
            for (int y = 0; y < label.getHeight(); ++y) {
                binaryLabel.set(x, y, (double)label.getPixelValue(x, y) > binaryThreshold ? 255 : 0);
                binaryProposal.set(x, y, (double)proposal.getPixelValue(x, y) > binaryThreshold ? 0 : 255);
            }
        }
        ShortProcessor components1 = (ShortProcessor)Utils.connectedComponents((ImagePlus)new ImagePlus((String)"binary labels", (ImageProcessor)binaryLabel), (int)4).allRegions.getProcessor();
        WatershedTransform2D wt = new WatershedTransform2D((ImageProcessor)binaryProposal, 4);
        ShortProcessor components2 = wt.apply().convertToShortProcessor(false);
        return this.getForegroundRestrictedRandIndexStatsN2(components1, components2);
    }

    public double classicRandIndex(ShortProcessor cluster1, ShortProcessor cluster2) {
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = pixels1.length;
        int[][] cont = new int[(int)cluster1.getMax()][(int)cluster2.getMax()];
        int i = 0;
        while ((double)i < n) {
            int[] nArray = cont[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            nArray[n2] = nArray[n2] + 1;
            ++i;
        }
        double t2 = 0.0;
        double[] ni = new double[cont.length];
        for (int i2 = 0; i2 < cont.length; ++i2) {
            for (int j = 0; j < cont[i2].length; ++j) {
                int n3 = i2;
                ni[n3] = ni[n3] + (double)cont[i2][j];
            }
        }
        double nis = 0.0;
        for (int k = 0; k < ni.length; ++k) {
            nis += ni[k] * ni[k];
        }
        double[] nj = new double[cont.length];
        for (int j = 0; j < cont[0].length; ++j) {
            for (int i3 = 0; i3 < cont.length; ++i3) {
                int n4 = j;
                nj[n4] = nj[n4] + (double)cont[i3][j];
                t2 += (double)(cont[i3][j] * cont[i3][j]);
            }
        }
        double njs = 0.0;
        for (int k = 0; k < nj.length; ++k) {
            njs += nj[k] * nj[k];
        }
        double t1 = n * (n - 1.0) / 2.0;
        double t3 = 0.5 * (nis + njs);
        double agreements = t1 + t2 - t3;
        return agreements / t1;
    }

    public double foregroundRestrictedRandIndex(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double nPixels = pixels1.length;
        double n = 0.0;
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int[][] cont = new int[(int)cluster1.getMax() + 1][(int)cluster2.getMax() + 1];
        int i = 0;
        while ((double)i < nPixels) {
            int[] nArray = cont[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            nArray[n2] = nArray[n2] + 1;
            if (pixels1[i] > 0) {
                n += 1.0;
            }
            ++i;
        }
        double[] ni = new double[cont.length];
        for (int i2 = 1; i2 < cont.length; ++i2) {
            for (j = 0; j < cont[0].length; ++j) {
                int n3 = i2;
                ni[n3] = ni[n3] + (double)cont[i2][j];
            }
        }
        double[] nj = new double[cont[0].length];
        for (j = 1; j < cont[0].length; ++j) {
            for (int i3 = 1; i3 < cont.length; ++i3) {
                int n4 = j;
                nj[n4] = nj[n4] + (double)cont[i3][j];
            }
        }
        double truePositives = 0.0;
        for (int j2 = 1; j2 < cont[0].length; ++j2) {
            for (int i4 = 1; i4 < cont.length; ++i4) {
                truePositives += (double)cont[i4][j2] * ((double)cont[i4][j2] - 1.0) / 2.0;
            }
        }
        double nPairsTotal = n * (n - 1.0) / 2.0;
        double nPosTrue = 0.0;
        for (int k = 0; k < ni.length; ++k) {
            nPosTrue += ni[k] * (ni[k] - 1.0) / 2.0;
        }
        double nPosActual = 0.0;
        for (int k = 0; k < nj.length; ++k) {
            nPosActual += nj[k] * (nj[k] - 1.0) / 2.0;
        }
        double trueNegatives = nPairsTotal + truePositives - nPosTrue - nPosActual;
        double agreements = truePositives + trueNegatives;
        double randIndex = agreements / nPairsTotal;
        return randIndex;
    }

    public static double adaptedRandIndex3D(ImagePlus originalLabels, ImagePlus proposedLabels) {
        if (!(originalLabels.getImageStack().getProcessor(1) instanceof ShortProcessor) || !(proposedLabels.getImageStack().getProcessor(1) instanceof ShortProcessor)) {
            return -1.0;
        }
        int nSlices = originalLabels.getImageStackSize();
        int maxIDGroundTruth = 0;
        int maxIDProposal = 0;
        for (int slice = 1; slice <= nSlices; ++slice) {
            ImageProcessor gt = originalLabels.getImageStack().getProcessor(slice);
            gt.resetMinAndMax();
            if ((double)maxIDGroundTruth < gt.getMax()) {
                maxIDGroundTruth = (int)gt.getMax();
            }
            ImageProcessor proposal = proposedLabels.getImageStack().getProcessor(slice);
            proposal.resetMinAndMax();
            if (!((double)maxIDProposal < proposal.getMax())) continue;
            maxIDProposal = (int)proposal.getMax();
        }
        double nPairsStack = 0.0;
        double agreements = 0.0;
        for (int slice = 1; slice <= nSlices; ++slice) {
            int j;
            ShortProcessor cluster1 = (ShortProcessor)originalLabels.getImageStack().getProcessor(slice);
            ShortProcessor cluster2 = (ShortProcessor)proposedLabels.getImageStack().getProcessor(slice);
            short[] pixels1 = (short[])cluster1.getPixels();
            short[] pixels2 = (short[])cluster2.getPixels();
            double nPixels = pixels1.length;
            double n = 0.0;
            int[][] cont = new int[maxIDGroundTruth + 1][maxIDProposal + 1];
            int i = 0;
            while ((double)i < nPixels) {
                int[] nArray = cont[pixels1[i] & 0xFFFF];
                int n2 = pixels2[i] & 0xFFFF;
                nArray[n2] = nArray[n2] + 1;
                if (pixels1[i] > 0) {
                    n += 1.0;
                }
                ++i;
            }
            double[] ni = new double[cont.length];
            for (int i2 = 1; i2 < cont.length; ++i2) {
                for (j = 0; j < cont[0].length; ++j) {
                    int n3 = i2;
                    ni[n3] = ni[n3] + (double)cont[i2][j];
                }
            }
            double[] nj = new double[cont[0].length];
            for (j = 1; j < cont[0].length; ++j) {
                for (int i3 = 1; i3 < cont.length; ++i3) {
                    int n4 = j;
                    nj[n4] = nj[n4] + (double)cont[i3][j];
                }
            }
            double truePositives = 0.0;
            for (int j2 = 1; j2 < cont[0].length; ++j2) {
                for (int i4 = 1; i4 < cont.length; ++i4) {
                    truePositives += (double)cont[i4][j2] * ((double)cont[i4][j2] - 1.0) / 2.0;
                }
            }
            double nPairsTotal = n * (n - 1.0) / 2.0;
            double nPosTrue = 0.0;
            for (int k = 0; k < ni.length; ++k) {
                nPosTrue += ni[k] * (ni[k] - 1.0) / 2.0;
            }
            double nPosActual = 0.0;
            for (int k = 0; k < nj.length; ++k) {
                nPosActual += nj[k] * (nj[k] - 1.0) / 2.0;
            }
            double trueNegatives = nPairsTotal + truePositives - nPosTrue - nPosActual;
            agreements += truePositives + trueNegatives;
            nPairsStack += nPairsTotal;
        }
        return agreements / nPairsStack;
    }

    public static ClassificationStatistics adaptedRandIndexStats3D(ImagePlus originalLabels, ImagePlus proposedLabels) {
        if (!(originalLabels.getImageStack().getProcessor(1) instanceof ShortProcessor) || !(proposedLabels.getImageStack().getProcessor(1) instanceof ShortProcessor)) {
            return null;
        }
        int nSlices = originalLabels.getImageStackSize();
        int maxIDGroundTruth = 0;
        int maxIDProposal = 0;
        for (int slice = 1; slice <= nSlices; ++slice) {
            ImageProcessor gt = originalLabels.getImageStack().getProcessor(slice);
            gt.resetMinAndMax();
            if ((double)maxIDGroundTruth < gt.getMax()) {
                maxIDGroundTruth = (int)gt.getMax();
            }
            ImageProcessor proposal = proposedLabels.getImageStack().getProcessor(slice);
            proposal.resetMinAndMax();
            if (!((double)maxIDProposal < proposal.getMax())) continue;
            maxIDProposal = (int)proposal.getMax();
        }
        double agreements = 0.0;
        long[][] cont = new long[maxIDGroundTruth + 1][maxIDProposal + 1];
        double[] ni = new double[cont.length];
        double[] nj = new double[cont[0].length];
        double n = 0.0;
        for (int slice = 1; slice <= nSlices; ++slice) {
            ShortProcessor cluster1 = (ShortProcessor)originalLabels.getImageStack().getProcessor(slice);
            ShortProcessor cluster2 = (ShortProcessor)proposedLabels.getImageStack().getProcessor(slice);
            short[] pixels1 = (short[])cluster1.getPixels();
            short[] pixels2 = (short[])cluster2.getPixels();
            double nPixels = pixels1.length;
            int i = 0;
            while ((double)i < nPixels) {
                long[] lArray = cont[pixels1[i] & 0xFFFF];
                int n2 = pixels2[i] & 0xFFFF;
                lArray[n2] = lArray[n2] + 1L;
                if (pixels1[i] > 0) {
                    n += 1.0;
                }
                ++i;
            }
        }
        for (int i = 1; i < cont.length; ++i) {
            for (int j = 0; j < cont[0].length; ++j) {
                int n3 = i;
                ni[n3] = ni[n3] + (double)cont[i][j];
            }
        }
        for (int j = 1; j < cont[0].length; ++j) {
            for (int i = 1; i < cont.length; ++i) {
                int n4 = j;
                nj[n4] = nj[n4] + (double)cont[i][j];
            }
        }
        double truePositives = 0.0;
        for (int j = 1; j < cont[0].length; ++j) {
            for (int i = 1; i < cont.length; ++i) {
                truePositives += (double)cont[i][j] * ((double)cont[i][j] - 1.0);
            }
        }
        double nPairsTotal = n * (n - 1.0);
        double nPosTrue = 0.0;
        for (int k = 0; k < ni.length; ++k) {
            nPosTrue += ni[k] * (ni[k] - 1.0);
        }
        double nPosActual = 0.0;
        for (int k = 0; k < nj.length; ++k) {
            nPosActual += nj[k] * (nj[k] - 1.0);
        }
        double trueNegatives = nPairsTotal + truePositives - nPosTrue - nPosActual;
        agreements += truePositives + trueNegatives;
        double falsePositives = nPosActual - truePositives;
        double nNegActual = nPairsTotal - nPosActual;
        double falseNegatives = nNegActual - trueNegatives;
        double randIndex = agreements / nPairsTotal;
        return new ClassificationStatistics(truePositives /= 2.0, trueNegatives /= 2.0, falsePositives /= 2.0, falseNegatives /= 2.0, randIndex);
    }

    public static double[] adaptedRandIndexStats3DN2(ImagePlus segA, ImagePlus segB) {
        int i;
        if (!(segA.getImageStack().getProcessor(1) instanceof ShortProcessor) || !(segB.getImageStack().getProcessor(1) instanceof ShortProcessor)) {
            return null;
        }
        int nSlices = segA.getImageStackSize();
        int nLabelsA = 0;
        int nLabelsB = 0;
        for (int slice = 1; slice <= nSlices; ++slice) {
            ImageProcessor gt = segA.getImageStack().getProcessor(slice);
            gt.resetMinAndMax();
            if ((double)nLabelsA < gt.getMax()) {
                nLabelsA = (int)gt.getMax();
            }
            ImageProcessor proposal = segB.getImageStack().getProcessor(slice);
            proposal.resetMinAndMax();
            if (!((double)nLabelsB < proposal.getMax())) continue;
            nLabelsB = (int)proposal.getMax();
        }
        long[][] pij = new long[nLabelsA + 1][nLabelsB + 1];
        double n = segA.getImageStackSize() * segA.getWidth() * segA.getHeight();
        for (int slice = 1; slice <= nSlices; ++slice) {
            ShortProcessor cluster1 = (ShortProcessor)segA.getImageStack().getProcessor(slice);
            ShortProcessor cluster2 = (ShortProcessor)segB.getImageStack().getProcessor(slice);
            short[] pixels1 = (short[])cluster1.getPixels();
            short[] pixels2 = (short[])cluster2.getPixels();
            double nPixels = pixels1.length;
            i = 0;
            while ((double)i < nPixels) {
                long[] lArray = pij[pixels1[i] & 0xFFFF];
                int n2 = pixels2[i] & 0xFFFF;
                lArray[n2] = lArray[n2] + 1L;
                ++i;
            }
        }
        double[] ai = new double[pij.length];
        for (int i2 = 1; i2 < pij.length; ++i2) {
            for (int j = 0; j < pij[0].length; ++j) {
                int n3 = i2;
                ai[n3] = ai[n3] + (double)pij[i2][j];
            }
        }
        double[] bj = new double[pij[0].length];
        for (int j = 1; j < pij[0].length; ++j) {
            for (int i3 = 1; i3 < pij.length; ++i3) {
                int n4 = j;
                bj[n4] = bj[n4] + (double)pij[i3][j];
            }
        }
        double[] pi0 = new double[pij.length];
        double aux = 0.0;
        for (int i4 = 1; i4 < pij.length; ++i4) {
            pi0[i4] = pij[i4][0];
            aux += pi0[i4];
        }
        double sumA = 0.0;
        for (i = 0; i < ai.length; ++i) {
            sumA += ai[i] * ai[i];
        }
        double sumB = 0.0;
        for (int j = 0; j < bj.length; ++j) {
            sumB += bj[j] * bj[j];
        }
        sumB += aux / n;
        double sumAB = 0.0;
        for (int i5 = 1; i5 < pij.length; ++i5) {
            for (int j = 1; j < pij[0].length; ++j) {
                sumAB += (double)(pij[i5][j] * pij[i5][j]);
            }
        }
        return new double[]{(sumAB += aux / n) / sumB, sumAB / sumA, 1.0 - (sumA + sumB - 2.0 * sumAB) / (n * n)};
    }

    public static double adaptedRandIndexFScore3D(ImagePlus originalLabels, ImagePlus proposedLabels) {
        if (!(originalLabels.getImageStack().getProcessor(1) instanceof ShortProcessor) || !(proposedLabels.getImageStack().getProcessor(1) instanceof ShortProcessor)) {
            return -1.0;
        }
        double[] stats = RandError.adaptedRandIndexStats3DN2(originalLabels, proposedLabels);
        return 2.0 * stats[0] * stats[1] / (stats[0] + stats[1]);
    }

    public ClassificationStatistics getRandIndexStats(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = pixels1.length;
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int[][] cont = new int[(int)cluster1.getMax() + 1][(int)cluster2.getMax() + 1];
        int i = 0;
        while ((double)i < n) {
            int[] nArray = cont[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            nArray[n2] = nArray[n2] + 1;
            ++i;
        }
        double[] ni = new double[cont.length];
        for (int i2 = 0; i2 < cont.length; ++i2) {
            for (j = 0; j < cont[0].length; ++j) {
                int n3 = i2;
                ni[n3] = ni[n3] + (double)cont[i2][j];
            }
        }
        double[] nj = new double[cont[0].length];
        for (j = 0; j < cont[0].length; ++j) {
            for (int i3 = 0; i3 < cont.length; ++i3) {
                int n4 = j;
                nj[n4] = nj[n4] + (double)cont[i3][j];
            }
        }
        double truePositives = 0.0;
        for (int j2 = 0; j2 < cont[0].length; ++j2) {
            for (int i4 = 0; i4 < cont.length; ++i4) {
                truePositives += (double)cont[i4][j2] * ((double)cont[i4][j2] - 1.0) / 2.0;
            }
        }
        double nPairsTotal = n * (n - 1.0) / 2.0;
        double nPosTrue = 0.0;
        for (int k = 0; k < ni.length; ++k) {
            nPosTrue += ni[k] * (ni[k] - 1.0) / 2.0;
        }
        double nPosActual = 0.0;
        for (int k = 0; k < nj.length; ++k) {
            nPosActual += nj[k] * (nj[k] - 1.0) / 2.0;
        }
        double trueNegatives = nPairsTotal + truePositives - nPosTrue - nPosActual;
        double falsePositives = nPosActual - truePositives;
        double nNegActual = nPairsTotal - nPosActual;
        double falseNegatives = nNegActual - trueNegatives;
        double agreements = truePositives + trueNegatives;
        double randIndex = agreements / nPairsTotal;
        return new ClassificationStatistics(truePositives, trueNegatives, falsePositives, falseNegatives, randIndex);
    }

    public ClassificationStatistics getForegroundRestrictedRandIndexStatsN2(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        int i;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = 0.0;
        for (int i2 = 0; i2 < pixels1.length; ++i2) {
            if (pixels1[i2] == 0) continue;
            n += 1.0;
        }
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        for (i = 0; i < pixels1.length; ++i) {
            double[] dArray = pij[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i = 0; i < nLabelsA + 1; ++i) {
            int j2 = 0;
            while (j2 < nLabelsB + 1) {
                double[] dArray = pij[i];
                int n3 = j2++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] ai = new double[pij.length];
        for (int i3 = 1; i3 < pij.length; ++i3) {
            for (j = 0; j < pij[0].length; ++j) {
                int n4 = i3;
                ai[n4] = ai[n4] + pij[i3][j];
            }
        }
        double[] bj = new double[pij[0].length];
        for (j = 1; j < pij[0].length; ++j) {
            for (int i4 = 1; i4 < pij.length; ++i4) {
                int n5 = j;
                bj[n5] = bj[n5] + pij[i4][j];
            }
        }
        double[] pi0 = new double[pij.length];
        double aux = 0.0;
        for (int i5 = 1; i5 < pij.length; ++i5) {
            pi0[i5] = pij[i5][0];
            aux += pi0[i5];
        }
        double sumA2 = 0.0;
        for (int i6 = 0; i6 < ai.length; ++i6) {
            sumA2 += ai[i6] * ai[i6];
        }
        double sumB2 = 0.0;
        for (int j3 = 0; j3 < bj.length; ++j3) {
            sumB2 += bj[j3] * bj[j3];
        }
        sumB2 += aux / n;
        double sumAB2 = 0.0;
        for (int i7 = 1; i7 < pij.length; ++i7) {
            for (int j4 = 1; j4 < pij[0].length; ++j4) {
                sumAB2 += pij[i7][j4] * pij[i7][j4];
            }
        }
        double n2 = n * n;
        double tp = n2 * (sumAB2 += aux / n);
        double fp = n2 * sumB2 - tp;
        double fn = n2 * sumA2 - tp;
        double tn = n2 - tp - fp - fn;
        double randError = (fp + fn) / n2;
        return new ClassificationStatistics(tp, tn, fp, fn, 1.0 - randError);
    }

    public double[] getForegroundRestrictedGroundTruthDisagreements(ShortProcessor cluster1, ShortProcessor cluster2) {
        int j;
        int i;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = 0.0;
        for (int i2 = 0; i2 < pixels1.length; ++i2) {
            if (pixels1[i2] == 0) continue;
            n += 1.0;
        }
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        for (i = 0; i < pixels1.length; ++i) {
            double[] dArray = pij[pixels1[i] & 0xFFFF];
            int n2 = pixels2[i] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i = 0; i < nLabelsA + 1; ++i) {
            j = 0;
            while (j < nLabelsB + 1) {
                double[] dArray = pij[i];
                int n3 = j++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] bj = new double[pij[0].length];
        for (j = 1; j < pij[0].length; ++j) {
            for (int i3 = 1; i3 < pij.length; ++i3) {
                int n4 = j;
                bj[n4] = bj[n4] + pij[i3][j];
            }
        }
        double[] dis = new double[pij[0].length];
        for (int j2 = 0; j2 < bj.length; ++j2) {
            double sum = 0.0;
            for (int i4 = 1; i4 < pij.length; ++i4) {
                sum += pij[i4][j2] * pij[i4][j2];
            }
            dis[j2] = bj[j2] * bj[j2] - sum;
        }
        return dis;
    }

    public double[] getForegroundRestrictedPredictionDisagreements(ShortProcessor cluster1, ShortProcessor cluster2) {
        int i;
        int i2;
        short[] pixels1 = (short[])cluster1.getPixels();
        short[] pixels2 = (short[])cluster2.getPixels();
        double n = 0.0;
        for (int i3 = 0; i3 < pixels1.length; ++i3) {
            if (pixels1[i3] == 0) continue;
            n += 1.0;
        }
        cluster1.resetMinAndMax();
        cluster2.resetMinAndMax();
        int nLabelsA = (int)cluster1.getMax();
        int nLabelsB = (int)cluster2.getMax();
        double[][] pij = new double[nLabelsA + 1][nLabelsB + 1];
        for (i2 = 0; i2 < pixels1.length; ++i2) {
            double[] dArray = pij[pixels1[i2] & 0xFFFF];
            int n2 = pixels2[i2] & 0xFFFF;
            dArray[n2] = dArray[n2] + 1.0;
        }
        for (i2 = 0; i2 < nLabelsA + 1; ++i2) {
            int j = 0;
            while (j < nLabelsB + 1) {
                double[] dArray = pij[i2];
                int n3 = j++;
                dArray[n3] = dArray[n3] / n;
            }
        }
        double[] dis = new double[pij.length];
        double[] ai = new double[pij.length];
        for (i = 1; i < pij.length; ++i) {
            for (int j = 0; j < pij[0].length; ++j) {
                int n4 = i;
                ai[n4] = ai[n4] + pij[i][j];
            }
        }
        for (i = 0; i < ai.length; ++i) {
            double sum = 0.0;
            for (int j = 0; j < pij[0].length; ++j) {
                sum += pij[i][j] * pij[i][j];
            }
            dis[i] = ai[i] * ai[i] - sum;
        }
        return dis;
    }

    public double getRandIndexMaximalFScore(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<ClassificationStatistics> stats = this.getRandIndexStats(minThreshold, maxThreshold, stepThreshold);
        double maxFScore = 0.0;
        for (ClassificationStatistics stat : stats) {
            if (!(stat.fScore > maxFScore)) continue;
            maxFScore = stat.fScore;
        }
        return maxFScore;
    }

    public double getForegroundRestrictedRandIndexMaximalFScore(double minThreshold, double maxThreshold, double stepThreshold) {
        ArrayList<ClassificationStatistics> stats = this.getForegroundRestrictedRandIndexStats(minThreshold, maxThreshold, stepThreshold);
        double maxFScore = 0.0;
        for (ClassificationStatistics stat : stats) {
            if (!(stat.fScore > maxFScore)) continue;
            maxFScore = stat.fScore;
        }
        return maxFScore;
    }

    public double getMaximalVRandAfterThinning(double minThreshold, double maxThreshold, double stepThreshold, boolean perSliceAverage) {
        ArrayList<ClassificationStatistics> stats = this.getForegroundRestrictedRandAfterThinningStats(minThreshold, maxThreshold, stepThreshold, perSliceAverage);
        double maxFScore = 0.0;
        for (ClassificationStatistics stat : stats) {
            if (!(stat.fScore > maxFScore)) continue;
            maxFScore = stat.fScore;
        }
        return maxFScore;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            RandError.dumpSyntax();
            System.exit(1);
        } else if (args[0].equals("-help")) {
            RandError.dumpSyntax();
        } else if (args[0].equals("-maxFScoreRandIndex")) {
            System.out.println(RandError.maxFScoreRandIndex(args));
        } else {
            RandError.dumpSyntax();
        }
        System.exit(0);
    }

    static double maxFScoreRandIndex(String[] args) {
        if (args.length != 6) {
            RandError.dumpSyntax();
            return -1.0;
        }
        ImagePlus label = new ImagePlus(args[1]);
        ImagePlus proposal = new ImagePlus(args[2]);
        double minThreshold = Double.parseDouble(args[3]);
        double maxThreshold = Double.parseDouble(args[4]);
        double stepThreshold = Double.parseDouble(args[5]);
        RandError re = new RandError(label, proposal);
        re.setVerboseMode(false);
        return re.getRandIndexMaximalFScore(minThreshold, maxThreshold, stepThreshold);
    }

    @Override
    public void setVerboseMode(boolean verbose) {
        this.verbose = verbose;
    }

    private static void dumpSyntax() {
        System.out.println("Purpose: calculate adapted Rand error between proposed and original labels.\n");
        System.out.println("Usage: RandError ");
        System.out.println("  -help                      : show this message");
        System.out.println("");
        System.out.println("  -maxFScoreRandIndex        : calculate maximum F-score of the standard Rand index over a set of thresholds");
        System.out.println("          labels             : image with the original labels");
        System.out.println("          proposal           : image with the proposed labels");
        System.out.println("          minThreshold       : minimum threshold value to binarize the proposal");
        System.out.println("          maxThreshold       : maximum threshold value to binarize the proposal");
        System.out.println("          stepThreshold      : threshold step value to use during binarization");
        System.out.println("Examples:");
        System.out.println("Calculate the maximum F-score of the Rand index between proposed and original labels over a set of");
        System.out.println("thresholds (from 0.0 to 1.0 in steps of 0.1)");
        System.out.println("   RandError -maxFScoreRandIndex original-labels.tif proposed-labels.tif 0.0 1.0 0.1");
    }
}

