/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij.IJ;
import ij.ImagePlus;
import ij3d.AxisConstants;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.Group;
import org.scijava.java3d.Node;
import org.scijava.java3d.OrderedGroup;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.Switch;
import org.scijava.java3d.Texture;
import org.scijava.java3d.TextureUnitState;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.View;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Vector3d;
import voltex.AppearanceCreator;
import voltex.GeometryCreator;
import voltex.Mask;
import voltex.VoltexVolume;

public class VolumeRenderer
implements AxisConstants {
    protected final VoltexVolume volume;
    protected final BranchGroup root;
    protected final AppearanceCreator appCreator;
    protected final GeometryCreator geomCreator;
    protected final Switch axisSwitch;
    protected final int[][] axisIndex = new int[3][2];
    private int curAxis = 2;
    private int curDir = 0;
    private final Vector3d eyeVec = new Vector3d();
    private static Transform3D parentInv = new Transform3D();
    private static Point3d viewPosition = new Point3d();
    private static Transform3D t = new Transform3D();

    public VolumeRenderer(ImagePlus img, Color3f color, float tr, boolean[] channels) {
        this.volume = new VoltexVolume(img);
        this.volume.setChannels(channels);
        this.appCreator = new AppearanceCreator(this.volume, color, tr);
        this.geomCreator = new GeometryCreator(this.volume);
        this.axisIndex[0][0] = 0;
        this.axisIndex[0][1] = 1;
        this.axisIndex[1][0] = 2;
        this.axisIndex[1][1] = 3;
        this.axisIndex[2][0] = 4;
        this.axisIndex[2][1] = 5;
        this.axisSwitch = new Switch();
        this.axisSwitch.setCapability(17);
        this.axisSwitch.setCapability(18);
        this.axisSwitch.setCapability(12);
        this.axisSwitch.setCapability(13);
        for (int i = 0; i < 6; ++i) {
            this.axisSwitch.addChild((Node)this.getOrderedGroup());
        }
        this.root = new BranchGroup();
        this.root.addChild((Node)this.axisSwitch);
        this.root.setCapability(17);
        this.root.setCapability(11);
    }

    public void disableTextures() {
        int[] size = new int[]{this.volume.xDim, this.volume.yDim, this.volume.zDim};
        Appearance empty = new Appearance();
        for (int axis = 0; axis < 3; ++axis) {
            for (int i = 0; i < size[axis]; ++i) {
                Group frontGroup = (Group)this.axisSwitch.getChild(this.axisIndex[axis][0]);
                Group backGroup = (Group)this.axisSwitch.getChild(this.axisIndex[axis][1]);
                Appearance app = this.getAppearance(axis, i);
                app.getTextureUnitState(0).setTexture(null);
                ((Shape3D)((Group)frontGroup.getChild(i)).getChild(0)).setAppearance(empty);
                ((Shape3D)((Group)backGroup.getChild(i)).getChild(0)).setAppearance(empty);
            }
        }
    }

    public void enableTextures() {
        int[] size = new int[]{this.volume.xDim, this.volume.yDim, this.volume.zDim};
        for (int axis = 0; axis < 3; ++axis) {
            for (int i = 0; i < size[axis]; ++i) {
                Appearance app = this.appCreator.getAppearance(axis, i);
                Group frontGroup = (Group)this.axisSwitch.getChild(this.axisIndex[axis][0]);
                ((Shape3D)((Group)frontGroup.getChild(i)).getChild(0)).setAppearance(app);
                Group backGroup = (Group)this.axisSwitch.getChild(this.axisIndex[axis][1]);
                ((Shape3D)((Group)backGroup.getChild(size[axis] - i - 1)).getChild(0)).setAppearance(app);
            }
        }
    }

    public BranchGroup getVolumeNode() {
        return this.root;
    }

    public VoltexVolume getVolume() {
        return this.volume;
    }

    public Appearance getAppearance(int axis, int index) {
        Group frontGroup = (Group)this.axisSwitch.getChild(this.axisIndex[axis][0]);
        return ((Shape3D)((Group)frontGroup.getChild(index)).getChild(0)).getAppearance();
    }

    public Mask createMask() {
        Mask mask = new Mask(this.volume, this.root);
        Object frontGroup = null;
        Object backGroup = null;
        int[] size = new int[]{this.volume.xDim, this.volume.yDim, this.volume.zDim};
        for (int axis = 0; axis < 3; ++axis) {
            for (int i = 0; i < size[axis]; ++i) {
                Appearance app = this.getAppearance(axis, i);
                app.setTextureUnitState(1, new TextureUnitState((Texture)this.appCreator.getTexture(axis, i, mask), mask.getMaskAttributes(), this.appCreator.getTg(axis)));
            }
        }
        return mask;
    }

    public void eyePtChanged(View view) {
        Point3d eyePt = VolumeRenderer.getViewPosInLocal(view, (Node)this.root);
        if (eyePt != null) {
            int dir;
            Point3d volRefPt = this.volume.volRefPt;
            this.eyeVec.sub((Tuple3d)eyePt, (Tuple3d)volRefPt);
            int axis = 0;
            double value = this.eyeVec.x;
            double max = Math.abs(this.eyeVec.x);
            if (Math.abs(this.eyeVec.y) > max) {
                axis = 1;
                value = this.eyeVec.y;
                max = Math.abs(this.eyeVec.y);
            }
            if (Math.abs(this.eyeVec.z) > max) {
                axis = 2;
                value = this.eyeVec.z;
                max = Math.abs(this.eyeVec.z);
            }
            int n = dir = value > 0.0 ? 0 : 1;
            if (axis != this.curAxis || dir != this.curDir) {
                this.curAxis = axis;
                this.curDir = dir;
                this.axisSwitch.setWhichChild(this.axisIndex[this.curAxis][this.curDir]);
            }
        }
    }

    public void fullReload() {
        for (int i = 0; i < this.axisSwitch.numChildren(); ++i) {
            ((Group)this.axisSwitch.getChild(i)).removeAllChildren();
        }
        this.loadAxis(2);
        this.loadAxis(1);
        this.loadAxis(0);
        this.axisSwitch.setWhichChild(this.axisIndex[this.curAxis][this.curDir]);
    }

    public void setThreshold(int threshold) {
        float value = (float)threshold / 255.0f;
        value = Math.min(1.0f, value);
        value = Math.max(0.1f, value);
        this.appCreator.setThreshold(value);
    }

    public void setTransparency(float transparency) {
        this.appCreator.setTransparency(transparency);
    }

    public void setChannels(boolean[] channels) {
        if (this.volume.setChannels(channels)) {
            this.appCreator.updateTextureMode();
            this.fullReload();
        }
    }

    public void setLUTs(int[] r, int[] g, int[] b, int[] a) {
        if (this.volume.setLUTs(r, g, b, a)) {
            this.appCreator.updateTextureMode();
            this.fullReload();
        }
    }

    public void setColor(Color3f color) {
        if (this.volume.setAverage(color != null)) {
            this.appCreator.updateTextureMode();
            this.fullReload();
        }
        Color3f c = color != null ? color : new Color3f(1.0f, 1.0f, 1.0f);
        this.appCreator.setColor(c);
    }

    protected void loadAxis(int axis) {
        int rSize = 0;
        Group frontGroup = null;
        Group backGroup = null;
        frontGroup = (Group)this.axisSwitch.getChild(this.axisIndex[axis][0]);
        backGroup = (Group)this.axisSwitch.getChild(this.axisIndex[axis][1]);
        String m = "Loading ";
        switch (axis) {
            case 2: {
                rSize = this.volume.zDim;
                m = m + "x axis";
                break;
            }
            case 1: {
                rSize = this.volume.yDim;
                m = m + "y axis";
                break;
            }
            case 0: {
                rSize = this.volume.xDim;
                m = m + "z axis";
            }
        }
        IJ.showStatus((String)m);
        for (int i = 0; i < rSize; ++i) {
            IJ.showProgress((int)(i + 1), (int)rSize);
            this.loadAxis(axis, i, frontGroup, backGroup);
        }
    }

    protected void loadAxis(int axis, int index, Group front, Group back) {
        GeometryArray quadArray = this.geomCreator.getQuad(axis, index);
        Appearance a = this.appCreator.getAppearance(axis, index);
        Shape3D frontShape = new Shape3D((Geometry)quadArray, a);
        frontShape.setCapability(15);
        frontShape.setCapability(14);
        BranchGroup frontShapeGroup = new BranchGroup();
        frontShapeGroup.setCapability(17);
        frontShapeGroup.setCapability(12);
        frontShapeGroup.addChild((Node)frontShape);
        front.addChild((Node)frontShapeGroup);
        Shape3D backShape = new Shape3D((Geometry)quadArray, a);
        backShape.setCapability(14);
        backShape.setCapability(15);
        BranchGroup backShapeGroup = new BranchGroup();
        backShapeGroup.setCapability(17);
        backShapeGroup.setCapability(12);
        backShapeGroup.addChild((Node)backShape);
        back.insertChild((Node)backShapeGroup, 0);
    }

    private static Point3d getViewPosInLocal(View view, Node node) {
        if (node == null) {
            return null;
        }
        if (!node.isLive()) {
            return null;
        }
        Canvas3D canvas = view.getCanvas3D(0);
        canvas.getCenterEyeInImagePlate(viewPosition);
        canvas.getImagePlateToVworld(t);
        t.transform(viewPosition);
        node.getLocalToVworld(parentInv);
        parentInv.invert();
        parentInv.transform(viewPosition);
        return viewPosition;
    }

    private Group getOrderedGroup() {
        OrderedGroup og = new OrderedGroup();
        og.setCapability(12);
        og.setCapability(13);
        og.setCapability(14);
        return og;
    }
}

