/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij3d.AxisConstants;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.QuadArray;
import voltex.VoltexVolume;

public class GeometryCreator
implements AxisConstants {
    private final double[] quadCoords = new double[12];
    private VoltexVolume volume;

    public GeometryCreator(VoltexVolume volume) {
        this.setVolume(volume);
    }

    public void setVolume(VoltexVolume volume) {
        this.volume = volume;
    }

    public GeometryArray getQuad(int direction, int index) {
        this.calculateQuad(direction, index);
        QuadArray quadArray = new QuadArray(4, 1);
        quadArray.setCoordinates(0, this.quadCoords);
        quadArray.setCapability(18);
        quadArray.setCapability(1);
        return quadArray;
    }

    public double[] getQuadCoords(int direction, int index) {
        this.calculateQuad(direction, index);
        return this.quadCoords;
    }

    private void calculateQuad(int direction, int index) {
        switch (direction) {
            case 0: {
                this.setCoordsY();
                this.setCoordsZ();
                this.setCurCoordX(index);
                break;
            }
            case 1: {
                this.setCoordsX();
                this.setCoordsZ();
                this.setCurCoordY(index);
                break;
            }
            case 2: {
                this.setCoordsX();
                this.setCoordsY();
                this.setCurCoordZ(index);
            }
        }
    }

    private void setCurCoordX(int i) {
        double curX;
        this.quadCoords[0] = curX = (double)i * this.volume.pw + this.volume.minCoord.x;
        this.quadCoords[3] = curX;
        this.quadCoords[6] = curX;
        this.quadCoords[9] = curX;
    }

    private void setCurCoordY(int i) {
        double curY;
        this.quadCoords[1] = curY = (double)i * this.volume.ph + this.volume.minCoord.y;
        this.quadCoords[4] = curY;
        this.quadCoords[7] = curY;
        this.quadCoords[10] = curY;
    }

    private void setCurCoordZ(int i) {
        double curZ;
        this.quadCoords[2] = curZ = (double)i * this.volume.pd + this.volume.minCoord.z;
        this.quadCoords[5] = curZ;
        this.quadCoords[8] = curZ;
        this.quadCoords[11] = curZ;
    }

    private void setCoordsX() {
        this.quadCoords[1] = this.volume.minCoord.y;
        this.quadCoords[2] = this.volume.minCoord.z;
        this.quadCoords[4] = this.volume.maxCoord.y;
        this.quadCoords[5] = this.volume.minCoord.z;
        this.quadCoords[7] = this.volume.maxCoord.y;
        this.quadCoords[8] = this.volume.maxCoord.z;
        this.quadCoords[10] = this.volume.minCoord.y;
        this.quadCoords[11] = this.volume.maxCoord.z;
    }

    private void setCoordsY() {
        this.quadCoords[0] = this.volume.minCoord.x;
        this.quadCoords[2] = this.volume.minCoord.z;
        this.quadCoords[3] = this.volume.minCoord.x;
        this.quadCoords[5] = this.volume.maxCoord.z;
        this.quadCoords[6] = this.volume.maxCoord.x;
        this.quadCoords[8] = this.volume.maxCoord.z;
        this.quadCoords[9] = this.volume.maxCoord.x;
        this.quadCoords[11] = this.volume.minCoord.z;
    }

    private void setCoordsZ() {
        this.quadCoords[0] = this.volume.minCoord.x;
        this.quadCoords[1] = this.volume.minCoord.y;
        this.quadCoords[3] = this.volume.maxCoord.x;
        this.quadCoords[4] = this.volume.minCoord.y;
        this.quadCoords[6] = this.volume.maxCoord.x;
        this.quadCoords[7] = this.volume.maxCoord.y;
        this.quadCoords[9] = this.volume.minCoord.x;
        this.quadCoords[10] = this.volume.maxCoord.y;
    }
}

