/*
 * Decompiled with CFR 0.152.
 */
package voltex;

import ij3d.AxisConstants;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.ColoringAttributes;
import org.scijava.java3d.ImageComponent;
import org.scijava.java3d.ImageComponent2D;
import org.scijava.java3d.Material;
import org.scijava.java3d.PolygonAttributes;
import org.scijava.java3d.RenderingAttributes;
import org.scijava.java3d.TexCoordGeneration;
import org.scijava.java3d.Texture;
import org.scijava.java3d.Texture2D;
import org.scijava.java3d.TextureAttributes;
import org.scijava.java3d.TextureUnitState;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Vector4f;
import voltex.VoltexVolume;

public class AppearanceCreator
implements AxisConstants {
    private VoltexVolume volume;
    private int textureMode;
    private boolean opaque = false;
    private TexCoordGeneration xTg;
    private TexCoordGeneration yTg;
    private TexCoordGeneration zTg;
    private TextureAttributes texAttr;
    private TransparencyAttributes transAttr;
    private PolygonAttributes polyAttr;
    private Material material;
    private ColoringAttributes colAttr;
    private RenderingAttributes rendAttr;

    public AppearanceCreator(VoltexVolume volume) {
        this(volume, null, 0.1f);
    }

    public AppearanceCreator(VoltexVolume volume, Color3f color, float transparency) {
        this.initAttributes(color, transparency);
        this.setVolume(volume);
    }

    public void release() {
        this.xTg = null;
        this.yTg = null;
        this.zTg = null;
        this.volume = null;
    }

    public void setVolume(VoltexVolume v) {
        this.volume = v;
        this.zTg = new TexCoordGeneration();
        this.zTg.setPlaneS(new Vector4f(v.xTexGenScale, 0.0f, 0.0f, (float)(0.5 * v.pw * (double)v.xTexGenScale) - (float)((double)v.xTexGenScale * v.minCoord.x)));
        this.zTg.setPlaneT(new Vector4f(0.0f, v.yTexGenScale, 0.0f, (float)(0.5 * v.ph * (double)v.yTexGenScale) - (float)((double)v.yTexGenScale * v.minCoord.y)));
        this.yTg = new TexCoordGeneration();
        this.yTg.setPlaneS(new Vector4f(v.xTexGenScale, 0.0f, 0.0f, (float)(0.5 * v.pw * (double)v.xTexGenScale) - (float)((double)v.xTexGenScale * v.minCoord.x)));
        this.yTg.setPlaneT(new Vector4f(0.0f, 0.0f, v.zTexGenScale, (float)(0.5 * v.pd * (double)v.zTexGenScale) - (float)((double)v.zTexGenScale * v.minCoord.z)));
        this.xTg = new TexCoordGeneration();
        this.xTg.setPlaneS(new Vector4f(0.0f, v.yTexGenScale, 0.0f, (float)(0.5 * v.ph * (double)v.yTexGenScale) - (float)((double)v.yTexGenScale * v.minCoord.y)));
        this.xTg.setPlaneT(new Vector4f(0.0f, 0.0f, v.zTexGenScale, (float)(0.5 * v.pd * (double)v.zTexGenScale) - (float)((double)v.zTexGenScale * v.minCoord.z)));
        this.updateTextureMode();
    }

    public boolean getOpaqueTextures() {
        return this.opaque;
    }

    public void setOpaqueTextures(boolean opaque) {
        if (this.opaque != opaque) {
            this.opaque = opaque;
            this.updateTextureMode();
        }
    }

    public void updateTextureMode() {
        boolean rgb;
        boolean bl = rgb = this.volume.getDataType() == 0;
        this.textureMode = rgb ? (this.opaque ? 5 : 6) : (this.opaque ? 2 : 1);
    }

    public Appearance getAppearance(int direction, int index) {
        Appearance a = new Appearance();
        a.setCapability(21);
        a.setCapability(3);
        a.setCapability(5);
        a.setMaterial(this.material);
        a.setTransparencyAttributes(this.transAttr);
        a.setPolygonAttributes(this.polyAttr);
        a.setColoringAttributes(this.colAttr);
        a.setRenderingAttributes(this.rendAttr);
        TextureUnitState[] tus = new TextureUnitState[2];
        tus[0] = new TextureUnitState((Texture)this.getTexture(direction, index, this.volume), this.texAttr, this.getTg(direction));
        tus[0].setCapability(1);
        tus[1] = null;
        a.setTextureUnitState(tus);
        return a;
    }

    public void setTransparency(float f) {
        this.transAttr.setTransparency(f);
    }

    public void setThreshold(float f) {
        this.rendAttr.setAlphaTestValue(f);
    }

    public void setColor(Color3f c) {
        this.colAttr.setColor(c);
    }

    public Texture2D getTexture(int axis, int index) {
        return this.getTexture(axis, index, this.volume);
    }

    public Texture2D getTexture(int axis, int index, VoltexVolume vol) {
        int sSize = 0;
        int tSize = 0;
        ImageComponent2D pArray = null;
        switch (axis) {
            case 2: {
                sSize = vol.xTexSize;
                tSize = vol.yTexSize;
                pArray = vol.getImageComponentZ(index);
                break;
            }
            case 1: {
                sSize = vol.xTexSize;
                tSize = vol.zTexSize;
                pArray = vol.getImageComponentY(index);
                break;
            }
            case 0: {
                sSize = vol.yTexSize;
                tSize = vol.zTexSize;
                pArray = vol.getImageComponentX(index);
            }
        }
        Texture2D tex = new Texture2D(1, this.textureMode, sSize, tSize);
        tex.setImage(0, (ImageComponent)pArray);
        tex.setEnable(true);
        tex.setMinFilter(3);
        tex.setMagFilter(3);
        tex.setBoundaryModeS(2);
        tex.setBoundaryModeT(2);
        return tex;
    }

    public TexCoordGeneration getTg(int direction) {
        switch (direction) {
            case 0: {
                return this.xTg;
            }
            case 1: {
                return this.yTg;
            }
            case 2: {
                return this.zTg;
            }
        }
        return null;
    }

    private void initAttributes(Color3f color, float transparency) {
        this.texAttr = new TextureAttributes();
        this.texAttr.setTextureMode(2);
        this.texAttr.setPerspectiveCorrectionMode(1);
        this.transAttr = new TransparencyAttributes();
        this.transAttr.setCapability(3);
        this.transAttr.setTransparencyMode(2);
        this.transAttr.setSrcBlendFunction(2);
        this.transAttr.setDstBlendFunction(3);
        this.transAttr.setTransparency(transparency);
        this.polyAttr = new PolygonAttributes();
        this.polyAttr.setCullFace(0);
        this.material = new Material();
        this.material.setLightingEnable(true);
        this.colAttr = new ColoringAttributes();
        this.colAttr.setCapability(1);
        this.colAttr.setShadeModel(1);
        if (color == null) {
            this.colAttr.setColor(1.0f, 1.0f, 1.0f);
        } else {
            this.colAttr.setColor(color);
        }
        this.rendAttr = new RenderingAttributes();
        this.rendAttr.setCapability(1);
        this.rendAttr.setAlphaTestValue(0.1f);
        this.rendAttr.setAlphaTestFunction(6);
    }
}

