/*
 * Decompiled with CFR 0.152.
 */
package orthoslice;

import ij.ImagePlus;
import java.util.BitSet;
import org.scijava.java3d.Group;
import org.scijava.java3d.QuadArray;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.TexCoordGeneration;
import org.scijava.java3d.Texture;
import org.scijava.java3d.Texture2D;
import org.scijava.java3d.View;
import org.scijava.vecmath.Color3f;
import voltex.VolumeRenderer;

public class Orthoslice
extends VolumeRenderer {
    private final int[] slices = new int[3];
    private final int[] dimensions = new int[3];
    private final boolean[] visible = new boolean[3];
    private final BitSet whichChild = new BitSet(6);

    public Orthoslice(ImagePlus img, Color3f color, float tr, boolean[] channels) {
        super(img, color, tr, channels);
        this.getVolume().setAlphaLUTFullyOpaque();
        this.dimensions[0] = img.getWidth();
        this.dimensions[1] = img.getHeight();
        this.dimensions[2] = img.getStackSize();
        for (int i = 0; i < 3; ++i) {
            this.slices[i] = this.dimensions[i] / 2;
            this.visible[i] = true;
            this.whichChild.set(i, true);
            this.whichChild.set(i + 3, true);
        }
    }

    @Override
    protected void loadAxis(int axis) {
        Group front = (Group)this.axisSwitch.getChild(this.axisIndex[axis][0]);
        Group back = (Group)this.axisSwitch.getChild(this.axisIndex[axis][1]);
        int i = this.slices[axis];
        this.loadAxis(axis, i, front, back);
    }

    @Override
    public void eyePtChanged(View view) {
        this.axisSwitch.setWhichChild(-3);
        this.axisSwitch.setChildMask(this.whichChild);
    }

    public int getSlice(int axis) {
        return this.slices[axis];
    }

    public boolean isVisible(int axis) {
        return this.visible[axis];
    }

    public void setVisible(int axis, boolean b) {
        if (this.visible[axis] != b) {
            this.visible[axis] = b;
            this.whichChild.set(this.axisIndex[axis][0], b);
            this.whichChild.set(this.axisIndex[axis][1], b);
            this.axisSwitch.setChildMask(this.whichChild);
        }
    }

    public void decrease(int axis) {
        this.setSlice(axis, this.slices[axis] - 1);
    }

    public void increase(int axis) {
        this.setSlice(axis, this.slices[axis] + 1);
    }

    public void setSlice(int axis, int v) {
        if (v >= this.dimensions[axis] || v < 0) {
            return;
        }
        this.slices[axis] = v;
        Group g = (Group)this.axisSwitch.getChild(this.axisIndex[axis][0]);
        int num = g.numChildren();
        if (num > 1) {
            System.out.println(num + " children, expected only 1");
        }
        Shape3D shape = (Shape3D)((Group)g.getChild(num - 1)).getChild(0);
        double[] quadCoords = this.geomCreator.getQuadCoords(axis, v);
        ((QuadArray)shape.getGeometry()).setCoordinates(0, quadCoords);
        Texture2D tex = this.appCreator.getTexture(axis, v);
        shape.getAppearance().setTexture((Texture)tex);
        TexCoordGeneration tg = this.appCreator.getTg(axis);
        shape.getAppearance().setTexCoordGeneration(tg);
    }
}

