/*
 * Decompiled with CFR 0.152.
 */
package orthoslice;

import ij.ImagePlus;
import java.util.Arrays;
import java.util.BitSet;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.Group;
import org.scijava.java3d.Node;
import org.scijava.java3d.Shape3D;
import org.scijava.java3d.View;
import org.scijava.vecmath.Color3f;
import voltex.VolumeRenderer;

public class MultiOrthoslice
extends VolumeRenderer {
    private final boolean[][] slices = new boolean[3][];
    private final int[] dimensions = new int[3];
    private final BitSet whichChild = new BitSet(6);

    public MultiOrthoslice(ImagePlus img, Color3f color, float tr, boolean[] channels) {
        super(img, color, tr, channels);
        this.getVolume().setAlphaLUTFullyOpaque();
        this.dimensions[0] = img.getWidth();
        this.dimensions[1] = img.getHeight();
        this.dimensions[2] = img.getStackSize();
        for (int i = 0; i < 3; ++i) {
            this.slices[i] = new boolean[this.dimensions[i]];
            this.slices[i][this.dimensions[i] / 2] = true;
            this.whichChild.set(i, true);
            this.whichChild.set(i + 3, true);
        }
    }

    public boolean getTexturesOpaque() {
        return this.appCreator.getOpaqueTextures();
    }

    public void setTexturesOpaque(boolean opaque) {
        boolean before = this.appCreator.getOpaqueTextures();
        if (before != opaque) {
            this.appCreator.setOpaqueTextures(opaque);
            this.fullReload();
        }
    }

    @Override
    protected void loadAxis(int axis, int index, Group front, Group back) {
        if (this.slices[axis][index]) {
            super.loadAxis(axis, index, front, back);
        }
    }

    @Override
    public void eyePtChanged(View view) {
        this.axisSwitch.setWhichChild(-3);
        this.axisSwitch.setChildMask(this.whichChild);
    }

    public int getSliceCount(int axis) {
        return this.dimensions[axis];
    }

    public void setVisible(int axis, boolean[] b) {
        int i;
        BranchGroup[] cachedFrontGroups = new BranchGroup[this.dimensions[axis]];
        int axisFront = this.axisIndex[axis][0];
        Group frontGroup = (Group)this.axisSwitch.getChild(axisFront);
        int groupIndex = 0;
        for (int i2 = 0; i2 < this.slices[axis].length; ++i2) {
            if (!this.slices[axis][i2]) continue;
            cachedFrontGroups[i2] = (BranchGroup)frontGroup.getChild(groupIndex++);
        }
        frontGroup.removeAllChildren();
        BranchGroup[] cachedBackGroups = new BranchGroup[this.dimensions[axis]];
        int axisBack = this.axisIndex[axis][1];
        Group backGroup = (Group)this.axisSwitch.getChild(axisBack);
        groupIndex = backGroup.numChildren() - 1;
        for (i = 0; i < this.slices[axis].length; ++i) {
            if (!this.slices[axis][i]) continue;
            cachedBackGroups[i] = (BranchGroup)backGroup.getChild(groupIndex--);
        }
        backGroup.removeAllChildren();
        for (i = 0; i < this.slices[axis].length; ++i) {
            this.slices[axis][i] = b[i];
            if (!this.slices[axis][i]) continue;
            BranchGroup frontShapeGroup = cachedFrontGroups[i];
            BranchGroup backShapeGroup = cachedBackGroups[i];
            if (frontShapeGroup == null || backShapeGroup == null) {
                GeometryArray quadArray = this.geomCreator.getQuad(axis, i);
                Appearance a = this.appCreator.getAppearance(axis, i);
                Shape3D frontShape = new Shape3D((Geometry)quadArray, a);
                frontShape.setCapability(13);
                frontShape.setCapability(15);
                frontShape.setCapability(14);
                frontShapeGroup = new BranchGroup();
                frontShapeGroup.setCapability(17);
                frontShapeGroup.setCapability(12);
                frontShapeGroup.addChild((Node)frontShape);
                Shape3D backShape = new Shape3D((Geometry)quadArray, a);
                backShape.setCapability(13);
                backShape.setCapability(14);
                backShape.setCapability(15);
                backShapeGroup = new BranchGroup();
                backShapeGroup.setCapability(17);
                backShapeGroup.setCapability(12);
                backShapeGroup.addChild((Node)backShape);
            }
            frontGroup.addChild((Node)frontShapeGroup);
            backGroup.insertChild((Node)backShapeGroup, 0);
        }
    }

    public void setVisible(int axis, boolean b) {
        boolean[] bs = new boolean[this.dimensions[axis]];
        Arrays.fill(bs, b);
        this.setVisible(axis, bs);
    }

    public void setVisible(int axis, int interval, int offset, int range) {
        boolean[] bs = new boolean[this.dimensions[axis]];
        int i = offset;
        int k = 0;
        while (k < this.dimensions[axis] - offset && k < range) {
            bs[i] = true;
            ++k;
            i += interval;
        }
        this.setVisible(axis, bs);
    }

    public void translateVisibilityState(int axis, int shift) {
        boolean[] bs = new boolean[this.dimensions[axis]];
        boolean first = false;
        int len = this.dimensions[axis];
        for (int i = 0; i < this.dimensions[axis]; ++i) {
            int target = i + shift;
            if (target < 0 || target > this.dimensions[axis]) continue;
            bs[target] = this.slices[axis][i];
        }
        this.setVisible(axis, bs);
    }
}

